/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.CopyContext;
import io.questdb.cutlass.text.CopyRequestTask;
import io.questdb.cutlass.text.CopyTask;
import io.questdb.cutlass.text.ParallelCsvFileImporter;
import io.questdb.cutlass.text.SerialCsvFileImporter;
import io.questdb.cutlass.text.TextImportException;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class CopyRequestJob
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(CopyRequestJob.class);
    private final MicrosecondClock clock;
    private final CopyContext copyContext;
    private final CairoEngine engine;
    private final int logRetentionDays;
    private final LongList partitionsToRemove = new LongList();
    private final RingQueue<CopyRequestTask> requestQueue;
    private final Sequence requestSubSeq;
    private final TableToken statusTableToken;
    private final StringSink stringSink = new StringSink();
    private ParallelCsvFileImporter parallelImporter;
    private Path path;
    private SerialCsvFileImporter serialImporter;
    private SqlCompiler sqlCompiler;
    private SqlExecutionContextImpl sqlExecutionContext;
    private CopyRequestTask task;
    private TableWriter writer;
    private final ParallelCsvFileImporter.PhaseStatusReporter updateStatusRef = this::updateStatus;

    public CopyRequestJob(CairoEngine engine, int workerCount, @Nullable FunctionFactoryCache functionFactoryCache) throws SqlException {
        this.requestQueue = engine.getMessageBus().getTextImportRequestQueue();
        this.requestSubSeq = engine.getMessageBus().getTextImportRequestSubSeq();
        this.parallelImporter = new ParallelCsvFileImporter(engine, workerCount);
        this.serialImporter = new SerialCsvFileImporter(engine);
        CairoConfiguration configuration = engine.getConfiguration();
        this.clock = configuration.getMicrosecondClock();
        this.sqlCompiler = configuration.getFactoryProvider().getSqlCompilerFactory().getInstance(engine, functionFactoryCache, null);
        this.sqlExecutionContext = new SqlExecutionContextImpl(engine, 1);
        this.sqlExecutionContext.with(configuration.getFactoryProvider().getSecurityContextFactory().getRootContext(), null, null);
        String statusTableName = configuration.getSystemTableNamePrefix() + "text_import_log";
        this.statusTableToken = this.sqlCompiler.query().$("CREATE TABLE IF NOT EXISTS \"").$(statusTableName).$("\" (ts timestamp, id string, table symbol, file symbol, phase symbol, status symbol, message string,rows_handled long,rows_imported long,errors long) timestamp(ts) partition by DAY BYPASS WAL").compile(this.sqlExecutionContext).getTableToken();
        this.writer = engine.getWriter(this.statusTableToken, "QuestDB system");
        this.logRetentionDays = configuration.getSqlCopyLogRetentionDays();
        this.copyContext = engine.getCopyContext();
        this.path = new Path();
        this.engine = engine;
        this.enforceLogRetention();
    }

    @Override
    public void close() {
        this.parallelImporter = Misc.free(this.parallelImporter);
        this.serialImporter = Misc.free(this.serialImporter);
        this.writer = Misc.free(this.writer);
        this.sqlCompiler = Misc.free(this.sqlCompiler);
        this.sqlExecutionContext = Misc.free(this.sqlExecutionContext);
        this.path = Misc.free(this.path);
    }

    private void updateStatus(byte phase, byte status, CharSequence msg, long rowsHandled, long rowsImported, long errors) {
        if (this.writer != null) {
            this.stringSink.clear();
            Numbers.appendHex(this.stringSink, this.task.getCopyID(), true);
            try {
                TableWriter.Row row = this.writer.newRow(this.clock.getTicks());
                row.putStr(1, this.stringSink);
                row.putSym(2, this.task.getTableName());
                row.putSym(3, this.task.getFileName());
                row.putSym(4, CopyTask.getPhaseName(phase));
                row.putSym(5, CopyTask.getStatusName(status));
                row.putStr(6, msg);
                row.putLong(7, rowsHandled);
                row.putLong(8, rowsImported);
                row.putLong(9, errors);
                row.append();
                this.writer.commit();
            }
            catch (Throwable th) {
                LOG.error().$("could not update status table [importId=").$hexPadded(this.task.getCopyID()).$(", statusTableName=").$(this.statusTableToken).$(", tableName=").$(this.task.getTableName()).$(", fileName=").$(this.task.getFileName()).$(", phase=").$(CopyTask.getPhaseName(phase)).$(", status=").$(CopyTask.getStatusName(phase)).$(", msg=").$(msg).$(", rowsHandled=").$(rowsHandled).$(", rowsImported=").$(rowsImported).$(", errors=").$(errors).$(", error=`").$(th).$('`').I$();
                this.writer = Misc.free(this.writer);
            }
            if (this.writer == null) {
                try {
                    this.writer = this.engine.getWriter(this.statusTableToken, "QuestDB system");
                }
                catch (Throwable e) {
                    LOG.error().$("could not re-open writer [table=").$(this.statusTableToken).$(", error=`").$(e).$('`').I$();
                }
            }
        }
    }

    private boolean useParallelImport() {
        TableToken tableToken = this.engine.getTableTokenIfExists(this.task.getTableName());
        if (this.engine.getTableStatus(this.path, tableToken) != 0) {
            return this.task.getPartitionBy() >= 0 && this.task.getPartitionBy() != 3;
        }
        try (TableReader reader = this.engine.getReader(tableToken);){
            boolean bl = PartitionBy.isPartitioned(reader.getPartitionedBy());
            return bl;
        }
    }

    void enforceLogRetention() {
        if (this.writer != null) {
            if (this.logRetentionDays < 1) {
                this.writer.truncate();
                return;
            }
            if (this.writer.getPartitionCount() > 0) {
                int i;
                this.partitionsToRemove.clear();
                for (i = this.writer.getPartitionCount() - this.logRetentionDays - 1; i > -1; --i) {
                    this.partitionsToRemove.add(this.writer.getPartitionTimestamp(i));
                }
                int sz = this.partitionsToRemove.size();
                for (i = 0; i < sz; ++i) {
                    this.writer.removePartition(this.partitionsToRemove.getQuick(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runSerially() {
        long cursor = this.requestSubSeq.next();
        if (cursor > -1L) {
            this.task = this.requestQueue.get(cursor);
            try {
                if (this.useParallelImport()) {
                    this.parallelImporter.of(this.task.getTableName(), this.task.getFileName(), this.task.getCopyID(), this.task.getPartitionBy(), this.task.getDelimiter(), this.task.getTimestampColumnName(), this.task.getTimestampFormat(), this.task.isHeaderFlag(), this.copyContext.getCircuitBreaker(), this.task.getAtomicity());
                    this.parallelImporter.setStatusReporter(this.updateStatusRef);
                    this.parallelImporter.process();
                } else {
                    this.serialImporter.of(this.task.getTableName(), this.task.getFileName(), this.task.getCopyID(), this.task.getDelimiter(), this.task.getTimestampColumnName(), this.task.getTimestampFormat(), this.task.isHeaderFlag(), this.copyContext.getCircuitBreaker(), this.task.getAtomicity());
                    this.serialImporter.setStatusReporter(this.updateStatusRef);
                    this.serialImporter.process(this.task.getSecurityContext());
                }
            }
            catch (TextImportException e) {
                this.updateStatus((byte)-1, e.isCancelled() ? (byte)3 : 2, e.getMessage(), 0L, 0L, 0L);
            }
            finally {
                this.requestSubSeq.done(cursor);
                this.copyContext.clear();
            }
            this.enforceLogRetention();
            return true;
        }
        return false;
    }
}

