/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.AllowAllSecurityContext;
import io.questdb.cairo.security.ReadOnlySecurityContext;
import io.questdb.cairo.security.SecurityContextFactory;
import io.questdb.std.Chars;

public final class ReadOnlyUsersAwareSecurityContextFactory
implements SecurityContextFactory {
    private final boolean pgWireReadOnly;
    private final String pgWireReadOnlyUser;
    private final boolean httpReadOnly;

    public ReadOnlyUsersAwareSecurityContextFactory(boolean pgWireReadOnly, String pgWireReadOnlyUser, boolean httpReadOnly) {
        this.pgWireReadOnly = pgWireReadOnly;
        this.pgWireReadOnlyUser = pgWireReadOnlyUser;
        this.httpReadOnly = httpReadOnly;
    }

    @Override
    public SecurityContext getInstance(CharSequence principal, int interfaceId) {
        switch (interfaceId) {
            case 0: {
                return this.httpReadOnly ? ReadOnlySecurityContext.INSTANCE : AllowAllSecurityContext.INSTANCE;
            }
            case 1: {
                return this.isReadOnlyPgWireUser(principal) ? ReadOnlySecurityContext.INSTANCE : AllowAllSecurityContext.INSTANCE;
            }
        }
        return AllowAllSecurityContext.INSTANCE;
    }

    private boolean isReadOnlyPgWireUser(CharSequence principal) {
        return this.pgWireReadOnly || this.pgWireReadOnlyUser != null && principal != null && Chars.equals((CharSequence)this.pgWireReadOnlyUser, principal);
    }
}

