/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IOContextFactoryImpl;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;

public class LineTcpReceiver
implements Closeable {
    private final IODispatcher<LineTcpConnectionContext> dispatcher;
    private final Metrics metrics;
    private LineTcpMeasurementScheduler scheduler = null;

    public LineTcpReceiver(LineTcpReceiverConfiguration configuration, CairoEngine engine, WorkerPool ioWorkerPool, WorkerPool writerWorkerPool) {
        this.metrics = engine.getMetrics();
        ObjectFactory<LineTcpConnectionContext> factory = () -> new LineTcpConnectionContext(configuration, this.scheduler, this.metrics);
        IOContextFactoryImpl<LineTcpConnectionContext> contextFactory = new IOContextFactoryImpl<LineTcpConnectionContext>(factory, configuration.getConnectionPoolInitialCapacity());
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), contextFactory);
        ioWorkerPool.assign(this.dispatcher);
        this.scheduler = new LineTcpMeasurementScheduler(configuration, engine, ioWorkerPool, this.dispatcher, writerWorkerPool);
        int n = ioWorkerPool.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            ioWorkerPool.assignThreadLocalCleaner(i, contextFactory::freeThreadLocal);
        }
    }

    @Override
    public void close() {
        Misc.free(this.scheduler);
        Misc.free(this.dispatcher);
    }
}

