/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.SymbolCache;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.network.IODispatcher;
import io.questdb.network.IORequestProcessor;
import io.questdb.std.ByteCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.DirectByteCharSequence;
import org.jetbrains.annotations.NotNull;

class LineTcpNetworkIOJob
implements NetworkIOJob {
    private static final Log LOG = LogFactory.getLog(LineTcpNetworkIOJob.class);
    private final IODispatcher<LineTcpConnectionContext> dispatcher;
    private final long maintenanceInterval;
    private final MillisecondClock millisecondClock;
    private final LineTcpMeasurementScheduler scheduler;
    private final ByteCharSequenceObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8 = new ByteCharSequenceObjHashMap();
    private final ObjList<SymbolCache> unusedSymbolCaches = new ObjList();
    private final int workerId;
    private LineTcpConnectionContext busyContext = null;
    private final IORequestProcessor<LineTcpConnectionContext> onRequest = this::onRequest;
    private long maintenanceJobDeadline;

    LineTcpNetworkIOJob(LineTcpReceiverConfiguration configuration, LineTcpMeasurementScheduler scheduler, IODispatcher<LineTcpConnectionContext> dispatcher, int workerId) {
        this.millisecondClock = configuration.getMillisecondClock();
        this.maintenanceInterval = configuration.getMaintenanceInterval();
        this.scheduler = scheduler;
        this.maintenanceJobDeadline = this.millisecondClock.getTicks() + this.maintenanceInterval;
        this.dispatcher = dispatcher;
        this.workerId = workerId;
    }

    @Override
    public void addTableUpdateDetails(ByteCharSequence tableNameUtf8, TableUpdateDetails tableUpdateDetails) {
        this.tableUpdateDetailsUtf8.put(tableNameUtf8, tableUpdateDetails);
        tableUpdateDetails.addReference(this.workerId);
    }

    @Override
    public void close() {
        if (this.busyContext != null) {
            this.busyContext.getDispatcher().disconnect(this.busyContext, 6);
            this.busyContext = null;
        }
        Misc.freeObjList(this.unusedSymbolCaches);
    }

    @Override
    public TableUpdateDetails getLocalTableDetails(DirectByteCharSequence tableNameUtf8) {
        return this.tableUpdateDetailsUtf8.get(tableNameUtf8);
    }

    @Override
    public ObjList<SymbolCache> getUnusedSymbolCaches() {
        return this.unusedSymbolCaches;
    }

    @Override
    public int getWorkerId() {
        return this.workerId;
    }

    @Override
    public void releaseWalTableDetails() {
        this.scheduler.releaseWalTableDetails(this.tableUpdateDetailsUtf8);
    }

    @Override
    public TableUpdateDetails removeTableUpdateDetails(DirectByteCharSequence tableNameUtf8) {
        int keyIndex = this.tableUpdateDetailsUtf8.keyIndex(tableNameUtf8);
        if (keyIndex < 0) {
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.valueAtQuick(keyIndex);
            this.tableUpdateDetailsUtf8.removeAt(keyIndex);
            return tud;
        }
        return null;
    }

    @Override
    public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
        long millis;
        assert (this.workerId == workerId);
        boolean busy = false;
        if (this.busyContext != null) {
            if (this.handleIO(this.busyContext)) {
                return true;
            }
            LOG.debug().$("context is no longer waiting on a full queue [fd=").$(this.busyContext.getFd()).$(']').$();
            this.busyContext = null;
            busy = true;
        }
        if (this.dispatcher.processIOQueue(this.onRequest)) {
            busy = true;
        }
        if ((millis = this.millisecondClock.getTicks()) > this.maintenanceJobDeadline && !(busy = this.scheduler.doMaintenance(this.tableUpdateDetailsUtf8, workerId, millis))) {
            this.maintenanceJobDeadline = millis + this.maintenanceInterval;
        }
        return busy;
    }

    private boolean handleIO(LineTcpConnectionContext context) {
        if (!context.invalid()) {
            switch (context.handleIO(this)) {
                case NEEDS_READ: {
                    context.getDispatcher().registerChannel(context, 1);
                    return false;
                }
                case NEEDS_WRITE: {
                    context.getDispatcher().registerChannel(context, 4);
                    return false;
                }
                case QUEUE_FULL: {
                    return true;
                }
                case NEEDS_DISCONNECT: {
                    context.getDispatcher().disconnect(context, 0);
                    return false;
                }
            }
        }
        return false;
    }

    private boolean onRequest(int operation, LineTcpConnectionContext context) {
        if (operation == 8) {
            context.doMaintenance(this.millisecondClock.getTicks());
            context.getDispatcher().registerChannel(context, 8);
            return false;
        }
        if (this.handleIO(context)) {
            this.busyContext = context;
            LOG.debug().$("context is waiting on a full queue [fd=").$(context.getFd()).$(']').$();
            return false;
        }
        return true;
    }
}

