/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;

public class IOTableUpdateDetailsPool
implements Closeable {
    private static final int ABASE;
    private static final int ASHIFT;
    private final Log LOG = LogFactory.getLog(IOTableUpdateDetailsPool.class);
    private final Function<CharSequence, ? extends TableUpdateDetails[]> createNewTableUpdateDetails;
    private final ConcurrentHashMap<TableUpdateDetails[]> pool = new ConcurrentHashMap();
    private final int pooledSize;
    private volatile boolean closed = false;

    public IOTableUpdateDetailsPool(int maxSize) {
        this.pooledSize = maxSize;
        this.createNewTableUpdateDetails = k -> new TableUpdateDetails[this.pooledSize];
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (CharSequence key : this.pool.keySet()) {
            TableUpdateDetails[] tudArray = this.pool.get(key);
            int n = tudArray.length;
            for (int i = 0; i < n; ++i) {
                TableUpdateDetails tud = IOTableUpdateDetailsPool.getVolatile(tudArray, i);
                if (tud == null) continue;
                this.releaseTud(tud);
            }
        }
    }

    public void closeIdle(long nowMillis, long idleTimeout) {
        for (CharSequence key : this.pool.keySet()) {
            TableUpdateDetails[] tudArray = this.pool.get(key);
            if (tudArray == null) continue;
            int n = tudArray.length;
            for (int i = 0; i < n; ++i) {
                TableUpdateDetails tud = IOTableUpdateDetailsPool.getVolatile(tudArray, i);
                if (tud == null || nowMillis - tud.getLastMeasurementMillis() < idleTimeout || !IOTableUpdateDetailsPool.casTabAt(tudArray, i, tud, null)) continue;
                this.LOG.info().$("active table going idle [tableName=").$(tud.getTableNameUtf16()).I$();
                this.releaseTud(tud);
            }
        }
    }

    public TableUpdateDetails get(CharSequence tableNameUtf8) {
        TableUpdateDetails[] tudArray = this.pool.get(tableNameUtf8);
        if (tudArray != null) {
            int n = tudArray.length;
            for (int i = 0; i < n; ++i) {
                TableUpdateDetails tud = IOTableUpdateDetailsPool.getVolatile(tudArray, i);
                if (tud == null || !IOTableUpdateDetailsPool.casTabAt(tudArray, i, tud, null)) continue;
                return tud;
            }
        }
        return null;
    }

    public void put(CharSequence tableNameUtf8, TableUpdateDetails tud) {
        TableUpdateDetails[] tudArray = this.pool.computeIfAbsent(tableNameUtf8, this.createNewTableUpdateDetails);
        block0: while (true) {
            if (this.closed) {
                this.releaseTud(tud);
                return;
            }
            int n = tudArray.length;
            int i = 0;
            while (true) {
                if (i >= n) continue block0;
                if (IOTableUpdateDetailsPool.casTabAt(tudArray, i, null, tud)) {
                    return;
                }
                ++i;
            }
            break;
        }
    }

    private void releaseTud(TableUpdateDetails tud) {
        Misc.free(tud);
    }

    static boolean casTabAt(TableUpdateDetails[] tab, int i, TableUpdateDetails expected, TableUpdateDetails v) {
        return Unsafe.getUnsafe().compareAndSwapObject(tab, ((long)i << ASHIFT) + (long)ABASE, expected, v);
    }

    static TableUpdateDetails getVolatile(TableUpdateDetails[] tab, int i) {
        return (TableUpdateDetails)Unsafe.getUnsafe().getObjectVolatile(tab, ((long)i << ASHIFT) + (long)ABASE);
    }

    static {
        Class<TableUpdateDetails[]> ak = TableUpdateDetails[].class;
        ABASE = Unsafe.getUnsafe().arrayBaseOffset(ak);
        int scale = Unsafe.getUnsafe().arrayIndexScale(ak);
        if ((scale & scale - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
    }
}

