/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.cairo.TableUtils;
import io.questdb.client.Sender;
import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import java.io.Closeable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;

public abstract class AbstractLineSender
extends AbstractCharSink
implements Closeable,
Sender {
    protected final int capacity;
    private final long bufA;
    private final long bufB;
    protected LineChannel lineChannel;
    private boolean closed;
    private boolean enableValidation;
    private boolean hasColumns;
    private boolean hasSymbols;
    private boolean hasTable;
    private long hi;
    private long lineStart;
    private long lo;
    private long ptr;
    private boolean quoted = false;

    public AbstractLineSender(LineChannel lineChannel, int capacity) {
        this.lineChannel = lineChannel;
        this.capacity = capacity;
        this.enableValidation = true;
        this.bufA = Unsafe.malloc(capacity, 46);
        this.bufB = Unsafe.malloc(capacity, 46);
        this.lo = this.bufA;
        this.hi = this.lo + (long)capacity;
        this.ptr = this.lo;
        this.lineStart = this.lo;
    }

    public void $(long timestamp) {
        this.put(' ').put(timestamp);
        this.atNow();
    }

    public void $() {
        this.atNow();
    }

    @Override
    public final void at(long timestamp) {
        this.put(' ').put(timestamp);
        this.atNow();
    }

    @Override
    public final void atNow() {
        if (!this.hasColumns && !this.hasSymbols && this.enableValidation) {
            throw new LineSenderException("no symbols or columns were provided");
        }
        this.put('\n');
        this.lineStart = this.ptr;
        this.hasTable = false;
        this.hasColumns = false;
        this.hasSymbols = false;
    }

    public final void authenticate(String keyId, PrivateKey privateKey) {
        this.validateNotClosed();
        this.encodeUtf8(keyId).put('\n');
        this.sendAll();
        byte[] challengeBytes = this.receiveChallengeBytes();
        byte[] signature = this.signAndEncode(privateKey, challengeBytes);
        int m = signature.length;
        for (int n = 0; n < m; ++n) {
            this.put((char)signature[n]);
        }
        this.put('\n');
        this.sendAll();
    }

    @Override
    public final AbstractLineSender boolColumn(CharSequence name, boolean value) {
        return this.field(name, value);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
        }
        finally {
            this.closed = true;
            this.lineChannel = Misc.free(this.lineChannel);
            Unsafe.free(this.bufA, this.capacity, 46);
            Unsafe.free(this.bufB, this.capacity, 46);
        }
    }

    public void disableValidation() {
        this.enableValidation = false;
    }

    @Override
    public final AbstractLineSender doubleColumn(CharSequence name, double value) {
        return this.field(name, value);
    }

    public AbstractLineSender field(CharSequence name, long value) {
        this.writeFieldName(name).put(value).put('i');
        return this;
    }

    public AbstractLineSender field(CharSequence name, CharSequence value) {
        this.writeFieldName(name).put('\"');
        this.quoted = true;
        this.encodeUtf8(value);
        this.quoted = false;
        this.put('\"');
        return this;
    }

    public AbstractLineSender field(CharSequence name, double value) {
        this.writeFieldName(name).put(value);
        return this;
    }

    public AbstractLineSender field(CharSequence name, boolean value) {
        this.writeFieldName(name).put(value ? (char)'t' : 'f');
        return this;
    }

    @Override
    public void flush() {
        this.validateNotClosed();
        this.sendLine();
        this.ptr = this.lineStart = this.lo;
    }

    @Override
    public final AbstractLineSender longColumn(CharSequence name, long value) {
        return this.field(name, value);
    }

    public AbstractLineSender metric(CharSequence metric) {
        this.validateNotClosed();
        this.validateTableName(metric);
        if (this.hasTable) {
            throw new LineSenderException("duplicated table. call sender.at() or sender.atNow() to finish the current row first");
        }
        if (metric.length() == 0) {
            throw new LineSenderException("table name cannot be empty");
        }
        this.quoted = false;
        this.hasTable = true;
        this.encodeUtf8(metric);
        return this;
    }

    @Override
    public AbstractLineSender put(CharSequence cs) {
        this.validateNotClosed();
        int l = cs.length();
        if (this.ptr + (long)l < this.hi) {
            Chars.asciiStrCpy(cs, l, this.ptr);
        } else {
            this.send00();
            if (this.ptr + (long)l < this.hi) {
                Chars.asciiStrCpy(cs, l, this.ptr);
            } else {
                throw new LineSenderException("value too long. increase buffer size.");
            }
        }
        this.ptr += (long)l;
        return this;
    }

    @Override
    public AbstractLineSender put(char c) {
        this.validateNotClosed();
        if (this.ptr >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putByte(this.ptr++, (byte)c);
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        this.validateNotClosed();
        if (this.ptr + (long)len < this.hi) {
            Chars.asciiCopyTo(chars, start, len, this.ptr);
        } else {
            this.send00();
            if (this.ptr + (long)len < this.hi) {
                Chars.asciiCopyTo(chars, start, len, this.ptr);
            } else {
                throw new LineSenderException("value too long. increase buffer size.");
            }
        }
        this.ptr += (long)len;
        return this;
    }

    @Override
    public CharSink put(long value) {
        Numbers.append((CharSink)this, value, false);
        return this;
    }

    @Override
    public void putUtf8Special(char c) {
        this.validateNotClosed();
        switch (c) {
            case ' ': 
            case ',': 
            case '=': {
                if (!this.quoted) {
                    this.put('\\');
                }
            }
            default: {
                this.put(c);
                break;
            }
            case '\n': 
            case '\r': {
                this.put('\\').put(c);
                break;
            }
            case '\"': {
                if (this.quoted) {
                    this.put('\\');
                }
                this.put(c);
                break;
            }
            case '\\': {
                this.put('\\').put('\\');
            }
        }
    }

    @Override
    public final AbstractLineSender stringColumn(CharSequence name, CharSequence value) {
        return this.field(name, value);
    }

    @Override
    public final AbstractLineSender symbol(CharSequence name, CharSequence value) {
        return this.tag(name, value);
    }

    @Override
    public final AbstractLineSender table(CharSequence table) {
        return this.metric(table);
    }

    public AbstractLineSender tag(CharSequence tag, CharSequence value) {
        if (!this.hasTable) {
            throw new LineSenderException("table expected");
        }
        if (this.hasColumns) {
            throw new LineSenderException("symbols must be written before any other column types");
        }
        this.validateColumnName(tag);
        this.put(',').encodeUtf8(tag).put('=').encodeUtf8(value);
        this.hasSymbols = true;
        return this;
    }

    @Override
    public final AbstractLineSender timestampColumn(CharSequence name, long value) {
        this.writeFieldName(name).put(value).put('t');
        return this;
    }

    private static int findEOL(long ptr, int len) {
        for (int i = 0; i < len; ++i) {
            byte b = Unsafe.getUnsafe().getByte(ptr + (long)i);
            if (b != 10) continue;
            return i;
        }
        return -1;
    }

    private byte[] receiveChallengeBytes() {
        int eol;
        int n;
        block3: {
            int rc;
            n = 0;
            do {
                if ((rc = this.lineChannel.receive(this.ptr + (long)n, this.capacity - n)) < 0) {
                    int errno = this.lineChannel.errno();
                    this.close();
                    throw new LineSenderException("disconnected during authentication").errno(errno);
                }
                eol = AbstractLineSender.findEOL(this.ptr + (long)n, rc);
                if (eol != -1) break block3;
            } while ((n += rc) != this.capacity);
            this.close();
            throw new LineSenderException("challenge did not fit into buffer");
        }
        int sz = n += eol;
        byte[] challengeBytes = new byte[sz];
        for (n = 0; n < sz; ++n) {
            challengeBytes[n] = Unsafe.getUnsafe().getByte(this.ptr + (long)n);
        }
        return challengeBytes;
    }

    private void sendLine() {
        if (this.lo < this.lineStart) {
            int len = (int)(this.lineStart - this.lo);
            this.lineChannel.send(this.lo, len);
        }
    }

    private void validateColumnName(CharSequence name) {
        if (!this.enableValidation) {
            return;
        }
        if (!TableUtils.isValidColumnName(name, Integer.MAX_VALUE)) {
            throw new LineSenderException("column name contains an illegal char: '\\n', '\\r', '?', '.', ',', ''', '\"', '\\', '/', ':', ')', '(', '+', '-', '*' '%%', '~', or a non-printable char: ").putAsPrintable(name);
        }
    }

    private void validateTableName(CharSequence name) {
        if (!this.enableValidation) {
            return;
        }
        if (!TableUtils.isValidTableName(name, Integer.MAX_VALUE)) {
            throw new LineSenderException("table name contains an illegal char: '\\n', '\\r', '?', ',', ''', '\"', '\\', '/', ':', ')', '(', '+', '*' '%%', '~', or a non-printable char: ").putAsPrintable(name);
        }
    }

    private CharSink writeFieldName(CharSequence name) {
        this.validateNotClosed();
        this.validateColumnName(name);
        if (this.hasTable) {
            if (!this.hasColumns) {
                this.put(' ');
                this.hasColumns = true;
            } else {
                this.put(',');
            }
            return this.encodeUtf8(name).put('=');
        }
        throw new LineSenderException("table expected");
    }

    protected void send00() {
        this.validateNotClosed();
        int len = (int)(this.ptr - this.lineStart);
        if (len == 0) {
            this.sendLine();
            this.ptr = this.lineStart = this.lo;
        } else if (len < this.capacity) {
            long target = this.lo == this.bufA ? this.bufB : this.bufA;
            Vect.memcpy(target, this.lineStart, len);
            this.sendLine();
            this.lineStart = this.lo = target;
            this.ptr = target + (long)len;
            this.hi = this.lo + (long)this.capacity;
        } else {
            throw new LineSenderException("line too long. increase buffer size.");
        }
    }

    protected void sendAll() {
        this.validateNotClosed();
        if (this.lo < this.ptr) {
            int len = (int)(this.ptr - this.lo);
            this.lineChannel.send(this.lo, len);
            this.lineStart = this.ptr = this.lo;
        }
    }

    protected byte[] signAndEncode(PrivateKey privateKey, byte[] challengeBytes) {
        byte[] rawSignature;
        try {
            Signature sig = Signature.getInstance("SHA256withECDSA");
            sig.initSign(privateKey);
            sig.update(challengeBytes);
            rawSignature = sig.sign();
        }
        catch (InvalidKeyException ex) {
            this.close();
            throw new LineSenderException("invalid key", ex);
        }
        catch (SignatureException ex) {
            this.close();
            throw new LineSenderException("cannot sign challenge", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.close();
            throw new LineSenderException("unsupported signing algorithm", ex);
        }
        return Base64.getEncoder().encode(rawSignature);
    }

    protected final void validateNotClosed() {
        if (this.closed) {
            throw new LineSenderException("sender already closed");
        }
    }
}

