/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorState;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.http.processors.TextQueryProcessorState;
import io.questdb.cutlass.text.TextUtil;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Uuid;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class TextQueryProcessor
implements HttpRequestProcessor,
Closeable {
    private static final Log LOG = LogFactory.getLog(TextQueryProcessor.class);
    private static final LocalValue<TextQueryProcessorState> LV = new LocalValue();
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final MillisecondClock clock;
    private final SqlCompiler compiler;
    private final JsonQueryProcessorConfiguration configuration;
    private final int doubleScale;
    private final int floatScale;
    private final Metrics metrics;
    private final SqlExecutionContextImpl sqlExecutionContext;

    public TextQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, int workerCount) {
        this(configuration, engine, workerCount, workerCount, null, null);
    }

    public TextQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, int workerCount, int sharedWorkerCount, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent) {
        this.configuration = configuration;
        this.compiler = configuration.getFactoryProvider().getSqlCompilerFactory().getInstance(engine, functionFactoryCache, snapshotAgent);
        this.floatScale = configuration.getFloatScale();
        this.clock = configuration.getClock();
        this.sqlExecutionContext = new SqlExecutionContextImpl(engine, workerCount, sharedWorkerCount);
        this.doubleScale = configuration.getDoubleScale();
        this.circuitBreaker = new NetworkSqlExecutionCircuitBreaker(engine.getConfiguration().getCircuitBreakerConfiguration(), 31);
        this.metrics = engine.getMetrics();
    }

    @Override
    public void close() {
        Misc.free(this.compiler);
        Misc.free(this.circuitBreaker);
    }

    public void execute(HttpConnectionContext context, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        block17: {
            try {
                boolean isExpRequest = TextQueryProcessor.isExpUrl(context.getRequestHeader().getUrl());
                this.circuitBreaker.resetTimer();
                state.recordCursorFactory = QueryCache.getThreadLocalInstance().poll(state.query);
                state.setQueryCacheable(true);
                this.sqlExecutionContext.with(context.getSecurityContext(), null, null, context.getFd(), this.circuitBreaker.of(context.getFd()));
                if (state.recordCursorFactory == null) {
                    CompiledQuery cc = this.compiler.compile(state.query, this.sqlExecutionContext);
                    if (cc.getType() == 1 || cc.getType() == 25) {
                        state.recordCursorFactory = cc.getRecordCursorFactory();
                    } else if (isExpRequest) {
                        throw SqlException.$(0, "/exp endpoint only accepts SELECT");
                    }
                    this.info(state).$("execute-new [q=`").utf8(state.query).$("`, skip: ").$(state.skip).$(", stop: ").$(state.stop).I$();
                    this.sqlExecutionContext.storeTelemetry(cc.getType(), (short)4);
                } else {
                    this.info(state).$("execute-cached [q=`").utf8(state.query).$("`, skip: ").$(state.skip).$(", stop: ").$(state.stop).I$();
                    this.sqlExecutionContext.storeTelemetry((short)1, (short)4);
                }
                if (state.recordCursorFactory != null) {
                    try {
                        boolean runQuery = true;
                        int retries = 0;
                        while (runQuery) {
                            try {
                                state.cursor = state.recordCursorFactory.getCursor(this.sqlExecutionContext);
                                runQuery = false;
                            }
                            catch (TableReferenceOutOfDateException e) {
                                if (retries == 10) {
                                    throw e;
                                }
                                this.info(state).$(e.getFlyweightMessage()).$();
                                state.recordCursorFactory = Misc.free(state.recordCursorFactory);
                                CompiledQuery cc = this.compiler.compile(state.query, this.sqlExecutionContext);
                                if (cc.getType() != 1 && isExpRequest) {
                                    throw SqlException.$(0, "/exp endpoint only accepts SELECT");
                                }
                                state.recordCursorFactory = cc.getRecordCursorFactory();
                            }
                            ++retries;
                        }
                        state.metadata = state.recordCursorFactory.getMetadata();
                        this.header(context.getChunkedResponseSocket(), state, 200);
                        this.doResumeSend(context);
                    }
                    catch (CairoException e) {
                        state.setQueryCacheable(e.isCacheable());
                        this.internalError(context.getChunkedResponseSocket(), context.getLastRequestBytesSent(), e, state);
                    }
                    catch (CairoError e) {
                        this.internalError(context.getChunkedResponseSocket(), context.getLastRequestBytesSent(), e, state);
                    }
                    break block17;
                }
                this.headerNoContentDisposition(context.getChunkedResponseSocket());
                this.sendConfirmation(context.getChunkedResponseSocket());
                TextQueryProcessor.readyForNextRequest(context);
            }
            catch (ImplicitCastException | SqlException e) {
                this.syntaxError(context.getChunkedResponseSocket(), state, (FlyweightMessageContainer)((Object)e));
                TextQueryProcessor.readyForNextRequest(context);
            }
            catch (CairoError | CairoException e) {
                this.internalError(context.getChunkedResponseSocket(), context.getLastRequestBytesSent(), e, state);
                TextQueryProcessor.readyForNextRequest(context);
            }
        }
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        TextQueryProcessorState state = LV.get(context);
        if (state == null) {
            state = new TextQueryProcessorState(context);
            LV.set(context, state);
        }
        state.rnd = null;
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        if (this.parseUrl(socket, context.getRequestHeader(), state)) {
            this.execute(context, state);
        } else {
            TextQueryProcessor.readyForNextRequest(context);
        }
    }

    @Override
    public void parkRequest(HttpConnectionContext context, boolean pausedQuery) {
        TextQueryProcessorState state = LV.get(context);
        if (state != null) {
            state.pausedQuery = pausedQuery;
            state.rnd = this.sqlExecutionContext.getRandom();
        }
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        try {
            this.doResumeSend(context);
        }
        catch (CairoError | CairoException e) {
            TextQueryProcessorState state = LV.get(context);
            if (state != null) {
                this.logInternalError(e, state);
            }
            throw ServerDisconnectException.INSTANCE;
        }
    }

    private static boolean isExpUrl(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 47 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 120 && (tok.charAt(i) | 0x20) == 112;
    }

    private static void putGeoHashStringValue(HttpChunkedResponseSocket socket, long value, int type) {
        if (value == -1L) {
            socket.put("null");
        } else {
            int bitFlags = GeoHashes.getBitFlags(type);
            socket.put('\"');
            if (bitFlags < 0) {
                GeoHashes.appendCharsUnsafe(value, -bitFlags, socket);
            } else {
                GeoHashes.appendBinaryStringUnsafe(value, bitFlags, socket);
            }
            socket.put('\"');
        }
    }

    private static void putStringOrNull(CharSink r, CharSequence str) {
        if (str != null) {
            r.encodeUtf8AndQuote(str);
        }
    }

    private static void putUuidOrNull(HttpChunkedResponseSocket socket, long lo, long hi) {
        if (Uuid.isNull(lo, hi)) {
            return;
        }
        Numbers.appendUuid(lo, hi, socket);
    }

    private static void readyForNextRequest(HttpConnectionContext context) {
        LOG.info().$("all sent [fd=").$(context.getFd()).$(", lastRequestBytesSent=").$(context.getLastRequestBytesSent()).$(", nCompletedRequests=").$(context.getNCompletedRequests() + 1).$(", totalBytesSent=").$(context.getTotalBytesSent()).I$();
    }

    private LogRecord critical(TextQueryProcessorState state) {
        return LOG.critical().$('[').$(state.getFd()).$("] ");
    }

    /*
     * Unable to fully structure code
     */
    private void doResumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        state = TextQueryProcessor.LV.get(context);
        if (state == null || state.cursor == null) {
            return;
        }
        this.sqlExecutionContext.with(context.getSecurityContext(), null, state.rnd, context.getFd(), this.circuitBreaker.of(context.getFd()));
        TextQueryProcessor.LOG.debug().$("resume [fd=").$(context.getFd()).I$();
        if (!state.pausedQuery) {
            context.resumeResponseSend();
        } else {
            state.pausedQuery = false;
        }
        socket = context.getChunkedResponseSocket();
        columnCount = state.metadata.getColumnCount();
        block10: while (true) {
            try {
                switch (state.queryState) {
                    case 1: 
                    case 2: {
                        state.columnIndex = 0;
                        state.queryState = 2;
                        while (state.columnIndex < columnCount) {
                            if (state.columnIndex > 0) {
                                socket.put(state.delimiter);
                            }
                            socket.putQuoted(state.metadata.getColumnName(state.columnIndex));
                            ++state.columnIndex;
                            socket.bookmark();
                        }
                        socket.put("\r\n");
                        state.queryState = 4;
                        socket.bookmark();
                    }
                    case 4: {
                        if (state.record != null) ** GOTO lbl42
                        record = state.cursor.getRecord();
                        while (state.cursor.hasNext()) {
                            ++state.count;
                            if (state.countRows && state.count > state.stop || state.count <= state.skip) continue;
                            state.record = record;
                            ** GOTO lbl42
                        }
                        state.queryState = 7;
                        continue block10;
lbl42:
                        // 2 sources

                        if (state.count > state.stop) {
                            state.queryState = 7;
                            continue block10;
                        }
                        state.queryState = 5;
                        state.columnIndex = 0;
                    }
                    case 5: {
                        while (state.columnIndex < columnCount) {
                            if (state.columnIndex > 0) {
                                socket.put(state.delimiter);
                            }
                            this.putValue(socket, state.metadata.getColumnType(state.columnIndex), state.record, state.columnIndex);
                            ++state.columnIndex;
                            socket.bookmark();
                        }
                        state.queryState = 6;
                    }
                    case 6: {
                        socket.put("\r\n");
                        state.record = null;
                        state.queryState = 4;
                        socket.bookmark();
                        continue block10;
                    }
                    case 7: {
                        this.sendDone(socket, state);
                        break;
                    }
                }
            }
            catch (DataUnavailableException e) {
                socket.resetToBookmark();
                throw QueryPausedException.instance(e.getEvent(), this.sqlExecutionContext.getCircuitBreaker());
            }
            catch (NoSpaceLeftInResponseBufferException ignored) {
                if (socket.resetToBookmark()) {
                    socket.sendChunk(false);
                    continue;
                }
                this.info(state).$("Response buffer is too small, state=").$(state.queryState).$();
                throw PeerDisconnectedException.INSTANCE;
            }
            break;
        }
        TextQueryProcessor.readyForNextRequest(context);
    }

    private LogRecord error(TextQueryProcessorState state) {
        return LOG.error().$('[').$(state.getFd()).$("] ");
    }

    private LogRecord info(TextQueryProcessorState state) {
        return LOG.info().$('[').$(state.getFd()).$("] ");
    }

    private void internalError(HttpChunkedResponseSocket socket, long bytesSent, Throwable e, TextQueryProcessorState state) throws ServerDisconnectException, PeerDisconnectedException, PeerIsSlowToReadException {
        this.logInternalError(e, state);
        if (bytesSent > 0L) {
            throw ServerDisconnectException.INSTANCE;
        }
        this.sendException(socket, 0, e.getMessage(), state);
    }

    private void logInternalError(Throwable e, TextQueryProcessorState state) {
        if (e instanceof CairoException) {
            CairoException ce = (CairoException)e;
            if (ce.isInterruption()) {
                this.info(state).$("query cancelled [reason=`").$(((CairoException)e).getFlyweightMessage()).$("`, q=`").utf8(state.query).$("`]").$();
            } else if (ce.isCritical()) {
                this.critical(state).$("error [msg=`").$(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$("`, q=`").utf8(state.query).$("`]").$();
            } else {
                this.error(state).$("error [msg=`").$(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$("`, q=`").utf8(state.query).$("`]").$();
            }
        } else if (e instanceof HttpException) {
            this.error(state).$("internal HTTP server error [reason=`").$(((HttpException)e).getFlyweightMessage()).$("`, q=`").utf8(state.query).$("`]").$();
        } else {
            this.critical(state).$("internal error [ex=").$(e).$(", q=`").utf8(state.query).$("`]").$();
            this.metrics.health().incrementUnhandledErrors();
        }
    }

    private boolean parseUrl(HttpChunkedResponseSocket socket, HttpRequestHeader request, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException {
        DirectByteCharSequence query = request.getUrlParam("query");
        if (query == null || query.length() == 0) {
            this.info(state).$("Empty query request received. Sending empty reply.").$();
            this.sendException(socket, 0, "No query text", state);
            return false;
        }
        long skip = 0L;
        long stop = Long.MAX_VALUE;
        DirectByteCharSequence limit = request.getUrlParam("limit");
        if (limit != null) {
            int sepPos = Chars.indexOf(limit, ',');
            try {
                if (sepPos > 0) {
                    skip = Numbers.parseLong(limit, 0, sepPos);
                    if (sepPos + 1 < limit.length()) {
                        stop = Numbers.parseLong(limit, sepPos + 1, limit.length());
                    }
                } else {
                    stop = Numbers.parseLong(limit);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        if (stop < 0L) {
            stop = 0L;
        }
        if (skip < 0L) {
            skip = 0L;
        }
        if (stop - skip > this.configuration.getMaxQueryResponseRowLimit()) {
            stop = skip + this.configuration.getMaxQueryResponseRowLimit();
        }
        state.query.clear();
        try {
            TextUtil.utf8ToUtf16(query.getLo(), query.getHi(), state.query);
        }
        catch (Utf8Exception e) {
            this.info(state).$("Bad UTF8 encoding").$();
            this.sendException(socket, 0, "Bad UTF8 encoding in query text", state);
            return false;
        }
        DirectByteCharSequence fileName = request.getUrlParam("filename");
        state.fileName = null;
        if (fileName != null && fileName.length() > 0) {
            state.fileName = fileName.toString();
        }
        DirectByteCharSequence delimiter = request.getUrlParam("delimiter");
        state.delimiter = (char)44;
        if (delimiter != null && delimiter.length() == 1) {
            state.delimiter = delimiter.charAt(0);
        }
        state.skip = skip;
        state.count = 0L;
        state.stop = stop;
        state.noMeta = Chars.equalsNc((CharSequence)"true", request.getUrlParam("nm"));
        state.countRows = Chars.equalsNc((CharSequence)"true", request.getUrlParam("count"));
        return true;
    }

    private void putValue(HttpChunkedResponseSocket socket, int type, Record rec, int col) {
        switch (ColumnType.tagOf(type)) {
            case 1: {
                socket.put(rec.getBool(col));
                break;
            }
            case 2: {
                socket.put(rec.getByte(col));
                break;
            }
            case 10: {
                double d = rec.getDouble(col);
                if (d != d) break;
                socket.put(d, this.doubleScale);
                break;
            }
            case 9: {
                float f = rec.getFloat(col);
                if (f != f) break;
                socket.put(f, this.floatScale);
                break;
            }
            case 5: {
                int i = rec.getInt(col);
                if (i <= Integer.MIN_VALUE) break;
                Numbers.append((CharSink)socket, i);
                break;
            }
            case 6: {
                long l = rec.getLong(col);
                if (l <= Long.MIN_VALUE) break;
                socket.put(l);
                break;
            }
            case 7: {
                long l = rec.getDate(col);
                if (l <= Long.MIN_VALUE) break;
                socket.put('\"').putISODateMillis(l).put('\"');
                break;
            }
            case 8: {
                long l = rec.getTimestamp(col);
                if (l <= Long.MIN_VALUE) break;
                socket.put('\"').putISODate(l).put('\"');
                break;
            }
            case 3: {
                socket.put(rec.getShort(col));
                break;
            }
            case 4: {
                char c = rec.getChar(col);
                if (c <= '\u0000') break;
                socket.put(c);
                break;
            }
            case 18: 
            case 22: 
            case 29: {
                break;
            }
            case 11: {
                TextQueryProcessor.putStringOrNull(socket, rec.getStr(col));
                break;
            }
            case 12: {
                TextQueryProcessor.putStringOrNull(socket, rec.getSym(col));
                break;
            }
            case 13: {
                rec.getLong256(col, socket);
                break;
            }
            case 14: {
                TextQueryProcessor.putGeoHashStringValue(socket, rec.getGeoByte(col), type);
                break;
            }
            case 15: {
                TextQueryProcessor.putGeoHashStringValue(socket, rec.getGeoShort(col), type);
                break;
            }
            case 16: {
                TextQueryProcessor.putGeoHashStringValue(socket, rec.getGeoInt(col), type);
                break;
            }
            case 17: {
                TextQueryProcessor.putGeoHashStringValue(socket, rec.getGeoLong(col), type);
                break;
            }
            case 19: {
                TextQueryProcessor.putUuidOrNull(socket, rec.getLong128Lo(col), rec.getLong128Hi(col));
                break;
            }
            case 24: {
                throw new UnsupportedOperationException();
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void sendConfirmation(HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        socket.put("DDL Success\n");
        socket.sendChunk(true);
    }

    private void sendDone(HttpChunkedResponseSocket socket, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (state.count > -1L) {
            state.count = -1L;
            socket.sendChunk(true);
            return;
        }
        socket.done();
    }

    private void sendException(HttpChunkedResponseSocket socket, int position, CharSequence message, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.headerJsonError(socket);
        JsonQueryProcessorState.prepareExceptionJson(socket, position, message, state.query);
    }

    private void syntaxError(HttpChunkedResponseSocket socket, TextQueryProcessorState state, FlyweightMessageContainer container) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.info(state).$("syntax-error [q=`").utf8(state.query).$("`, at=").$(container.getPosition()).$(", message=`").$(container.getFlyweightMessage()).$('`').I$();
        this.sendException(socket, container.getPosition(), container.getFlyweightMessage(), state);
    }

    protected void header(HttpChunkedResponseSocket socket, TextQueryProcessorState state, int statusCode) throws PeerDisconnectedException, PeerIsSlowToReadException {
        socket.status(statusCode, "text/csv; charset=utf-8");
        if (state.fileName != null && state.fileName.length() > 0) {
            socket.headers().put("Content-Disposition: attachment; filename=\"").put(state.fileName).put(".csv\"").put("\r\n");
        } else {
            socket.headers().put("Content-Disposition: attachment; filename=\"questdb-query-").put(this.clock.getTicks()).put(".csv\"").put("\r\n");
        }
        socket.headers().setKeepAlive(this.configuration.getKeepAliveHeader());
        socket.sendHeader();
    }

    protected void headerJsonError(HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        socket.status(400, "application/json; charset=utf-8");
        socket.headers().setKeepAlive(this.configuration.getKeepAliveHeader());
        socket.sendHeader();
    }

    protected void headerNoContentDisposition(HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        socket.status(200, "text/csv; charset=utf-8");
        socket.headers().setKeepAlive(this.configuration.getKeepAliveHeader());
        socket.sendHeader();
    }
}

