/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.processors.TextLoaderCompletedState;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import java.io.Closeable;

class TextImportProcessorState
implements Mutable,
Closeable {
    public static final int STATE_OK = 0;
    public int columnIndex = 0;
    public TextLoaderCompletedState completeState;
    boolean analysed = false;
    CharSequence errorMessage;
    boolean forceHeader = false;
    long hi;
    boolean json = false;
    long lo;
    int messagePart = 3;
    int responseState = 1;
    int state;
    String stateMessage;
    TextLoader textLoader;

    TextImportProcessorState(CairoEngine engine) {
        this.textLoader = new TextLoader(engine);
    }

    @Override
    public void clear() {
        this.responseState = 1;
        this.messagePart = 3;
        this.columnIndex = 0;
        this.analysed = false;
        this.json = false;
        this.state = 0;
        this.textLoader.clear();
        this.errorMessage = null;
    }

    @Override
    public void close() {
        this.clear();
        this.textLoader = Misc.free(this.textLoader);
    }

    public void snapshotStateAndCloseWriter() {
        if (this.completeState == null) {
            this.completeState = new TextLoaderCompletedState();
        }
        this.completeState.copyState(this.textLoader);
        this.textLoader.closeWriter();
    }
}

