/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRangeParser;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.processors.StaticContentProcessorState;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.FileNameExtractorCharSequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.PrefixedPath;
import java.io.Closeable;

public class StaticContentProcessor
implements HttpRequestProcessor,
Closeable {
    private static final Log LOG = LogFactory.getLog(StaticContentProcessor.class);
    private static final LocalValue<StaticContentProcessorState> LV = new LocalValue();
    private final FilesFacade ff;
    private final String httpProtocolVersion;
    private final CharSequence indexFileName;
    private final String keepAliveHeader;
    private final MimeTypesCache mimeTypes;
    private final PrefixedPath prefixedPath;
    private final HttpRangeParser rangeParser = new HttpRangeParser();
    private final boolean requiresAuthentication;

    public StaticContentProcessor(HttpServerConfiguration configuration) {
        this.mimeTypes = configuration.getStaticContentProcessorConfiguration().getMimeTypesCache();
        this.prefixedPath = new PrefixedPath(configuration.getStaticContentProcessorConfiguration().getPublicDirectory());
        this.indexFileName = configuration.getStaticContentProcessorConfiguration().getIndexFileName();
        this.ff = configuration.getStaticContentProcessorConfiguration().getFilesFacade();
        this.keepAliveHeader = configuration.getStaticContentProcessorConfiguration().getKeepAliveHeader();
        this.httpProtocolVersion = configuration.getHttpContextConfiguration().getHttpVersion();
        this.requiresAuthentication = configuration.getStaticContentProcessorConfiguration().isAuthenticationRequired();
    }

    @Override
    public void close() {
        Misc.free(this.prefixedPath);
    }

    public LogRecord logInfoWithFd(HttpConnectionContext context) {
        return LOG.info().$('[').$(context.getFd()).$("] ");
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpRequestHeader headers = context.getRequestHeader();
        CharSequence url = headers.getUrl();
        this.logInfoWithFd(context).$("incoming [url=").$(url).$(']').$();
        if (Chars.contains(url, "..")) {
            this.logInfoWithFd(context).$("URL abuse: ").$(url).$();
            StaticContentProcessor.sendStatusWithDefaultMessage(context, 404);
        } else {
            PrefixedPath path = this.prefixedPath.rewind();
            if (Chars.equals(url, '/')) {
                path.concat(this.indexFileName);
            } else {
                path.concat(url);
            }
            path.$();
            if (this.ff.exists(path)) {
                this.send(context, path, headers.getUrlParam("attachment") != null);
            } else {
                this.logInfoWithFd(context).$("not found [path=").$(path).$(']').$();
                StaticContentProcessor.sendStatusWithDefaultMessage(context, 404);
            }
        }
    }

    @Override
    public boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        long l;
        LOG.debug().$("resumeSend").$();
        StaticContentProcessorState state = LV.get(context);
        if (state == null || state.fd == -1) {
            return;
        }
        context.resumeResponseSend();
        HttpRawSocket socket = context.getRawResponseSocket();
        long address = socket.getBufferAddress();
        int size = socket.getBufferSize();
        while (state.bytesSent < state.sendMax && (l = this.ff.read(state.fd, address, size, state.bytesSent)) > 0L) {
            if (l + state.bytesSent > state.sendMax) {
                l = state.sendMax - state.bytesSent;
            }
            state.bytesSent += l;
            socket.send((int)l);
        }
    }

    private static void sendStatusWithDefaultMessage(HttpConnectionContext context, int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
        context.simpleResponse().sendStatusWithDefaultMessage(code);
    }

    private void send(HttpConnectionContext context, LPSZ path, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int l;
        int n = Chars.lastIndexOf(path, '.');
        if (n == -1) {
            this.logInfoWithFd(context).$("missing extension [file=").$(path).$(']').$();
            StaticContentProcessor.sendStatusWithDefaultMessage(context, 404);
            return;
        }
        HttpRequestHeader headers = context.getRequestHeader();
        CharSequence contentType = (CharSequence)this.mimeTypes.valueAt(this.mimeTypes.keyIndex(path, n + 1, path.length()));
        DirectByteCharSequence val = headers.getHeader("Range");
        if (val != null) {
            this.sendRange(context, val, path, contentType, asAttachment);
            return;
        }
        val = headers.getHeader("If-None-Match");
        if (val != null && (l = val.length()) > 2 && val.charAt(0) == '\"' && val.charAt(l - 1) == '\"') {
            try {
                long that = Numbers.parseLong(val, 1, l - 1);
                if (that == this.ff.getLastModified(path)) {
                    context.simpleResponse().sendStatus(304);
                    return;
                }
            }
            catch (NumericException e) {
                LOG.info().$("bad 'If-None-Match' [value=").$(val).$(']').$();
                StaticContentProcessor.sendStatusWithDefaultMessage(context, 400);
                return;
            }
        }
        this.sendVanilla(context, path, contentType, asAttachment);
    }

    private void sendRange(HttpConnectionContext context, CharSequence range, LPSZ path, CharSequence contentType, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.rangeParser.of(range)) {
            StaticContentProcessorState state = LV.get(context);
            if (state == null) {
                state = new StaticContentProcessorState();
                LV.set(context, state);
            }
            state.fd = this.ff.openRO(path);
            if (state.fd == -1) {
                LOG.info().$("Cannot open file: ").$(path).$();
                StaticContentProcessor.sendStatusWithDefaultMessage(context, 404);
                return;
            }
            state.bytesSent = 0L;
            long length = this.ff.length(path);
            long lo = this.rangeParser.getLo();
            long hi = this.rangeParser.getHi();
            if (lo > length || hi != Long.MAX_VALUE && hi > length || lo > hi) {
                StaticContentProcessor.sendStatusWithDefaultMessage(context, 416);
            } else {
                state.bytesSent = lo;
                state.sendMax = hi == Long.MAX_VALUE ? length : hi;
                HttpResponseHeader header = context.getResponseHeader();
                header.status(this.httpProtocolVersion, 206, contentType, state.sendMax - lo);
                if (asAttachment) {
                    header.put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorCharSequence.get(path)).put('\"').put("\r\n");
                }
                header.put("Accept-Ranges: bytes").put("\r\n");
                header.put("Content-Range: bytes ").put(lo).put('-').put(state.sendMax).put('/').put(length).put("\r\n");
                header.put("ETag: ").put(this.ff.getLastModified(path)).put("\r\n");
                if (this.keepAliveHeader != null) {
                    header.put(this.keepAliveHeader);
                }
                header.send();
                this.resumeSend(context);
            }
        } else {
            StaticContentProcessor.sendStatusWithDefaultMessage(context, 416);
        }
    }

    private void sendVanilla(HttpConnectionContext context, LPSZ path, CharSequence contentType, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int fd = this.ff.openRO(path);
        if (fd == -1) {
            LOG.info().$("Cannot open file: ").$(path).$('(').$(this.ff.errno()).$(')').$();
            StaticContentProcessor.sendStatusWithDefaultMessage(context, 404);
        } else {
            long length;
            StaticContentProcessorState h = LV.get(context);
            if (h == null) {
                h = new StaticContentProcessorState();
                LV.set(context, h);
            }
            h.fd = fd;
            h.bytesSent = 0L;
            h.sendMax = length = this.ff.length(path);
            HttpResponseHeader header = context.getResponseHeader();
            header.status(this.httpProtocolVersion, 200, contentType, length);
            if (asAttachment) {
                header.put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorCharSequence.get(path)).put("\"").put("\r\n");
            }
            header.put("ETag: ").put('\"').put(this.ff.getLastModified(path)).put('\"').put("\r\n");
            header.setKeepAlive(this.keepAliveHeader);
            header.send();
            this.resumeSend(context);
        }
    }
}

