/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Metrics;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.metrics.LongGauge;
import io.questdb.std.AssociativeCache;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public final class QueryCache
implements Closeable {
    private static final Log LOG = LogFactory.getLog(QueryCache.class);
    private static ThreadLocal<QueryCache> TL_QUERY_CACHE;
    private static HttpServerConfiguration httpServerConfiguration;
    private static Metrics metrics;
    private final AssociativeCache<RecordCursorFactory> cache;

    public QueryCache(int blocks, int rows, LongGauge cachedQueriesGauge) {
        this.cache = new AssociativeCache(blocks, rows, cachedQueriesGauge);
    }

    public static void configure(HttpServerConfiguration configuration, Metrics metrics) {
        TL_QUERY_CACHE = new ThreadLocal();
        httpServerConfiguration = configuration;
        QueryCache.metrics = metrics;
    }

    @NotNull
    public static QueryCache getThreadLocalInstance() {
        QueryCache cache = TL_QUERY_CACHE.get();
        if (cache == null) {
            boolean enableQueryCache = httpServerConfiguration.isQueryCacheEnabled();
            int blockCount = enableQueryCache ? httpServerConfiguration.getQueryCacheBlockCount() : 1;
            int rowCount = enableQueryCache ? httpServerConfiguration.getQueryCacheRowCount() : 1;
            cache = new QueryCache(blockCount, rowCount, metrics.jsonQuery().cachedQueriesGauge());
            TL_QUERY_CACHE.set(cache);
        }
        return cache;
    }

    public static QueryCache getWeakThreadLocalInstance() {
        if (TL_QUERY_CACHE != null) {
            return TL_QUERY_CACHE.get();
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
        LOG.info().$("cleared").$();
    }

    @Override
    public void close() {
        this.cache.close();
        LOG.info().$("closed").$();
    }

    public RecordCursorFactory poll(CharSequence sql) {
        RecordCursorFactory factory = this.cache.poll(sql);
        this.log(factory == null ? "miss" : "hit", sql);
        return factory;
    }

    public void push(CharSequence sql, RecordCursorFactory factory) {
        if (factory != null) {
            this.cache.put(sql, factory);
            this.log("push", sql);
        }
    }

    private void log(CharSequence action, CharSequence sql) {
        LOG.info().$(action).$(" [thread=").$(Thread.currentThread().getName()).$(", sql=").utf8(sql).I$();
    }
}

