/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.ex.RetryOperationException;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorState;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.SqlTimeoutException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class JsonQueryProcessor
implements HttpRequestProcessor,
Closeable {
    private static final Log LOG = LogFactory.getLog(JsonQueryProcessor.class);
    private static final LocalValue<JsonQueryProcessorState> LV = new LocalValue();
    protected final ObjList<QueryExecutor> queryExecutors = new ObjList();
    private final long asyncCommandTimeout;
    private final long asyncWriterStartTimeout;
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final SqlCompiler compiler;
    private final JsonQueryProcessorConfiguration configuration;
    private final Metrics metrics;
    private final NanosecondClock nanosecondClock;
    private final Path path = new Path();
    private final SqlExecutionContextImpl sqlExecutionContext;

    public JsonQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, int workerCount) {
        this(configuration, engine, workerCount, workerCount, null, null);
    }

    public JsonQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, int workerCount, int sharedWorkerCount, @Nullable FunctionFactoryCache functionFactoryCache, @Nullable DatabaseSnapshotAgent snapshotAgent) {
        this(configuration, engine, configuration.getFactoryProvider().getSqlCompilerFactory().getInstance(engine, functionFactoryCache, snapshotAgent), new SqlExecutionContextImpl(engine, workerCount, sharedWorkerCount));
    }

    public JsonQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, SqlCompiler sqlCompiler, SqlExecutionContextImpl sqlExecutionContext) {
        this.configuration = configuration;
        this.compiler = sqlCompiler;
        QueryExecutor sendConfirmation = this::updateMetricsAndSendConfirmation;
        this.queryExecutors.extendAndSet(1, this::executeNewSelect);
        this.queryExecutors.extendAndSet(2, this::executeInsert);
        this.queryExecutors.extendAndSet(3, sendConfirmation);
        this.queryExecutors.extendAndSet(4, this::executeAlterTable);
        this.queryExecutors.extendAndSet(6, sendConfirmation);
        this.queryExecutors.extendAndSet(7, sendConfirmation);
        this.queryExecutors.extendAndSet(8, this::executePseudoSelect);
        this.queryExecutors.extendAndSet(9, sendConfirmation);
        this.queryExecutors.extendAndSet(10, sendConfirmation);
        this.queryExecutors.extendAndSet(11, JsonQueryProcessor::cannotCopyRemote);
        this.queryExecutors.extendAndSet(12, sendConfirmation);
        this.queryExecutors.extendAndSet(5, sendConfirmation);
        this.queryExecutors.extendAndSet(13, sendConfirmation);
        this.queryExecutors.extendAndSet(14, this::executeUpdate);
        this.queryExecutors.extendAndSet(17, sendConfirmation);
        this.queryExecutors.extendAndSet(18, sendConfirmation);
        this.queryExecutors.extendAndSet(19, sendConfirmation);
        this.queryExecutors.extendAndSet(20, sendConfirmation);
        this.queryExecutors.extendAndSet(21, sendConfirmation);
        this.queryExecutors.extendAndSet(22, sendConfirmation);
        this.queryExecutors.extendAndSet(23, sendConfirmation);
        this.queryExecutors.extendAndSet(24, sendConfirmation);
        this.queryExecutors.extendAndSet(25, this::executeExplain);
        this.queryExecutors.extendAndSet(26, sendConfirmation);
        this.queryExecutors.extendAndSet(27, sendConfirmation);
        assert (this.queryExecutors.size() == 28);
        this.sqlExecutionContext = sqlExecutionContext;
        this.nanosecondClock = engine.getConfiguration().getNanosecondClock();
        this.circuitBreaker = new NetworkSqlExecutionCircuitBreaker(engine.getConfiguration().getCircuitBreakerConfiguration(), 30);
        this.metrics = engine.getMetrics();
        this.asyncWriterStartTimeout = engine.getConfiguration().getWriterAsyncCommandBusyWaitTimeout();
        this.asyncCommandTimeout = engine.getConfiguration().getWriterAsyncCommandMaxTimeout();
    }

    @Override
    public void close() {
        Misc.free(this.compiler);
        Misc.free(this.path);
        Misc.free(this.circuitBreaker);
    }

    public void execute0(JsonQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        OperationFuture fut = state.getOperationFuture();
        HttpConnectionContext context = state.getHttpConnectionContext();
        this.circuitBreaker.resetTimer();
        if (fut == null) {
            this.metrics.jsonQuery().markStart();
            state.startExecutionTimer();
            this.sqlExecutionContext.with(context.getSecurityContext(), null, null, context.getFd(), this.circuitBreaker.of(context.getFd()));
            if (state.getStatementTimeout() > 0L) {
                this.circuitBreaker.setTimeout(state.getStatementTimeout());
            } else {
                this.circuitBreaker.resetMaxTimeToDefault();
            }
            state.info().$("exec [q='").utf8(state.getQuery()).$("']").$();
        }
        try {
            if (fut != null) {
                this.retryQueryExecution(state, fut);
                return;
            }
            RecordCursorFactory factory = QueryCache.getThreadLocalInstance().poll(state.getQuery());
            if (factory != null) {
                try {
                    this.sqlExecutionContext.storeTelemetry((short)1, (short)2);
                    this.executeCachedSelect(state, factory, this.configuration.getKeepAliveHeader());
                }
                catch (TableReferenceOutOfDateException e) {
                    LOG.info().$(e.getFlyweightMessage()).$();
                    Misc.free(factory);
                    this.compileQuery(state);
                }
            } else {
                this.compileQuery(state);
            }
        }
        catch (ImplicitCastException | SqlException e) {
            JsonQueryProcessor.sqlError(context.getChunkedResponseSocket(), state, (FlyweightMessageContainer)((Object)e), this.configuration.getKeepAliveHeader());
            JsonQueryProcessor.readyForNextRequest(context);
        }
        catch (EntryUnavailableException e) {
            LOG.info().$("[fd=").$(context.getFd()).$("] resource busy, will retry").$();
            throw RetryOperationException.INSTANCE;
        }
        catch (DataUnavailableException e) {
            LOG.info().$("[fd=").$(context.getFd()).$("] data is in cold storage, will retry").$();
            throw QueryPausedException.instance(e.getEvent(), this.sqlExecutionContext.getCircuitBreaker());
        }
        catch (CairoError | CairoException e) {
            this.internalError(context.getChunkedResponseSocket(), context.getLastRequestBytesSent(), ((FlyweightMessageContainer)((Object)e)).getFlyweightMessage(), e, state, context.getMetrics());
            JsonQueryProcessor.readyForNextRequest(context);
        }
        catch (PeerDisconnectedException | PeerIsSlowToReadException | QueryPausedException e) {
            throw e;
        }
        catch (Throwable e) {
            state.critical().$("Uh-oh. Error!").$(e).$();
            throw ServerDisconnectException.INSTANCE;
        }
    }

    @Override
    public void failRequest(HttpConnectionContext context, HttpException e) throws PeerDisconnectedException, PeerIsSlowToReadException {
        JsonQueryProcessorState state = LV.get(context);
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        JsonQueryProcessor.logInternalError(e, state, this.metrics);
        JsonQueryProcessor.sendException(socket, 0, e.getFlyweightMessage(), state.getQuery(), this.configuration.getKeepAliveHeader());
        socket.shutdownWrite();
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        JsonQueryProcessorState state = LV.get(context);
        if (state == null) {
            state = new JsonQueryProcessorState(context, this.nanosecondClock, this.configuration.getFloatScale(), this.configuration.getDoubleScale());
            LV.set(context, state);
        }
        state.setRnd(null);
        if (this.parseUrl(state, this.configuration.getKeepAliveHeader())) {
            this.execute0(state);
        } else {
            JsonQueryProcessor.readyForNextRequest(context);
        }
    }

    @Override
    public void onRequestRetry(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        JsonQueryProcessorState state = LV.get(context);
        this.execute0(state);
    }

    @Override
    public void parkRequest(HttpConnectionContext context, boolean pausedQuery) {
        JsonQueryProcessorState state = LV.get(context);
        if (state != null) {
            state.setPausedQuery(pausedQuery);
            state.setRnd(this.sqlExecutionContext.getRandom());
        }
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        JsonQueryProcessorState state = LV.get(context);
        if (state != null) {
            this.sqlExecutionContext.with(context.getSecurityContext(), null, state.getRnd(), context.getFd(), this.circuitBreaker.of(context.getFd()));
            if (!state.isPausedQuery()) {
                context.resumeResponseSend();
            } else {
                state.setPausedQuery(false);
            }
            try {
                JsonQueryProcessor.doResumeSend(state, context, this.sqlExecutionContext);
            }
            catch (CairoError | CairoException e) {
                JsonQueryProcessor.logInternalError(e, state, context.getMetrics());
                throw ServerDisconnectException.INSTANCE;
            }
        }
    }

    private static void cannotCopyRemote(JsonQueryProcessorState state, CompiledQuery cc, CharSequence keepAliveHeader) throws SqlException {
        throw SqlException.$(0, "copy from STDIN is not supported over REST");
    }

    private static void doResumeSend(JsonQueryProcessorState state, HttpConnectionContext context, SqlExecutionContext sqlExecutionContext) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        if (state.noCursor()) {
            return;
        }
        LOG.debug().$("resume [fd=").$(context.getFd()).I$();
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        while (true) {
            try {
                state.resume(socket);
            }
            catch (DataUnavailableException e) {
                socket.resetToBookmark();
                throw QueryPausedException.instance(e.getEvent(), sqlExecutionContext.getCircuitBreaker());
            }
            catch (NoSpaceLeftInResponseBufferException ignored) {
                if (socket.resetToBookmark()) {
                    socket.sendChunk(false);
                    continue;
                }
                state.logBufferTooSmall();
                throw PeerDisconnectedException.INSTANCE;
            }
            break;
        }
        JsonQueryProcessor.readyForNextRequest(context);
    }

    private static void logInternalError(Throwable e, JsonQueryProcessorState state, Metrics metrics) {
        if (e instanceof CairoException) {
            CairoException ce = (CairoException)e;
            if (ce.isInterruption()) {
                state.info().$("query cancelled [reason=`").$(((CairoException)e).getFlyweightMessage()).$("`, q=`").utf8(state.getQuery()).$("`]").$();
            } else if (ce.isCritical()) {
                state.critical().$("error [msg=`").$(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$(", q=`").utf8(state.getQuery()).$("`]").$();
            } else {
                state.error().$("error [msg=`").$(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$(", q=`").utf8(state.getQuery()).$("`]").$();
            }
        } else if (e instanceof HttpException) {
            state.error().$("internal HTTP server error [reason=`").$(((HttpException)e).getFlyweightMessage()).$("`, q=`").utf8(state.getQuery()).$("`]").$();
        } else {
            state.critical().$("internal error [ex=").$(e).$(", q=`").utf8(state.getQuery()).$("`]").$();
            metrics.health().incrementUnhandledErrors();
        }
    }

    private static void readyForNextRequest(HttpConnectionContext context) {
        LOG.info().$("all sent [fd=").$(context.getFd()).$(", lastRequestBytesSent=").$(context.getLastRequestBytesSent()).$(", nCompletedRequests=").$(context.getNCompletedRequests() + 1).$(", totalBytesSent=").$(context.getTotalBytesSent()).I$();
    }

    private static void sendConfirmation(JsonQueryProcessorState state, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        JsonQueryProcessor.header(socket, keepAliveHeader, 200);
        socket.put('{').putQuoted("ddl").put(':').putQuoted("OK").put('}');
        socket.sendChunk(true);
        JsonQueryProcessor.readyForNextRequest(context);
    }

    private static void sendUpdateConfirmation(JsonQueryProcessorState state, CharSequence keepAliveHeader, long updateRecords) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        HttpChunkedResponseSocket socket = context.getChunkedResponseSocket();
        JsonQueryProcessor.header(socket, keepAliveHeader, 200);
        socket.put('{').putQuoted("ddl").put(':').putQuoted("OK").put(',').putQuoted("updated").put(':').put(updateRecords).put('}');
        socket.sendChunk(true);
        JsonQueryProcessor.readyForNextRequest(context);
    }

    private static void sqlError(HttpChunkedResponseSocket socket, JsonQueryProcessorState state, FlyweightMessageContainer container, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        state.logSqlError(container);
        JsonQueryProcessor.sendException(socket, container.getPosition(), container.getFlyweightMessage(), state.getQuery(), keepAliveHeader);
    }

    private void compileQuery(JsonQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException, SqlException {
        boolean recompileStale = true;
        int retries = 0;
        while (recompileStale) {
            try {
                long nanos = this.nanosecondClock.getTicks();
                CompiledQuery cc = this.compiler.compile(state.getQuery(), this.sqlExecutionContext);
                this.sqlExecutionContext.storeTelemetry(cc.getType(), (short)2);
                state.setCompilerNanos(this.nanosecondClock.getTicks() - nanos);
                state.setQueryType(cc.getType());
                this.queryExecutors.getQuick(cc.getType()).execute(state, cc, this.configuration.getKeepAliveHeader());
                recompileStale = false;
            }
            catch (TableReferenceOutOfDateException e) {
                if (retries == 10) {
                    throw e;
                }
                LOG.info().$(e.getFlyweightMessage()).$();
            }
            ++retries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAlterTable(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerIsSlowToReadException, PeerDisconnectedException, SqlException {
        try (OperationFuture fut = null;){
            fut = cq.execute(state.getEventSubSequence());
            int waitResult = fut.await(this.getAsyncWriterStartTimeout(state));
            if (waitResult != 2) {
                state.setOperationFuture(fut);
                fut = null;
                throw EntryUnavailableException.instance("retry alter table wait");
            }
        }
        this.metrics.jsonQuery().markComplete();
        JsonQueryProcessor.sendConfirmation(state, keepAliveHeader);
    }

    private void executeCachedSelect(JsonQueryProcessorState state, RecordCursorFactory factory, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        state.setCompilerNanos(0L);
        state.logExecuteCached();
        this.executeSelect(state, factory, keepAliveHeader);
    }

    private void executeExplain(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        state.logExecuteNew();
        RecordCursorFactory factory = cq.getRecordCursorFactory();
        HttpConnectionContext context = state.getHttpConnectionContext();
        try {
            if (state.of(factory, false, this.sqlExecutionContext)) {
                JsonQueryProcessor.header(context.getChunkedResponseSocket(), keepAliveHeader, 200);
                JsonQueryProcessor.doResumeSend(state, context, this.sqlExecutionContext);
                this.metrics.jsonQuery().markComplete();
            } else {
                JsonQueryProcessor.readyForNextRequest(context);
            }
        }
        catch (CairoException ex) {
            state.setQueryCacheable(ex.isCacheable());
            throw ex;
        }
    }

    private void executeInsert(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        cq.getInsertOperation().execute(this.sqlExecutionContext).await();
        this.metrics.jsonQuery().markComplete();
        JsonQueryProcessor.sendConfirmation(state, keepAliveHeader);
    }

    private void executeNewSelect(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        state.logExecuteNew();
        RecordCursorFactory factory = cq.getRecordCursorFactory();
        this.executeSelect(state, factory, keepAliveHeader);
    }

    private void executePseudoSelect(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        RecordCursorFactory factory = cq.getRecordCursorFactory();
        if (factory == null) {
            this.updateMetricsAndSendConfirmation(state, cq, keepAliveHeader);
            return;
        }
        HttpConnectionContext context = state.getHttpConnectionContext();
        if (state.of(factory, false, this.sqlExecutionContext)) {
            JsonQueryProcessor.header(context.getChunkedResponseSocket(), keepAliveHeader, 200);
            JsonQueryProcessor.doResumeSend(state, context, this.sqlExecutionContext);
            this.metrics.jsonQuery().markComplete();
        } else {
            JsonQueryProcessor.readyForNextRequest(context);
        }
    }

    private void executeSelect(JsonQueryProcessorState state, RecordCursorFactory factory, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException, SqlException {
        HttpConnectionContext context = state.getHttpConnectionContext();
        try {
            if (state.of(factory, this.sqlExecutionContext)) {
                JsonQueryProcessor.header(context.getChunkedResponseSocket(), keepAliveHeader, 200);
                JsonQueryProcessor.doResumeSend(state, context, this.sqlExecutionContext);
                this.metrics.jsonQuery().markComplete();
            } else {
                JsonQueryProcessor.readyForNextRequest(context);
            }
        }
        catch (CairoException ex) {
            state.setQueryCacheable(ex.isCacheable());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        this.circuitBreaker.resetTimer();
        OperationFuture fut = null;
        boolean isAsyncWait = false;
        try {
            fut = cq.execute(this.sqlExecutionContext, state.getEventSubSequence(), true);
            int waitResult = fut.await(this.getAsyncWriterStartTimeout(state));
            if (waitResult != 2) {
                isAsyncWait = true;
                state.setOperationFuture(fut);
                throw EntryUnavailableException.instance("retry update table wait");
            }
            long updatedCount = fut.getAffectedRowsCount();
            this.metrics.jsonQuery().markComplete();
            JsonQueryProcessor.sendUpdateConfirmation(state, keepAliveHeader, updatedCount);
        }
        finally {
            if (!isAsyncWait && fut != null) {
                fut.close();
            }
        }
    }

    private long getAsyncWriterStartTimeout(JsonQueryProcessorState state) {
        return Math.min(this.asyncWriterStartTimeout, state.getStatementTimeout());
    }

    private void internalError(HttpChunkedResponseSocket socket, long bytesSent, CharSequence message, Throwable e, JsonQueryProcessorState state, Metrics metrics) throws ServerDisconnectException, PeerDisconnectedException, PeerIsSlowToReadException {
        JsonQueryProcessor.logInternalError(e, state, metrics);
        if (bytesSent > 0L) {
            throw ServerDisconnectException.INSTANCE;
        }
        JsonQueryProcessor.sendException(socket, 0, message, state.getQuery(), this.configuration.getKeepAliveHeader());
    }

    private boolean parseUrl(JsonQueryProcessorState state, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpRequestHeader header = state.getHttpConnectionContext().getRequestHeader();
        DirectByteCharSequence query = header.getUrlParam("query");
        if (query == null || query.length() == 0) {
            state.info().$("Empty query header received. Sending empty reply.").$();
            JsonQueryProcessor.sendException(state.getHttpConnectionContext().getChunkedResponseSocket(), 0, "No query text", query, keepAliveHeader);
            return false;
        }
        long skip = 0L;
        long stop = Long.MAX_VALUE;
        DirectByteCharSequence limit = header.getUrlParam("limit");
        if (limit != null) {
            int sepPos = Chars.indexOf(limit, ',');
            try {
                if (sepPos > 0) {
                    skip = Numbers.parseLong(limit, 0, sepPos) - 1L;
                    if (sepPos + 1 < limit.length()) {
                        stop = Numbers.parseLong(limit, sepPos + 1, limit.length());
                    }
                } else {
                    stop = Numbers.parseLong(limit);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        if (stop < 0L) {
            stop = 0L;
        }
        if (skip < 0L) {
            skip = 0L;
        }
        if (stop - skip > this.configuration.getMaxQueryResponseRowLimit()) {
            stop = skip + this.configuration.getMaxQueryResponseRowLimit();
        }
        try {
            state.configure(header, query, skip, stop);
        }
        catch (Utf8Exception e) {
            state.info().$("Bad UTF8 encoding").$();
            JsonQueryProcessor.sendException(state.getHttpConnectionContext().getChunkedResponseSocket(), 0, "Bad UTF8 encoding in query text", query, keepAliveHeader);
            return false;
        }
        return true;
    }

    private void retryQueryExecution(JsonQueryProcessorState state, OperationFuture fut) throws PeerIsSlowToReadException, PeerDisconnectedException, ServerDisconnectException, QueryPausedException, SqlException {
        int waitResult;
        try {
            waitResult = fut.await(0L);
        }
        catch (TableReferenceOutOfDateException e) {
            state.freeAsyncOperation();
            this.compileQuery(state);
            return;
        }
        if (waitResult != 2) {
            long timeout;
            long l = timeout = state.getStatementTimeout() > 0L ? state.getStatementTimeout() : this.asyncCommandTimeout;
            if (state.getExecutionTimeNanos() / 1000000L < timeout) {
                state.info().$("waiting for update query [instance=").$(fut.getInstanceId()).I$();
                throw EntryUnavailableException.instance("wait for update query");
            }
            state.freeAsyncOperation();
            throw SqlTimeoutException.timeout("Query timeout. Please add HTTP header 'Statement-Timeout' with timeout in ms");
        }
        state.freeAsyncOperation();
        if (state.getQueryType() == 14) {
            JsonQueryProcessor.sendUpdateConfirmation(state, this.configuration.getKeepAliveHeader(), fut.getAffectedRowsCount());
        } else {
            JsonQueryProcessor.sendConfirmation(state, this.configuration.getKeepAliveHeader());
        }
    }

    private void updateMetricsAndSendConfirmation(JsonQueryProcessorState state, CompiledQuery cq, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.metrics.jsonQuery().markComplete();
        JsonQueryProcessor.sendConfirmation(state, keepAliveHeader);
    }

    protected static void header(HttpChunkedResponseSocket socket, CharSequence keepAliveHeader, int statusCode) throws PeerDisconnectedException, PeerIsSlowToReadException {
        socket.status(statusCode, "application/json; charset=utf-8");
        socket.headers().setKeepAlive(keepAliveHeader);
        socket.sendHeader();
    }

    static void sendException(HttpChunkedResponseSocket socket, int position, CharSequence message, CharSequence query, CharSequence keepAliveHeader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        JsonQueryProcessor.header(socket, keepAliveHeader, 400);
        JsonQueryProcessorState.prepareExceptionJson(socket, position, message, query);
    }

    @FunctionalInterface
    public static interface QueryExecutor {
        public void execute(JsonQueryProcessorState var1, CompiledQuery var2, CharSequence var3) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException, SqlException;
    }
}

