/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsRegistry;

public class JsonQueryMetrics {
    private final LongGauge cachedQueriesGauge;
    private final Counter completedQueriesCounter;
    private final Counter startedQueriesCounter;

    public JsonQueryMetrics(MetricsRegistry metricsRegistry) {
        this.startedQueriesCounter = metricsRegistry.newCounter("json_queries");
        this.completedQueriesCounter = metricsRegistry.newCounter("json_queries_completed");
        this.cachedQueriesGauge = metricsRegistry.newLongGauge("json_queries_cached");
    }

    public LongGauge cachedQueriesGauge() {
        return this.cachedQueriesGauge;
    }

    public long completedQueriesCount() {
        return this.completedQueriesCounter.getValue();
    }

    public void markComplete() {
        this.completedQueriesCounter.inc();
    }

    public void markStart() {
        this.startedQueriesCounter.inc();
    }

    public long startedQueriesCount() {
        return this.startedQueriesCounter.getValue();
    }
}

