/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpMinServerConfiguration;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.metrics.HealthMetricsImpl;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;

public class HealthCheckProcessor
implements HttpRequestProcessor {
    private final boolean pessimisticMode;
    private final boolean requiresAuthentication;

    public HealthCheckProcessor(HttpMinServerConfiguration configuration) {
        this.pessimisticMode = configuration.isPessimisticHealthCheckEnabled();
        this.requiresAuthentication = configuration.isHealthCheckAuthenticationRequired();
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HealthMetricsImpl metrics;
        long unhandledErrors;
        HttpChunkedResponseSocket r = context.getChunkedResponseSocket();
        if (this.pessimisticMode && (unhandledErrors = (metrics = context.getMetrics().health()).unhandledErrorsCount()) > 0L) {
            r.status(500, "text/plain");
            r.sendHeader();
            r.put("Status: Unhealthy\nUnhandled errors: ");
            r.put(unhandledErrors);
            r.sendChunk(true);
            return;
        }
        r.status(200, "text/plain");
        r.sendHeader();
        r.put("Status: Healthy");
        r.sendChunk(true);
    }

    @Override
    public boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }
}

