/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.ServerDisconnectException;

public interface HttpRequestProcessor {
    default public void failRequest(HttpConnectionContext context, HttpException exception) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
    }

    default public void onHeadersReady(HttpConnectionContext context) {
    }

    default public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
    }

    default public void onRequestRetry(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
    }

    default public void parkRequest(HttpConnectionContext context, boolean pausedQuery) {
    }

    default public boolean requiresAuthentication() {
        return true;
    }

    default public void resumeRecv(HttpConnectionContext context) {
    }

    default public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
    }
}

