/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SimpleWaitingLock;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class WalPurgeJob
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(WalPurgeJob.class);
    private final TableSequencerAPI.TableSequencerCallback broadSweepRef;
    private final long checkInterval;
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final NativeLPSZ fileName = new NativeLPSZ();
    private final Logic logic;
    private final MillisecondClock millisecondClock;
    private final IntHashSet onDiskWalIDSet = new IntHashSet();
    private final Path path = new Path();
    private final SimpleWaitingLock runLock = new SimpleWaitingLock();
    private final long spinLockTimeout;
    private final ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet();
    private final TxReader txReader;
    private final NativeLPSZ walName = new NativeLPSZ();
    private long last = 0L;
    private TableToken tableToken;

    public WalPurgeJob(CairoEngine engine, FilesFacade ff, MicrosecondClock clock) {
        this.engine = engine;
        this.ff = ff;
        this.clock = clock;
        this.checkInterval = engine.getConfiguration().getWalPurgeInterval() * 1000L;
        this.millisecondClock = engine.getConfiguration().getMillisecondClock();
        this.spinLockTimeout = engine.getConfiguration().getSpinLockTimeout();
        this.txReader = new TxReader(ff);
        this.broadSweepRef = this::broadSweep;
        assert ("wal".equals("wal"));
        this.configuration = engine.getConfiguration();
        this.logic = new Logic(new FsDeleter());
    }

    public WalPurgeJob(CairoEngine engine) {
        this(engine, engine.getConfiguration().getFilesFacade(), engine.getConfiguration().getMicrosecondClock());
    }

    @Override
    public void close() {
        this.txReader.close();
        this.path.close();
    }

    public void delayByHalfInterval() {
        this.last = this.clock.getTicks() - this.checkInterval / 2L;
    }

    public SimpleWaitingLock getRunLock() {
        return this.runLock;
    }

    private static boolean matchesSegmentName(CharSequence name) {
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean matchesWalNamePattern(CharSequence name) {
        int len = name.length();
        if (len < "wal".length() + 1) {
            return false;
        }
        if (name.charAt(0) != 'w' || name.charAt(1) != 'a' || name.charAt(2) != 'l') {
            return false;
        }
        for (int i = 3; i < len; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private void broadSweep() {
        this.engine.getTableSequencerAPI().forAllWalTables(this.tableTokenBucket, true, this.broadSweepRef);
    }

    private void broadSweep(int tableId, TableToken tableToken, long lastTxn) {
        try {
            this.tableToken = tableToken;
            this.logic.reset(tableToken);
            this.onDiskWalIDSet.clear();
            boolean tableDropped = false;
            this.discoverWalSegments();
            if (this.logic.hasOnDiskSegments()) {
                tableDropped = this.fetchSequencerPairs();
                this.logic.run();
            }
            if (tableDropped || lastTxn < 0L && this.engine.isTableDropped(tableToken)) {
                if (this.logic.hasPendingTasks()) {
                    LOG.info().$("table is dropped, but has WALs containing segments with pending tasks ").$("[tableDir=").$(tableToken.getDirName()).I$();
                } else if (TableUtils.exists(this.ff, Path.getThreadLocal(""), this.configuration.getRoot(), tableToken.getDirName()) != 0) {
                    LOG.info().$("table is fully dropped [tableDir=").$(tableToken.getDirName()).I$();
                    Path pathToDelete = Path.getThreadLocal(this.configuration.getRoot()).concat(tableToken).$();
                    Path symLinkTarget = null;
                    if (this.ff.isSoftLink(this.path) && !this.ff.readLink(pathToDelete, symLinkTarget = Path.getThreadLocal2(""))) {
                        symLinkTarget = null;
                    }
                    this.ff.rmdir(pathToDelete);
                    if (symLinkTarget != null) {
                        this.ff.rmdir(symLinkTarget);
                    }
                    TableUtils.lockName(pathToDelete);
                    this.ff.remove(pathToDelete);
                    this.engine.removeTableToken(tableToken);
                } else {
                    LOG.info().$("table is not fully dropped, pinging WAL Apply job to delete table files [tableDir=").$(tableToken.getDirName()).I$();
                    this.engine.notifyWalTxnRepublisher();
                }
            }
        }
        catch (CairoException ce) {
            LOG.error().$("broad sweep failed [table=").$(tableToken).$(", msg=").$(ce).$(", errno=").$(this.ff.errno()).$(']').$();
        }
    }

    private boolean deleteFile(Path path) {
        int errno;
        if (!this.ff.remove(path) && (errno = this.ff.errno()) != 2) {
            LOG.error().$("Could not delete file [path=").$(path).$(", errno=").$(errno).$(']').$();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverWalSegments() {
        Path path = this.setTablePath(this.tableToken);
        long p = this.ff.findFirst(path);
        int rootPathLen = path.length();
        if (p > 0L) {
            try {
                do {
                    int type = this.ff.findType(p);
                    long pUtf8NameZ = this.ff.findName(p);
                    if (type != 4 || !WalPurgeJob.matchesWalNamePattern(this.walName.of(pUtf8NameZ))) continue;
                    try {
                        int walId = Numbers.parseInt(this.walName, 3, this.walName.length());
                        this.onDiskWalIDSet.add(walId);
                        boolean walInUse = this.walIsInUse(this.tableToken, walId);
                        boolean walHasPendingTasks = false;
                        path.trimTo(rootPathLen).concat(pUtf8NameZ);
                        int walPathLen = path.length();
                        long sp = this.ff.findFirst(path.$());
                        try {
                            do {
                                type = this.ff.findType(sp);
                                pUtf8NameZ = this.ff.findName(sp);
                                if (type != 4 || !WalPurgeJob.matchesSegmentName(this.walName.of(pUtf8NameZ))) continue;
                                try {
                                    int segmentId = Numbers.parseInt(this.walName);
                                    if (segmentId < 0 || segmentId > 0x1FFFFFFE) {
                                        throw NumericException.INSTANCE;
                                    }
                                    Path segmentPath = path.trimTo(walPathLen).slash().put(segmentId);
                                    TableUtils.lockName(segmentPath);
                                    boolean locked = !this.unlocked(segmentPath.$());
                                    boolean pendingTasks = this.segmentHasPendingTasks(walId, segmentId);
                                    if (pendingTasks) {
                                        walHasPendingTasks = true;
                                    }
                                    this.logic.trackDiscoveredSegment(walId, segmentId, pendingTasks, locked);
                                }
                                catch (NumericException numericException) {
                                    // empty catch block
                                }
                            } while (this.ff.findNext(sp) > 0);
                        }
                        finally {
                            this.ff.findClose(sp);
                        }
                        this.logic.trackDiscoveredWal(walId, walHasPendingTasks, walInUse);
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                } while (this.ff.findNext(p) > 0);
            }
            finally {
                this.ff.findClose(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchSequencerPairs() {
        this.setTxnPath(this.tableToken);
        if (!this.engine.isTableDropped(this.tableToken)) {
            try {
                this.txReader.ofRO(this.path, 3);
                TableUtils.safeReadTxn(this.txReader, this.millisecondClock, this.spinLockTimeout);
                long lastAppliedTxn = this.txReader.getSeqTxn();
                TableSequencerAPI tableSequencerAPI = this.engine.getTableSequencerAPI();
                try (TransactionLogCursor transactionLogCursor = tableSequencerAPI.getCursor(this.tableToken, lastAppliedTxn);){
                    while (this.onDiskWalIDSet.size() > 0 && transactionLogCursor.hasNext()) {
                        int walId = transactionLogCursor.getWalId();
                        if (this.onDiskWalIDSet.remove(walId) == -1) continue;
                        int segmentId = transactionLogCursor.getSegmentId();
                        this.logic.trackNextToApplySegment(walId, segmentId);
                    }
                }
                catch (CairoException e) {
                    if (e.isTableDropped()) {
                        boolean bl = true;
                        this.txReader.close();
                        return bl;
                    }
                    throw e;
                }
            }
            finally {
                this.txReader.close();
            }
        }
        return false;
    }

    private void recursiveDelete(Path path) {
        int errno = this.ff.rmdir(path);
        if (errno > 0 && !CairoException.errnoRemovePathDoesNotExist(errno)) {
            LOG.error().$("could not delete directory [path=").utf8(path).$(", errno=").$(errno).$(']').$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean segmentHasPendingTasks(int walId, int segmentId) {
        Path pendingPath = this.setSegmentPendingPath(this.tableToken, walId, segmentId);
        long p = this.ff.findFirst(pendingPath);
        if (p > 0L) {
            try {
                do {
                    int type = this.ff.findType(p);
                    long pUtf8NameZ = this.ff.findName(p);
                    this.fileName.of(pUtf8NameZ);
                    if (type != 8 || !Chars.endsWith((CharSequence)this.fileName, ".pending")) continue;
                    boolean bl = true;
                    return bl;
                } while (this.ff.findNext(p) > 0);
            }
            finally {
                this.ff.findClose(p);
            }
        }
        return false;
    }

    private Path setSegmentLockPath(TableToken tableName, int walId, int segmentId) {
        this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId).slash().put(segmentId);
        TableUtils.lockName(this.path);
        return this.path;
    }

    private Path setSegmentPath(TableToken tableName, int walId, int segmentId) {
        return this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId).slash().put(segmentId).$();
    }

    private Path setSegmentPendingPath(TableToken tableName, int walId, int segmentId) {
        return this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId).slash().put(segmentId).concat(".pending").slash$();
    }

    private Path setTablePath(TableToken tableName) {
        return this.path.of(this.configuration.getRoot()).concat(tableName).$();
    }

    private void setTxnPath(TableToken tableName) {
        this.path.of(this.configuration.getRoot()).concat(tableName).concat("_txn").$();
    }

    private Path setWalLockPath(TableToken tableName, int walId) {
        this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId);
        TableUtils.lockName(this.path);
        return this.path;
    }

    private Path setWalPath(TableToken tableName, int walId) {
        return this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId).$();
    }

    private boolean unlocked(Path path) {
        int lockFd = TableUtils.lock(this.ff, path, false);
        if (lockFd != -1) {
            this.ff.close(lockFd);
            return true;
        }
        return false;
    }

    private boolean walIsInUse(TableToken tableName, int walId) {
        return !this.unlocked(this.setWalLockPath(tableName, walId));
    }

    @Override
    protected boolean runSerially() {
        long t = this.clock.getTicks();
        if (this.last + this.checkInterval < t) {
            this.last = t;
            if (this.runLock.tryLock()) {
                try {
                    this.broadSweep();
                }
                finally {
                    this.runLock.unlock();
                }
            } else {
                LOG.info().$("skipping, locked out").$();
            }
        }
        return false;
    }

    private class FsDeleter
    implements Deleter {
        private FsDeleter() {
        }

        @Override
        public void deleteSegmentDirectory(int walId, int segmentId) {
            LOG.info().$("deleting WAL segment directory [table=").utf8(WalPurgeJob.this.tableToken.getDirName()).$(", walId=").$(walId).$(", segmentId=").$(segmentId).$(']').$();
            if (WalPurgeJob.this.deleteFile(WalPurgeJob.this.setSegmentLockPath(WalPurgeJob.this.tableToken, walId, segmentId))) {
                WalPurgeJob.this.recursiveDelete(WalPurgeJob.this.setSegmentPath(WalPurgeJob.this.tableToken, walId, segmentId));
            }
        }

        @Override
        public void deleteWalDirectory(int walId) {
            LOG.info().$("deleting WAL directory [table=").utf8(WalPurgeJob.this.tableToken.getDirName()).$(", walId=").$(walId).$(']').$();
            if (WalPurgeJob.this.deleteFile(WalPurgeJob.this.setWalLockPath(WalPurgeJob.this.tableToken, walId))) {
                WalPurgeJob.this.recursiveDelete(WalPurgeJob.this.setWalPath(WalPurgeJob.this.tableToken, walId));
            }
        }
    }

    public static class Logic {
        private final StringSink debugBuffer = new StringSink();
        private final Deleter deleter;
        private final LongList discovered = new LongList();
        private final IntIntHashMap nextToApply = new IntIntHashMap();
        private final LongList nextToApplyKeys = new LongList();
        private TableToken tableToken;

        public Logic(Deleter deleter) {
            this.deleter = deleter;
        }

        public void accumDebugState() {
            int i;
            this.debugBuffer.clear();
            this.debugBuffer.put("table=").put(this.tableToken.getDirName()).put(", discovered=[");
            int n = this.discovered.size();
            for (i = 0; i < n; ++i) {
                long encoded = this.discovered.getQuick(i);
                int walId = Logic.decodeWalId(encoded);
                int segmentId = Logic.decodeSegmentId(encoded);
                boolean pendingTasks = Logic.decodePendingTasks(encoded);
                boolean locked = Logic.decodeLocked(encoded);
                if (Logic.isWalDir(segmentId)) {
                    this.debugBuffer.put("(wal").put(walId);
                } else {
                    this.debugBuffer.put('(').put(walId).put(',').put(segmentId);
                }
                if (pendingTasks) {
                    this.debugBuffer.put(":tasks");
                }
                if (locked) {
                    this.debugBuffer.put(":locked");
                }
                this.debugBuffer.put(')');
                if (i >= n - 1) continue;
                this.debugBuffer.put(',');
            }
            this.debugBuffer.put("], nextToApply=[");
            n = this.nextToApplyKeys.size();
            for (i = 0; i < n; ++i) {
                int walId = (int)this.nextToApplyKeys.getQuick(i);
                int segmentId = this.nextToApply.get(walId);
                this.debugBuffer.put('(').put(walId).put(',').put(segmentId).put(')');
                if (i >= n - 1) continue;
                this.debugBuffer.put(',');
            }
            this.debugBuffer.put(']');
        }

        public boolean hasOnDiskSegments() {
            return this.discovered.size() != 0;
        }

        public boolean hasPendingTasks() {
            for (int i = 0; i < this.discovered.size(); ++i) {
                if (!Logic.decodePendingTasks(this.discovered.get(i))) continue;
                return true;
            }
            return false;
        }

        public void reset(TableToken tableToken) {
            this.tableToken = tableToken;
            this.nextToApply.clear();
            this.nextToApplyKeys.clear();
            this.discovered.clear();
        }

        public void run() {
            this.sortTracked();
            this.accumDebugState();
            int n = this.discovered.size();
            for (int i = 0; i < n; ++i) {
                boolean segmentAlreadyApplied;
                long encoded = this.discovered.get(i);
                int walId = Logic.decodeWalId(encoded);
                int segmentId = Logic.decodeSegmentId(encoded);
                boolean hasPendingTasks = Logic.decodePendingTasks(encoded);
                boolean isLocked = Logic.decodeLocked(encoded);
                int nextToApplySegmentId = this.nextToApply.get(walId);
                if (Logic.isWalDir(segmentId)) {
                    boolean walAlreadyApplied;
                    boolean bl = walAlreadyApplied = nextToApplySegmentId == -1;
                    if (!walAlreadyApplied || isLocked || hasPendingTasks) continue;
                    this.logDebugInfo();
                    this.deleter.deleteWalDirectory(walId);
                    continue;
                }
                boolean bl = segmentAlreadyApplied = nextToApplySegmentId == -1 || nextToApplySegmentId > segmentId;
                if (!segmentAlreadyApplied || isLocked || hasPendingTasks) continue;
                this.logDebugInfo();
                this.deleter.deleteSegmentDirectory(walId, segmentId);
            }
        }

        public void trackDiscoveredSegment(int walId, int segmentId, boolean pendingTasks, boolean locked) {
            this.discovered.add(Logic.encodeDiscovered(walId, segmentId, pendingTasks, locked));
        }

        public void trackDiscoveredWal(int walId, boolean pendingTasks, boolean locked) {
            this.discovered.add(Logic.encodeDiscovered(walId, 0x1FFFFFFF, pendingTasks, locked));
        }

        public void trackNextToApplySegment(int walId, int segmentId) {
            int index = this.nextToApply.keyIndex(walId);
            if (index > -1) {
                this.nextToApply.putAt(index, walId, segmentId);
                this.nextToApplyKeys.add(walId);
            }
        }

        private static boolean decodeLocked(long encoded) {
            int segmentKey = Numbers.decodeLowInt(encoded);
            return (segmentKey & 1) == 1;
        }

        private static boolean decodePendingTasks(long encoded) {
            int segmentKey = Numbers.decodeLowInt(encoded);
            return (segmentKey & 2) == 2;
        }

        private static int decodeSegmentId(long encoded) {
            int segmentKey = Numbers.decodeLowInt(encoded);
            return segmentKey >> 2;
        }

        private static int decodeWalId(long encoded) {
            return Numbers.decodeHighInt(encoded);
        }

        private static long encodeDiscovered(int walId, int segmentId, boolean pendingTasks, boolean locked) {
            int segmentKey = (segmentId << 2) + (pendingTasks ? 2 : 0) + (locked ? 1 : 0);
            return Numbers.encodeLowHighInts(segmentKey, walId);
        }

        private static boolean isWalDir(int segmentId) {
            return segmentId == 0x1FFFFFFF;
        }

        private void logDebugInfo() {
            if (this.debugBuffer.length() > 0) {
                LOG.info().utf8(this.debugBuffer).$();
                this.debugBuffer.clear();
            }
        }

        private void sortTracked() {
            this.discovered.sort();
            this.nextToApplyKeys.sort();
        }
    }

    public static interface Deleter {
        public void deleteSegmentDirectory(int var1, int var2);

        public void deleteWalDirectory(int var1);
    }
}

