/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class WalEventReader
implements Closeable {
    private final Log LOG = LogFactory.getLog(WalEventReader.class);
    private final WalEventCursor eventCursor;
    private final MemoryMR eventMem;
    private final FilesFacade ff;

    public WalEventReader(FilesFacade ff) {
        this.ff = ff;
        this.eventMem = Vm.getMRInstance();
        this.eventCursor = new WalEventCursor(this.eventMem);
    }

    @Override
    public void close() {
        Misc.free(this.eventMem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalEventCursor of(Path path, int expectedVersion, long segmentTxn) {
        int trimTo = path.length();
        try {
            int pathLen = path.length();
            path.concat("_event").$();
            this.eventMem.of(this.ff, path, this.ff.getPageSize(), 12L, 36, 0L, -1);
            if (segmentTxn > -1L) {
                int fdi = TableUtils.openRO(this.ff, path.trimTo(pathLen).concat("_event.i").$(), this.LOG);
                try {
                    int maxTxn = this.eventMem.getInt(0L);
                    long offset = this.ff.readNonNegativeLong(fdi, segmentTxn << 3);
                    long size = this.ff.readNonNegativeLong(fdi, (long)maxTxn + 1L << 3);
                    if (offset < 0L || size < 12L || offset >= size) {
                        int errno = offset < 0L || size < 0L ? this.ff.errno() : 0;
                        long fileSize = this.ff.length(fdi);
                        throw CairoException.critical(errno).put("segment ").put(path).put(" does not have txn with id ").put(segmentTxn).put(", offset=").put(offset).put(", indexFileSize=").put(fileSize).put(", maxTxn=").put(maxTxn).put(", size=").put(size);
                    }
                    this.eventMem.extend(size + 4L);
                    this.eventCursor.openOffset(offset);
                }
                finally {
                    this.ff.close(fdi);
                }
            } else {
                this.eventCursor.openOffset(-1L);
            }
            TableUtils.validateMetaVersion(this.eventMem, 4L, expectedVersion);
            WalEventCursor walEventCursor = this.eventCursor;
            return walEventCursor;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(trimTo);
        }
    }
}

