/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.wal.TableRenameSupportExecutionContext;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.bind.BindVariableServiceImpl;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.std.Misc;
import io.questdb.std.Rnd;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

class OperationCompiler
implements Closeable {
    private final BindVariableService bindVariableService;
    private final Rnd rnd = new Rnd();
    private final SqlCompiler sqlCompiler;
    private final TableRenameSupportExecutionContext renameSupportExecutionContext;

    OperationCompiler(CairoEngine engine, int workerCount, int sharedWorkerCount, @Nullable FunctionFactoryCache functionFactoryCache) {
        this.bindVariableService = new BindVariableServiceImpl(engine.getConfiguration());
        this.renameSupportExecutionContext = new TableRenameSupportExecutionContext(engine, workerCount, sharedWorkerCount);
        this.renameSupportExecutionContext.with(engine.getConfiguration().getFactoryProvider().getSecurityContextFactory().getRootContext(), this.bindVariableService, this.rnd, -1L, null);
        this.sqlCompiler = new SqlCompiler(engine, functionFactoryCache, null);
    }

    @Override
    public void close() {
        Misc.free(this.sqlCompiler);
        Misc.free(this.renameSupportExecutionContext);
    }

    public AlterOperation compileAlterSql(CharSequence alterSql, TableToken tableToken) throws SqlException {
        this.renameSupportExecutionContext.remapTableNameResolutionTo(tableToken);
        CompiledQuery compiledQuery = this.sqlCompiler.compile(alterSql, this.renameSupportExecutionContext);
        AlterOperation alterOp = compiledQuery.getAlterOperation();
        alterOp.withContext(this.renameSupportExecutionContext);
        return alterOp;
    }

    public UpdateOperation compileUpdateSql(CharSequence updateSql, TableToken tableToken) throws SqlException {
        this.renameSupportExecutionContext.remapTableNameResolutionTo(tableToken);
        CompiledQuery compiledQuery = this.sqlCompiler.compile(updateSql, this.renameSupportExecutionContext);
        UpdateOperation updateOperation = compiledQuery.getUpdateOperation();
        updateOperation.withContext(this.renameSupportExecutionContext);
        return updateOperation;
    }

    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    public void resetRnd(long seed0, long seed1) {
        this.rnd.reset(seed0, seed1);
    }

    public void setNowAndFixClock(long now) {
        this.renameSupportExecutionContext.setNowAndFixClock(now);
    }
}

