/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;

public class CopyWalSegmentUtils {
    private static final Log LOG = LogFactory.getLog(CopyWalSegmentUtils.class);
    private static final int MEMORY_TAG = 37;

    public static void rollColumnToSegment(FilesFacade ff, long options, MemoryMA primaryColumn, MemoryMA secondaryColumn, Path walPath, int newSegment, CharSequence columnName, int columnType, long rowOffset, long rowCount, LongList newColumnFiles, int columnIndex, int commitMode) {
        int secondaryFd;
        Path newSegPath = Path.PATH.get().of(walPath).slash().put(newSegment);
        int setPathRoot = newSegPath.length();
        TableUtils.dFile(newSegPath, columnName, -1L);
        int primaryFd = TableUtils.openRW(ff, newSegPath, LOG, options);
        newColumnFiles.setQuick(columnIndex * 6, primaryFd);
        if (ColumnType.isVariableLength(columnType)) {
            TableUtils.iFile(newSegPath.trimTo(setPathRoot), columnName, -1L);
            secondaryFd = TableUtils.openRW(ff, newSegPath, LOG, options);
            newColumnFiles.setQuick(columnIndex * 6 + 3, secondaryFd);
        } else {
            secondaryFd = -1;
        }
        boolean success = ColumnType.isVariableLength(columnType) ? CopyWalSegmentUtils.copyVarLenFile(ff, primaryColumn, secondaryColumn, primaryFd, secondaryFd, rowOffset, rowCount, newColumnFiles, columnIndex, commitMode) : (columnType > 0 ? CopyWalSegmentUtils.copyFixLenFile(ff, primaryColumn, primaryFd, rowOffset, rowCount, columnType, newColumnFiles, columnIndex, commitMode) : CopyWalSegmentUtils.copyTimestampFile(ff, primaryColumn, primaryFd, rowOffset, rowCount, newColumnFiles, columnIndex, commitMode));
        if (!success) {
            throw CairoException.critical(ff.errno()).put("failed to copy column file to new segment [path=").put(newSegPath).put(", column=").put(columnName).put(", rowOffset=").put(rowOffset).put(", rowCount=").put(rowCount).put(", columnType=").put(columnType).put("]");
        }
    }

    private static boolean copyFixLenFile(FilesFacade ff, MemoryMA primaryColumn, int primaryFd, long rowOffset, long rowCount, int columnType, LongList newOffsets, int columnIndex, int commitMode) {
        boolean success;
        int shl = ColumnType.pow2SizeOf(columnType);
        long offset = rowOffset << shl;
        long length = rowCount << shl;
        boolean bl = success = ff.copyData(primaryColumn.getFd(), primaryFd, offset, length) == length;
        if (success) {
            newOffsets.setQuick(columnIndex * 6 + 1, offset);
            newOffsets.setQuick(columnIndex * 6 + 2, length);
        }
        if (commitMode != 2) {
            ff.fsync(primaryFd);
        }
        return success;
    }

    private static boolean copyTimestampFile(FilesFacade ff, MemoryMA primaryColumn, int primaryFd, long rowOffset, long rowCount, LongList newOffsets, int columnIndex, int commitMode) {
        if (!CopyWalSegmentUtils.copyFixLenFile(ff, primaryColumn, primaryFd, rowOffset, rowCount, 24, newOffsets, columnIndex, commitMode)) {
            return false;
        }
        long size = rowCount << 4;
        long srcDataTimestampAddr = TableUtils.mapRW(ff, primaryFd, size, 37);
        Vect.flattenIndex(srcDataTimestampAddr, rowCount);
        if (commitMode != 2) {
            ff.msync(srcDataTimestampAddr, size, commitMode == 0);
        }
        ff.munmap(srcDataTimestampAddr, size, 37);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyVarLenFile(FilesFacade ff, MemoryMA primaryColumn, MemoryMA secondaryColumn, int primaryFd, int secondaryFd, long rowOffset, long rowCount, LongList newOffsets, int columnIndex, int commitMode) {
        long indexMapSize = (rowOffset + rowCount + 1L) * 8L;
        long srcIndexAddr = TableUtils.mapRW(ff, secondaryColumn.getFd(), indexMapSize, 37);
        try {
            boolean success;
            long varStart = Unsafe.getUnsafe().getLong(srcIndexAddr + rowOffset * 8L);
            long varEnd = Unsafe.getUnsafe().getLong(srcIndexAddr + (rowOffset + rowCount) * 8L);
            long varCopyLen = varEnd - varStart;
            boolean bl = success = ff.copyData(primaryColumn.getFd(), primaryFd, varStart, varCopyLen) == varCopyLen;
            if (!success) {
                boolean bl2 = false;
                return bl2;
            }
            if (commitMode != 2) {
                ff.fsync(primaryFd);
            }
            newOffsets.setQuick(columnIndex * 6 + 1, varStart);
            newOffsets.setQuick(columnIndex * 6 + 2, varCopyLen);
            long indexLen = (rowCount + 1L) * 8L;
            long dstIndexAddr = TableUtils.mapRW(ff, secondaryFd, indexLen, 37);
            ff.madvise(dstIndexAddr, indexLen, Files.POSIX_MADV_RANDOM);
            Vect.shiftCopyFixedSizeColumnData(varStart, srcIndexAddr, rowOffset, rowOffset + rowCount, dstIndexAddr);
            newOffsets.setQuick(columnIndex * 6 + 4, (rowOffset + 1L) * 8L);
            newOffsets.setQuick(columnIndex * 6 + 5, indexLen);
            if (commitMode != 2) {
                ff.msync(dstIndexAddr, indexLen, commitMode == 0);
            }
            ff.munmap(dstIndexAddr, indexLen, 37);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            ff.munmap(srcIndexAddr, indexMapSize, 37);
        }
    }
}

