/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjHashSet;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;

public class CheckWalTransactionsJob
extends SynchronizedJob {
    private final TableSequencerAPI.TableSequencerCallback checkNotifyOutstandingTxnInWalRef;
    private final CharSequence dbRoot;
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final MillisecondClock millisecondClock;
    private final long spinLockTimeout;
    private final ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet();
    private final TxReader txReader;
    private long lastProcessedCount = 0L;
    private Path threadLocalPath;

    public CheckWalTransactionsJob(CairoEngine engine) {
        this.engine = engine;
        this.ff = engine.getConfiguration().getFilesFacade();
        this.txReader = new TxReader(engine.getConfiguration().getFilesFacade());
        this.dbRoot = engine.getConfiguration().getRoot();
        this.millisecondClock = engine.getConfiguration().getMillisecondClock();
        this.spinLockTimeout = engine.getConfiguration().getSpinLockTimeout();
        this.checkNotifyOutstandingTxnInWalRef = (tableToken, txn, txn2) -> this.checkNotifyOutstandingTxnInWal(txn, txn2);
    }

    public void checkMissingWalTransactions() {
        this.threadLocalPath = Path.PATH.get().of(this.dbRoot);
        this.engine.getTableSequencerAPI().forAllWalTables(this.tableTokenBucket, true, this.checkNotifyOutstandingTxnInWalRef);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkNotifyOutstandingTxnInWal(TableToken tableToken, long txn) {
        if (txn < 0L && TableUtils.exists(this.ff, this.threadLocalPath, this.dbRoot, tableToken.getDirName()) == 0) {
            this.engine.notifyWalTxnCommitted(tableToken, Long.MAX_VALUE);
            return;
        } else {
            this.threadLocalPath.trimTo(this.dbRoot.length()).concat(tableToken).concat("_meta").$();
            if (this.ff.exists(this.threadLocalPath)) {
                this.threadLocalPath.trimTo(this.dbRoot.length()).concat(tableToken).concat("_txn").$();
                try (TxReader txReader2 = this.txReader.ofRO(this.threadLocalPath, 3);){
                    TableUtils.safeReadTxn(this.txReader, this.millisecondClock, this.spinLockTimeout);
                    if (txReader2.getSeqTxn() >= txn) return;
                    this.engine.notifyWalTxnCommitted(tableToken, txn);
                    return;
                }
            } else {
                this.engine.notifyWalTxnCommitted(tableToken, Long.MAX_VALUE);
            }
        }
    }

    @Override
    public boolean runSerially() {
        long unpublishedWalTxnCount = this.engine.getUnpublishedWalTxnCount();
        if (unpublishedWalTxnCount == this.lastProcessedCount) {
            return false;
        }
        this.checkMissingWalTransactions();
        this.lastProcessedCount = unpublishedWalTxnCount;
        return true;
    }
}

