/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.vm.MemoryCARWImpl;
import io.questdb.cairo.vm.MemoryCMARWImpl;
import io.questdb.cairo.vm.MemoryCMORImpl;
import io.questdb.cairo.vm.MemoryCMRImpl;
import io.questdb.cairo.vm.MemoryPMARImpl;
import io.questdb.cairo.vm.api.MemoryAR;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.vm.api.MemoryCMOR;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.log.Log;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class Vm {
    public static final int STRING_LENGTH_BYTES = 4;
    public static final byte TRUNCATE_TO_PAGE = 0;
    public static final byte TRUNCATE_TO_POINTER = 1;
    public static final boolean PARANOIA_MODE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bestEffortClose(FilesFacade ff, Log log, int fd, long size, byte truncateMode) {
        try {
            if (size > -1L) {
                Vm.bestEffortTruncate(ff, log, fd, size, truncateMode);
            } else {
                log.debug().$("closed [fd=").$(fd).$(']').$();
            }
        }
        finally {
            ff.close(fd);
        }
    }

    public static void bestEffortClose(FilesFacade ff, Log log, int fd, long size) {
        Vm.bestEffortClose(ff, log, fd, size, (byte)0);
    }

    public static long bestEffortTruncate(FilesFacade ff, Log log, int fd, long size, byte truncateMode) {
        long sz;
        long l = sz = truncateMode == 0 ? Files.ceilPageSize(size) : size;
        if (ff.truncate(Math.abs(fd), sz)) {
            log.debug().$("truncated and closed [fd=").$(fd).$(", size=").$(sz).$(']').$();
            return sz;
        }
        log.debug().$("closed without truncate [fd=").$(fd).$(", errno=").$(ff.errno()).$(']').$();
        return -1L;
    }

    public static long bestEffortTruncate(FilesFacade ff, Log log, int fd, long size) {
        return Vm.bestEffortTruncate(ff, log, fd, size, (byte)0);
    }

    public static MemoryAR getARInstance(long pageSize, int maxPages, int memoryTag) {
        return new MemoryCARWImpl(pageSize, maxPages, memoryTag);
    }

    public static MemoryARW getARWInstance(long pageSize, int maxPages, int memoryTag) {
        return new MemoryCARWImpl(pageSize, maxPages, memoryTag);
    }

    public static MemoryCARW getCARWInstance(long pageSize, int maxPages, int memoryTag) {
        return new MemoryCARWImpl(pageSize, maxPages, memoryTag);
    }

    public static MemoryCMARW getCMARWInstance(FilesFacade ff, LPSZ name, long pageSize, long size, int memoryTag, long opts) {
        return new MemoryCMARWImpl(ff, name, pageSize, size, memoryTag, opts);
    }

    public static MemoryCMARW getCMARWInstance() {
        return new MemoryCMARWImpl();
    }

    public static MemoryCMR getCMRInstance() {
        return new MemoryCMRImpl();
    }

    public static MemoryMA getMAInstance(int commitMode) {
        return new MemoryPMARImpl(commitMode);
    }

    public static MemoryMAR getMARInstance(int commitMode) {
        return new MemoryPMARImpl(commitMode);
    }

    public static MemoryMARW getMARWInstance() {
        return new MemoryCMARWImpl();
    }

    public static MemoryMARW getMARWInstance(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, long opts) {
        return new MemoryCMARWImpl(ff, name, extendSegmentSize, size, memoryTag, opts);
    }

    public static MemoryMR getMRInstance() {
        return new MemoryCMRImpl();
    }

    public static MemoryMR getMRInstance(FilesFacade ff, LPSZ name, long size, int memoryTag) {
        return new MemoryCMRImpl(ff, name, size, memoryTag);
    }

    public static MemoryCMOR getMemoryCMOR() {
        return new MemoryCMORImpl();
    }

    public static MemoryCMARW getSmallCMARWInstance(FilesFacade ff, LPSZ name, int memoryTag, long opts) {
        return new MemoryCMARWImpl(ff, name, ff.getPageSize(), -1L, memoryTag, opts);
    }

    public static MemoryMA getSmallMAInstance(FilesFacade ff, LPSZ name, int memoryTag, long opts) {
        return new MemoryCMARWImpl(ff, name, ff.getPageSize(), -1L, memoryTag, opts);
    }

    public static long getStorageLength(int len) {
        return 4L + (long)len * 2L;
    }

    public static int getStorageLength(CharSequence s) {
        if (s == null) {
            return 4;
        }
        return 4 + s.length() * 2;
    }

    public static MemoryMARW getWholeMARWInstance(FilesFacade ff, LPSZ name, long extendSegmentSize, int memoryTag, long opts) {
        return new MemoryCMARWImpl(ff, name, extendSegmentSize, -1L, memoryTag, opts);
    }
}

