/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.ptt;

import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.microtime.Timestamps;

public class PartitionDateParseUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long parseDayTime(CharSequence seq, int lim, int pos, long ts, int dayRange, int dayDigits) throws NumericException {
        PartitionDateParseUtil.checkChar(seq, pos++, lim, '-');
        int day = Numbers.parseInt(seq, pos, pos += dayDigits);
        PartitionDateParseUtil.checkRange(day, 1, dayRange);
        if (PartitionDateParseUtil.checkLen(pos, lim)) {
            PartitionDateParseUtil.checkChar(seq, pos++, lim, 'T');
            int hour = Numbers.parseInt(seq, pos, pos += 2);
            PartitionDateParseUtil.checkRange(hour, 0, 23);
            if (PartitionDateParseUtil.checkLen(pos, lim)) {
                int min = Numbers.parseInt(seq, pos, pos += 2);
                PartitionDateParseUtil.checkRange(min, 0, 59);
                if (PartitionDateParseUtil.checkLen(pos, lim)) {
                    int sec = Numbers.parseInt(seq, pos, pos += 2);
                    PartitionDateParseUtil.checkRange(sec, 0, 59);
                    if (pos < lim && seq.charAt(pos) == '-') {
                        int micrLim = ++pos + 6;
                        int mlim = Math.min(lim, micrLim);
                        int micr = 0;
                        while (pos < mlim) {
                            char c = seq.charAt(pos);
                            if (c < '0' || c > '9') {
                                throw NumericException.INSTANCE;
                            }
                            micr *= 10;
                            micr += c - 48;
                            ++pos;
                        }
                        ts += (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + (long)(micr *= PartitionDateParseUtil.tenPow(micrLim - pos));
                        return ts;
                    } else {
                        if (pos != lim) throw NumericException.INSTANCE;
                        ts += (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L;
                    }
                    return ts;
                } else {
                    ts += (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L;
                }
                return ts;
            } else {
                ts += (long)(day - 1) * 86400000000L + (long)hour * 3600000000L;
            }
            return ts;
        } else {
            ts += (long)(day - 1) * 86400000000L;
        }
        return ts;
    }

    public static long parseFloorPartialTimestamp(CharSequence seq, int pos, int lim) throws NumericException {
        long ts;
        if (lim - pos < 4 || lim - pos > 25) {
            throw NumericException.INSTANCE;
        }
        int p = pos;
        int year = Numbers.parseInt(seq, p, p += 4);
        boolean l = Timestamps.isLeapYear(year);
        if (PartitionDateParseUtil.checkLen(p, lim)) {
            PartitionDateParseUtil.checkChar(seq, p++, lim, '-');
            int month = Numbers.parseInt(seq, p, p += 2);
            PartitionDateParseUtil.checkRange(month, 1, 12);
            if (PartitionDateParseUtil.checkLen(p, lim)) {
                int dayRange = Timestamps.getDaysPerMonth(month, l);
                ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l);
                ts = PartitionDateParseUtil.parseDayTime(seq, lim, p, ts, dayRange, 2);
            } else {
                ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l);
            }
        } else {
            ts = Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(1, l);
        }
        return ts;
    }

    private static void checkChar(CharSequence s, int p, int lim, char c) throws NumericException {
        if (p >= lim || s.charAt(p) != c) {
            throw NumericException.INSTANCE;
        }
    }

    private static boolean checkLen(int p, int lim) throws NumericException {
        if (lim - p >= 2) {
            return true;
        }
        if (lim <= p) {
            return false;
        }
        throw NumericException.INSTANCE;
    }

    private static void checkRange(int x, int min, int max) throws NumericException {
        if (x < min || x > max) {
            throw NumericException.INSTANCE;
        }
    }

    private static int tenPow(int i) throws NumericException {
        switch (i) {
            case 0: {
                return 1;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return 10000;
            }
            case 5: {
                return 100000;
            }
        }
        throw NumericException.INSTANCE;
    }
}

