/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.mig.MigrationUtils;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;

public class Mig702 {
    private static final Log LOG = LogFactory.getLog(EngineMigration.class);
    private static final String TXN_FILE_NAME_MIG = "_txn";
    private static final long TXN_VERSION_OFFSET_MIG = 0L;
    private static final long TX_BASE_OFFSET_A_32 = 8L;
    private static final long TX_BASE_OFFSET_B_32 = 32L;
    private static final long TX_OFFSET_MAP_WRITER_COUNT_MIG = 128L;
    private static final long TX_OFFSET_SEQ_TXN_64_MIG = 80L;
    private static final long TX_OFFSET_CHECKSUM_32_MIG = 88L;
    private static final long TX_OFFSET_LAG_TXN_COUNT_32_MIG = 92L;
    private static final long TX_OFFSET_LAG_ROW_COUNT_32_MIG = 96L;
    private static final long TX_OFFSET_LAG_MIN_TIMESTAMP_64_MIG = 100L;
    private static final long TX_OFFSET_LAG_MAX_TIMESTAMP_64_MIG = 108L;

    public static int calculateTxnLagChecksum(long txn, long seqTxn, int lagRowCount, long lagMinTimestamp, long lagMaxTimestamp, int lagTxnCount) {
        long checkSum = lagMinTimestamp;
        checkSum = checkSum * 31L + lagMaxTimestamp;
        checkSum = checkSum * 31L + txn;
        checkSum = checkSum * 31L + seqTxn;
        checkSum = checkSum * 31L + (long)lagRowCount;
        checkSum = checkSum * 31L + (long)lagTxnCount;
        return (int)(checkSum ^ checkSum >>> 32);
    }

    private static int getInt(MemoryMARW txMemory, long baseOffset, long txOffsetTransientRowCount64) {
        return txMemory.getInt(baseOffset + txOffsetTransientRowCount64);
    }

    private static long getLong(MemoryMARW txMemory, long baseOffset, long txOffsetTransientRowCount64) {
        return txMemory.getLong(baseOffset + txOffsetTransientRowCount64);
    }

    static void migrate(MigrationContext migrationContext) {
        FilesFacade ff = migrationContext.getFf();
        Path path = migrationContext.getTablePath();
        path.concat(TXN_FILE_NAME_MIG).$();
        if (!ff.exists(path)) {
            LOG.error().$("7.0.2 migration is skipped for the table, no _txn file exists [path=").$(path).I$();
            return;
        }
        try (MemoryCMARW txMemory = MigrationUtils.openFileSafe(ff, path, 32L);){
            long baseOffset;
            long version = txMemory.getLong(0L);
            boolean isA = (version & 1L) == 0L;
            long l = baseOffset = isA ? (long)txMemory.getInt(8L) : (long)txMemory.getInt(32L);
            if (baseOffset + 128L <= txMemory.size()) {
                long seqTxn = Mig702.getLong(txMemory, baseOffset, 80L);
                int lagRowCount = Mig702.getInt(txMemory, baseOffset, 96L);
                long lagMinTimestamp = Mig702.getLong(txMemory, baseOffset, 100L);
                long lagMaxTimestamp = Mig702.getLong(txMemory, baseOffset, 108L);
                int lagTxnCountRaw = Mig702.getInt(txMemory, baseOffset, 92L);
                int expectedChecksum = Mig702.calculateTxnLagChecksum(version, seqTxn, lagRowCount, lagMinTimestamp, lagMaxTimestamp, lagTxnCountRaw);
                int actualCheckSum = Mig702.getInt(txMemory, baseOffset, 88L);
                if (actualCheckSum != expectedChecksum) {
                    EngineMigration.backupFile(ff, path, migrationContext.getTablePath2(), TXN_FILE_NAME_MIG, 426);
                    txMemory.putInt(baseOffset + 92L, 0);
                    txMemory.putInt(baseOffset + 96L, 0);
                    txMemory.putLong(baseOffset + 100L, Long.MAX_VALUE);
                    txMemory.putLong(baseOffset + 108L, Long.MIN_VALUE);
                    int zeroChecksum = Mig702.calculateTxnLagChecksum(version, seqTxn, 0, Long.MAX_VALUE, Long.MIN_VALUE, 0);
                    txMemory.putInt(baseOffset + 88L, zeroChecksum);
                }
            } else {
                LOG.error().$("7.0.2 migration is skipped for the table, _txn file is too small [path=").$(path).$(", fileLength=").$(txMemory.size()).$(", expectedLength=").$(baseOffset + 128L).I$();
            }
        }
    }
}

