/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameColumnPool;
import io.questdb.cairo.frm.file.ContiguousFileColumnPool;
import io.questdb.cairo.frm.file.PartitionFrame;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class PartitionFrameFactory
implements RecycleBin<PartitionFrame>,
Closeable {
    private final FrameColumnPool columnPool;
    private final ObjList<PartitionFrame> framePool = new ObjList();
    private boolean closed;

    public PartitionFrameFactory(CairoConfiguration configuration) {
        this.columnPool = new ContiguousFileColumnPool(configuration);
    }

    @Override
    public void close() {
        this.closed = true;
        Misc.freeObjList(this.framePool);
        Misc.free(this.columnPool);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public Frame open(boolean rw, Path path, long targetPartition, RecordMetadata metadata, ColumnVersionWriter cvr, long size) {
        if (rw) {
            return this.openRW(path, targetPartition, metadata, cvr, size);
        }
        return this.openRO(path, targetPartition, metadata, cvr, size);
    }

    public Frame openRO(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionReader cvr, long size) {
        PartitionFrame frame = this.getOrCreate();
        frame.openRO(partitionPath, partitionTimestamp, metadata, cvr, size);
        return frame;
    }

    public Frame openRW(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionWriter cvw, long size) {
        PartitionFrame frame = this.getOrCreate();
        frame.openRW(partitionPath, partitionTimestamp, metadata, cvw, size);
        return frame;
    }

    @Override
    public void put(PartitionFrame frame) {
        assert (!this.isClosed());
        this.framePool.add(frame);
    }

    private PartitionFrame getOrCreate() {
        if (this.framePool.size() > 0) {
            PartitionFrame frm = this.framePool.getLast();
            this.framePool.setPos(this.framePool.size() - 1);
            return frm;
        }
        PartitionFrame frame = new PartitionFrame(this.columnPool);
        frame.setRecycleBin(this);
        return frame;
    }
}

