/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.frm.DeletedFrameColumn;
import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.FrameColumnPool;
import io.questdb.cairo.frm.FrameColumnTypePool;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;

public class PartitionFrame
implements Frame {
    private final FrameColumnPool columnPool;
    private boolean canWrite = false;
    private ColumnVersionReader crv;
    private RecycleBin<PartitionFrame> frameRecycleBin;
    private RecordMetadata metadata;
    private long offset = 0L;
    private Path partitionPath = new Path();
    private long partitionTimestamp;
    private long size;

    public PartitionFrame(FrameColumnPool columnPool) {
        this.columnPool = columnPool;
    }

    @Override
    public void close() {
        if (this.frameRecycleBin != null && !this.frameRecycleBin.isClosed()) {
            this.frameRecycleBin.put(this);
        } else {
            this.free();
        }
    }

    @Override
    public int columnCount() {
        return this.metadata.getColumnCount();
    }

    @Override
    public FrameColumn createColumn(int columnIndex) {
        int columnType = this.metadata.getColumnType(columnIndex);
        if (columnType < 0) {
            return DeletedFrameColumn.INSTANCE;
        }
        boolean isIndexed = this.metadata.isColumnIndexed(columnIndex);
        int indexBlockCapacity = isIndexed ? this.metadata.getIndexValueBlockCapacity(columnIndex) : 0;
        int crvRecIndex = this.crv.getRecordIndex(this.partitionTimestamp, columnIndex);
        long columnTop = this.crv.getColumnTopByIndexOrDefault(crvRecIndex, this.partitionTimestamp, columnIndex, this.size);
        long columnTxn = this.crv.getColumnNameTxn(this.partitionTimestamp, columnIndex);
        FrameColumnTypePool columnTypePool = this.canWrite ? this.columnPool.getPoolRW(columnType) : this.columnPool.getPoolRO(columnType);
        boolean createNew = columnTop >= this.size;
        columnTop = Math.min(columnTop, this.size);
        return columnTypePool.create(this.partitionPath, this.metadata.getColumnName(columnIndex), columnTxn, columnType, indexBlockCapacity, columnTop, columnIndex, createNew);
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void openRO(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionReader cvr, long size) {
        this.metadata = metadata;
        this.crv = cvr;
        this.size = size;
        this.partitionTimestamp = partitionTimestamp;
        this.partitionPath.of(partitionPath);
        this.canWrite = false;
    }

    public void openRW(Path partitionPath, long partitionTimestamp, RecordMetadata metadata, ColumnVersionWriter cvw, long size) {
        this.metadata = metadata;
        this.crv = cvw;
        this.size = size;
        this.partitionTimestamp = partitionTimestamp;
        this.partitionPath.of(partitionPath);
        this.canWrite = true;
    }

    @Override
    public void rebuildIndexes(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveChanges(FrameColumn frameColumn) {
        if (!this.canWrite) {
            throw CairoException.critical(0).put("cannot save column top, partition frame is read-only [path=").put(this.partitionPath).put(']');
        }
        ColumnVersionWriter cvw = (ColumnVersionWriter)this.crv;
        cvw.upsertColumnTop(this.partitionTimestamp, frameColumn.getColumnIndex(), frameColumn.getColumnTop());
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    private void free() {
        this.partitionPath = Misc.free(this.partitionPath);
    }

    void setRecycleBin(RecycleBin<PartitionFrame> frameRecycleBin) {
        this.frameRecycleBin = frameRecycleBin;
    }
}

