/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileFixFrameColumn;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;

public class ContiguousFileVarFrameColumn
implements FrameColumn {
    private static final Log LOG = LogFactory.getLog(ContiguousFileFixFrameColumn.class);
    private static final int MEMORY_TAG = 5;
    private final FilesFacade ff;
    private final long fileOpts;
    private int columnIndex;
    private long columnTop;
    private int columnType;
    private int fixedFd = -1;
    private RecycleBin<ContiguousFileVarFrameColumn> recycleBin;
    private long varAppendOffset = -1L;
    private int varFd = -1;
    private long varLength = -1L;

    public ContiguousFileVarFrameColumn(FilesFacade ff, long fileOpts) {
        this.ff = ff;
        this.fileOpts = fileOpts;
    }

    @Override
    public void addTop(long value) {
        this.columnTop += value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(long offset, FrameColumn sourceColumn, long sourceLo, long sourceHi, int commitMode) {
        if (sourceColumn.getStorageType() != 0) {
            throw new UnsupportedOperationException();
        }
        sourceLo -= sourceColumn.getColumnTop();
        offset -= this.columnTop;
        assert ((sourceHi -= sourceColumn.getColumnTop()) >= 0L);
        assert (sourceLo >= 0L);
        assert (offset >= 0L);
        if (sourceHi > 0L) {
            long varOffset = this.getVarOffset(offset);
            long srcFixMapSize = (sourceHi - sourceLo + 1L) * 8L;
            long srcFixAddr = TableUtils.mapAppendColumnBuffer(this.ff, sourceColumn.getSecondaryFd(), sourceLo * 8L, srcFixMapSize, false, 5);
            try {
                long varSrcOffset = Unsafe.getUnsafe().getLong(srcFixAddr);
                assert (sourceLo == 0L && varSrcOffset == 0L || sourceLo > 0L && varSrcOffset > 0L && varSrcOffset < 0x10000000000L);
                long copySize = Unsafe.getUnsafe().getLong(srcFixAddr + sourceHi * 8L) - varSrcOffset;
                assert (copySize > 0L && copySize < 0x10000000000L);
                TableUtils.allocateDiskSpaceToPage(this.ff, this.varFd, varOffset + copySize);
                this.ff.fadvise(sourceColumn.getPrimaryFd(), varSrcOffset, copySize, Files.POSIX_FADV_SEQUENTIAL);
                if (this.ff.copyData(sourceColumn.getPrimaryFd(), this.varFd, varSrcOffset, varOffset, copySize) != copySize) {
                    throw CairoException.critical(this.ff.errno()).put("Cannot copy data [fd=").put(this.varFd).put(", destOffset=").put(varOffset).put(", size=").put(copySize).put(", fileSize=").put(this.ff.length(this.varFd)).put(", srcFd=").put(sourceColumn.getPrimaryFd()).put(", srcOffset=").put(varSrcOffset).put(", srcFileSize=").put(this.ff.length(sourceColumn.getPrimaryFd())).put(']');
                }
                long fixedOffset = offset * 8L;
                TableUtils.allocateDiskSpaceToPage(this.ff, this.fixedFd, fixedOffset + srcFixMapSize);
                long fixAddr = TableUtils.mapAppendColumnBuffer(this.ff, this.fixedFd, fixedOffset, srcFixMapSize, true, 5);
                try {
                    Vect.shiftCopyFixedSizeColumnData(varSrcOffset - varOffset, srcFixAddr, 0L, sourceHi, fixAddr);
                }
                finally {
                    TableUtils.mapAppendColumnBufferRelease(this.ff, fixAddr, fixedOffset, srcFixMapSize, 5);
                }
                this.varAppendOffset = offset + (sourceHi - sourceLo);
                this.varLength = varOffset + copySize;
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, srcFixAddr, sourceLo * 8L, srcFixMapSize, 5);
            }
            if (commitMode != 2) {
                this.ff.fsync(this.fixedFd);
                this.ff.fsync(this.varFd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendNulls(long offset, long count, int commitMode) {
        assert ((offset -= this.columnTop) >= 0L);
        if (count > 0L) {
            long varOffset = this.getVarOffset(offset);
            long appendVarSize = count * (long)(ColumnType.isString(this.columnType) ? 4 : 8);
            TableUtils.allocateDiskSpaceToPage(this.ff, this.varFd, varOffset + appendVarSize);
            long varAddr = TableUtils.mapAppendColumnBuffer(this.ff, this.varFd, varOffset, appendVarSize, true, 5);
            try {
                Vect.memset(varAddr, appendVarSize, -1);
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, varAddr, varOffset, appendVarSize, 5);
            }
            long fixedSize = count * 8L;
            long fixedOffset = (offset + 1L) * 8L;
            TableUtils.allocateDiskSpaceToPage(this.ff, this.fixedFd, fixedOffset + fixedSize);
            long fixAddr = TableUtils.mapAppendColumnBuffer(this.ff, this.fixedFd, fixedOffset, fixedSize, true, 5);
            try {
                if (ColumnType.isString(this.columnType)) {
                    Vect.setVarColumnRefs32Bit(fixAddr, varOffset + 4L, count);
                } else {
                    Vect.setVarColumnRefs64Bit(fixAddr, varOffset + 8L, count);
                }
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, fixAddr, fixedOffset, fixedSize, 5);
            }
            if (commitMode != 2) {
                this.ff.fsync(this.fixedFd);
                this.ff.fsync(this.varFd);
            }
        }
    }

    @Override
    public void close() {
        if (this.fixedFd != -1) {
            this.ff.close(this.fixedFd);
            this.fixedFd = -1;
        }
        if (this.varFd != -1) {
            this.ff.close(this.varFd);
            this.varFd = -1;
        }
        if (this.recycleBin != null && !this.recycleBin.isClosed()) {
            this.varAppendOffset = 0L;
            this.varLength = 0L;
            this.recycleBin.put(this);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public long getColumnTop() {
        return this.columnTop;
    }

    @Override
    public int getColumnType() {
        return this.columnType;
    }

    @Override
    public int getPrimaryFd() {
        return this.varFd;
    }

    @Override
    public int getSecondaryFd() {
        return this.fixedFd;
    }

    @Override
    public int getStorageType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ofRO(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex, boolean isEmpty) {
        assert (this.fixedFd == -1);
        this.columnType = columnType;
        this.columnTop = columnTop;
        this.columnIndex = columnIndex;
        int plen = partitionPath.length();
        try {
            if (!isEmpty) {
                TableUtils.dFile(partitionPath, columnName, columnTxn);
                this.varFd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
                partitionPath.trimTo(plen);
                TableUtils.iFile(partitionPath, columnName, columnTxn);
                this.fixedFd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
            }
        }
        finally {
            partitionPath.trimTo(plen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex) {
        assert (this.fixedFd == -1);
        this.columnType = columnType;
        this.columnTop = columnTop;
        this.columnIndex = columnIndex;
        int plen = partitionPath.length();
        try {
            TableUtils.dFile(partitionPath, columnName, columnTxn);
            this.varFd = TableUtils.openRW(this.ff, partitionPath.$(), LOG, this.fileOpts);
            partitionPath.trimTo(plen);
            TableUtils.iFile(partitionPath, columnName, columnTxn);
            this.fixedFd = TableUtils.openRW(this.ff, partitionPath.$(), LOG, this.fileOpts);
        }
        finally {
            partitionPath.trimTo(plen);
        }
    }

    public void setPool(RecycleBin<ContiguousFileVarFrameColumn> recycleBin) {
        assert (this.recycleBin == null);
        this.recycleBin = recycleBin;
    }

    private long getVarOffset(long offset) {
        if (this.varAppendOffset != offset) {
            this.varLength = this.readVarOffset(this.fixedFd, offset);
            this.varAppendOffset = offset;
            return this.varLength;
        }
        return this.varLength;
    }

    private long readVarOffset(int fixedFd, long offset) {
        long varOffset;
        long fixedOffset = offset * 8L;
        long l = varOffset = offset > 0L ? this.ff.readNonNegativeLong(fixedFd, fixedOffset) : 0L;
        if (varOffset < 0L || varOffset > 0x10000000000L || offset > 0L && varOffset == 0L) {
            throw CairoException.critical(this.ff.errno()).put("Invalid variable file length offset read from offset file [fixedFd=").put(fixedFd).put(", offset=").put(fixedOffset).put(", fileLen=").put(this.ff.length(fixedFd)).put(", result=").put(varOffset).put(']');
        }
        return varOffset;
    }
}

