/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileFixFrameColumn;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class ContiguousFileIndexedFrameColumn
extends ContiguousFileFixFrameColumn {
    private final BitmapIndexWriter indexWriter;

    public ContiguousFileIndexedFrameColumn(CairoConfiguration configuration) {
        super(configuration);
        this.indexWriter = new BitmapIndexWriter(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(long offset, FrameColumn sourceColumn, long sourceLo, long sourceHi, int commitMode) {
        super.append(offset, sourceColumn, sourceLo, sourceHi, commitMode);
        int fd = super.getPrimaryFd();
        int shl = ColumnType.pow2SizeOf(this.getColumnType());
        long size = sourceHi - sourceLo;
        assert (size >= 0L);
        if (size > 0L) {
            long mappedAddress = TableUtils.mapAppendColumnBuffer(this.ff, fd, offset - this.getColumnTop() << shl, size << shl, false, 5);
            try {
                this.indexWriter.rollbackConditionally(offset);
                for (long i = 0L; i < size; ++i) {
                    this.indexWriter.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(mappedAddress + (i << shl))), offset + i);
                }
                this.indexWriter.setMaxValue(offset + size - 1L);
                this.indexWriter.commit();
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, mappedAddress, offset - this.getColumnTop() << shl, size << shl, 5);
            }
        }
    }

    @Override
    public void appendNulls(long offset, long count, int commitMode) {
        super.appendNulls(offset, count, commitMode);
        this.indexWriter.rollbackConditionally(offset);
        for (long i = 0L; i < count; ++i) {
            this.indexWriter.add(0, offset + i);
        }
        this.indexWriter.setMaxValue(offset + count - 1L);
        this.indexWriter.commit();
    }

    @Override
    public void close() {
        this.indexWriter.close();
        super.close();
    }

    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, int indexBlockCapacity, long columnTop, int columnIndex, boolean isEmpty) {
        super.ofRW(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex);
        this.indexWriter.of(partitionPath, columnName, columnTxn, isEmpty ? indexBlockCapacity : 0);
    }

    @Override
    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    private int keyCount(int key, long size, long mappedAddress) {
        int count = 0;
        for (long i = 0L; i < size; ++i) {
            if (TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(mappedAddress + (i << 2))) != key) continue;
            ++count;
        }
        return count;
    }
}

