/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.FrameColumnPool;
import io.questdb.cairo.frm.FrameColumnTypePool;
import io.questdb.cairo.frm.file.ContiguousFileFixFrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileIndexedFrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileVarFrameColumn;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class ContiguousFileColumnPool
implements FrameColumnPool,
Closeable {
    private final ColumnTypePool columnTypePool = new ColumnTypePool();
    private final FilesFacade ff;
    private final ListPool<ContiguousFileFixFrameColumn> fixColumnPool = new ListPool();
    private final ListPool<ContiguousFileFixFrameColumn> indexedColumnPool = new ListPool();
    private final ListPool<ContiguousFileVarFrameColumn> varColumnPool = new ListPool();
    private boolean canWrite;
    private boolean isClosed;
    private final CairoConfiguration configuration;

    public ContiguousFileColumnPool(CairoConfiguration configuration) {
        this.ff = configuration.getFilesFacade();
        this.configuration = configuration;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public FrameColumnTypePool getPoolRO(int columnType) {
        this.canWrite = false;
        return this.columnTypePool;
    }

    @Override
    public FrameColumnTypePool getPoolRW(int columnType) {
        this.canWrite = true;
        return this.columnTypePool;
    }

    private class ListPool<T>
    implements RecycleBin<T> {
        private final ObjList<T> pool = new ObjList();

        private ListPool() {
        }

        @Override
        public boolean isClosed() {
            return ContiguousFileColumnPool.this.isClosed;
        }

        public T pop() {
            T last = this.pool.getLast();
            this.pool.setPos(this.pool.size() - 1);
            return last;
        }

        @Override
        public void put(T frame) {
            this.pool.add(frame);
        }

        public int size() {
            return this.pool.size();
        }
    }

    private class ColumnTypePool
    implements FrameColumnTypePool {
        private ColumnTypePool() {
        }

        @Override
        public FrameColumn create(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, int indexBlockCapacity, long columnTop, int columnIndex, boolean isEmpty) {
            boolean isIndexed = indexBlockCapacity > 0;
            switch (columnType) {
                case 12: {
                    if (ContiguousFileColumnPool.this.canWrite && isIndexed) {
                        ContiguousFileIndexedFrameColumn indexedColumn = this.getIndexedColumn();
                        indexedColumn.ofRW(partitionPath, columnName, columnTxn, columnType, indexBlockCapacity, columnTop, columnIndex, isEmpty);
                        return indexedColumn;
                    }
                }
                default: {
                    ContiguousFileFixFrameColumn column = this.getFixColumn();
                    if (ContiguousFileColumnPool.this.canWrite) {
                        column.ofRW(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex);
                    } else {
                        column.ofRO(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex, isEmpty);
                    }
                    return column;
                }
                case 11: 
                case 18: 
            }
            ContiguousFileVarFrameColumn column = this.getVarColumn();
            if (ContiguousFileColumnPool.this.canWrite) {
                column.ofRW(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex);
            } else {
                column.ofRO(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex, isEmpty);
            }
            return column;
        }

        private ContiguousFileFixFrameColumn getFixColumn() {
            if (ContiguousFileColumnPool.this.fixColumnPool.size() > 0) {
                return ContiguousFileColumnPool.this.fixColumnPool.pop();
            }
            ContiguousFileFixFrameColumn col = new ContiguousFileFixFrameColumn(ContiguousFileColumnPool.this.configuration);
            col.setPool(ContiguousFileColumnPool.this.fixColumnPool);
            return col;
        }

        private ContiguousFileIndexedFrameColumn getIndexedColumn() {
            if (ContiguousFileColumnPool.this.indexedColumnPool.size() > 0) {
                return (ContiguousFileIndexedFrameColumn)ContiguousFileColumnPool.this.indexedColumnPool.pop();
            }
            ContiguousFileIndexedFrameColumn col = new ContiguousFileIndexedFrameColumn(ContiguousFileColumnPool.this.configuration);
            col.setPool(ContiguousFileColumnPool.this.indexedColumnPool);
            return col;
        }

        private ContiguousFileVarFrameColumn getVarColumn() {
            if (ContiguousFileColumnPool.this.varColumnPool.size() > 0) {
                return ContiguousFileColumnPool.this.varColumnPool.pop();
            }
            ContiguousFileVarFrameColumn col = new ContiguousFileVarFrameColumn(ContiguousFileColumnPool.this.ff, ContiguousFileColumnPool.this.configuration.getWriterFileOpenOpts());
            col.setPool(ContiguousFileColumnPool.this.varColumnPool);
            return col;
        }
    }
}

