/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.Metrics;
import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.AttachDetachStatus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.ColumnVersionWriter;
import io.questdb.cairo.CommitListener;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.IndexBuilder;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.O3Basket;
import io.questdb.cairo.O3CallbackJob;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3MutableAtomicInteger;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3PartitionJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolColumnIndexer;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxWriter;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.UpdateOperator;
import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameAlgebra;
import io.questdb.cairo.frm.file.PartitionFrameFactory;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.NullMapWriter;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCMOR;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMAT;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.cairo.vm.api.NullMemory;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.cairo.wal.SymbolMapDiff;
import io.questdb.cairo.wal.SymbolMapDiffCursor;
import io.questdb.cairo.wal.SymbolMapDiffEntry;
import io.questdb.cairo.wal.WalTxnDetails;
import io.questdb.cairo.wal.WriterRowUtils;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.DropIndexOperator;
import io.questdb.griffin.PurgingOperator;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.UpdateOperatorImpl;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.LongList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.PagedDirectLongList;
import io.questdb.std.ReadOnlyObjList;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.Vect;
import io.questdb.std.WeakClosableObjectPool;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.O3CallbackTask;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import io.questdb.tasks.TableWriterTask;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;

public class TableWriter
implements TableWriterAPI,
MetadataService,
Closeable {
    public static final int O3_BLOCK_DATA = 2;
    public static final int O3_BLOCK_MERGE = 3;
    public static final int O3_BLOCK_NONE = -1;
    public static final int O3_BLOCK_O3 = 1;
    public static final int PARTITION_SINK_SIZE_LONGS = 5;
    public static final int PARTITION_SINK_COL_TOP_OFFSET = 40;
    public static final int TIMESTAMP_MERGE_ENTRY_BYTES = 16;
    private static final ObjectFactory<MemoryCMOR> GET_MEMORY_CMOR = Vm::getMemoryCMOR;
    private static final long IGNORE = -1L;
    private static final Log LOG = LogFactory.getLog(TableWriter.class);
    private static final int MAX_MID_SUB_PARTITION_COUNT = 1;
    private static final Runnable NOOP = () -> {};
    private static final Row NOOP_ROW = new NoOpRow();
    private static final int O3_ERRNO_FATAL = 0x7FFFFFFE;
    private static final int ROW_ACTION_NO_PARTITION = 1;
    private static final int ROW_ACTION_NO_TIMESTAMP = 2;
    private static final int ROW_ACTION_O3 = 3;
    private static final int ROW_ACTION_OPEN_PARTITION = 0;
    private static final int ROW_ACTION_SWITCH_PARTITION = 4;
    final ObjList<MemoryMA> columns;
    private final AlterOperation alterOp = new AlterOperation();
    private final LongConsumer appendTimestampSetter;
    private final ColumnVersionWriter columnVersionWriter;
    private final MPSequence commandPubSeq;
    private final RingQueue<TableWriterTask> commandQueue;
    private final SCSequence commandSubSeq;
    private final CairoConfiguration configuration;
    private final MemoryMAR ddlMem;
    private final ObjList<ColumnIndexer> denseIndexers = new ObjList();
    private final ObjList<MapWriter> denseSymbolMapWriters;
    private final FilesFacade ff;
    private final StringSink fileNameSink = new StringSink();
    private final int fileOperationRetryCount;
    private final SOCountDownLatch indexLatch = new SOCountDownLatch();
    private final MemoryMR indexMem = Vm.getMRInstance();
    private final LongList indexSequences = new LongList();
    private final ObjList<ColumnIndexer> indexers;
    private final MessageBus messageBus;
    private final MemoryMR metaMem;
    private final TableWriterMetadata metadata;
    private final Metrics metrics;
    private final boolean mixedIOFlag;
    private final int mkDirMode;
    private final ObjList<Runnable> nullSetters;
    private final ObjectPool<O3Basket> o3BasketPool = new ObjectPool<O3Basket>(O3Basket::new, 64);
    private final ObjectPool<O3MutableAtomicInteger> o3ColumnCounters = new ObjectPool<O3MutableAtomicInteger>(O3MutableAtomicInteger::new, 64);
    private final int o3ColumnMemorySize;
    private final ObjList<MemoryCR> o3ColumnOverrides;
    private final SOUnboundedCountDownLatch o3DoneLatch = new SOUnboundedCountDownLatch();
    private final AtomicInteger o3ErrorCount = new AtomicInteger();
    private final long[] o3LastTimestampSpreads;
    private final AtomicLong o3PartitionUpdRemaining = new AtomicLong();
    private final boolean o3QuickSortEnabled;
    private final Path other;
    private final MessageBus ownMessageBus;
    private final boolean parallelIndexerEnabled;
    private final int partitionBy;
    private final DateFormat partitionDirFmt;
    private final PartitionFrameFactory partitionFrameFactory;
    private final LongList partitionRemoveCandidates = new LongList();
    private final Path path;
    private final AtomicLong physicallyWrittenRowsSinceLastCommit = new AtomicLong();
    private final int rootLen;
    private final FragileCode RECOVER_FROM_META_RENAME_FAILURE = this::recoverFromMetaRenameFailure;
    private final Row row = new RowImpl();
    private final LongList rowValueIsNotNull = new LongList();
    private final TxReader slaveTxReader;
    private final ObjList<MapWriter> symbolMapWriters;
    private final IntList symbolRewriteMap = new IntList();
    private final MemoryMARW todoMem = Vm.getMARWInstance();
    private final TxWriter txWriter;
    private final FindVisitor removePartitionDirsNotAttached = this::removePartitionDirsNotAttached;
    private final TxnScoreboard txnScoreboard;
    private final Uuid uuid = new Uuid();
    private final LowerCaseCharSequenceIntHashMap validationMap = new LowerCaseCharSequenceIntHashMap();
    private final WeakClosableObjectPool<MemoryCMOR> walColumnMemoryPool;
    private final ObjList<MemoryCMOR> walMappedColumns = new ObjList();
    private ObjList<? extends MemoryA> activeColumns;
    private ObjList<Runnable> activeNullSetters;
    private ColumnVersionReader attachColumnVersionReader;
    private IndexBuilder attachIndexBuilder;
    private long attachMaxTimestamp;
    private MemoryCMR attachMetaMem;
    private TableWriterMetadata attachMetadata;
    private long attachMinTimestamp;
    private TxReader attachTxReader;
    private long avgRecordSize;
    private boolean avoidIndexOnCommit = false;
    private int columnCount;
    private CommitListener commitListener;
    private long committedMasterRef;
    private String designatedTimestampColumnName;
    private boolean distressed = false;
    private DropIndexOperator dropIndexOperator;
    private int indexCount;
    private int lastErrno;
    private boolean lastOpenPartitionIsReadOnly;
    private long lastOpenPartitionTs = Long.MIN_VALUE;
    private long lastPartitionTimestamp;
    private LifecycleManager lifecycleManager;
    private int lockFd = -1;
    private long masterRef = 0L;
    private int metaPrevIndex;
    private final FragileCode RECOVER_FROM_TODO_WRITE_FAILURE = this::recoverFromTodoWriteFailure;
    private int metaSwapIndex;
    private long minSplitPartitionTimestamp;
    private long noOpRowCount;
    private ReadOnlyObjList<? extends MemoryCR> o3Columns;
    private long o3CommitBatchTimestampMin = Long.MAX_VALUE;
    private long o3EffectiveLag = 0L;
    private boolean o3InError = false;
    private long o3MasterRef = -1L;
    private ObjList<MemoryCARW> o3MemColumns;
    private ObjList<MemoryCARW> o3MemColumns2;
    private ObjList<Runnable> o3NullSetters;
    private ObjList<Runnable> o3NullSetters2;
    private PagedDirectLongList o3PartitionUpdateSink;
    private long o3RowCount;
    private MemoryMAT o3TimestampMem;
    private MemoryARW o3TimestampMemCpy;
    private long partitionTimestampHi;
    private boolean performRecovery;
    private PurgingOperator purgingOperator;
    private boolean removeDirOnCancelRow = true;
    private int rowAction = 0;
    private TableToken tableToken;
    private final O3ColumnUpdateMethod o3MoveWalFromFilesToLastPartitionRef = this::o3MoveWalFromFilesToLastPartition;
    private final O3ColumnUpdateMethod o3SortFixColumnRef = this::o3SortFixColumn;
    private final O3ColumnUpdateMethod o3SortVarColumnRef = this::o3SortVarColumn;
    private final O3ColumnUpdateMethod o3MergeVarColumnLagRef = this::o3MergeVarColumnLag;
    private final O3ColumnUpdateMethod o3MoveUncommittedRef = this::o3MoveUncommitted0;
    private final O3ColumnUpdateMethod o3MoveLagRef = this::o3MoveLag0;
    private final O3ColumnUpdateMethod o3MergeFixColumnLagRef = this::o3MergeFixColumnLag;
    private long tempMem16b = Unsafe.malloc(16L, 26);
    private LongConsumer timestampSetter;
    private long todoTxn;
    private final FragileCode RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE = this::recoverFromSymbolMapWriterFailure;
    private final FragileCode RECOVER_FROM_SWAP_RENAME_FAILURE = this::recoverFromSwapRenameFailure;
    private final FragileCode RECOVER_FROM_COLUMN_OPEN_FAILURE = this::recoverOpenColumnFailure;
    private UpdateOperatorImpl updateOperatorImpl;
    private WalTxnDetails walTxnDetails;

    public TableWriter(CairoConfiguration configuration, TableToken tableToken, MessageBus messageBus, MessageBus ownMessageBus, boolean lock, LifecycleManager lifecycleManager, CharSequence root, Metrics metrics) {
        LOG.info().$("open '").utf8(tableToken.getTableName()).$('\'').$();
        this.configuration = configuration;
        this.partitionFrameFactory = new PartitionFrameFactory(configuration);
        this.mixedIOFlag = configuration.isWriterMixedIOEnabled();
        this.metrics = metrics;
        this.ownMessageBus = ownMessageBus;
        this.messageBus = ownMessageBus != null ? ownMessageBus : messageBus;
        this.lifecycleManager = lifecycleManager;
        this.parallelIndexerEnabled = configuration.isParallelIndexingEnabled();
        this.ff = configuration.getFilesFacade();
        this.mkDirMode = configuration.getMkDirMode();
        this.fileOperationRetryCount = configuration.getFileOperationRetryCount();
        this.tableToken = tableToken;
        this.o3QuickSortEnabled = configuration.isO3QuickSortEnabled();
        this.o3ColumnMemorySize = configuration.getO3ColumnMemorySize();
        this.path = new Path().of(root).concat(tableToken);
        this.other = new Path().of(root).concat(tableToken);
        this.rootLen = this.path.length();
        try {
            if (lock) {
                this.lock();
            } else {
                this.lockFd = -1;
            }
            int todo = this.readTodo();
            if (todo == 2) {
                this.repairMetaRename((int)this.todoMem.getLong(48L));
            }
            this.ddlMem = Vm.getMARInstance(configuration.getCommitMode());
            this.metaMem = Vm.getMRInstance();
            this.columnVersionWriter = TableWriter.openColumnVersionFile(configuration, this.path, this.rootLen);
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.metadata = new TableWriterMetadata(this.tableToken, this.metaMem);
            this.partitionBy = this.metaMem.getInt(4L);
            this.txWriter = new TxWriter(this.ff, configuration).ofRW(this.path.concat("_txn").$(), this.partitionBy);
            this.txnScoreboard = new TxnScoreboard(this.ff, configuration.getTxnScoreboardEntryCount()).ofRW(this.path.trimTo(this.rootLen));
            this.path.trimTo(this.rootLen);
            this.o3ColumnOverrides = this.metadata.isWalEnabled() ? new ObjList() : null;
            switch (todo) {
                case 1: {
                    this.repairTruncate();
                    break;
                }
                case -1: 
                case 2: {
                    break;
                }
                default: {
                    LOG.error().$("ignoring unknown *todo* [code=").$(todo).I$();
                }
            }
            this.columnCount = this.metadata.getColumnCount();
            if (this.metadata.getTimestampIndex() > -1) {
                this.designatedTimestampColumnName = this.metadata.getColumnName(this.metadata.getTimestampIndex());
            }
            this.rowValueIsNotNull.extendAndSet(this.columnCount, 0L);
            this.columns = new ObjList(this.columnCount * 2);
            this.o3MemColumns = new ObjList(this.columnCount * 2);
            this.o3MemColumns2 = new ObjList(this.columnCount * 2);
            this.o3Columns = this.o3MemColumns;
            this.activeColumns = this.columns;
            this.symbolMapWriters = new ObjList(this.columnCount);
            this.indexers = new ObjList(this.columnCount);
            this.denseSymbolMapWriters = new ObjList(this.metadata.getSymbolMapCount());
            this.nullSetters = new ObjList(this.columnCount);
            this.o3NullSetters = new ObjList(this.columnCount);
            this.o3NullSetters2 = new ObjList(this.columnCount);
            this.activeNullSetters = this.nullSetters;
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                this.partitionDirFmt = PartitionBy.getPartitionDirFormatMethod(this.partitionBy);
                this.partitionTimestampHi = this.txWriter.getLastPartitionTimestamp();
            } else {
                this.partitionDirFmt = null;
            }
            this.configureColumnMemory();
            this.configureTimestampSetter();
            this.appendTimestampSetter = this.timestampSetter;
            this.configureAppendPosition();
            this.purgeUnusedPartitions();
            this.minSplitPartitionTimestamp = this.findMinSplitPartitionTimestamp();
            this.clearTodoLog();
            this.slaveTxReader = new TxReader(this.ff);
            this.commandQueue = new RingQueue<TableWriterTask>(TableWriterTask::new, configuration.getWriterCommandQueueSlotSize(), configuration.getWriterCommandQueueCapacity(), 17);
            this.commandSubSeq = new SCSequence();
            this.commandPubSeq = new MPSequence(this.commandQueue.getCycle());
            this.commandPubSeq.then(this.commandSubSeq).then(this.commandPubSeq);
            this.walColumnMemoryPool = new WeakClosableObjectPool<MemoryCMOR>(GET_MEMORY_CMOR, this.columnCount);
            this.o3LastTimestampSpreads = new long[configuration.getO3LagCalculationWindowsSize()];
            Arrays.fill(this.o3LastTimestampSpreads, 0L);
        }
        catch (Throwable e) {
            this.doClose(false);
            throw e;
        }
    }

    public TableWriter(CairoConfiguration configuration, TableToken tableToken, Metrics metrics) {
        this(configuration, tableToken, null, new MessageBusImpl(configuration), true, DefaultLifecycleManager.INSTANCE, configuration.getRoot(), metrics);
    }

    public TableWriter(CairoConfiguration configuration, TableToken tableToken, MessageBus messageBus, Metrics metrics) {
        this(configuration, tableToken, null, messageBus, true, DefaultLifecycleManager.INSTANCE, configuration.getRoot(), metrics);
    }

    public static void dispatchO3CallbackQueue0(RingQueue<O3CallbackTask> queue, int queuedCount, Sequence subSeq, SOUnboundedCountDownLatch o3DoneLatch) {
        while (!o3DoneLatch.done(queuedCount)) {
            long cursor = subSeq.next();
            if (cursor > -1L) {
                O3CallbackJob.runCallbackWithCol(queue.get(cursor), cursor, subSeq);
                continue;
            }
            Os.pause();
        }
    }

    public static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    public static int getSecondaryColumnIndex(int index) {
        return TableWriter.getPrimaryColumnIndex(index) + 1;
    }

    public static long getTimestampIndexValue(long timestampIndex, long indexRow) {
        return Unsafe.getUnsafe().getLong(timestampIndex + indexRow * 16L);
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType) {
        this.addColumn(columnName, columnType, this.configuration.getDefaultSymbolCapacity(), this.configuration.getDefaultSymbolCacheFlag(), false, 0, false);
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity) {
        this.addColumn(columnName, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, false);
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential) {
        assert (this.txWriter.getLagRowCount() == 0);
        assert (indexValueBlockCapacity == Numbers.ceilPow2(indexValueBlockCapacity)) : "power of 2 expected";
        assert (symbolCapacity == Numbers.ceilPow2(symbolCapacity)) : "power of 2 expected";
        this.checkDistressed();
        this.checkColumnName(columnName);
        if (TableWriter.getColumnIndexQuiet(this.metaMem, columnName, this.columnCount) != -1) {
            throw CairoException.duplicateColumn(columnName);
        }
        this.commit();
        long columnNameTxn = this.getTxn();
        LOG.info().$("adding column '").utf8(columnName).$('[').$(ColumnType.nameOf(columnType)).$("], columnName txn ").$(columnNameTxn).$(" to ").$(this.path).$();
        this.metaSwapIndex = this.addColumnToMeta(columnName, columnType, isIndexed, indexValueBlockCapacity, isSequential);
        this.metaMem.close();
        this.validateSwapMeta(columnName);
        this.renameMetaToMetaPrev(columnName);
        this.writeRestoreMetaTodo(columnName);
        this.renameSwapMetaToMeta(columnName);
        if (ColumnType.isSymbol(columnType)) {
            try {
                this.createSymbolMapWriter(columnName, columnNameTxn, symbolCapacity, symbolCacheFlag);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE, columnName, e);
            }
        } else {
            this.symbolMapWriters.extendAndSet(this.columnCount, NullMapWriter.INSTANCE);
        }
        this.configureColumn(columnType, isIndexed, this.columnCount);
        if (isIndexed) {
            this.populateDenseIndexerList();
        }
        ++this.columnCount;
        int columnIndex = this.columnCount - 1;
        this.columnVersionWriter.upsertDefaultTxnName(columnIndex, columnNameTxn, this.txWriter.getLastPartitionTimestamp());
        if (this.txWriter.getTransientRowCount() > 0L || !PartitionBy.isPartitioned(this.partitionBy)) {
            try {
                this.openNewColumnFiles(columnName, columnType, isIndexed, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_COLUMN_OPEN_FAILURE, columnName, e);
            }
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpColumnStructureVersion();
        this.metadata.addColumn(columnName, columnType, isIndexed, indexValueBlockCapacity, columnIndex);
        if (!Os.isWindows()) {
            this.ff.fsyncAndClose(TableUtils.openRO(this.ff, this.path.$(), LOG));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndex(CharSequence columnName, int indexValueBlockSize) {
        assert (indexValueBlockSize == Numbers.ceilPow2(indexValueBlockSize)) : "power of 2 expected";
        this.checkDistressed();
        int columnIndex = TableWriter.getColumnIndexQuiet(this.metaMem, columnName, this.columnCount);
        if (columnIndex == -1) {
            throw CairoException.nonCritical().put("column '").put(columnName).put("' does not exist");
        }
        this.commit();
        if (TableUtils.isColumnIndexed(this.metaMem, columnIndex)) {
            throw CairoException.nonCritical().put("already indexed [column=").put(columnName).put(']');
        }
        int existingType = TableUtils.getColumnType(this.metaMem, columnIndex);
        LOG.info().$("adding index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).I$();
        if (!ColumnType.isSymbol(existingType)) {
            LOG.error().$("cannot create index for [column='").utf8(columnName).$(", type=").$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).I$();
            throw CairoException.nonCritical().put("cannot create index for [column='").put(columnName).put(", type=").put(ColumnType.nameOf(existingType)).put(", path=").put(this.path).put(']');
        }
        SymbolColumnIndexer indexer = new SymbolColumnIndexer(this.configuration);
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(this.txWriter.getLastPartitionTimestamp(), columnIndex);
        try {
            try {
                if (PartitionBy.isPartitioned(this.partitionBy)) {
                    this.indexHistoricPartitions(indexer, columnName, indexValueBlockSize);
                    long timestamp = this.txWriter.getLastPartitionTimestamp();
                    if (timestamp != Long.MIN_VALUE) {
                        this.path.trimTo(this.rootLen);
                        this.setStateForTimestamp(this.path, timestamp);
                        this.indexLastPartition(indexer, columnName, columnNameTxn, columnIndex, indexValueBlockSize);
                    }
                } else {
                    this.setStateForTimestamp(this.path, 0L);
                    this.indexLastPartition(indexer, columnName, columnNameTxn, columnIndex, indexValueBlockSize);
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        catch (Throwable e) {
            LOG.error().$("rolling back index created so far [path=").$(this.path).I$();
            this.removeIndexFiles(columnName, columnIndex);
            throw e;
        }
        this.metaSwapIndex = this.copyMetadataAndSetIndexAttrs(columnIndex, 1, indexValueBlockSize);
        this.swapMetaFile(columnName);
        this.indexers.extendAndSet(columnIndex, indexer);
        this.populateDenseIndexerList();
        TableColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
        columnMetadata.setIndexed(true);
        columnMetadata.setIndexValueBlockCapacity(indexValueBlockSize);
        LOG.info().$("ADDED index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$("]' to ").$(this.path).$();
    }

    public void addPhysicallyWrittenRows(long rows) {
        this.physicallyWrittenRowsSinceLastCommit.addAndGet(rows);
        this.metrics.tableWriter().addPhysicallyWrittenRows(rows);
    }

    public void apply(AbstractOperation operation, long seqTxn) {
        try {
            this.setSeqTxn(seqTxn);
            long txnBefore = this.getTxn();
            operation.apply(this, true);
            if (txnBefore == this.getTxn()) {
                this.txWriter.commit(this.denseSymbolMapWriters);
            }
        }
        catch (CairoException ex) {
            if (ex.isWALTolerable()) {
                try {
                    this.rollback();
                    this.commitSeqTxn(seqTxn);
                }
                catch (Throwable th2) {
                    LOG.critical().$("could not rollback, table is distressed [table=").utf8(this.tableToken.getTableName()).$(", error=").$(th2).I$();
                }
            }
            throw ex;
        }
        catch (Throwable th) {
            try {
                this.rollback();
            }
            catch (Throwable th2) {
                LOG.critical().$("could not rollback, table is distressed [table=").utf8(this.tableToken.getTableName()).$(", error=").$(th2).I$();
            }
            throw th;
        }
    }

    @Override
    public long apply(AlterOperation alterOp, boolean contextAllowsAnyStructureChanges) throws AlterTableContextException {
        return alterOp.apply(this, contextAllowsAnyStructureChanges);
    }

    @Override
    public long apply(UpdateOperation operation) {
        return operation.apply(this, true);
    }

    @Override
    public AttachDetachStatus attachPartition(long timestamp) {
        return this.attachPartition(timestamp, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachDetachStatus attachPartition(long timestamp, long partitionSize) {
        boolean isSoftLink;
        assert (this.metadata.getTimestampIndex() > -1);
        if (this.txWriter.attachedPartitionsContains(timestamp)) {
            LOG.info().$("partition is already attached [path=").$(this.path).I$();
            return AttachDetachStatus.ATTACH_ERR_PARTITION_EXISTS;
        }
        if (this.inTransaction()) {
            LOG.info().$("committing open transaction before applying attach partition command [table=").utf8(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
            this.commit();
            if (this.txWriter.attachedPartitionsContains(timestamp)) {
                LOG.info().$("partition is already attached [path=").$(this.path).I$();
                return AttachDetachStatus.ATTACH_ERR_PARTITION_EXISTS;
            }
        }
        TableUtils.setPathForPartition(this.path.trimTo(this.rootLen), this.partitionBy, timestamp, this.getTxn());
        this.path.$();
        if (this.ff.exists(this.path)) {
            return AttachDetachStatus.ATTACH_ERR_DIR_EXISTS;
        }
        Path detachedPath = Path.PATH.get().of(this.configuration.getRoot()).concat(this.tableToken);
        TableUtils.setPathForPartition(detachedPath, this.partitionBy, timestamp, -1L);
        detachedPath.put(this.configuration.getAttachPartitionSuffix()).$();
        int detachedRootLen = detachedPath.length();
        boolean forceRenamePartitionDir = partitionSize < 0L;
        boolean checkPassed = false;
        try {
            if (this.ff.exists(detachedPath)) {
                isSoftLink = this.ff.isSoftLink(detachedPath);
                String timestampColName = this.metadata.getColumnMetadata(this.metadata.getTimestampIndex()).getName();
                if (partitionSize > -1L) {
                    this.readPartitionMinMax(this.ff, timestamp, detachedPath.trimTo(detachedRootLen), timestampColName, partitionSize);
                } else {
                    partitionSize = this.readPartitionSizeMinMax(this.ff, timestamp, detachedPath.trimTo(detachedRootLen), timestampColName);
                }
                if (partitionSize < 1L) {
                    AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_EMPTY_PARTITION;
                    return attachDetachStatus;
                }
                if (forceRenamePartitionDir && !this.attachPrepare(timestamp, partitionSize, detachedPath, detachedRootLen)) {
                    this.attachValidateMetadata(partitionSize, detachedPath.trimTo(detachedRootLen), timestamp);
                }
                if (forceRenamePartitionDir && this.configuration.attachPartitionCopy() && !isSoftLink) {
                    if (this.ff.copyRecursive(detachedPath.trimTo(detachedRootLen), this.path, this.configuration.getMkDirMode()) != 0) {
                        LOG.error().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(detachedPath).$(", to=").$(this.path).I$();
                        AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_COPY;
                        return attachDetachStatus;
                    }
                    LOG.info().$("copied partition dir [from=").$(detachedPath).$(", to=").$(this.path).I$();
                } else {
                    if (this.ff.rename(detachedPath.trimTo(detachedRootLen).$(), this.path) != 0) {
                        LOG.error().$("could not rename [errno=").$(this.ff.errno()).$(", from=").$(detachedPath).$(", to=").$(this.path).I$();
                        AttachDetachStatus attachDetachStatus = AttachDetachStatus.ATTACH_ERR_RENAME;
                        return attachDetachStatus;
                    }
                    LOG.info().$("renamed partition dir [from=").$(detachedPath).$(", to=").$(this.path).I$();
                }
            } else {
                LOG.info().$("attach partition command failed, partition to attach does not exist [path=").$(detachedPath).I$();
                AttachDetachStatus timestampColName = AttachDetachStatus.ATTACH_ERR_MISSING_PARTITION;
                return timestampColName;
            }
            checkPassed = true;
        }
        finally {
            this.path.trimTo(this.rootLen);
            if (!checkPassed) {
                this.columnVersionWriter.readUnsafe();
            }
        }
        try {
            if (!$assertionsDisabled) {
                if (timestamp > this.attachMinTimestamp) throw new AssertionError();
                if (this.attachMinTimestamp > this.attachMaxTimestamp) {
                    throw new AssertionError();
                }
            }
            long nextMinTimestamp = Math.min(this.attachMinTimestamp, this.txWriter.getMinTimestamp());
            long nextMaxTimestamp = Math.max(this.attachMaxTimestamp, this.txWriter.getMaxTimestamp());
            boolean appendPartitionAttached = this.size() == 0L || this.txWriter.getNextPartitionTimestamp(nextMaxTimestamp) > this.txWriter.getNextPartitionTimestamp(this.txWriter.getMaxTimestamp());
            this.txWriter.beginPartitionSizeUpdate();
            this.txWriter.updatePartitionSizeByTimestamp(timestamp, partitionSize, this.getTxn());
            this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, nextMaxTimestamp);
            if (isSoftLink) {
                this.txWriter.setPartitionReadOnlyByTimestamp(timestamp, true);
            }
            this.txWriter.bumpTruncateVersion();
            this.columnVersionWriter.commit();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(this.denseSymbolMapWriters);
            LOG.info().$("partition attached [table=").utf8(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
            if (!appendPartitionAttached) return AttachDetachStatus.OK;
            LOG.info().$("switch partition after partition attach [tableName=").utf8(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
            this.freeColumns(true);
            this.configureAppendPosition();
            return AttachDetachStatus.OK;
        }
        catch (Throwable e) {
            LOG.critical().$("failed on attaching partition to the table and rolling back [tableName=").utf8(this.tableToken.getTableName()).$(", error=").$(e).I$();
            this.rollback();
            throw e;
        }
    }

    @Override
    public void changeCacheFlag(int columnIndex, boolean cache) {
        this.checkDistressed();
        this.commit();
        MapWriter symbolMapWriter = this.symbolMapWriters.getQuick(columnIndex);
        if (symbolMapWriter.isCached() == cache) {
            return;
        }
        symbolMapWriter.updateCacheFlag(cache);
        this.updateMetaStructureVersion();
    }

    public boolean checkScoreboardHasReadersBeforeLastCommittedTxn() {
        long lastCommittedTxn = this.txWriter.getTxn();
        try {
            if (this.txnScoreboard.acquireTxn(lastCommittedTxn)) {
                this.txnScoreboard.releaseTxn(lastCommittedTxn);
            }
        }
        catch (CairoException ex) {
            LOG.error().$("cannot lock last txn in scoreboard, partition purge will be scheduled [table=").utf8(this.tableToken.getTableName()).$(", txn=").$(lastCommittedTxn).$(", error=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
        }
        return this.txnScoreboard.getMin() != lastCommittedTxn;
    }

    @Override
    public void close() {
        if (this.lifecycleManager.close() && this.isOpen()) {
            this.doClose(true);
        }
    }

    public void closeActivePartition(boolean truncate) {
        LOG.debug().$("closing last partition [table=").utf8(this.tableToken.getTableName()).I$();
        this.closeAppendMemoryTruncate(truncate);
        this.freeIndexers();
    }

    @Override
    public long commit() {
        return this.commit(0L);
    }

    public void commitSeqTxn(long seqTxn) {
        this.txWriter.setSeqTxn(seqTxn);
        this.txWriter.commit(this.denseSymbolMapWriters);
    }

    public void commitSeqTxn() {
        this.txWriter.commit(this.denseSymbolMapWriters);
    }

    public long commitWalTransaction(Path walPath, boolean inOrder, long rowLo, long rowHi, long o3TimestampMin, long o3TimestampMax, SymbolMapDiffCursor mapDiffCursor, long seqTxn) {
        long canCommitToTxn;
        if (this.inTransaction()) {
            this.distressed = true;
            throw CairoException.critical(0).put("cannot process WAL while in transaction");
        }
        this.physicallyWrittenRowsSinceLastCommit.set(0L);
        this.txWriter.beginPartitionSizeUpdate();
        long commitToTimestamp = this.walTxnDetails.getCommitToTimestamp(seqTxn);
        if (commitToTimestamp != Long.MAX_VALUE && (canCommitToTxn = this.walTxnDetails.getFullyCommittedTxn(this.txWriter.getSeqTxn(), seqTxn, commitToTimestamp)) <= this.txWriter.getSeqTxn()) {
            commitToTimestamp = Long.MIN_VALUE;
        }
        LOG.info().$("processing WAL [path=").$(walPath).$(", roLo=").$(rowLo).$(", roHi=").$(rowHi).$(", seqTxn=").$(seqTxn).$(", tsMin=").$ts(o3TimestampMin).$(", tsMax=").$ts(o3TimestampMax).$(", commitToTimestamp=").$ts(commitToTimestamp).I$();
        long committedRowCount = this.txWriter.getRowCount();
        long maxCommittedTimestamp = this.processWalBlock(walPath, this.metadata.getTimestampIndex(), inOrder, rowLo, rowHi, o3TimestampMin, o3TimestampMax, mapDiffCursor, commitToTimestamp);
        if (maxCommittedTimestamp != Long.MIN_VALUE) {
            long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
            this.updateIndexes();
            this.columnVersionWriter.commit();
            if (this.txWriter.getLagRowCount() == 0) {
                this.txWriter.setSeqTxn(seqTxn);
                this.txWriter.setLagTxnCount(0);
            } else {
                long committedTxn = this.walTxnDetails.getFullyCommittedTxn(this.txWriter.getSeqTxn(), seqTxn, maxCommittedTimestamp);
                this.txWriter.setSeqTxn(committedTxn);
                this.txWriter.setLagTxnCount((int)(seqTxn - committedTxn));
            }
            this.syncColumns();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(this.denseSymbolMapWriters);
            this.squashSplitPartitions(this.minSplitPartitionTimestamp, this.txWriter.maxTimestamp, this.configuration.getO3LastPartitionMaxSplits());
            this.committedMasterRef = this.masterRef;
            this.processPartitionRemoveCandidates();
            this.metrics.tableWriter().incrementCommits();
            this.metrics.tableWriter().addCommittedRows(rowsAdded);
            this.shrinkO3Mem();
            if (this.commitListener != null) {
                this.commitListener.onCommit(this.txWriter.getTxn(), rowsAdded);
            }
            return rowsAdded;
        }
        this.txWriter.setLagTxnCount((int)(seqTxn - this.txWriter.getSeqTxn()));
        this.shrinkO3Mem();
        return 0L;
    }

    public void destroy() {
        LOG.info().$("closing table files [table=").utf8(this.tableToken.getTableName()).$(", dirName=").utf8(this.tableToken.getDirName()).I$();
        this.distressed = true;
        this.doClose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachDetachStatus detachPartition(long timestamp) {
        long partitionNameTxn;
        block32: {
            assert (this.metadata.getTimestampIndex() > -1);
            assert (PartitionBy.isPartitioned(this.partitionBy));
            if (this.inTransaction()) {
                LOG.info().$("committing open transaction before applying detach partition command [table=").utf8(this.tableToken.getTableName()).$(", partition=").$ts(timestamp).I$();
                this.commit();
            }
            if ((timestamp = this.txWriter.getLogicalPartitionTimestamp(timestamp)) == this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getMaxTimestamp())) {
                return AttachDetachStatus.DETACH_ERR_ACTIVE;
            }
            int partitionIndex = this.txWriter.getPartitionIndex(timestamp);
            if (partitionIndex < 0) {
                assert (!this.txWriter.attachedPartitionsContains(timestamp));
                return AttachDetachStatus.DETACH_ERR_MISSING_PARTITION;
            }
            this.squashPartitionForce(partitionIndex);
            assert (this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getPartitionTimestampByIndex(partitionIndex + 1)) != timestamp);
            long minTimestamp = this.txWriter.getMinTimestamp();
            partitionNameTxn = this.txWriter.getPartitionNameTxn(partitionIndex);
            Path detachedPath = Path.PATH.get();
            try {
                AttachDetachStatus attachDetachStatus;
                int detachedPathLen;
                TableUtils.setPathForPartition(this.path.trimTo(this.rootLen), this.partitionBy, timestamp, partitionNameTxn);
                if (!this.ff.exists(this.path.$())) {
                    LOG.error().$("partition folder does not exist [path=").$(this.path).I$();
                    AttachDetachStatus attachDetachStatus2 = AttachDetachStatus.DETACH_ERR_MISSING_PARTITION_DIR;
                    return attachDetachStatus2;
                }
                if (this.ff.isSoftLink(this.path)) {
                    detachedPathLen = 0;
                    attachDetachStatus = AttachDetachStatus.OK;
                    LOG.info().$("detaching partition via unlink [path=").$(this.path).I$();
                } else {
                    detachedPath.of(this.configuration.getRoot()).concat(this.tableToken.getDirName());
                    int detachedRootLen = detachedPath.length();
                    if (!this.ff.exists(detachedPath.slash$()) && 0 != this.ff.mkdirs(detachedPath, this.mkDirMode)) {
                        LOG.error().$("could no create detached partition folder [errno=").$(this.ff.errno()).$(", path=").$(detachedPath).I$();
                        AttachDetachStatus attachDetachStatus3 = AttachDetachStatus.DETACH_ERR_MKDIR;
                        return attachDetachStatus3;
                    }
                    TableUtils.setPathForPartition(detachedPath.trimTo(detachedRootLen), this.partitionBy, timestamp, -1L);
                    detachedPath.put(".detached").$();
                    detachedPathLen = detachedPath.length();
                    if (this.ff.exists(detachedPath)) {
                        LOG.error().$("detached partition folder already exist [path=").$(detachedPath).I$();
                        AttachDetachStatus attachDetachStatus4 = AttachDetachStatus.DETACH_ERR_ALREADY_DETACHED;
                        return attachDetachStatus4;
                    }
                    if (this.ff.hardLinkDirRecursive(this.path, detachedPath, this.mkDirMode) != 0) {
                        if (this.ff.isCrossDeviceCopyError(this.ff.errno())) {
                            if (this.ff.copyRecursive(this.path, detachedPath, this.mkDirMode) != 0) {
                                LOG.critical().$("could not copy detached partition [errno=").$(this.ff.errno()).$(", from=").$(this.path).$(", to=").$(detachedPath).I$();
                                AttachDetachStatus attachDetachStatus5 = AttachDetachStatus.DETACH_ERR_COPY;
                                return attachDetachStatus5;
                            }
                        } else {
                            LOG.critical().$("could not create hard link to detached partition [errno=").$(this.ff.errno()).$(", from=").$(this.path).$(", to=").$(detachedPath).I$();
                            AttachDetachStatus attachDetachStatus6 = AttachDetachStatus.DETACH_ERR_HARD_LINK;
                            return attachDetachStatus6;
                        }
                    }
                    this.other.of(this.path).trimTo(this.rootLen).concat("_meta").$();
                    detachedPath.trimTo(detachedPathLen).concat("_meta").$();
                    attachDetachStatus = AttachDetachStatus.OK;
                    if (-1 == this.copyOverwrite(detachedPath)) {
                        attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                        LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                    } else {
                        this.other.parent().concat("_cv").$();
                        detachedPath.parent().concat("_cv").$();
                        if (-1 == this.copyOverwrite(detachedPath)) {
                            attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                            LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                        } else {
                            this.other.parent().concat("_txn").$();
                            detachedPath.parent().concat("_txn").$();
                            if (-1 == this.copyOverwrite(detachedPath)) {
                                attachDetachStatus = AttachDetachStatus.DETACH_ERR_COPY_META;
                                LOG.critical().$("could not copy [errno=").$(this.ff.errno()).$(", from=").$(this.other).$(", to=").$(detachedPath).I$();
                            }
                        }
                    }
                }
                if (attachDetachStatus == AttachDetachStatus.OK) {
                    long nextMinTimestamp = minTimestamp;
                    if (timestamp == this.txWriter.getPartitionTimestampByIndex(0)) {
                        this.other.of(this.path).trimTo(this.rootLen);
                        nextMinTimestamp = this.readMinTimestamp(this.txWriter.getPartitionTimestampByIndex(1));
                    }
                    this.txWriter.beginPartitionSizeUpdate();
                    this.txWriter.removeAttachedPartitions(timestamp);
                    this.txWriter.setMinTimestamp(nextMinTimestamp);
                    this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, this.txWriter.getMaxTimestamp());
                    this.txWriter.bumpTruncateVersion();
                    this.columnVersionWriter.removePartition(timestamp);
                    this.columnVersionWriter.commit();
                    this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
                    this.txWriter.commit(this.denseSymbolMapWriters);
                    break block32;
                }
                detachedPath.trimTo(detachedPathLen).slash().$();
                if (this.ff.rmdir(detachedPath) != 0) {
                    LOG.error().$("could not rollback detached copy (rmdir) [errno=").$(this.ff.errno()).$(", undo=").$(detachedPath).$(", original=").$(this.path).I$();
                }
                AttachDetachStatus attachDetachStatus7 = attachDetachStatus;
                return attachDetachStatus7;
            }
            finally {
                this.path.trimTo(this.rootLen);
                this.other.trimTo(this.rootLen);
            }
        }
        this.safeDeletePartitionDir(timestamp, partitionNameTxn);
        return AttachDetachStatus.OK;
    }

    @Override
    public void dropIndex(CharSequence columnName) {
        this.checkDistressed();
        int columnIndex = TableWriter.getColumnIndexQuiet(this.metaMem, columnName, this.columnCount);
        if (columnIndex == -1) {
            throw CairoException.invalidMetadata("Column does not exist", columnName);
        }
        if (!TableUtils.isColumnIndexed(this.metaMem, columnIndex)) {
            throw CairoException.invalidMetadata("Column is not indexed", columnName);
        }
        int defaultIndexValueBlockSize = Numbers.ceilPow2(this.configuration.getIndexValueBlockSize());
        if (this.inTransaction()) {
            LOG.info().$("committing current transaction before DROP INDEX execution [txn=").$(this.txWriter.getTxn()).$(", table=").utf8(this.tableToken.getTableName()).$(", column=").utf8(columnName).I$();
            this.commit();
        }
        try {
            LOG.info().$("BEGIN DROP INDEX [txn=").$(this.txWriter.getTxn()).$(", table=").utf8(this.tableToken.getTableName()).$(", column=").utf8(columnName).I$();
            if (this.dropIndexOperator == null) {
                this.dropIndexOperator = new DropIndexOperator(this.configuration, this, this.path, this.other, this.rootLen, this.getPurgingOperator());
            }
            this.dropIndexOperator.executeDropIndex(columnName, columnIndex);
            this.metaSwapIndex = this.copyMetadataAndSetIndexAttrs(columnIndex, 0, defaultIndexValueBlockSize);
            this.swapMetaFile(columnName);
            TableColumnMetadata columnMetadata = this.metadata.getColumnMetadata(columnIndex);
            columnMetadata.setIndexed(false);
            columnMetadata.setIndexValueBlockCapacity(defaultIndexValueBlockSize);
            ColumnIndexer columnIndexer = this.indexers.getQuick(columnIndex);
            if (columnIndexer != null) {
                this.indexers.setQuick(columnIndex, null);
                Misc.free(columnIndexer);
                this.populateDenseIndexerList();
            }
            this.finishColumnPurge();
            LOG.info().$("END DROP INDEX [txn=").$(this.txWriter.getTxn()).$(", table=").utf8(this.tableToken.getTableName()).$(", column=").utf8(columnName).I$();
        }
        catch (Throwable e) {
            throw CairoException.critical(0).put("Cannot DROP INDEX for [txn=").put(this.txWriter.getTxn()).put(", table=").put(this.tableToken.getTableName()).put(", column=").put(columnName).put("]: ").put(e.getMessage());
        }
    }

    public long getAppliedSeqTxn() {
        return this.txWriter.getSeqTxn() + (long)this.txWriter.getLagTxnCount();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(CharSequence name) {
        int index = this.metadata.getColumnIndexQuiet(name);
        if (index > -1) {
            return index;
        }
        throw CairoException.critical(0).put("column '").put(name).put("' does not exist");
    }

    public long getColumnNameTxn(long partitionTimestamp, int columnIndex) {
        return this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
    }

    public long getColumnStructureVersion() {
        return this.txWriter.getColumnStructureVersion();
    }

    public long getColumnTop(long partitionTimestamp, int columnIndex, long defaultValue) {
        long colTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex);
        return colTop > -1L ? colTop : defaultValue;
    }

    public ObjList<MapWriter> getDenseSymbolMapWriters() {
        return this.denseSymbolMapWriters;
    }

    public String getDesignatedTimestampColumnName() {
        return this.designatedTimestampColumnName;
    }

    public FilesFacade getFilesFacade() {
        return this.ff;
    }

    public long getMaxTimestamp() {
        return this.txWriter.getMaxTimestamp();
    }

    @Override
    public long getMetaMaxUncommittedRows() {
        return this.metadata.getMaxUncommittedRows();
    }

    @Override
    public TableRecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public long getMetadataVersion() {
        return this.txWriter.getMetadataVersion();
    }

    public long getO3RowCount() {
        return this.hasO3() ? this.getO3RowCount0() : 0L;
    }

    @Override
    public int getPartitionBy() {
        return this.partitionBy;
    }

    public int getPartitionCount() {
        return this.txWriter.getPartitionCount();
    }

    public long getPartitionNameTxn(int partitionIndex) {
        return this.txWriter.getPartitionNameTxn(partitionIndex);
    }

    public long getPartitionO3SplitThreshold() {
        long splitMinSizeBytes = this.configuration.getPartitionO3SplitMinSize();
        return splitMinSizeBytes / (this.avgRecordSize != 0L ? this.avgRecordSize : (this.avgRecordSize = TableUtils.estimateAvgRecordSize(this.metadata)));
    }

    public long getPartitionSize(int partitionIndex) {
        if (partitionIndex == this.txWriter.getPartitionCount() - 1 || !PartitionBy.isPartitioned(this.partitionBy)) {
            return this.txWriter.getTransientRowCount();
        }
        return this.txWriter.getPartitionSize(partitionIndex);
    }

    public long getPartitionTimestamp(int partitionIndex) {
        return this.txWriter.getPartitionTimestampByIndex(partitionIndex);
    }

    public long getPhysicallyWrittenRowsSinceLastCommit() {
        return this.physicallyWrittenRowsSinceLastCommit.get();
    }

    public long getRowCount() {
        return this.txWriter.getRowCount();
    }

    public long getSeqTxn() {
        return this.txWriter.getSeqTxn();
    }

    public MemoryMA getStorageColumn(int index) {
        return this.columns.getQuick(index);
    }

    @Override
    public int getSymbolCountWatermark(int columnIndex) {
        return -1;
    }

    public int getSymbolIndexNoTransientCountUpdate(int columnIndex, CharSequence symValue) {
        return this.symbolMapWriters.getQuick(columnIndex).put(symValue, SymbolValueCountCollector.NOOP);
    }

    public MapWriter getSymbolMapWriter(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex);
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    public long getTransientRowCount() {
        return this.txWriter.getTransientRowCount();
    }

    public long getTruncateVersion() {
        return this.txWriter.getTruncateVersion();
    }

    public TxWriter getTxWriter() {
        return this.txWriter;
    }

    public long getTxn() {
        return this.txWriter.getTxn();
    }

    public TxnScoreboard getTxnScoreboard() {
        return this.txnScoreboard;
    }

    @Override
    public long getUncommittedRowCount() {
        return this.masterRef - this.committedMasterRef >> 1;
    }

    @Override
    public UpdateOperator getUpdateOperator() {
        if (this.updateOperatorImpl == null) {
            this.updateOperatorImpl = new UpdateOperatorImpl(this.configuration, this, this.path, this.rootLen, this.getPurgingOperator());
        }
        return this.updateOperatorImpl;
    }

    public WalTxnDetails getWalTnxDetails() {
        return this.walTxnDetails;
    }

    public boolean hasO3() {
        return this.o3MasterRef > -1L;
    }

    @Override
    public void ic(long o3MaxLag) {
        this.commit(o3MaxLag);
    }

    @Override
    public void ic() {
        this.commit(this.metadata.getO3MaxLag());
    }

    public boolean inTransaction() {
        return this.txWriter != null && (this.txWriter.inTransaction() || this.hasO3() || this.columnVersionWriter.hasChanges());
    }

    public boolean isOpen() {
        return this.tempMem16b != 0L;
    }

    public boolean isPartitionReadOnly(int partitionIndex) {
        return this.txWriter.isPartitionReadOnly(partitionIndex);
    }

    public boolean isSymbolMapWriterCached(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex).isCached();
    }

    public void markSeqTxnCommitted(long seqTxn) {
        this.setSeqTxn(seqTxn);
        this.txWriter.commit(this.denseSymbolMapWriters);
    }

    @Override
    public Row newRow() {
        return this.newRow(0L);
    }

    @Override
    public Row newRow(long timestamp) {
        switch (this.rowAction) {
            case 0: {
                if (timestamp < 0L) {
                    throw CairoException.nonCritical().put("timestamp before 1970-01-01 is not allowed");
                }
                if (this.txWriter.getMaxTimestamp() == Long.MIN_VALUE) {
                    this.txWriter.setMinTimestamp(timestamp);
                    this.initLastPartition(this.txWriter.getPartitionTimestampByTimestamp(timestamp));
                }
                this.rowAction = 4;
            }
            default: {
                this.bumpMasterRef();
                if (timestamp > this.partitionTimestampHi || timestamp < this.txWriter.getMaxTimestamp()) {
                    if (timestamp < this.txWriter.getMaxTimestamp()) {
                        return this.newRowO3(timestamp);
                    }
                    if (timestamp > this.partitionTimestampHi && PartitionBy.isPartitioned(this.partitionBy)) {
                        this.switchPartition(this.txWriter.getPartitionTimestampByTimestamp(timestamp));
                    }
                }
                if (this.lastOpenPartitionIsReadOnly) {
                    --this.masterRef;
                    ++this.noOpRowCount;
                    return NOOP_ROW;
                }
                this.updateMaxTimestamp(timestamp);
                break;
            }
            case 1: {
                if (timestamp < 0L) {
                    throw CairoException.nonCritical().put("timestamp before 1970-01-01 is not allowed");
                }
                if (timestamp < this.txWriter.getMaxTimestamp()) {
                    throw CairoException.nonCritical().put("Cannot insert rows out of order to non-partitioned table. Table=").put(this.path);
                }
                this.bumpMasterRef();
                this.updateMaxTimestamp(timestamp);
                break;
            }
            case 2: {
                this.bumpMasterRef();
                break;
            }
            case 3: {
                this.bumpMasterRef();
                this.o3TimestampSetter(timestamp);
                return this.row;
            }
        }
        this.txWriter.append();
        return this.row;
    }

    public void o3BumpErrorCount() {
        this.o3ErrorCount.incrementAndGet();
    }

    public void openLastPartition() {
        try {
            this.openLastPartitionAndSetAppendPosition(this.txWriter.getLastPartitionTimestamp());
        }
        catch (Throwable e) {
            this.freeColumns(false);
            throw e;
        }
    }

    public void processCommandQueue(TableWriterTask cmd, Sequence commandSubSeq, long cursor, boolean contextAllowsAnyStructureChanges) {
        if (cmd.getTableId() == (long)this.getMetadata().getTableId()) {
            switch (cmd.getType()) {
                case 2: {
                    this.processAsyncWriterCommand(this.alterOp, cmd, cursor, commandSubSeq, contextAllowsAnyStructureChanges);
                    break;
                }
                case 3: {
                    this.processAsyncWriterCommand(cmd.getAsyncWriterCommand(), cmd, cursor, commandSubSeq, false);
                    break;
                }
                default: {
                    LOG.error().$("unknown TableWriterTask type, ignored: ").$(cmd.getType()).$();
                    commandSubSeq.done(cursor);
                    break;
                }
            }
        } else {
            LOG.info().$("not my command [cmdTableId=").$(cmd.getTableId()).$(", cmdTableName=").$(cmd.getTableToken()).$(", myTableId=").$(this.getMetadata().getTableId()).$(", myTableName=").utf8(this.tableToken.getTableName()).I$();
            commandSubSeq.done(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long processWalBlock(Path walPath, int timestampIndex, boolean ordered, long rowLo, long rowHi, long o3TimestampMin, long o3TimestampMax, SymbolMapDiffCursor mapDiffCursor, long commitToTimestamp) {
        int walRootPathLen = walPath.length();
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        if (this.isLastPartitionClosed()) {
            if (this.txWriter.getPartitionCount() == 0 && this.txWriter.getLagRowCount() == 0) {
                this.openPartition(o3TimestampMin);
                this.txWriter.setMaxTimestamp(o3TimestampMin);
                this.txWriter.updatePartitionSizeByTimestamp(o3TimestampMin, 0L, this.txWriter.getTxn() - 1L);
            } else {
                throw CairoException.critical(0).put("system error, cannot resolve WAL table last partition [path=").put(this.path).put(']');
            }
        }
        assert (maxTimestamp == Long.MIN_VALUE || this.txWriter.getPartitionTimestampByTimestamp(this.partitionTimestampHi) == this.txWriter.getPartitionTimestampByTimestamp(this.txWriter.maxTimestamp));
        this.lastPartitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(this.partitionTimestampHi);
        try {
            long commitMaxTimestamp;
            long maxLagRows = this.getMaxWalSquashRows();
            long walLagMaxTimestampBefore = this.txWriter.getLagMaxTimestamp();
            this.mmapWalColumns(walPath, timestampIndex, rowLo, rowHi);
            long newMinLagTs = Math.min(o3TimestampMin, this.txWriter.getLagMinTimestamp());
            long initialPartitionTimestampHi = this.partitionTimestampHi;
            long walLagRowCount = this.txWriter.getLagRowCount();
            long o3Hi = rowHi;
            try {
                long commitMinTimestamp;
                boolean copiedToMemory;
                long timestampAddr;
                boolean copyToLagOnly;
                long o3Lo = rowLo;
                long commitRowCount = rowHi - rowLo;
                long totalUncommitted = walLagRowCount + commitRowCount;
                boolean bl = copyToLagOnly = commitToTimestamp < newMinLagTs || commitToTimestamp != Long.MAX_VALUE && totalUncommitted < (long)this.metadata.getMaxUncommittedRows();
                if (copyToLagOnly && totalUncommitted <= maxLagRows) {
                    this.o3Columns = this.remapWalSymbols(mapDiffCursor, rowLo, rowHi, walPath, 0L);
                    LOG.debug().$("all WAL rows copied to LAG [table=").$(this.tableToken).I$();
                    this.o3ShiftLagRowsUp(timestampIndex, o3Hi - o3Lo, o3Lo, walLagRowCount, true, this.o3MoveWalFromFilesToLastPartitionRef);
                    this.txWriter.setLagRowCount((int)(walLagRowCount += commitRowCount));
                    this.txWriter.setLagOrdered(this.txWriter.isLagOrdered() && ordered && walLagMaxTimestampBefore <= o3TimestampMin);
                    this.txWriter.setLagMinTimestamp(newMinLagTs);
                    this.txWriter.setLagMaxTimestamp(Math.max(o3TimestampMax, this.txWriter.getLagMaxTimestamp()));
                    long l = this.applyFromWalLagToLastPartition(commitToTimestamp);
                    return l;
                }
                if (this.applyFromWalLagToLastPartition(Math.min(o3TimestampMin, commitToTimestamp)) != Long.MIN_VALUE) {
                    walLagRowCount = this.txWriter.getLagRowCount();
                    totalUncommitted = walLagRowCount + commitRowCount;
                }
                this.txWriter.setLagMinTimestamp(Math.min(o3TimestampMin, this.txWriter.getLagMinTimestamp()));
                this.txWriter.setLagMaxTimestamp(Math.max(o3TimestampMax, this.txWriter.getLagMaxTimestamp()));
                boolean needsOrdering = !ordered || walLagRowCount > 0L;
                MemoryCR walTimestampColumn = this.walMappedColumns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
                if (needsOrdering) {
                    LOG.info().$("sorting WAL [table=").$(this.tableToken).$(", ordered=").$(ordered).$(", lagRowCount=").$(walLagRowCount).$(", walRowLo=").$(rowLo).$(", walRowHi=").$(rowHi).I$();
                    this.o3Columns = this.remapWalSymbols(mapDiffCursor, rowLo, rowHi, walPath, 0L);
                    long timestampMemorySize = totalUncommitted << 4;
                    this.o3TimestampMem.jumpTo(timestampMemorySize);
                    this.o3TimestampMemCpy.jumpTo(timestampMemorySize);
                    MemoryMA timestampColumn = this.columns.get(TableWriter.getPrimaryColumnIndex(timestampIndex));
                    long tsLagOffset = this.txWriter.getTransientRowCount() << 3;
                    long tsLagSize = walLagRowCount << 3;
                    long tsLagBufferAddr = this.mapAppendColumnBuffer(timestampColumn, tsLagOffset, tsLagSize, false);
                    long mappedTimestampIndexAddr = walTimestampColumn.addressOf(rowLo << 4);
                    timestampAddr = this.o3TimestampMem.getAddress();
                    Vect.radixSortABLongIndexAsc(Math.abs(tsLagBufferAddr), walLagRowCount, mappedTimestampIndexAddr, commitRowCount, timestampAddr, this.o3TimestampMemCpy.addressOf(0L));
                    this.mapAppendColumnBufferRelease(tsLagBufferAddr, tsLagOffset, tsLagSize);
                    this.o3MergeIntoLag(timestampAddr, walLagRowCount, rowLo, rowHi, timestampIndex);
                    o3Hi = totalUncommitted;
                    o3Lo = 0L;
                    walLagRowCount = 0L;
                    this.o3Columns = this.o3MemColumns;
                    copiedToMemory = true;
                } else {
                    this.o3Columns = this.remapWalSymbols(mapDiffCursor, rowLo, rowHi, walPath, rowLo);
                    timestampAddr = walTimestampColumn.addressOf(0L);
                    copiedToMemory = false;
                }
                if (commitToTimestamp < this.txWriter.getLagMaxTimestamp() && maxLagRows > 0L) {
                    long lagThresholdRow = 1L + Vect.boundedBinarySearchIndexT(timestampAddr, commitToTimestamp, o3Lo, o3Hi - 1L, 1);
                    boolean lagTrimmedToMax = o3Hi - lagThresholdRow > maxLagRows;
                    long l = walLagRowCount = lagTrimmedToMax ? maxLagRows : o3Hi - lagThresholdRow;
                    assert (walLagRowCount > 0L && walLagRowCount <= o3Hi - o3Lo);
                    commitMaxTimestamp = TableWriter.getTimestampIndexValue(timestampAddr, (o3Hi -= walLagRowCount) - 1L);
                    commitMinTimestamp = this.txWriter.getLagMinTimestamp();
                    assert (lagTrimmedToMax || commitMaxTimestamp <= commitToTimestamp && commitToTimestamp < TableWriter.getTimestampIndexValue(timestampAddr, o3Hi)) : "commit lag calculation error";
                    assert (!lagTrimmedToMax || commitMaxTimestamp > commitToTimestamp) : "commit lag calculation error 2";
                    this.txWriter.setLagMinTimestamp(TableWriter.getTimestampIndexValue(timestampAddr, o3Hi));
                    LOG.debug().$("committing WAL with LAG [table=").$(this.tableToken).$(", lagRowCount=").$(walLagRowCount).$(", rowLo=").$(o3Lo).$(", rowHi=").$(o3Hi).I$();
                } else {
                    walLagRowCount = 0L;
                    commitMinTimestamp = this.txWriter.getLagMinTimestamp();
                    commitMaxTimestamp = this.txWriter.getLagMaxTimestamp();
                    this.txWriter.setLagMinTimestamp(Long.MAX_VALUE);
                    this.txWriter.setLagMaxTimestamp(Long.MIN_VALUE);
                }
                this.o3RowCount = o3Hi - o3Lo + walLagRowCount;
                if (this.txWriter.getRowCount() == 0L && this.txWriter.getPartitionCount() == 1 && this.txWriter.getPartitionSize(0) == 0L) {
                    this.txWriter.setMaxTimestamp(Long.MIN_VALUE);
                    this.lastPartitionTimestamp = Long.MIN_VALUE;
                    this.closeActivePartition(false);
                    this.partitionTimestampHi = Long.MIN_VALUE;
                    long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(0);
                    long partitionNameTxn = this.txWriter.getPartitionNameTxnByRawIndex(0);
                    this.txWriter.removeAttachedPartitions(partitionTimestamp);
                    this.safeDeletePartitionDir(partitionTimestamp, partitionNameTxn);
                }
                if (o3Hi > o3Lo) {
                    this.processO3Block(walLagRowCount, timestampIndex, timestampAddr, o3Hi, commitMinTimestamp, commitMaxTimestamp, copiedToMemory, o3Lo);
                    this.finishO3Commit(initialPartitionTimestampHi);
                }
                this.txWriter.setLagOrdered(true);
                this.txWriter.setLagRowCount((int)walLagRowCount);
                if (walLagRowCount > 0L) {
                    LOG.info().$("moving rows to LAG [table=").$(this.tableToken).$(", lagRowCount=").$(walLagRowCount).$(", partitionTimestampHi=").$ts(this.partitionTimestampHi).I$();
                    this.o3ShiftLagRowsUp(timestampIndex, walLagRowCount, o3Hi, 0L, false, this.o3MoveWalFromFilesToLastPartitionRef);
                }
            }
            finally {
                this.finishO3Append(walLagRowCount);
                this.o3Columns = this.o3MemColumns;
            }
            long l = commitMaxTimestamp;
            return l;
        }
        finally {
            walPath.trimTo(walRootPathLen);
            this.closeWalColumns();
        }
    }

    public void publishAsyncWriterCommand(AsyncWriterCommand asyncWriterCommand) {
        while (true) {
            long seq;
            if ((seq = this.commandPubSeq.next()) > -1L) {
                TableWriterTask task = this.commandQueue.get(seq);
                asyncWriterCommand.serialize(task);
                this.commandPubSeq.done(seq);
                return;
            }
            if (seq == -1L) {
                throw CairoException.nonCritical().put("could not publish, command queue is full [table=").put(this.tableToken.getTableName()).put(']');
            }
            Os.pause();
        }
    }

    public void readWalTxnDetails(TransactionLogCursor transactionLogCursor) {
        if (this.walTxnDetails == null) {
            this.walTxnDetails = new WalTxnDetails(this.ff);
        }
        long appliedSeqTxn = this.txWriter.getSeqTxn();
        transactionLogCursor.setPosition(Math.max(appliedSeqTxn, this.walTxnDetails.getLastSeqTxn()));
        this.walTxnDetails.readObservableTxnMeta(this.other, transactionLogCursor, this.rootLen, appliedSeqTxn, this.txWriter.getMaxTimestamp());
    }

    public final void removeAllPartitions() {
        if (this.size() == 0L) {
            return;
        }
        if (this.partitionBy == 3) {
            throw CairoException.critical(0).put("cannot remove partitions from non-partitioned table");
        }
        this.txWriter.beginPartitionSizeUpdate();
        this.closeActivePartition(false);
        this.scheduleRemoveAllPartitions();
        this.columnVersionWriter.truncate();
        this.txWriter.removeAllPartitions();
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.commit(this.denseSymbolMapWriters);
        this.rowAction = 0;
        this.closeActivePartition(false);
        this.processPartitionRemoveCandidates();
        LOG.info().$("removed all partitions (soft truncated) [name=").utf8(this.tableToken.getTableName()).I$();
    }

    @Override
    public void removeColumn(CharSequence name) {
        boolean timestamp;
        assert (this.txWriter.getLagRowCount() == 0);
        this.checkDistressed();
        this.checkColumnName(name);
        int index = this.getColumnIndex(name);
        int type = this.metadata.getColumnType(index);
        LOG.info().$("removing [column=").utf8(name).$(", path=").utf8(this.path).I$();
        int timestampIndex = this.metaMem.getInt(8L);
        boolean bl = timestamp = index == timestampIndex;
        if (timestamp && PartitionBy.isPartitioned(this.partitionBy)) {
            throw CairoException.nonCritical().put("Cannot remove timestamp from partitioned table");
        }
        this.commit();
        this.metaSwapIndex = this.removeColumnFromMeta(index);
        this.metaMem.close();
        this.renameMetaToMetaPrev(name);
        this.writeRestoreMetaTodo(name);
        this.renameSwapMetaToMeta(name);
        this.removeColumn(index);
        this.removeSymbolMapWriter(index);
        if (timestamp) {
            this.txWriter.resetTimestamp();
            this.timestampSetter = value -> {};
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
            this.removeColumnFiles(index, type);
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpColumnStructureVersion();
        this.metadata.removeColumn(index);
        if (timestamp) {
            this.metadata.clearTimestampIndex();
        }
        this.finishColumnPurge();
        LOG.info().$("REMOVED column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("]' from ").$(this.path).$();
    }

    @Override
    public boolean removePartition(long timestamp) {
        if (!PartitionBy.isPartitioned(this.partitionBy)) {
            return false;
        }
        this.commit();
        long logicalPartitionTimestampToDelete = this.txWriter.getLogicalPartitionTimestamp(timestamp);
        int partitionIndex = this.txWriter.getPartitionIndex(logicalPartitionTimestampToDelete);
        boolean dropped = false;
        if (partitionIndex >= 0) {
            long partitionTimestamp;
            while (partitionIndex < this.txWriter.getPartitionCount() && this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex)) == logicalPartitionTimestampToDelete) {
                dropped |= this.dropPartitionByExactTimestamp(partitionTimestamp);
            }
        }
        return dropped;
    }

    @Override
    public void renameColumn(CharSequence currentName, CharSequence newName) {
        this.checkDistressed();
        this.checkColumnName(newName);
        int index = this.getColumnIndex(currentName);
        int type = this.metadata.getColumnType(index);
        LOG.info().$("renaming column '").utf8(currentName).$('[').$(ColumnType.nameOf(type)).$("]' to '").utf8(newName).$("' in ").$(this.path).$();
        this.commit();
        this.metaSwapIndex = this.renameColumnFromMeta(index, newName);
        this.metaMem.close();
        this.renameMetaToMetaPrev(currentName);
        this.writeRestoreMetaTodo(currentName);
        this.renameSwapMetaToMeta(currentName);
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
            this.hardLinkAndPurgeColumnFiles(currentName, index, newName, type);
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpColumnStructureVersion();
        this.finishColumnPurge();
        this.metadata.renameColumn(currentName, newName);
        if (index == this.metadata.getTimestampIndex()) {
            this.designatedTimestampColumnName = Chars.toString(newName);
        }
        LOG.info().$("RENAMED column '").utf8(currentName).$("' to '").utf8(newName).$("' from ").$(this.path).$();
    }

    @Override
    public void rollback() {
        this.checkDistressed();
        if (this.o3InError || this.inTransaction()) {
            try {
                LOG.info().$("tx rollback [name=").utf8(this.tableToken.getTableName()).I$();
                this.partitionRemoveCandidates.clear();
                this.o3CommitBatchTimestampMin = Long.MAX_VALUE;
                if ((this.masterRef & 1L) != 0L) {
                    ++this.masterRef;
                }
                this.freeColumns(false);
                this.txWriter.unsafeLoadAll();
                this.rollbackIndexes();
                this.rollbackSymbolTables();
                this.columnVersionWriter.readUnsafe();
                this.closeActivePartition(false);
                this.purgeUnusedPartitions();
                this.configureAppendPosition();
                this.o3InError = false;
                this.o3MasterRef = -1L;
                LOG.info().$("tx rollback complete [name=").utf8(this.tableToken.getTableName()).I$();
                this.processCommandQueue(false);
                this.metrics.tableWriter().incrementRollbacks();
            }
            catch (Throwable e) {
                LOG.critical().$("could not perform rollback [name=").utf8(this.tableToken.getTableName()).$(", msg=").$(e.getMessage()).I$();
                this.distressed = true;
            }
        }
    }

    public void setCommitListener(CommitListener commitListener) {
        this.commitListener = commitListener;
    }

    public void setExtensionListener(ExtensionListener listener) {
        this.txWriter.setExtensionListener(listener);
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaMaxUncommittedRows(int maxUncommittedRows) {
        try {
            this.commit();
            long metaSize = this.copyMetadataAndUpdateVersion();
            TableUtils.openMetaSwapFileByIndex(this.ff, this.ddlMem, this.path, this.rootLen, this.metaSwapIndex);
            try {
                this.ddlMem.jumpTo(20L);
                this.ddlMem.putInt(maxUncommittedRows);
                this.ddlMem.jumpTo(metaSize);
            }
            finally {
                this.ddlMem.close();
            }
            this.finishMetaSwapUpdate();
            this.metadata.setMaxUncommittedRows(maxUncommittedRows);
            this.clearTodoLog();
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaO3MaxLag(long o3MaxLagUs) {
        try {
            this.commit();
            long metaSize = this.copyMetadataAndUpdateVersion();
            TableUtils.openMetaSwapFileByIndex(this.ff, this.ddlMem, this.path, this.rootLen, this.metaSwapIndex);
            try {
                this.ddlMem.jumpTo(24L);
                this.ddlMem.putLong(o3MaxLagUs);
                this.ddlMem.jumpTo(metaSize);
            }
            finally {
                this.ddlMem.close();
            }
            this.finishMetaSwapUpdate();
            this.metadata.setO3MaxLag(o3MaxLagUs);
            this.clearTodoLog();
        }
        finally {
            this.ddlMem.close();
        }
    }

    public void setSeqTxn(long seqTxn) {
        assert (this.txWriter.getLagRowCount() == 0 && this.txWriter.getLagTxnCount() == 0);
        this.txWriter.setSeqTxn(seqTxn);
    }

    public long size() {
        return this.txWriter.getRowCount() + this.getO3RowCount();
    }

    public void squashAllPartitionsIntoOne() {
        this.squashSplitPartitions(0, this.txWriter.getPartitionCount(), 1, false);
    }

    @Override
    public void squashPartitions() {
        for (int i = 0; i < this.txWriter.getPartitionCount(); ++i) {
            this.squashPartitionForce(i);
        }
    }

    @Override
    public boolean supportsMultipleWriters() {
        return false;
    }

    @Override
    public void tick() {
        this.tick(false);
    }

    public void tick(boolean contextAllowsAnyStructureChanges) {
        this.processCommandQueue(contextAllowsAnyStructureChanges);
    }

    public String toString() {
        return "TableWriter{name=" + this.tableToken.getTableName() + "}";
    }

    public void transferLock(int lockFd) {
        assert (lockFd != -1);
        this.lockFd = lockFd;
    }

    @Override
    public final void truncate() {
        this.truncate(false);
    }

    @Override
    public final void truncateSoft() {
        this.truncate(true);
    }

    public void updateTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
        this.metadata.updateTableToken(tableToken);
    }

    public void upsertColumnVersion(long partitionTimestamp, int columnIndex, long columnTop) {
        this.columnVersionWriter.upsert(partitionTimestamp, columnIndex, this.txWriter.txn, columnTop);
        this.txWriter.updatePartitionColumnVersion(partitionTimestamp);
    }

    public void warmUp() {
        Row r = this.newRow(Math.max(0L, this.txWriter.getMaxTimestamp()));
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                r.putByte(i, (byte)0);
            }
        }
        finally {
            r.cancel();
        }
    }

    private static void configureNullSetters(ObjList<Runnable> nullers, int type, MemoryA mem1, MemoryA mem2) {
        switch (ColumnType.tagOf(type)) {
            case 1: 
            case 2: {
                nullers.add(() -> mem1.putByte((byte)0));
                break;
            }
            case 10: {
                nullers.add(() -> mem1.putDouble(Double.NaN));
                break;
            }
            case 9: {
                nullers.add(() -> mem1.putFloat(Float.NaN));
                break;
            }
            case 5: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                nullers.add(() -> mem1.putLong(Long.MIN_VALUE));
                break;
            }
            case 19: 
            case 24: {
                nullers.add(() -> mem1.putLong128(Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 13: {
                nullers.add(() -> mem1.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 3: {
                nullers.add(() -> mem1.putShort((short)0));
                break;
            }
            case 4: {
                nullers.add(() -> mem1.putChar('\u0000'));
                break;
            }
            case 11: {
                nullers.add(() -> mem2.putLong(mem1.putNullStr()));
                break;
            }
            case 12: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 18: {
                nullers.add(() -> mem2.putLong(mem1.putNullBin()));
                break;
            }
            case 14: {
                nullers.add(() -> mem1.putByte((byte)-1));
                break;
            }
            case 15: {
                nullers.add(() -> mem1.putShort((short)-1));
                break;
            }
            case 16: {
                nullers.add(() -> mem1.putInt(-1));
                break;
            }
            case 17: {
                nullers.add(() -> mem1.putLong(-1L));
                break;
            }
            default: {
                nullers.add(NOOP);
            }
        }
    }

    private static int getColumnIndexQuiet(MemoryMR metaMem, CharSequence name, int columnCount) {
        long nameOffset = TableUtils.getColumnNameOffset(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            CharSequence col = metaMem.getStr(nameOffset);
            int columnType = TableUtils.getColumnType(metaMem, i);
            if (columnType > 0 && Chars.equalsIgnoreCase(col, name)) {
                return i;
            }
            nameOffset += (long)Vm.getStorageLength(col);
        }
        return -1;
    }

    private static void linkFile(FilesFacade ff, LPSZ from, LPSZ to) {
        if (ff.exists(from)) {
            if (ff.hardLink(from, to) == 0) {
                LOG.debug().$("renamed [from=").utf8(from).$(", to=").utf8(to).I$();
            } else {
                throw CairoException.critical(ff.errno()).put("could not create hard link [errno=").put(ff.errno()).put(", from=").put(from).put(", to=").put(to).put(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnVersionWriter openColumnVersionFile(CairoConfiguration configuration, Path path, int rootLen) {
        path.concat("_cv").$();
        try {
            ColumnVersionWriter columnVersionWriter = new ColumnVersionWriter(configuration, path);
            return columnVersionWriter;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openMetaFile(FilesFacade ff, Path path, int rootLen, MemoryMR metaMem) {
        path.concat("_meta").$();
        try {
            metaMem.smallFile(ff, path, 5);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    private static void removeFileAndOrLog(FilesFacade ff, LPSZ name) {
        if (ff.exists(name)) {
            if (ff.remove(name)) {
                LOG.debug().$("removed [file=").utf8(name).I$();
            } else {
                LOG.error().$("could not remove [errno=").$(ff.errno()).$(", file=").utf8(name).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addColumnToMeta(CharSequence name, int type, boolean indexFlag, int indexValueBlockCapacity, boolean sequentialFlag) {
        int index;
        try {
            index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount + 1);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i, false);
            }
            this.ddlMem.putInt(type);
            long flags = 0L;
            if (indexFlag) {
                flags |= 1L;
            }
            if (sequentialFlag) {
                flags |= 2L;
            }
            this.ddlMem.putLong(flags);
            this.ddlMem.putInt(indexValueBlockCapacity);
            this.ddlMem.putLong(this.configuration.getRandom().nextLong());
            this.ddlMem.skip(8L);
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            this.ddlMem.putStr(name);
            this.ddlMem.sync(false);
        }
        finally {
            this.ddlMem.close(true, (byte)1);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long applyFromWalLagToLastPartition(long commitToTimestamp) {
        long lagMinTimestamp = this.txWriter.getLagMinTimestamp();
        if (this.txWriter.getLagRowCount() > 0 && this.txWriter.isLagOrdered() && this.txWriter.getMaxTimestamp() <= lagMinTimestamp && this.txWriter.getPartitionTimestampByTimestamp(lagMinTimestamp) == this.lastPartitionTimestamp) {
            long lagMaxTimestamp = this.txWriter.getLagMaxTimestamp();
            if (lagMaxTimestamp <= (commitToTimestamp = Math.min(commitToTimestamp, this.partitionTimestampHi))) {
                LOG.debug().$("fast apply full lag to last partition [table=").$(this.tableToken).I$();
                this.applyLagToLastPartition(lagMaxTimestamp, this.txWriter.getLagRowCount(), Long.MAX_VALUE);
                return lagMaxTimestamp;
            }
            if (lagMinTimestamp <= commitToTimestamp) {
                long lagRows = this.txWriter.getLagRowCount();
                long timestampMapOffset = this.txWriter.getTransientRowCount() * 8L;
                long timestampMapSize = lagRows * 8L;
                long timestampMaAddr = this.mapAppendColumnBuffer(this.getPrimaryColumn(this.metadata.getTimestampIndex()), timestampMapOffset, timestampMapSize, false);
                try {
                    long timestampAddr = Math.abs(timestampMaAddr);
                    long binarySearchInsertionPoint = Vect.binarySearch64Bit(timestampAddr, commitToTimestamp, 0L, lagRows - 1L, 1);
                    long applyCount = binarySearchInsertionPoint < 0L ? -binarySearchInsertionPoint - 1L : binarySearchInsertionPoint + 1L;
                    long newMinLagTimestamp = Unsafe.getUnsafe().getLong(timestampAddr + applyCount * 8L);
                    long newMaxTimestamp = Unsafe.getUnsafe().getLong(timestampAddr + (applyCount - 1L) * 8L);
                    assert (newMinLagTimestamp > commitToTimestamp && commitToTimestamp >= newMaxTimestamp);
                    this.applyLagToLastPartition(newMaxTimestamp, (int)applyCount, newMinLagTimestamp);
                    LOG.debug().$("partial apply lag to last partition [table=").$(this.tableToken).$(" ,lagSize=").$(lagRows).$(" ,rowApplied=").$(applyCount).$(", commitToTimestamp=").$(commitToTimestamp).$(", newMaxTimestamp=").$(newMaxTimestamp).$(", newMinLagTimestamp=").$(newMinLagTimestamp).I$();
                    long l = newMaxTimestamp;
                    return l;
                }
                finally {
                    this.mapAppendColumnBufferRelease(timestampMaAddr, timestampMapOffset, timestampMapSize);
                }
            }
        }
        return Long.MIN_VALUE;
    }

    private void applyLagToLastPartition(long maxTimestamp, int lagRowCount, long lagMinTimestamp) {
        long initialTransientRowCount = this.txWriter.transientRowCount;
        this.txWriter.transientRowCount += (long)lagRowCount;
        this.txWriter.updatePartitionSizeByTimestamp(this.lastPartitionTimestamp, this.txWriter.transientRowCount);
        this.txWriter.setMinTimestamp(Math.min(this.txWriter.getMinTimestamp(), this.txWriter.getLagMinTimestamp()));
        this.txWriter.setLagMinTimestamp(lagMinTimestamp);
        if (this.txWriter.getLagRowCount() == lagRowCount) {
            this.txWriter.setLagMaxTimestamp(Long.MIN_VALUE);
        }
        this.txWriter.setLagRowCount(this.txWriter.getLagRowCount() - lagRowCount);
        this.txWriter.setMaxTimestamp(maxTimestamp);
        if (this.indexCount > 0) {
            long newTransientRowCount = this.txWriter.getTransientRowCount();
            int shl = ColumnType.pow2SizeOf(12);
            int n = this.metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (this.metadata.getColumnType(i) != 12 || !this.metadata.isColumnIndexed(i)) continue;
                this.getPrimaryColumn(i).jumpTo(newTransientRowCount << shl);
            }
            this.updateIndexesParallel(initialTransientRowCount, newTransientRowCount);
        }
        this.setAppendPosition(this.txWriter.transientRowCount, false);
    }

    private boolean assertColumnPositionIncludeWalLag() {
        return this.txWriter.getLagRowCount() == 0 || this.columns.get(TableWriter.getPrimaryColumnIndex(this.metadata.getTimestampIndex())).getAppendOffset() == (this.txWriter.getTransientRowCount() + (long)this.txWriter.getLagRowCount()) * 8L;
    }

    private void attachPartitionCheckFilesMatchFixedColumn(int columnType, long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) {
        long columnSize = partitionSize - columnTop;
        if (columnSize == 0L) {
            return;
        }
        TableUtils.dFile(partitionPath, columnName, columnNameTxn);
        if (!this.ff.exists(partitionPath.$())) {
            LOG.info().$("attaching partition with missing column [path=").$(partitionPath).I$();
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
        } else {
            long fileSize = this.ff.length(partitionPath);
            if (fileSize < columnSize << ColumnType.pow2SizeOf(columnType)) {
                throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(", expectedSize=").put(columnSize << ColumnType.pow2SizeOf(columnType)).put(", actual=").put(fileSize).put(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachPartitionCheckFilesMatchVarLenColumn(long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) throws CairoException {
        block12: {
            long columnSize = partitionSize - columnTop;
            if (columnSize == 0L) {
                return;
            }
            int pathLen = partitionPath.length();
            TableUtils.dFile(partitionPath, columnName, columnNameTxn);
            long dataLength = this.ff.length(partitionPath.$());
            if (dataLength > 0L) {
                partitionPath.trimTo(pathLen);
                TableUtils.iFile(partitionPath, columnName, columnNameTxn);
                int typeSize = 8;
                int indexFd = TableUtils.openRO(this.ff, partitionPath, LOG);
                try {
                    long fileSize = this.ff.length(indexFd);
                    long expectedFileSize = (columnSize + 1L) * (long)typeSize;
                    if (fileSize < expectedFileSize) {
                        throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(",expectedSize=").put(expectedFileSize).put(",actual=").put(fileSize).put(']');
                    }
                    long mappedAddr = TableUtils.mapRO(this.ff, indexFd, expectedFileSize, 0);
                    try {
                        long prevDataAddress = dataLength;
                        for (long offset = columnSize * (long)typeSize; offset >= 0L; offset -= (long)typeSize) {
                            long dataAddress = Unsafe.getUnsafe().getLong(mappedAddr + offset);
                            if (dataAddress < 0L || dataAddress > dataLength) {
                                throw CairoException.critical(0).put("Variable size column has invalid data address value [path=").put(this.path).put(", indexOffset=").put(offset).put(", dataAddress=").put(dataAddress).put(", dataFileSize=").put(dataLength).put(']');
                            }
                            if (dataAddress > prevDataAddress) {
                                throw CairoException.critical(0).put("Variable size column has invalid data address value [path=").put(partitionPath).put(", indexOffset=").put(offset).put(", dataAddress=").put(dataAddress).put(", prevDataAddress=").put(prevDataAddress).put(", dataFileSize=").put(dataLength).put(']');
                            }
                            prevDataAddress = dataAddress;
                        }
                        break block12;
                    }
                    finally {
                        this.ff.munmap(mappedAddr, expectedFileSize, 0);
                    }
                }
                finally {
                    this.ff.close(indexFd);
                }
            }
            LOG.info().$("attaching partition with missing column [path=").$(partitionPath).I$();
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachPartitionCheckSymbolColumn(long partitionSize, long columnTop, String columnName, long columnNameTxn, Path partitionPath, long partitionTimestamp, int columnIndex) {
        long columnSize = partitionSize - columnTop;
        if (columnSize == 0L) {
            return;
        }
        int pathLen = partitionPath.length();
        TableUtils.dFile(partitionPath, columnName, columnNameTxn);
        if (!this.ff.exists(partitionPath.$())) {
            this.columnVersionWriter.upsertColumnTop(partitionTimestamp, columnIndex, partitionSize);
            return;
        }
        int fd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
        try {
            long fileSize = this.ff.length(fd);
            int typeSize = 4;
            long expectedSize = columnSize * (long)typeSize;
            if (fileSize < expectedSize) {
                throw CairoException.critical(0).put("Column file is too small. ").put("Partition files inconsistent [file=").put(partitionPath).put(", expectedSize=").put(expectedSize).put(", actual=").put(fileSize).put(']');
            }
            long address = TableUtils.mapRO(this.ff, fd, fileSize, 0);
            try {
                int maxKey = Vect.maxInt(address, columnSize);
                int symbolValues = this.symbolMapWriters.getQuick(columnIndex).getSymbolCount();
                if (maxKey >= symbolValues) {
                    throw CairoException.critical(0).put("Symbol file does not match symbol column [file=").put(this.path).put(", key=").put(maxKey).put(", columnKeys=").put(symbolValues).put(']');
                }
                int minKey = Vect.minInt(address, columnSize);
                if (minKey != Integer.MIN_VALUE && minKey < 0) {
                    throw CairoException.critical(0).put("Symbol file does not match symbol column, invalid key [file=").put(this.path).put(", key=").put(minKey).put(']');
                }
            }
            finally {
                this.ff.munmap(address, fileSize, 0);
            }
            if (this.metadata.isColumnIndexed(columnIndex)) {
                BitmapIndexUtils.valueFileName(partitionPath.trimTo(pathLen), columnName, columnNameTxn);
                if (!this.ff.exists(partitionPath.$())) {
                    throw CairoException.critical(0).put("Symbol index value file does not exist [file=").put(partitionPath).put(']');
                }
                BitmapIndexUtils.keyFileName(partitionPath.trimTo(pathLen), columnName, columnNameTxn);
                if (!this.ff.exists(partitionPath.$())) {
                    throw CairoException.critical(0).put("Symbol index key file does not exist [file=").put(partitionPath).put(']');
                }
            }
        }
        finally {
            this.ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachPrepare(long partitionTimestamp, long partitionSize, Path detachedPath, int detachedPartitionRoot) {
        try {
            detachedPath.trimTo(detachedPartitionRoot).concat("_meta");
            if (!this.ff.exists(detachedPath.$())) {
                LOG.info().$("detached ").$("_meta").$(" file not found, skipping check [path=").$(detachedPath).I$();
                boolean bl = false;
                return bl;
            }
            if (this.attachMetadata == null) {
                this.attachMetaMem = Vm.getCMRInstance();
                this.attachMetaMem.smallFile(this.ff, detachedPath, 5);
                this.attachMetadata = new TableWriterMetadata(this.tableToken, this.attachMetaMem);
            } else {
                this.attachMetaMem.smallFile(this.ff, detachedPath, 5);
                this.attachMetadata.reload(this.attachMetaMem);
            }
            if (this.metadata.getTableId() != this.attachMetadata.getTableId()) {
                throw CairoException.detachedMetadataMismatch("table_id");
            }
            if (this.metadata.getTimestampIndex() != this.attachMetadata.getTimestampIndex()) {
                throw CairoException.detachedMetadataMismatch("timestamp_index");
            }
            detachedPath.trimTo(detachedPartitionRoot).concat("_cv").$();
            if (!this.ff.exists(detachedPath)) {
                LOG.error().$("detached _dcv file not found, skipping check [path=").$(detachedPath).I$();
                boolean bl = false;
                return bl;
            }
            if (this.attachColumnVersionReader == null) {
                this.attachColumnVersionReader = new ColumnVersionReader();
            }
            this.attachColumnVersionReader.ofRO(this.ff, detachedPath);
            this.attachColumnVersionReader.readUnsafe();
            this.columnVersionWriter.copyPartition(partitionTimestamp, this.attachColumnVersionReader);
            for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
                int attachColType;
                String columnName = this.metadata.getColumnName(colIdx);
                int detColIdx = this.attachMetadata.getColumnIndexQuiet(columnName);
                if (detColIdx == -1) {
                    this.columnVersionWriter.upsertColumnTop(partitionTimestamp, colIdx, partitionSize);
                    continue;
                }
                if (detColIdx != colIdx) {
                    throw CairoException.detachedColumnMetadataMismatch(colIdx, columnName, "name");
                }
                int tableColType = this.metadata.getColumnType(colIdx);
                if (tableColType != (attachColType = this.attachMetadata.getColumnType(detColIdx)) && tableColType != -attachColType) {
                    throw CairoException.detachedColumnMetadataMismatch(colIdx, columnName, "type");
                }
                if (tableColType != attachColType) {
                    LOG.info().$("detached partition has column deleted while the table has the same column alive [tableName=").utf8(this.tableToken.getTableName()).$(", columnName=").utf8(columnName).$(", columnType=").$(ColumnType.nameOf(tableColType)).I$();
                    this.columnVersionWriter.upsertColumnTop(partitionTimestamp, colIdx, partitionSize);
                }
                if (!ColumnType.isSymbol(tableColType)) continue;
                boolean isIndexedNow = this.metadata.isColumnIndexed(colIdx);
                boolean wasIndexedAtDetached = this.attachMetadata.isColumnIndexed(detColIdx);
                int indexValueBlockCapacityNow = this.metadata.getIndexValueBlockCapacity(colIdx);
                int indexValueBlockCapacityDetached = this.attachMetadata.getIndexValueBlockCapacity(detColIdx);
                if (!isIndexedNow && wasIndexedAtDetached) {
                    long columnNameTxn = this.attachColumnVersionReader.getColumnNameTxn(partitionTimestamp, colIdx);
                    BitmapIndexUtils.keyFileName(detachedPath.trimTo(detachedPartitionRoot), columnName, columnNameTxn);
                    TableWriter.removeFileAndOrLog(this.ff, detachedPath);
                    BitmapIndexUtils.valueFileName(detachedPath.trimTo(detachedPartitionRoot), columnName, columnNameTxn);
                    TableWriter.removeFileAndOrLog(this.ff, detachedPath);
                    continue;
                }
                if (!isIndexedNow || wasIndexedAtDetached && indexValueBlockCapacityNow == indexValueBlockCapacityDetached) continue;
                detachedPath.trimTo(detachedPartitionRoot);
                this.rebuildAttachedPartitionColumnIndex(partitionTimestamp, partitionSize, columnName);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Misc.free(this.attachColumnVersionReader);
            Misc.free(this.attachMetaMem);
            Misc.free(this.attachIndexBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void attachValidateMetadata(long partitionSize, Path partitionPath, long partitionTimestamp) throws CairoException {
        rootLen = partitionPath.length();
        size = this.metadata.getColumnCount();
        block9: for (columnIndex = 0; columnIndex < size; ++columnIndex) {
            try {
                columnName = this.metadata.getColumnName(columnIndex);
                columnType = this.metadata.getColumnType(columnIndex);
                if ((long)columnType <= -1L || (columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex)) < 0L || columnTop == partitionSize) continue;
                columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
                switch (ColumnType.tagOf(columnType)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 24: {
                        this.attachPartitionCheckFilesMatchFixedColumn(columnType, partitionSize, columnTop, columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                        ** break;
lbl13:
                        // 1 sources

                        continue block9;
                    }
                    case 11: 
                    case 18: {
                        this.attachPartitionCheckFilesMatchVarLenColumn(partitionSize, columnTop, columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                        ** break;
lbl17:
                        // 1 sources

                        continue block9;
                    }
                    case 12: {
                        this.attachPartitionCheckSymbolColumn(partitionSize, columnTop, columnName, columnNameTxn, partitionPath, partitionTimestamp, columnIndex);
                        continue block9;
                    }
                    ** default:
lbl22:
                    // 1 sources

                    continue block9;
                }
            }
            finally {
                partitionPath.trimTo(rootLen);
            }
        }
    }

    private void bumpColumnStructureVersion() {
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.bumpColumnStructureVersion(this.denseSymbolMapWriters);
        assert ((long)this.txWriter.getMetadataVersion() == this.metadata.getMetadataVersion());
    }

    private void bumpMasterRef() {
        if ((this.masterRef & 1L) == 0L) {
            ++this.masterRef;
        } else {
            this.cancelRowAndBump();
        }
    }

    private void bumpMetadataVersion() {
        this.columnVersionWriter.commit();
        this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
        this.txWriter.bumpMetadataVersion(this.denseSymbolMapWriters);
        assert ((long)this.txWriter.getMetadataVersion() == this.metadata.getMetadataVersion());
    }

    private boolean canSquashOverwritePartitionTail(int partitionIndex) {
        long fromTxn = this.txWriter.getPartitionNameTxn(partitionIndex);
        if (fromTxn < 0L) {
            fromTxn = 0L;
        }
        long toTxn = this.txWriter.getTxn();
        if (partitionIndex + 1 < this.txWriter.getPartitionCount() && this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getPartitionTimestampByIndex(partitionIndex)) == this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getPartitionTimestampByIndex(partitionIndex + 1))) {
            toTxn = Math.max(fromTxn + 1L, this.getPartitionNameTxn(partitionIndex + 1) + 1L);
        }
        return this.txnScoreboard.isRangeAvailable(fromTxn, toTxn);
    }

    private void cancelRowAndBump() {
        this.rowCancel();
        ++this.masterRef;
    }

    private void checkColumnName(CharSequence name) {
        if (!TableUtils.isValidColumnName(name, this.configuration.getMaxFileNameLength())) {
            throw CairoException.nonCritical().put("invalid column name [table=").put(this.tableToken.getTableName()).put(", column=").putAsPrintable(name).put(']');
        }
    }

    private void checkDistressed() {
        if (!this.distressed) {
            return;
        }
        throw new CairoError("Table '" + this.tableToken.getTableName() + "' is distressed");
    }

    private void checkO3Errors() {
        if (this.o3ErrorCount.get() > 0) {
            if (this.lastErrno == 0x7FFFFFFE) {
                this.distressed = true;
                throw new CairoError("commit failed with fatal error, see logs for details [table=" + this.tableToken.getTableName() + ", tableDir=" + this.tableToken.getDirName() + "]");
            }
            throw CairoException.critical(this.lastErrno).put("commit failed, see logs for details [table=").put(this.tableToken.getTableName()).put(", tableDir=").put(this.tableToken.getDirName()).put(']');
        }
    }

    private void clearO3() {
        this.o3MasterRef = -1L;
        this.rowAction = 4;
        this.activeColumns = this.columns;
        this.activeNullSetters = this.nullSetters;
    }

    private void clearTodoLog() {
        try {
            this.todoMem.putLong(0L, ++this.todoTxn);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(8L, 0L);
            this.todoMem.putLong(16L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(32L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(24L, this.todoTxn);
            this.todoMem.jumpTo(40L);
            this.todoMem.sync(false);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void closeAppendMemoryTruncate(boolean truncate) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            MemoryMA m = this.columns.getQuick(i);
            if (m == null) continue;
            m.close(truncate);
        }
    }

    private void closeWalColumns() {
        int n = this.walMappedColumns.size();
        for (int col = 0; col < n; ++col) {
            MemoryCMOR mappedColumnMem = this.walMappedColumns.getQuick(col);
            if (mappedColumnMem == null) continue;
            Misc.free(mappedColumnMem);
            this.walColumnMemoryPool.push(mappedColumnMem);
        }
    }

    private long commit(long o3MaxLag) {
        this.checkDistressed();
        this.physicallyWrittenRowsSinceLastCommit.set(0L);
        if (this.o3InError) {
            this.rollback();
            return Long.MIN_VALUE;
        }
        if ((this.masterRef & 1L) != 0L) {
            this.rowCancel();
        }
        if (this.inTransaction()) {
            boolean o3 = this.hasO3();
            if (o3) {
                boolean noop = this.o3Commit(o3MaxLag);
                if (noop) {
                    this.committedMasterRef = this.masterRef;
                    return this.getTxn();
                }
                if (o3MaxLag > 0L && this.reconcileOptimisticPartitions()) {
                    this.lastPartitionTimestamp = this.txWriter.getLastPartitionTimestamp();
                    this.partitionTimestampHi = this.txWriter.getNextPartitionTimestamp(this.txWriter.getMaxTimestamp()) - 1L;
                    this.openLastPartition();
                }
            } else if (this.noOpRowCount > 0L) {
                LOG.critical().$("o3 ignoring write on read-only partition [table=").utf8(this.tableToken.getTableName()).$(", timestamp=").$ts(this.lastOpenPartitionTs).$(", numRows=").$(this.noOpRowCount).$();
            }
            long committedRowCount = this.txWriter.unsafeCommittedFixedRowCount() + this.txWriter.unsafeCommittedTransientRowCount();
            long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
            this.updateIndexes();
            this.syncColumns();
            this.columnVersionWriter.commit();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(this.denseSymbolMapWriters);
            this.squashSplitPartitions(this.minSplitPartitionTimestamp, this.txWriter.getMaxTimestamp(), this.configuration.getO3LastPartitionMaxSplits());
            this.committedMasterRef = this.masterRef;
            this.processPartitionRemoveCandidates();
            this.metrics.tableWriter().incrementCommits();
            this.metrics.tableWriter().addCommittedRows(rowsAdded);
            if (!o3) {
                this.addPhysicallyWrittenRows(rowsAdded);
            }
            this.noOpRowCount = 0L;
            long txn = this.getTxn();
            if (this.commitListener != null) {
                this.commitListener.onCommit(txn, rowsAdded);
            }
            return txn;
        }
        return Long.MIN_VALUE;
    }

    private void configureAppendPosition() {
        boolean partitioned = PartitionBy.isPartitioned(this.partitionBy);
        if (this.txWriter.getMaxTimestamp() > Long.MIN_VALUE || !partitioned) {
            this.initLastPartition(this.txWriter.getMaxTimestamp());
            if (partitioned) {
                this.partitionTimestampHi = this.txWriter.getNextPartitionTimestamp(this.txWriter.getMaxTimestamp()) - 1L;
                this.rowAction = 0;
                this.timestampSetter = this.appendTimestampSetter;
            } else if (this.metadata.getTimestampIndex() < 0) {
                this.rowAction = 2;
            } else {
                this.rowAction = 1;
                this.timestampSetter = this.appendTimestampSetter;
            }
        } else {
            this.rowAction = 0;
            this.timestampSetter = this.appendTimestampSetter;
        }
        this.activeColumns = this.columns;
        this.activeNullSetters = this.nullSetters;
    }

    private void configureColumn(int type, boolean indexFlag, int index) {
        MemoryCARW oooSecondary2;
        MemoryCARW oooSecondary;
        MemoryMA secondary;
        MemoryCARW oooPrimary2;
        MemoryCARW oooPrimary;
        MemoryMA primary;
        if (type > 0) {
            primary = Vm.getMAInstance(this.configuration.getCommitMode());
            oooPrimary = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 3);
            oooPrimary2 = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 3);
            switch (ColumnType.tagOf(type)) {
                case 11: 
                case 18: {
                    secondary = Vm.getMAInstance(this.configuration.getCommitMode());
                    oooSecondary = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 3);
                    oooSecondary2 = Vm.getCARWInstance(this.o3ColumnMemorySize, this.configuration.getO3MemMaxPages(), 3);
                    break;
                }
                default: {
                    secondary = null;
                    oooSecondary = null;
                    oooSecondary2 = null;
                    break;
                }
            }
        } else {
            primary = secondary = NullMemory.INSTANCE;
            oooPrimary2 = oooSecondary2 = NullMemory.INSTANCE;
            oooSecondary = oooSecondary2;
            oooPrimary = oooSecondary2;
        }
        int baseIndex = TableWriter.getPrimaryColumnIndex(index);
        this.columns.extendAndSet(baseIndex, primary);
        this.columns.extendAndSet(baseIndex + 1, secondary);
        this.o3MemColumns.extendAndSet(baseIndex, oooPrimary);
        this.o3MemColumns.extendAndSet(baseIndex + 1, oooSecondary);
        this.o3MemColumns2.extendAndSet(baseIndex, oooPrimary2);
        this.o3MemColumns2.extendAndSet(baseIndex + 1, oooSecondary2);
        TableWriter.configureNullSetters(this.nullSetters, type, primary, secondary);
        TableWriter.configureNullSetters(this.o3NullSetters, type, oooPrimary, oooSecondary);
        TableWriter.configureNullSetters(this.o3NullSetters2, type, oooPrimary2, oooSecondary2);
        if (indexFlag && type > 0) {
            this.indexers.extendAndSet(index, new SymbolColumnIndexer(this.configuration));
        }
        this.rowValueIsNotNull.add(0L);
    }

    private void configureColumnMemory() {
        this.symbolMapWriters.setPos(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            this.configureColumn(type, this.metadata.isColumnIndexed(i), i);
            if (!ColumnType.isSymbol(type)) continue;
            int symbolIndex = this.denseSymbolMapWriters.size();
            long columnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(i);
            SymbolMapWriter symbolMapWriter = new SymbolMapWriter(this.configuration, this.path.trimTo(this.rootLen), this.metadata.getColumnName(i), columnNameTxn, this.txWriter.unsafeReadSymbolTransientCount(symbolIndex), symbolIndex, this.txWriter);
            this.symbolMapWriters.extendAndSet(i, symbolMapWriter);
            this.denseSymbolMapWriters.add(symbolMapWriter);
        }
        int timestampIndex = this.metadata.getTimestampIndex();
        if (timestampIndex != -1) {
            this.o3TimestampMem = this.o3MemColumns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
            this.o3TimestampMemCpy = this.o3MemColumns2.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
        }
    }

    private void configureTimestampSetter() {
        int index = this.metadata.getTimestampIndex();
        if (index == -1) {
            this.timestampSetter = value -> {};
        } else {
            this.nullSetters.setQuick(index, NOOP);
            this.o3NullSetters.setQuick(index, NOOP);
            this.o3NullSetters2.setQuick(index, NOOP);
            this.timestampSetter = this.getPrimaryColumn(index)::putLong;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyMetadataAndSetIndexAttrs(int columnIndex, int indexedFlag, int indexValueBlockSize) {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                if (i != columnIndex) {
                    this.writeColumnEntry(i, false);
                    continue;
                }
                this.ddlMem.putInt(TableUtils.getColumnType(this.metaMem, i));
                long flags = indexedFlag;
                if (TableUtils.isSequential(this.metaMem, i)) {
                    flags |= 2L;
                }
                this.ddlMem.putLong(flags);
                this.ddlMem.putInt(indexValueBlockSize);
                this.ddlMem.skip(16L);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            int n = index;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyMetadataAndUpdateVersion() {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i, false);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            this.metaSwapIndex = index;
            long l = nameOffset;
            return l;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private int copyOverwrite(Path to) {
        int res = this.ff.copy(this.other, to);
        if (Os.isWindows() && res == -1 && this.ff.errno() == 80) {
            if (!this.ff.remove(to)) {
                return -1;
            }
            return this.ff.copy(this.other, to);
        }
        return res;
    }

    private void copyVersionAndLagValues() {
        this.ddlMem.putInt(426);
        this.ddlMem.putInt(this.metaMem.getInt(16L));
        this.ddlMem.putInt(this.metaMem.getInt(20L));
        this.ddlMem.putLong(this.metaMem.getLong(24L));
        this.ddlMem.putLong(this.txWriter.getMetadataVersion() + 1);
        this.ddlMem.putBool(this.metaMem.getBool(40L));
        this.metadata.setMetadataVersion(this.txWriter.getMetadataVersion() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFiles(CharSequence columnName, long columnNameTxn, int indexValueBlockCapacity, int plen, boolean force) {
        try {
            BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn);
            if (!force && this.ff.exists(this.path)) {
                return;
            }
            try {
                this.ddlMem.smallFile(this.ff, this.path, 5);
                this.ddlMem.truncate();
                BitmapIndexWriter.initKeyMemory(this.ddlMem, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                LOG.error().$("could not create index [name=").utf8(this.path).$(", errno=").$(e.getErrno()).I$();
                if (!this.ff.remove(this.path)) {
                    LOG.critical().$("could not remove '").utf8(this.path).$("'. Please remove MANUALLY.").$("[errno=").$(this.ff.errno()).I$();
                }
                throw e;
            }
            finally {
                this.ddlMem.close();
            }
            if (!this.ff.touch(BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$("could not create index [name=").$(this.path).$(", errno=").$(this.ff.errno()).I$();
                throw CairoException.critical(this.ff.errno()).put("could not create index [name=").put(this.path).put(']');
            }
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void createSymbolMapWriter(CharSequence name, long columnNameTxn, int symbolCapacity, boolean symbolCacheFlag) {
        MapWriter.createSymbolMapFiles(this.ff, this.ddlMem, this.path, name, columnNameTxn, symbolCapacity, symbolCacheFlag);
        SymbolMapWriter w = new SymbolMapWriter(this.configuration, this.path, name, columnNameTxn, 0, this.denseSymbolMapWriters.size(), this.txWriter);
        this.denseSymbolMapWriters.add(w);
        this.symbolMapWriters.extendAndSet(this.columnCount, w);
    }

    private boolean createWalSymbolMapping(SymbolMapDiff symbolMapDiff, int columnIndex, IntList symbolMap) {
        SymbolMapDiffEntry entry;
        int cleanSymbolCount = symbolMapDiff.getCleanSymbolCount();
        symbolMap.setPos(symbolMapDiff.getSize());
        symbolMap.setAll(symbolMapDiff.getSize(), -1);
        MapWriter mapWriter = this.symbolMapWriters.get(columnIndex);
        boolean identical = true;
        if (symbolMapDiff.hasNullValue()) {
            mapWriter.updateNullFlag(true);
        }
        while ((entry = symbolMapDiff.nextEntry()) != null) {
            CharSequence symbolValue = entry.getSymbol();
            int newKey = mapWriter.put(symbolValue);
            identical &= newKey == entry.getKey();
            symbolMap.setQuick(entry.getKey() - cleanSymbolCount, newKey);
        }
        return identical;
    }

    private void dispatchO3CallbackQueue(RingQueue<O3CallbackTask> queue, int queuedCount) {
        MCSequence subSeq = this.messageBus.getO3CallbackSubSeq();
        TableWriter.dispatchO3CallbackQueue0(queue, queuedCount, subSeq, this.o3DoneLatch);
        this.checkO3Errors();
    }

    private void doClose(boolean truncate) {
        boolean tx = this.inTransaction();
        this.freeSymbolMapWriters();
        this.freeIndexers();
        Misc.free(this.txWriter);
        Misc.free(this.metaMem);
        Misc.free(this.ddlMem);
        Misc.free(this.indexMem);
        Misc.free(this.other);
        Misc.free(this.todoMem);
        Misc.free(this.attachMetaMem);
        Misc.free(this.attachColumnVersionReader);
        Misc.free(this.attachIndexBuilder);
        Misc.free(this.columnVersionWriter);
        Misc.free(this.o3PartitionUpdateSink);
        Misc.free(this.slaveTxReader);
        Misc.free(this.commandQueue);
        this.updateOperatorImpl = Misc.free(this.updateOperatorImpl);
        this.dropIndexOperator = null;
        this.noOpRowCount = 0L;
        this.lastOpenPartitionTs = Long.MIN_VALUE;
        this.lastOpenPartitionIsReadOnly = false;
        Misc.free(this.partitionFrameFactory);
        assert (!truncate || this.distressed || this.assertColumnPositionIncludeWalLag());
        this.freeColumns(truncate & !this.distressed);
        this.commitListener = Misc.free(this.commitListener);
        try {
            this.releaseLock(!truncate | tx | this.performRecovery | this.distressed);
        }
        finally {
            Misc.free(this.txnScoreboard);
            Misc.free(this.path);
            Misc.free(this.o3TimestampMem);
            Misc.free(this.o3TimestampMemCpy);
            Misc.free(this.ownMessageBus);
            if (this.tempMem16b != 0L) {
                Unsafe.free(this.tempMem16b, 16L, 26);
                this.tempMem16b = 0L;
            }
            LOG.info().$("closed '").utf8(this.tableToken.getTableName()).$('\'').$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropPartitionByExactTimestamp(long timestamp) {
        long minTimestamp = this.txWriter.getMinTimestamp();
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        int index = this.txWriter.getPartitionIndex(timestamp = this.txWriter.getPartitionTimestampByTimestamp(timestamp));
        if (index < 0) {
            LOG.error().$("partition is already removed [path=").utf8(this.path).$(", partitionTimestamp=").$ts(timestamp).I$();
            return false;
        }
        long partitionNameTxn = this.txWriter.getPartitionNameTxnByPartitionTimestamp(timestamp);
        if (timestamp == this.txWriter.getPartitionTimestampByTimestamp(maxTimestamp)) {
            long prevTimestamp;
            long newTransientRowCount;
            long nextMaxTimestamp;
            if (index == 0) {
                nextMaxTimestamp = Long.MIN_VALUE;
                newTransientRowCount = 0L;
                prevTimestamp = 0L;
            } else {
                int prevIndex = index - 1;
                prevTimestamp = this.txWriter.getPartitionTimestampByIndex(prevIndex);
                newTransientRowCount = this.txWriter.getPartitionSize(prevIndex);
                try {
                    TableUtils.setPathForPartition(this.path.trimTo(this.rootLen), this.partitionBy, prevTimestamp, this.txWriter.getPartitionNameTxn(prevIndex));
                    this.readPartitionMinMax(this.ff, prevTimestamp, this.path, this.metadata.getColumnName(this.metadata.getTimestampIndex()), newTransientRowCount);
                    nextMaxTimestamp = this.attachMaxTimestamp;
                }
                finally {
                    this.path.trimTo(this.rootLen);
                }
            }
            this.columnVersionWriter.removePartition(timestamp);
            this.txWriter.beginPartitionSizeUpdate();
            this.txWriter.removeAttachedPartitions(timestamp);
            this.txWriter.finishPartitionSizeUpdate(index == 0 ? Long.MAX_VALUE : this.txWriter.getMinTimestamp(), nextMaxTimestamp);
            this.txWriter.bumpTruncateVersion();
            this.columnVersionWriter.commit();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(this.denseSymbolMapWriters);
            this.closeActivePartition(false);
            if (index != 0) {
                this.openPartition(prevTimestamp);
                this.setAppendPosition(newTransientRowCount, false);
            } else {
                this.rowAction = 0;
            }
        } else {
            long nextMinTimestamp = minTimestamp;
            if (timestamp == this.txWriter.getPartitionTimestampByIndex(0)) {
                nextMinTimestamp = this.readMinTimestamp(this.txWriter.getPartitionTimestampByIndex(1));
            }
            this.columnVersionWriter.removePartition(timestamp);
            this.txWriter.beginPartitionSizeUpdate();
            this.txWriter.removeAttachedPartitions(timestamp);
            this.txWriter.setMinTimestamp(nextMinTimestamp);
            this.txWriter.finishPartitionSizeUpdate(nextMinTimestamp, this.txWriter.getMaxTimestamp());
            this.txWriter.bumpTruncateVersion();
            this.columnVersionWriter.commit();
            this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
            this.txWriter.commit(this.denseSymbolMapWriters);
        }
        this.safeDeletePartitionDir(timestamp, partitionNameTxn);
        return true;
    }

    private long findMinSplitPartitionTimestamp() {
        int n = this.txWriter.getPartitionCount();
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
            if (this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp) == partitionTimestamp) continue;
            return partitionTimestamp;
        }
        return Long.MAX_VALUE;
    }

    private void finishColumnPurge() {
        if (this.purgingOperator == null) {
            return;
        }
        boolean asyncOnly = this.checkScoreboardHasReadersBeforeLastCommittedTxn();
        this.purgingOperator.purge(this.path.trimTo(this.rootLen), this.tableToken, this.partitionBy, asyncOnly, this.metadata, this.getTruncateVersion(), this.getTxn());
        this.purgingOperator.clear();
    }

    private void finishMetaSwapUpdate() {
        this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        this.writeRestoreMetaTodo();
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException e) {
            try {
                this.recoverFromTodoWriteFailure(null);
            }
            catch (CairoException e2) {
                this.throwDistressException(e2);
            }
            throw e;
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpMetadataVersion();
        this.metadata.setTableVersion();
    }

    private void finishO3Append(long o3LagRowCount) {
        if (this.denseIndexers.size() == 0) {
            this.populateDenseIndexerList();
        }
        this.path.trimTo(this.rootLen);
        boolean bl = this.avoidIndexOnCommit = this.o3ErrorCount.get() == 0;
        if (o3LagRowCount == 0L) {
            this.clearO3();
            LOG.debug().$("lag segment is empty").$();
        } else {
            this.o3MasterRef = this.masterRef - o3LagRowCount * 2L + 1L;
            LOG.debug().$("adjusted [o3RowCount=").$(this.getO3RowCount0()).I$();
        }
    }

    private void finishO3Commit(long partitionTimestampHiLimit) {
        if (!this.o3InError) {
            this.updateO3ColumnTops();
        }
        if (this.isLastPartitionClosed() || this.partitionTimestampHi > partitionTimestampHiLimit) {
            this.openPartition(this.txWriter.getLastPartitionTimestamp());
        }
        try {
            this.setAppendPosition(this.txWriter.getTransientRowCount(), true);
        }
        catch (Throwable e) {
            LOG.critical().$("data is committed but writer failed to update its state `").$(e).$('`').$();
            this.distressed = true;
            throw e;
        }
        this.metrics.tableWriter().incrementO3Commits();
    }

    private CharSequence formatPartitionForTimestamp(long partitionTimestamp, long nameTxn) {
        this.fileNameSink.clear();
        TableUtils.setSinkForPartition(this.fileNameSink, this.partitionBy, partitionTimestamp, nameTxn);
        return this.fileNameSink;
    }

    private void freeAndRemoveColumnPair(ObjList<MemoryMA> columns, int pi, int si) {
        Misc.free(columns.getAndSetQuick(pi, NullMemory.INSTANCE));
        Misc.free(columns.getAndSetQuick(si, NullMemory.INSTANCE));
    }

    private void freeAndRemoveO3ColumnPair(ObjList<MemoryCARW> columns, int pi, int si) {
        Misc.free(columns.getAndSetQuick(pi, NullMemory.INSTANCE));
        Misc.free(columns.getAndSetQuick(si, NullMemory.INSTANCE));
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            this.closeAppendMemoryTruncate(truncate);
        }
        Misc.freeObjListAndKeepObjects(this.o3MemColumns);
        Misc.freeObjListAndKeepObjects(this.o3MemColumns2);
    }

    private void freeIndexers() {
        if (this.indexers != null) {
            int n = this.indexers.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.indexers.getQuick(i));
            }
            this.denseIndexers.clear();
        }
    }

    private void freeNullSetter(ObjList<Runnable> nullSetters, int columnIndex) {
        nullSetters.setQuick(columnIndex, NOOP);
    }

    private void freeSymbolMapWriters() {
        if (this.denseSymbolMapWriters != null) {
            int n = this.denseSymbolMapWriters.size();
            for (int i = 0; i < n; ++i) {
                Misc.freeIfCloseable(this.denseSymbolMapWriters.getQuick(i));
            }
            this.denseSymbolMapWriters.clear();
        }
        if (this.symbolMapWriters != null) {
            this.symbolMapWriters.clear();
        }
    }

    private long getMaxWalSquashRows() {
        return Math.max(0L, (long)this.configuration.getWalSquashUncommittedRowsMultiplier() * (long)this.metadata.getMaxUncommittedRows());
    }

    private long getO3RowCount0() {
        return (this.masterRef - this.o3MasterRef + 1L) / 2L;
    }

    private long getPartitionTimestampOrMax(int partitionIndex) {
        if (partitionIndex < this.txWriter.getPartitionCount()) {
            return this.txWriter.getPartitionTimestampByIndex(partitionIndex);
        }
        return Long.MAX_VALUE;
    }

    private MemoryMA getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getPrimaryColumnIndex(column));
    }

    private PurgingOperator getPurgingOperator() {
        if (this.purgingOperator == null) {
            this.purgingOperator = new PurgingOperator(LOG, this.configuration, this.messageBus);
        } else {
            this.purgingOperator.clear();
        }
        return this.purgingOperator;
    }

    private MemoryMA getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getSecondaryColumnIndex(column));
    }

    private void handleWorkStealingException(String message, int columnIndex, int columnType, long indexAddr, long row1Count, long row2Lo, long row2Hi, Throwable e) {
        this.o3ErrorCount.incrementAndGet();
        LogRecord logRecord = LOG.critical().$(message + " [table=").$(this.tableToken.getTableName()).$(", column=").$(columnIndex).$(", type=").$(columnType).$(", indexAddr=").$(indexAddr).$(", row1Count=").$(row1Count).$(", row2Lo=").$(row2Lo).$(", row2Hi=").$(row2Hi);
        if (e instanceof CairoException) {
            this.lastErrno = this.lastErrno == 0 ? ((CairoException)e).errno : this.lastErrno;
            logRecord.$(", errno=").$(this.lastErrno).$(", ex=").$(((CairoException)e).getFlyweightMessage()).I$();
        } else {
            this.lastErrno = 0x7FFFFFFE;
            logRecord.$(", ex=").$(e).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardLinkAndPurgeColumnFiles(CharSequence columnName, int columnIndex, CharSequence newName, int columnType) {
        try {
            PurgingOperator purgingOperator = this.getPurgingOperator();
            long newColumnNameTxn = this.getTxn();
            long defaultColumnNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                int i = this.txWriter.getPartitionCount() - 1;
                while ((long)i > -1L) {
                    long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
                    long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
                    this.hardLinkAndPurgeColumnFiles(columnName, columnIndex, columnType, newName, partitionTimestamp, partitionNameTxn, newColumnNameTxn, columnNameTxn);
                    if ((long)this.columnVersionWriter.getRecordIndex(partitionTimestamp, columnIndex) > -1L) {
                        long columnTop = this.columnVersionWriter.getColumnTop(partitionTimestamp, columnIndex);
                        this.columnVersionWriter.upsert(partitionTimestamp, columnIndex, newColumnNameTxn, columnTop);
                    }
                    --i;
                }
            } else {
                long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(this.txWriter.getLastPartitionTimestamp(), columnIndex);
                this.hardLinkAndPurgeColumnFiles(columnName, columnIndex, columnType, newName, this.txWriter.getLastPartitionTimestamp(), -1L, newColumnNameTxn, columnNameTxn);
                long columnTop = this.columnVersionWriter.getColumnTop(this.txWriter.getLastPartitionTimestamp(), columnIndex);
                this.columnVersionWriter.upsert(this.txWriter.getLastPartitionTimestamp(), columnIndex, newColumnNameTxn, columnTop);
            }
            if (ColumnType.isSymbol(columnType)) {
                TableWriter.linkFile(this.ff, TableUtils.offsetFileName(this.path.trimTo(this.rootLen), columnName, defaultColumnNameTxn), TableUtils.offsetFileName(this.other.trimTo(this.rootLen), newName, newColumnNameTxn));
                TableWriter.linkFile(this.ff, TableUtils.charFileName(this.path.trimTo(this.rootLen), columnName, defaultColumnNameTxn), TableUtils.charFileName(this.other.trimTo(this.rootLen), newName, newColumnNameTxn));
                TableWriter.linkFile(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), columnName, defaultColumnNameTxn), BitmapIndexUtils.keyFileName(this.other.trimTo(this.rootLen), newName, newColumnNameTxn));
                TableWriter.linkFile(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), columnName, defaultColumnNameTxn), BitmapIndexUtils.valueFileName(this.other.trimTo(this.rootLen), newName, newColumnNameTxn));
                purgingOperator.add(columnIndex, defaultColumnNameTxn, -9223372036854775807L, -1L);
            }
            long columnAddedPartition = this.columnVersionWriter.getColumnTopPartitionTimestamp(columnIndex);
            this.columnVersionWriter.upsertDefaultTxnName(columnIndex, newColumnNameTxn, columnAddedPartition);
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void hardLinkAndPurgeColumnFiles(CharSequence columnName, int columnIndex, int columnType, CharSequence newName, long partitionTimestamp, long partitionNameTxn, long newColumnNameTxn, long columnNameTxn) {
        TableUtils.setPathForPartition(this.path, this.partitionBy, partitionTimestamp, partitionNameTxn);
        TableUtils.setPathForPartition(this.other, this.partitionBy, partitionTimestamp, partitionNameTxn);
        int plen = this.path.length();
        TableWriter.linkFile(this.ff, TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn), TableUtils.dFile(this.other.trimTo(plen), newName, newColumnNameTxn));
        if (ColumnType.isVariableLength(columnType)) {
            TableWriter.linkFile(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName, columnNameTxn), TableUtils.iFile(this.other.trimTo(plen), newName, newColumnNameTxn));
        } else if (ColumnType.isSymbol(columnType) && this.metadata.isColumnIndexed(columnIndex)) {
            TableWriter.linkFile(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn), BitmapIndexUtils.keyFileName(this.other.trimTo(plen), newName, newColumnNameTxn));
            TableWriter.linkFile(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn), BitmapIndexUtils.valueFileName(this.other.trimTo(plen), newName, newColumnNameTxn));
        }
        this.path.trimTo(this.rootLen);
        this.other.trimTo(this.rootLen);
        this.purgingOperator.add(columnIndex, columnNameTxn, partitionTimestamp, partitionNameTxn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexHistoricPartitions(SymbolColumnIndexer indexer, CharSequence columnName, int indexValueBlockSize) {
        long ts = this.txWriter.getMaxTimestamp();
        if (ts > Long.MIN_VALUE) {
            int columnIndex = this.metadata.getColumnIndex(columnName);
            try (MemoryMR roMem = this.indexMem;){
                int n = this.txWriter.getPartitionCount() - 1;
                for (int i = 0; i < n; ++i) {
                    long timestamp = this.txWriter.getPartitionTimestampByIndex(i);
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, timestamp);
                    if (!this.ff.exists(this.path.$())) continue;
                    int plen = this.path.length();
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(timestamp, columnIndex);
                    TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn);
                    if (!this.ff.exists(this.path)) continue;
                    this.path.trimTo(plen);
                    LOG.info().$("indexing [path=").$(this.path).I$();
                    this.createIndexFiles(columnName, columnNameTxn, indexValueBlockSize, plen, true);
                    long partitionSize = this.txWriter.getPartitionSizeByPartitionTimestamp(timestamp);
                    long columnTop = this.columnVersionWriter.getColumnTop(timestamp, columnIndex);
                    if (columnTop <= -1L || partitionSize <= columnTop) continue;
                    TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn);
                    long columnSize = partitionSize - columnTop << ColumnType.pow2SizeOf(5);
                    roMem.of(this.ff, this.path, columnSize, columnSize, 5);
                    indexer.configureWriter(this.path.trimTo(plen), columnName, columnNameTxn, columnTop);
                    indexer.index(roMem, columnTop, partitionSize);
                }
            }
            finally {
                Misc.free(indexer);
            }
        }
    }

    private void indexLastPartition(SymbolColumnIndexer indexer, CharSequence columnName, long columnNameTxn, int columnIndex, int indexValueBlockSize) {
        int plen = this.path.length();
        this.createIndexFiles(columnName, columnNameTxn, indexValueBlockSize, plen, true);
        long lastPartitionTs = this.txWriter.getLastPartitionTimestamp();
        long columnTop = this.columnVersionWriter.getColumnTopQuick(lastPartitionTs, columnIndex);
        indexer.configureFollowerAndWriter(this.path.trimTo(plen), columnName, columnNameTxn, this.getPrimaryColumn(columnIndex), columnTop);
        indexer.refreshSourceAndIndex(0L, this.txWriter.getTransientRowCount());
    }

    private void initLastPartition(long timestamp) {
        long ts = this.repairDataGaps(timestamp);
        this.openLastPartitionAndSetAppendPosition(ts);
        this.populateDenseIndexerList();
        if (this.performRecovery) {
            this.performRecovery();
        }
        this.txWriter.initLastPartition(ts);
    }

    private boolean isLastPartitionClosed() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) <= 0) continue;
            return !this.columns.getQuick(TableWriter.getPrimaryColumnIndex(i)).isOpen();
        }
        return false;
    }

    private void lock() {
        try {
            this.path.trimTo(this.rootLen);
            TableUtils.lockName(this.path);
            this.performRecovery = this.ff.exists(this.path);
            this.lockFd = TableUtils.lock(this.ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.lockFd == -1) {
            throw CairoException.critical(this.ff.errno()).put("Cannot lock table: ").put(this.path.$());
        }
    }

    private long mapAppendColumnBuffer(MemoryMA column, long offset, long size, boolean rw) {
        if (size == 0L) {
            return 0L;
        }
        column.jumpTo(offset + size);
        long address = column.map(offset, size);
        if (address != 0L) {
            return address;
        }
        return -TableUtils.mapAppendColumnBuffer(this.ff, column.getFd(), offset, size, rw, 5);
    }

    private void mapAppendColumnBufferRelease(long address, long offset, long size) {
        if (address < 0L) {
            TableUtils.mapAppendColumnBufferRelease(this.ff, -address, offset, size, 5);
        }
    }

    private void mmapWalColumns(Path walPath, int timestampIndex, long rowLo, long rowHi) {
        this.walMappedColumns.clear();
        int walPathLen = walPath.length();
        int columnCount = this.metadata.getColumnCount();
        try {
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                int type = this.metadata.getColumnType(columnIndex);
                this.o3RowCount = rowHi - rowLo;
                if (type > 0) {
                    int sizeBitsPow2 = ColumnType.pow2SizeOf(type);
                    if (columnIndex == timestampIndex) {
                        ++sizeBitsPow2;
                    }
                    if (!ColumnType.isVariableLength(type)) {
                        MemoryCMOR primary = (MemoryCMOR)this.walColumnMemoryPool.pop();
                        TableUtils.dFile(walPath, this.metadata.getColumnName(columnIndex), -1L);
                        primary.ofOffset(this.configuration.getFilesFacade(), walPath, rowLo << sizeBitsPow2, rowHi << sizeBitsPow2, 5, 0L);
                        walPath.trimTo(walPathLen);
                        this.walMappedColumns.add(primary);
                        this.walMappedColumns.add(null);
                        continue;
                    }
                    sizeBitsPow2 = 3;
                    MemoryCMOR fixed = (MemoryCMOR)this.walColumnMemoryPool.pop();
                    MemoryCMOR var = (MemoryCMOR)this.walColumnMemoryPool.pop();
                    TableUtils.iFile(walPath, this.metadata.getColumnName(columnIndex), -1L);
                    fixed.ofOffset(this.configuration.getFilesFacade(), walPath, rowLo << sizeBitsPow2, rowHi + 1L << sizeBitsPow2, 5, 0L);
                    walPath.trimTo(walPathLen);
                    long varOffset = fixed.getLong(rowLo << sizeBitsPow2);
                    long varLen = fixed.getLong(rowHi << sizeBitsPow2) - varOffset;
                    TableUtils.dFile(walPath, this.metadata.getColumnName(columnIndex), -1L);
                    var.ofOffset(this.configuration.getFilesFacade(), walPath, varOffset, varOffset + varLen, 5, 0L);
                    walPath.trimTo(walPathLen);
                    this.walMappedColumns.add(var);
                    this.walMappedColumns.add(fixed);
                    continue;
                }
                this.walMappedColumns.add(null);
                this.walMappedColumns.add(null);
            }
            this.o3Columns = this.walMappedColumns;
        }
        catch (Throwable th) {
            this.closeWalColumns();
            throw th;
        }
    }

    private Row newRowO3(long timestamp) {
        LOG.info().$("switched to o3 [table=").utf8(this.tableToken.getTableName()).I$();
        this.txWriter.beginPartitionSizeUpdate();
        this.o3OpenColumns();
        this.o3InError = false;
        this.o3MasterRef = this.masterRef;
        this.rowAction = 3;
        this.o3TimestampSetter(timestamp);
        return this.row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean o3Commit(long o3MaxLag) {
        this.o3RowCount = this.getO3RowCount0();
        long o3LagRowCount = 0L;
        long maxUncommittedRows = this.metadata.getMaxUncommittedRows();
        int timestampIndex = this.metadata.getTimestampIndex();
        this.lastPartitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(this.partitionTimestampHi);
        long partitionTimestampHiLimit = this.txWriter.getNextPartitionTimestamp(this.partitionTimestampHi) - 1L;
        try {
            long srcOooMax;
            this.o3RowCount += this.o3MoveUncommitted(timestampIndex);
            LOG.debug().$("sorting o3 [table=").utf8(this.tableToken.getTableName()).I$();
            long sortedTimestampsAddr = this.o3TimestampMem.getAddress();
            assert (this.o3TimestampMem.getAppendOffset() == this.o3RowCount * 16L);
            if (this.o3RowCount > 600L || !this.o3QuickSortEnabled) {
                this.o3TimestampMemCpy.jumpTo(this.o3TimestampMem.getAppendOffset());
                Vect.radixSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount, this.o3TimestampMemCpy.addressOf(0L));
            } else {
                Vect.quickSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount);
            }
            long o3TimestampMin = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, 0L);
            if (o3TimestampMin < 0L) {
                this.o3InError = true;
                throw CairoException.nonCritical().put("timestamps before 1970-01-01 are not allowed for O3");
            }
            long o3TimestampMax = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, this.o3RowCount - 1L);
            if (o3TimestampMax < 0L) {
                this.o3InError = true;
                throw CairoException.nonCritical().put("timestamps before 1970-01-01 are not allowed for O3");
            }
            assert (o3TimestampMin <= o3TimestampMax);
            if (o3MaxLag > 0L) {
                long lagError = 0L;
                if (this.getMaxTimestamp() != Long.MIN_VALUE) {
                    lagError = this.getMaxTimestamp() - this.o3CommitBatchTimestampMin;
                    int n = this.o3LastTimestampSpreads.length - 1;
                    if (lagError > 0L) {
                        this.o3EffectiveLag = (long)((double)this.o3EffectiveLag + (double)lagError * this.configuration.getO3LagIncreaseFactor());
                        this.o3EffectiveLag = Math.min(this.o3EffectiveLag, o3MaxLag);
                    } else {
                        this.o3EffectiveLag = (long)((double)this.o3EffectiveLag + (double)lagError * this.configuration.getO3LagDecreaseFactor());
                        this.o3EffectiveLag = Math.max(0L, this.o3EffectiveLag);
                    }
                    long max = Long.MIN_VALUE;
                    for (int i = 0; i < n; ++i) {
                        long e;
                        this.o3LastTimestampSpreads[i] = e = this.o3LastTimestampSpreads[i + 1];
                        max = Math.max(e, max);
                    }
                    this.o3LastTimestampSpreads[n] = this.o3EffectiveLag;
                    this.o3EffectiveLag = Math.max(this.o3EffectiveLag, max);
                } else {
                    this.o3EffectiveLag = o3MaxLag;
                }
                long lagThresholdTimestamp = o3TimestampMax - this.o3EffectiveLag;
                if (lagThresholdTimestamp >= o3TimestampMin) {
                    long lagThresholdRow = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, lagThresholdTimestamp, 0L, this.o3RowCount - 1L, 1);
                    o3LagRowCount = this.o3RowCount - lagThresholdRow - 1L;
                    if (o3LagRowCount > maxUncommittedRows) {
                        o3LagRowCount = maxUncommittedRows;
                        srcOooMax = this.o3RowCount - maxUncommittedRows;
                    } else {
                        srcOooMax = lagThresholdRow + 1L;
                    }
                } else {
                    o3LagRowCount = this.o3RowCount;
                    if (o3LagRowCount > maxUncommittedRows) {
                        o3LagRowCount = maxUncommittedRows / 2L;
                        srcOooMax = this.o3RowCount - o3LagRowCount;
                    } else {
                        srcOooMax = 0L;
                    }
                }
                LOG.info().$("o3 commit [table=").utf8(this.tableToken.getTableName()).$(", maxUncommittedRows=").$(maxUncommittedRows).$(", o3TimestampMin=").$ts(o3TimestampMin).$(", o3TimestampMax=").$ts(o3TimestampMax).$(", o3MaxLagUs=").$(o3MaxLag).$(", o3EffectiveLagUs=").$(this.o3EffectiveLag).$(", lagError=").$(lagError).$(", o3SpreadUs=").$(o3TimestampMax - o3TimestampMin).$(", lagThresholdTimestamp=").$ts(lagThresholdTimestamp).$(", o3LagRowCount=").$(o3LagRowCount).$(", srcOooMax=").$(srcOooMax).$(", o3RowCount=").$(this.o3RowCount).I$();
            } else {
                LOG.info().$("o3 commit [table=").utf8(this.tableToken.getTableName()).$(", o3RowCount=").$(this.o3RowCount).I$();
                srcOooMax = this.o3RowCount;
            }
            this.o3CommitBatchTimestampMin = Long.MAX_VALUE;
            if (srcOooMax == 0L) {
                boolean bl = true;
                return bl;
            }
            o3TimestampMax = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooMax - 1L);
            this.o3Sort(sortedTimestampsAddr, timestampIndex, this.o3RowCount);
            LOG.info().$("sorted [table=").utf8(this.tableToken.getTableName()).$(", o3RowCount=").$(this.o3RowCount).I$();
            this.processO3Block(o3LagRowCount, timestampIndex, sortedTimestampsAddr, srcOooMax, o3TimestampMin, o3TimestampMax, true, 0L);
        }
        finally {
            this.finishO3Append(o3LagRowCount);
        }
        this.finishO3Commit(partitionTimestampHiLimit);
        return false;
    }

    private void o3CommitPartitionAsync(AtomicInteger columnCounter, long maxTimestamp, long sortedTimestampsAddr, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long srcOooLo, long srcOooHi, long partitionTimestamp, boolean last, long srcDataMax, long srcNameTxn, O3Basket o3Basket, long partitionUpdateSinkAddr) {
        long cursor = this.messageBus.getO3PartitionPubSeq().next();
        if (cursor > -1L) {
            O3PartitionTask task = this.messageBus.getO3PartitionQueue().get(cursor);
            task.of(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataMax, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket, partitionUpdateSinkAddr);
            this.messageBus.getO3PartitionPubSeq().done(cursor);
        } else {
            O3PartitionJob.processPartition(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataMax, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket, partitionUpdateSinkAddr);
        }
    }

    private void o3ConsumePartitionUpdateSink() {
        long blockIndex = -1L;
        while ((blockIndex = this.o3PartitionUpdateSink.nextBlockIndex(blockIndex)) > -1L) {
            long blockAddress = this.o3PartitionUpdateSink.getBlockAddress(blockIndex);
            long partitionTimestamp = Unsafe.getUnsafe().getLong(blockAddress);
            long timestampMin = Unsafe.getUnsafe().getLong(blockAddress + 8L);
            if (partitionTimestamp == -1L || timestampMin == -1L) continue;
            long newPartitionSize = Unsafe.getUnsafe().getLong(blockAddress + 16L);
            long oldPartitionSize = Unsafe.getUnsafe().getLong(blockAddress + 24L);
            long flags = Unsafe.getUnsafe().getLong(blockAddress + 32L);
            boolean partitionMutates = Numbers.decodeLowInt(flags) != 0;
            boolean isLastWrittenPartition = Numbers.decodeHighInt(flags) != 0;
            this.o3PartitionUpdate(timestampMin, partitionTimestamp, newPartitionSize, oldPartitionSize, partitionMutates, isLastWrittenPartition);
        }
    }

    private void o3ConsumePartitionUpdates() {
        MCSequence partitionSubSeq = this.messageBus.getO3PartitionSubSeq();
        RingQueue<O3PartitionTask> partitionQueue = this.messageBus.getO3PartitionQueue();
        MCSequence openColumnSubSeq = this.messageBus.getO3OpenColumnSubSeq();
        RingQueue<O3OpenColumnTask> openColumnQueue = this.messageBus.getO3OpenColumnQueue();
        MCSequence copySubSeq = this.messageBus.getO3CopySubSeq();
        RingQueue<O3CopyTask> copyQueue = this.messageBus.getO3CopyQueue();
        do {
            long cursor;
            if ((cursor = partitionSubSeq.next()) > -1L) {
                O3PartitionTask partitionTask = partitionQueue.get(cursor);
                if (partitionTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    partitionSubSeq.done(cursor);
                    this.o3ClockDownPartitionUpdateCount();
                    this.o3CountDownDoneLatch();
                    continue;
                }
                this.o3ProcessPartitionSafe(partitionSubSeq, cursor, partitionTask);
                continue;
            }
            cursor = openColumnSubSeq.next();
            if (cursor > -1L) {
                O3OpenColumnTask openColumnTask = openColumnQueue.get(cursor);
                if (openColumnTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    O3CopyJob.closeColumnIdle(openColumnTask.getColumnCounter(), openColumnTask.getTimestampMergeIndexAddr(), openColumnTask.getTimestampMergeIndexSize(), openColumnTask.getSrcTimestampFd(), openColumnTask.getSrcTimestampAddr(), openColumnTask.getSrcTimestampSize(), this);
                    openColumnSubSeq.done(cursor);
                    continue;
                }
                this.o3OpenColumnSafe(openColumnSubSeq, cursor, openColumnTask);
                continue;
            }
            cursor = copySubSeq.next();
            if (cursor <= -1L) continue;
            O3CopyTask copyTask = copyQueue.get(cursor);
            if (copyTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                O3CopyJob.copyIdle(copyTask.getColumnCounter(), copyTask.getPartCounter(), copyTask.getTimestampMergeIndexAddr(), copyTask.getTimestampMergeIndexSize(), copyTask.getSrcDataFixFd(), copyTask.getSrcDataFixAddr(), copyTask.getSrcDataFixSize(), copyTask.getSrcDataVarFd(), copyTask.getSrcDataVarAddr(), copyTask.getSrcDataVarSize(), copyTask.getDstFixFd(), copyTask.getDstFixAddr(), copyTask.getDstFixSize(), copyTask.getDstVarFd(), copyTask.getDstVarAddr(), copyTask.getDstVarSize(), copyTask.getSrcTimestampFd(), copyTask.getSrcTimestampAddr(), copyTask.getSrcTimestampSize(), copyTask.getDstKFd(), copyTask.getDstVFd(), this);
                copySubSeq.done(cursor);
                continue;
            }
            this.o3CopySafe(cursor);
        } while (this.o3PartitionUpdRemaining.get() > 0L);
        if (this.o3ErrorCount.get() == 0) {
            this.o3ConsumePartitionUpdateSink();
        }
    }

    private void o3CopySafe(long cursor) {
        O3CopyTask task = this.messageBus.getO3CopyQueue().get(cursor);
        try {
            O3CopyJob.copy(task, cursor, this.messageBus.getO3CopySubSeq());
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void o3MergeFixColumnLag(int columnIndex, int columnType, long mergeIndex, long lagRows, long mappedRowLo, long mappedRowHi) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            long rowCount = lagRows + mappedRowHi - mappedRowLo;
            int primaryColumnIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
            MemoryMA lagMem = this.columns.getQuick(primaryColumnIndex);
            MemoryCR mappedMem = this.o3Columns.getQuick(primaryColumnIndex);
            if (ColumnType.isSymbol(columnType) && mappedMem instanceof MemoryCARW) {
                mappedRowLo = 0L;
            }
            MemoryCARW destMem = this.o3MemColumns2.getQuick(primaryColumnIndex);
            int shl = ColumnType.pow2SizeOf(columnType);
            destMem.jumpTo(rowCount << shl);
            long src1 = mappedMem.addressOf(mappedRowLo << shl);
            long lagMemOffset = this.txWriter.getTransientRowCount() - this.getColumnTop(columnIndex) << shl;
            long lagAddr = this.mapAppendColumnBuffer(lagMem, lagMemOffset, lagRows << shl, false);
            try {
                long src2 = Math.abs(lagAddr);
                long dest = destMem.addressOf(0L);
                if (src2 == 0L && lagRows != 0L) {
                    throw CairoException.critical(0).put("cannot sort WAL data, lag rows are missing [table").put(this.tableToken.getTableName()).put(", columnName=").put(this.metadata.getColumnName(columnIndex)).put(", type=").put(ColumnType.nameOf(columnType)).put(", lagRows=").put(lagRows).put(']');
                }
                if (src1 == 0L) {
                    throw CairoException.critical(0).put("cannot sort WAL data, rows are missing [table").put(this.tableToken.getTableName()).put(", columnName=").put(this.metadata.getColumnName(columnIndex)).put(", type=").put(ColumnType.nameOf(columnType)).put(']');
                }
                if (dest == 0L) {
                    throw CairoException.critical(0).put("cannot sort WAL data, destination buffer is empty [table").put(this.tableToken.getTableName()).put(", columnName=").put(this.metadata.getColumnName(columnIndex)).put(", type=").put(ColumnType.nameOf(columnType)).put(']');
                }
                switch (shl) {
                    case 0: {
                        Vect.mergeShuffle8Bit(src1, src2, dest, mergeIndex, rowCount);
                        return;
                    }
                    case 1: {
                        Vect.mergeShuffle16Bit(src1, src2, dest, mergeIndex, rowCount);
                        return;
                    }
                    case 2: {
                        Vect.mergeShuffle32Bit(src1, src2, dest, mergeIndex, rowCount);
                        return;
                    }
                    case 3: {
                        Vect.mergeShuffle64Bit(src1, src2, dest, mergeIndex, rowCount);
                        return;
                    }
                    case 4: {
                        Vect.mergeShuffle128Bit(src1, src2, dest, mergeIndex, rowCount);
                        return;
                    }
                    case 5: {
                        Vect.mergeShuffle256Bit(src1, src2, dest, mergeIndex, rowCount);
                        return;
                    }
                    default: {
                        assert (false) : "col type is unsupported";
                        return;
                    }
                }
            }
            finally {
                this.mapAppendColumnBufferRelease(lagAddr, lagMemOffset, lagRows << shl);
            }
        }
        catch (Throwable e) {
            this.handleWorkStealingException("cannot merge fix column into lag", columnIndex, columnType, mergeIndex, lagRows, mappedRowLo, mappedRowHi, e);
        }
    }

    private void o3MergeIntoLag(long mergedTimestamps, long countInLag, long mappedRowLo, long mappedRoHi, int timestampIndex) {
        MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
        RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
        this.o3DoneLatch.reset();
        int queuedCount = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            if (timestampIndex == i || type <= 0) continue;
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                O3CallbackTask task = queue.get(cursor);
                task.of(this.o3DoneLatch, i, type, mergedTimestamps, countInLag, mappedRowLo, mappedRoHi, ColumnType.isVariableLength(type) ? this.o3MergeVarColumnLagRef : this.o3MergeFixColumnLagRef);
                ++queuedCount;
                pubSeq.done(cursor);
                continue;
            }
            this.o3MergeIntoLagColumn(mergedTimestamps, i, type, countInLag, mappedRowLo, mappedRoHi);
        }
        this.dispatchO3CallbackQueue(queue, queuedCount);
        this.swapO3ColumnsExcept(timestampIndex);
    }

    private void o3MergeIntoLagColumn(long mergedTimestampAddress, int columnIndex, int type, long lagRows, long mappedRowLo, long mappedRowHi) {
        if (ColumnType.isVariableLength(type)) {
            this.o3MergeVarColumnLag(columnIndex, type, mergedTimestampAddress, lagRows, mappedRowLo, mappedRowHi);
        } else {
            this.o3MergeFixColumnLag(columnIndex, type, mergedTimestampAddress, lagRows, mappedRowLo, mappedRowHi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3MergeVarColumnLag(int columnIndex, int columnType, long mergedTimestampAddress, long lagRows, long mappedRowLo, long mappedRowHi) {
        block13: {
            if (this.o3ErrorCount.get() > 0) {
                return;
            }
            try {
                long rowCount = lagRows + mappedRowHi - mappedRowLo;
                int primaryIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
                int secondaryIndex = primaryIndex + 1;
                MemoryCR src1Data = this.o3Columns.getQuick(primaryIndex);
                MemoryCR src1Index = this.o3Columns.getQuick(secondaryIndex);
                MemoryMA lagData = this.columns.getQuick(primaryIndex);
                MemoryMA lagIndex = this.columns.getQuick(secondaryIndex);
                MemoryCARW destData = this.o3MemColumns2.getQuick(primaryIndex);
                MemoryCARW destIndex = this.o3MemColumns2.getQuick(secondaryIndex);
                long src1DataHi = src1Index.getLong(mappedRowHi << 3);
                long src1DataLo = src1Index.getLong(mappedRowLo << 3);
                long src1DataSize = src1DataHi - src1DataLo;
                assert (src1Data.size() >= src1DataSize);
                long src1DataAddr = src1Data.addressOf(src1DataLo) - src1DataLo;
                long src1IndxAddr = src1Index.addressOf(mappedRowLo << 3);
                long lagIndxOffset = this.txWriter.getTransientRowCount() - this.getColumnTop(columnIndex) << 3;
                long lagIndxSize = lagRows + 1L << 3;
                long lagIndxMapAddr = lagRows > 0L ? this.mapAppendColumnBuffer(lagIndex, lagIndxOffset, lagIndxSize, false) : 0L;
                try {
                    long lagIndxAddr = Math.abs(lagIndxMapAddr);
                    long lagDataBegin = lagRows > 0L ? Unsafe.getUnsafe().getLong(lagIndxAddr) : 0L;
                    long lagDataEnd = lagRows > 0L ? Unsafe.getUnsafe().getLong(lagIndxAddr + lagIndxSize - 8L) : 0L;
                    long lagDataSize = lagDataEnd - lagDataBegin;
                    assert (lagRows == 0L || lagDataSize > 0L);
                    long lagDataMapAddr = lagRows > 0L ? this.mapAppendColumnBuffer(lagData, lagDataBegin, lagDataSize, false) : 0L;
                    try {
                        long lagDataAddr = Math.abs(lagDataMapAddr) - lagDataBegin;
                        destData.jumpTo(src1DataSize + lagDataSize);
                        destIndex.jumpTo(rowCount + 1L << 3);
                        destIndex.putLong(rowCount << 3, src1DataSize + lagDataSize);
                        long destDataAddr = destData.addressOf(0L);
                        long destIndxAddr = destIndex.addressOf(0L);
                        if (columnType == 11) {
                            Vect.oooMergeCopyStrColumn(mergedTimestampAddress, rowCount, src1IndxAddr, src1DataAddr, lagIndxAddr, lagDataAddr, destIndxAddr, destDataAddr, 0L);
                            break block13;
                        }
                        if (columnType == 18) {
                            Vect.oooMergeCopyBinColumn(mergedTimestampAddress, rowCount, src1IndxAddr, src1DataAddr, lagIndxAddr, lagDataAddr, destIndxAddr, destDataAddr, 0L);
                            break block13;
                        }
                        throw new UnsupportedOperationException("unsupported column type:" + ColumnType.nameOf(columnType));
                    }
                    finally {
                        this.mapAppendColumnBufferRelease(lagDataMapAddr, lagDataBegin, lagDataSize);
                    }
                }
                finally {
                    this.mapAppendColumnBufferRelease(lagIndxMapAddr, lagIndxOffset, lagIndxSize);
                }
            }
            catch (Throwable e) {
                this.handleWorkStealingException("cannot merge variable length column into lag", columnIndex, columnType, mergedTimestampAddress, lagRows, mappedRowLo, mappedRowHi, e);
            }
        }
    }

    private void o3MoveLag0(int columnIndex, int columnType, long copyToLagRowCount, long columnDataRowOffset, long existingLagRows, long excludeSymbols) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            if (columnIndex > -1) {
                long destOffset;
                long size;
                long sourceOffset;
                MemoryCR o3SrcDataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                MemoryCR o3SrcIndexMem = this.o3Columns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                MemoryARW o3DstDataMem = this.o3MemColumns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
                MemoryARW o3DstIndexMem = this.o3MemColumns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
                if (o3SrcDataMem == o3DstDataMem && excludeSymbols > 0L && columnType == 12) {
                    return;
                }
                int shl = ColumnType.pow2SizeOf(columnType);
                if (null == o3SrcIndexMem) {
                    sourceOffset = columnDataRowOffset << shl;
                    size = copyToLagRowCount << shl;
                    destOffset = existingLagRows << shl;
                } else {
                    long committedIndexOffset = columnDataRowOffset << 3;
                    sourceOffset = o3SrcIndexMem.getLong(committedIndexOffset);
                    size = o3SrcIndexMem.getLong(columnDataRowOffset + copyToLagRowCount << 3) - sourceOffset;
                    destOffset = existingLagRows == 0L ? 0L : o3DstIndexMem.getLong(existingLagRows << 3);
                    o3DstIndexMem.jumpTo(existingLagRows + copyToLagRowCount + 1L << 3);
                    O3Utils.shiftCopyFixedSizeColumnData(sourceOffset - destOffset, o3SrcIndexMem.addressOf(committedIndexOffset), 0L, copyToLagRowCount, o3DstIndexMem.addressOf(existingLagRows << 3));
                }
                o3DstDataMem.jumpTo(destOffset + size);
                assert (o3SrcDataMem.size() >= size);
                Vect.memmove(o3DstDataMem.addressOf(destOffset), o3SrcDataMem.addressOf(sourceOffset), size);
            } else {
                MemoryCR o3SrcDataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(-columnIndex - 1));
                long sourceOffset = columnDataRowOffset << 4;
                this.o3TimestampMem.jumpTo(copyToLagRowCount + existingLagRows << 4);
                long dstTimestampAddr = this.o3TimestampMem.getAddress() + (existingLagRows << 4);
                Vect.shiftTimestampIndex(o3SrcDataMem.addressOf(sourceOffset), copyToLagRowCount, dstTimestampAddr);
            }
        }
        catch (Throwable ex) {
            this.handleWorkStealingException("o3 move lag failed", columnIndex, columnType, copyToLagRowCount, columnDataRowOffset, existingLagRows, excludeSymbols, ex);
        }
    }

    private long o3MoveUncommitted(int timestampIndex) {
        long committedRowCount = this.txWriter.unsafeCommittedFixedRowCount() + this.txWriter.unsafeCommittedTransientRowCount();
        long rowsAdded = this.txWriter.getRowCount() - committedRowCount;
        long transientRowCount = this.txWriter.getTransientRowCount();
        long transientRowsAdded = Math.min(transientRowCount, rowsAdded);
        if (transientRowsAdded > 0L) {
            LOG.debug().$("o3 move uncommitted [table=").utf8(this.tableToken.getTableName()).$(", transientRowsAdded=").$(transientRowsAdded).I$();
            long committedTransientRowCount = transientRowCount - transientRowsAdded;
            return this.o3ScheduleMoveUncommitted0(timestampIndex, transientRowsAdded, committedTransientRowCount);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3MoveUncommitted0(int colIndex, int columnType, long committedTransientRowCount, long transientRowsAdded, long ignore1, long ignore2) {
        block19: {
            if (this.o3ErrorCount.get() > 0) {
                return;
            }
            try {
                long alignedExtraLen;
                boolean locallyMapped;
                long srcFixLen;
                long srcFixOffset;
                if (colIndex > -1) {
                    long srcFixOffset2;
                    long extendedSize;
                    MemoryMA srcDataMem = this.getPrimaryColumn(colIndex);
                    int shl = ColumnType.pow2SizeOf(columnType);
                    MemoryARW o3DataMem = this.o3MemColumns.get(TableWriter.getPrimaryColumnIndex(colIndex));
                    MemoryARW o3IndexMem = this.o3MemColumns.get(TableWriter.getSecondaryColumnIndex(colIndex));
                    long dstVarOffset = o3DataMem.getAppendOffset();
                    long columnTop = this.getColumnTop(colIndex);
                    if (columnTop > 0L) {
                        LOG.debug().$("move uncommitted [columnTop=").$(columnTop).$(", columnIndex=").$(colIndex).$(", committedTransientRowCount=").$(committedTransientRowCount).$(", transientRowsAdded=").$(transientRowsAdded).I$();
                    }
                    if (null == o3IndexMem) {
                        extendedSize = transientRowsAdded << shl;
                        srcFixOffset2 = committedTransientRowCount - columnTop << shl;
                    } else {
                        long alignedExtraLen2;
                        boolean locallyMapped2;
                        int indexShl = 3;
                        MemoryMA srcFixMem = this.getSecondaryColumn(colIndex);
                        long sourceOffset = committedTransientRowCount - columnTop << 3;
                        long sourceLen = transientRowsAdded + 1L << 3;
                        long dstAppendOffset = o3IndexMem.getAppendOffset();
                        o3IndexMem.jumpTo(dstAppendOffset + (transientRowsAdded << 3));
                        long srcAddress = srcFixMem.map(sourceOffset, sourceLen);
                        boolean bl = locallyMapped2 = srcAddress == 0L;
                        if (!locallyMapped2) {
                            alignedExtraLen2 = 0L;
                        } else {
                            long alignedOffset = Files.floorPageSize(sourceOffset);
                            alignedExtraLen2 = sourceOffset - alignedOffset;
                            srcAddress = TableUtils.mapRO(this.ff, srcFixMem.getFd(), sourceLen + alignedExtraLen2, alignedOffset, 5);
                        }
                        long srcVarOffset = Unsafe.getUnsafe().getLong(srcAddress + alignedExtraLen2);
                        O3Utils.shiftCopyFixedSizeColumnData(srcVarOffset - dstVarOffset, srcAddress + alignedExtraLen2 + 8L, 0L, transientRowsAdded - 1L, o3IndexMem.addressOf(dstAppendOffset));
                        if (locallyMapped2) {
                            this.ff.munmap(srcAddress, sourceLen + alignedExtraLen2, 5);
                        }
                        extendedSize = srcDataMem.getAppendOffset() - srcVarOffset;
                        srcFixOffset2 = srcVarOffset;
                        srcFixMem.jumpTo(sourceOffset + 8L);
                    }
                    o3DataMem.jumpTo(dstVarOffset + extendedSize);
                    long appendAddress = o3DataMem.addressOf(dstVarOffset);
                    long sourceAddress = srcDataMem.map(srcFixOffset2, extendedSize);
                    if (sourceAddress != 0L) {
                        Vect.memcpy(appendAddress, sourceAddress, extendedSize);
                    } else {
                        long alignedOffset = Files.floorPageSize(srcFixOffset2);
                        long alignedExtraLen3 = srcFixOffset2 - alignedOffset;
                        sourceAddress = TableUtils.mapRO(this.ff, srcDataMem.getFd(), extendedSize + alignedExtraLen3, alignedOffset, 5);
                        Vect.memcpy(appendAddress, sourceAddress + alignedExtraLen3, extendedSize);
                        this.ff.munmap(sourceAddress, extendedSize + alignedExtraLen3, 5);
                    }
                    srcDataMem.jumpTo(srcFixOffset2);
                    break block19;
                }
                colIndex = -colIndex - 1;
                int shl = ColumnType.pow2SizeOf(8);
                MemoryMA srcDataMem = this.getPrimaryColumn(colIndex);
                long address = srcDataMem.map(srcFixOffset = committedTransientRowCount << shl, srcFixLen = transientRowsAdded << shl);
                boolean bl = locallyMapped = address == 0L;
                if (!locallyMapped) {
                    alignedExtraLen = 0L;
                } else {
                    long alignedOffset = Files.floorPageSize(srcFixOffset);
                    alignedExtraLen = srcFixOffset - alignedOffset;
                    address = TableUtils.mapRO(this.ff, srcDataMem.getFd(), srcFixLen + alignedExtraLen, alignedOffset, 5);
                }
                try {
                    for (long n = 0L; n < transientRowsAdded; ++n) {
                        long ts = Unsafe.getUnsafe().getLong(address + alignedExtraLen + (n << shl));
                        this.o3TimestampMem.putLong128(ts, this.o3RowCount + n);
                    }
                }
                finally {
                    if (locallyMapped) {
                        this.ff.munmap(address, srcFixLen + alignedExtraLen, 5);
                    }
                }
                srcDataMem.jumpTo(srcFixOffset);
            }
            catch (Throwable ex) {
                this.handleWorkStealingException("could not move uncommitted data", colIndex, columnType, committedTransientRowCount, transientRowsAdded, ignore1, ignore2, ex);
            }
        }
    }

    private void o3MoveWalFromFilesToLastPartition(int columnIndex, int columnType, long copyToLagRowCount, long columnDataRowOffset, long existingLagRows, long symbolsFlags) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            long destOffset;
            long size;
            long sourceOffset;
            boolean isDesignatedTimestamp = columnIndex < 0;
            columnIndex = columnIndex < 0 ? -columnIndex - 1 : columnIndex;
            MemoryCR o3SrcDataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            MemoryCR o3SrcIndexMem = this.o3Columns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
            MemoryMA o3DstDataMem = this.columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            MemoryMA o3DstIndexMem = this.columns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
            long destRowOffset = this.txWriter.getTransientRowCount() - this.getColumnTop(columnIndex) + existingLagRows;
            if (o3SrcIndexMem == null) {
                int shl = ColumnType.pow2SizeOf(columnType);
                sourceOffset = isDesignatedTimestamp ? columnDataRowOffset << 4 : columnDataRowOffset << shl;
                size = copyToLagRowCount << shl;
                destOffset = destRowOffset << shl;
            } else {
                long committedIndexOffset = columnDataRowOffset << 3;
                sourceOffset = o3SrcIndexMem.getLong(committedIndexOffset);
                size = o3SrcIndexMem.getLong(columnDataRowOffset + copyToLagRowCount << 3) - sourceOffset;
                long destIndexOffset = destRowOffset << 3;
                long destIndexSize = copyToLagRowCount + 1L << 3;
                if (destIndexOffset > 0L) {
                    o3DstIndexMem.jumpTo(destIndexOffset);
                    destOffset = Unsafe.getUnsafe().getLong(o3DstIndexMem.addressOf(destIndexOffset));
                } else {
                    destOffset = 0L;
                }
                long destAddr = this.mapAppendColumnBuffer(o3DstIndexMem, destIndexOffset, destIndexSize, true);
                assert (destAddr != 0L);
                O3Utils.shiftCopyFixedSizeColumnData(sourceOffset - destOffset, o3SrcIndexMem.addressOf(committedIndexOffset), 0L, copyToLagRowCount, Math.abs(destAddr));
                this.mapAppendColumnBufferRelease(destAddr, destIndexOffset, destIndexSize);
            }
            o3DstDataMem.jumpTo(destOffset + size);
            if (!isDesignatedTimestamp) {
                if (o3SrcDataMem instanceof MemoryCARW) {
                    if (symbolsFlags > 0L && ColumnType.isSymbol(columnType)) {
                        sourceOffset = 0L;
                    }
                    MemoryCARW o3MemBuff = (MemoryCARW)o3SrcDataMem;
                    long bytesWritten = this.ff.write(o3DstDataMem.getFd(), o3MemBuff.addressOf(sourceOffset), size, destOffset);
                    if (bytesWritten != size) {
                        throw CairoException.critical(this.ff.errno()).put("Could not copy data from WAL lag [fd=").put(o3DstDataMem.getFd()).put(", size=").put(size).put(", bytesWritten=").put(bytesWritten).put(']');
                    }
                } else {
                    MemoryCMOR o3SrcDataMemFile = (MemoryCMOR)o3SrcDataMem;
                    this.ff.copyData(o3SrcDataMemFile.getFd(), o3DstDataMem.getFd(), sourceOffset, destOffset, size);
                }
            } else {
                long srcLo = o3SrcDataMem.addressOf(sourceOffset);
                long destAddr = this.mapAppendColumnBuffer(o3DstDataMem, destOffset, size, true);
                Vect.copyFromTimestampIndex(srcLo, 0L, copyToLagRowCount - 1L, Math.abs(destAddr));
                this.mapAppendColumnBufferRelease(destAddr, destOffset, size);
            }
        }
        catch (Throwable th) {
            this.handleWorkStealingException("move wal to lag failed", columnIndex, columnType, copyToLagRowCount, columnDataRowOffset, existingLagRows, symbolsFlags, th);
        }
    }

    private void o3OpenColumnSafe(Sequence openColumnSubSeq, long cursor, O3OpenColumnTask openColumnTask) {
        try {
            O3OpenColumnJob.openColumn(openColumnTask, cursor, openColumnSubSeq);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    private void o3OpenColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) <= 0) continue;
            MemoryARW mem1 = this.o3MemColumns.getQuick(TableWriter.getPrimaryColumnIndex(i));
            mem1.jumpTo(0L);
            MemoryARW mem2 = this.o3MemColumns.getQuick(TableWriter.getSecondaryColumnIndex(i));
            if (mem2 == null) continue;
            mem2.jumpTo(0L);
            mem2.putLong(0L);
        }
        this.activeColumns = this.o3MemColumns;
        this.activeNullSetters = this.o3NullSetters;
        LOG.debug().$("switched partition to memory").$();
    }

    private void o3PartitionUpdate(long timestampMin, long partitionTimestamp, long newPartitionSize, long oldPartitionSize, boolean partitionMutates, boolean isLastWrittenPartition) {
        this.txWriter.minTimestamp = Math.min(timestampMin, this.txWriter.minTimestamp);
        int partitionIndexRaw = this.txWriter.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp);
        long newPartitionTimestamp = partitionTimestamp;
        int newPartitionIndex = partitionIndexRaw;
        if (partitionIndexRaw < 0) {
            partitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(partitionTimestamp);
            partitionIndexRaw = this.txWriter.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp);
        }
        if (partitionTimestamp == this.lastPartitionTimestamp && newPartitionTimestamp == partitionTimestamp) {
            if (partitionMutates) {
                this.closeActivePartition(true);
            } else if (!isLastWrittenPartition) {
                this.closeActivePartition(oldPartitionSize);
            } else {
                this.setAppendPosition(oldPartitionSize, false);
            }
        }
        LOG.debug().$("o3 partition update [timestampMin=").$ts(timestampMin).$(", last=").$(partitionTimestamp == this.lastPartitionTimestamp).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", partitionMutates=").$(partitionMutates).$(", lastPartitionTimestamp=").$(this.lastPartitionTimestamp).$(", partitionSize=").$(oldPartitionSize).I$();
        if (newPartitionTimestamp != partitionTimestamp) {
            LOG.info().$("o3 split partition [table=").utf8(this.tableToken.getTableName()).$(", part1=").$(this.formatPartitionForTimestamp(partitionTimestamp, this.txWriter.getPartitionNameTxnByPartitionTimestamp(partitionTimestamp))).$(", part1OldSize=").$(this.txWriter.getPartitionSizeByPartitionTimestamp(partitionTimestamp)).$(", part1NewSize=").$(oldPartitionSize).$(", part2=").$(this.formatPartitionForTimestamp(newPartitionTimestamp, this.txWriter.txn)).$(", part2Size=").$(newPartitionSize).I$();
            this.minSplitPartitionTimestamp = Math.min(this.minSplitPartitionTimestamp, newPartitionTimestamp);
            this.txWriter.bumpPartitionTableVersion();
            this.txWriter.updateAttachedPartitionSizeByRawIndex(newPartitionIndex, newPartitionTimestamp, newPartitionSize, this.txWriter.txn);
            if (partitionTimestamp == this.lastPartitionTimestamp) {
                long committedLastPartitionSize = this.txWriter.getPartitionSizeByPartitionTimestamp(partitionTimestamp);
                this.closeActivePartition(committedLastPartitionSize);
                if (isLastWrittenPartition) {
                    this.txWriter.transientRowCount = newPartitionSize;
                    this.txWriter.fixedRowCount += oldPartitionSize;
                }
            }
        }
        if (partitionMutates && newPartitionTimestamp == partitionTimestamp) {
            long srcDataTxn = this.txWriter.getPartitionNameTxnByRawIndex(partitionIndexRaw);
            LOG.info().$("merged partition [table=`").utf8(this.tableToken.getTableName()).$("`, ts=").$ts(partitionTimestamp).$(", txn=").$(this.txWriter.txn).I$();
            this.txWriter.updatePartitionSizeAndTxnByRawIndex(partitionIndexRaw, oldPartitionSize);
            this.partitionRemoveCandidates.add(partitionTimestamp, srcDataTxn);
            this.txWriter.bumpPartitionTableVersion();
        } else {
            if (partitionTimestamp != this.lastPartitionTimestamp) {
                this.txWriter.bumpPartitionTableVersion();
            }
            this.txWriter.updatePartitionSizeByRawIndex(partitionIndexRaw, partitionTimestamp, oldPartitionSize);
        }
    }

    private void o3ProcessPartitionSafe(Sequence partitionSubSeq, long cursor, O3PartitionTask partitionTask) {
        try {
            O3PartitionJob.processPartition(partitionTask, cursor, partitionSubSeq);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long o3ScheduleMoveUncommitted0(int timestampIndex, long transientRowsAdded, long committedTransientRowCount) {
        if (transientRowsAdded > 0L) {
            MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
            RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
            this.o3DoneLatch.reset();
            int queuedCount = 0;
            for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
                int columnType = this.metadata.getColumnType(colIndex);
                if (columnType <= 0) continue;
                int columnIndex = colIndex != timestampIndex ? colIndex : -colIndex - 1;
                long cursor = pubSeq.next();
                if (cursor > -1L) {
                    try {
                        O3CallbackTask task = queue.get(cursor);
                        task.of(this.o3DoneLatch, columnIndex, columnType, committedTransientRowCount, transientRowsAdded, -1L, -1L, this.o3MoveUncommittedRef);
                        continue;
                    }
                    finally {
                        ++queuedCount;
                        pubSeq.done(cursor);
                    }
                }
                this.o3MoveUncommitted0(columnIndex, columnType, committedTransientRowCount, transientRowsAdded, -1L, -1L);
            }
            this.dispatchO3CallbackQueue(queue, queuedCount);
        }
        this.txWriter.resetToLastPartition(committedTransientRowCount);
        return transientRowsAdded;
    }

    private void o3SetAppendOffset(int columnIndex, int columnType, long o3RowCount) {
        if (columnIndex != this.metadata.getTimestampIndex()) {
            long size;
            MemoryARW o3DataMem = this.o3MemColumns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            MemoryARW o3IndexMem = this.o3MemColumns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
            if (null == o3IndexMem) {
                size = o3RowCount << ColumnType.pow2SizeOf(columnType);
            } else {
                size = o3RowCount > 0L ? o3IndexMem.getLong(o3RowCount * 8L) : 0L;
                o3IndexMem.jumpTo((o3RowCount + 1L) * 8L);
            }
            o3DataMem.jumpTo(size);
        } else {
            this.o3TimestampMem.jumpTo(o3RowCount * 16L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ShiftLagRowsUp(int timestampIndex, long o3LagRowCount, long o3RowCount, long existingLagRowCount, boolean excludeSymbols, O3ColumnUpdateMethod o3MoveLagRef) {
        MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
        RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
        this.o3DoneLatch.reset();
        int queuedCount = 0;
        long excludeSymbolsL = excludeSymbols ? 1L : 0L;
        for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
            int columnIndex;
            int columnType = this.metadata.getColumnType(colIndex);
            int n = columnIndex = colIndex != timestampIndex ? colIndex : -colIndex - 1;
            if (columnType <= 0) continue;
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                try {
                    O3CallbackTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, columnIndex, columnType, o3LagRowCount, o3RowCount, existingLagRowCount, excludeSymbolsL, o3MoveLagRef);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            o3MoveLagRef.run(columnIndex, columnType, o3LagRowCount, o3RowCount, existingLagRowCount, excludeSymbolsL);
        }
        this.dispatchO3CallbackQueue(queue, queuedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3Sort(long mergedTimestamps, int timestampIndex, long rowCount) {
        this.o3ErrorCount.set(0);
        this.lastErrno = 0;
        MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
        RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
        this.o3DoneLatch.reset();
        int queuedCount = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            if (timestampIndex == i || type <= 0) continue;
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                try {
                    O3CallbackTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, i, type, mergedTimestamps, rowCount, -1L, -1L, ColumnType.isVariableLength(type) ? this.o3SortVarColumnRef : this.o3SortFixColumnRef);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            this.o3SortColumn(mergedTimestamps, i, type, rowCount);
        }
        this.dispatchO3CallbackQueue(queue, queuedCount);
        this.swapO3ColumnsExcept(timestampIndex);
    }

    private void o3SortColumn(long mergedTimestamps, int i, int type, long rowCount) {
        if (ColumnType.isVariableLength(type)) {
            this.o3SortVarColumn(i, type, mergedTimestamps, rowCount, -1L, -1L);
        } else {
            this.o3SortFixColumn(i, type, mergedTimestamps, rowCount, -1L, -1L);
        }
    }

    private void o3SortFixColumn(int columnIndex, int columnType, long mergedTimestampsAddr, long valueCount, long ignore1, long ignore2) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            int columnOffset = TableWriter.getPrimaryColumnIndex(columnIndex);
            MemoryCR mem = this.o3Columns.getQuick(columnOffset);
            MemoryCARW mem2 = this.o3MemColumns2.getQuick(columnOffset);
            int shl = ColumnType.pow2SizeOf(columnType);
            long src = mem.addressOf(0L);
            mem2.jumpTo(valueCount << shl);
            long tgtDataAddr = mem2.addressOf(0L);
            switch (shl) {
                case 0: {
                    Vect.indexReshuffle8Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                    break;
                }
                case 1: {
                    Vect.indexReshuffle16Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                    break;
                }
                case 2: {
                    Vect.indexReshuffle32Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                    break;
                }
                case 3: {
                    Vect.indexReshuffle64Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                    break;
                }
                case 4: {
                    Vect.indexReshuffle128Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                    break;
                }
                case 5: {
                    Vect.indexReshuffle256Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                    break;
                }
                default: {
                    assert (false) : "col type is unsupported";
                    break;
                }
            }
        }
        catch (Throwable th) {
            this.handleWorkStealingException("sort fixed size column failed", columnIndex, columnType, mergedTimestampsAddr, valueCount, ignore1, ignore2, th);
        }
    }

    private void o3SortVarColumn(int columnIndex, int columnType, long mergedTimestampsAddr, long valueCount, long ignore1, long ignore2) {
        if (this.o3ErrorCount.get() > 0) {
            return;
        }
        try {
            int primaryIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
            int secondaryIndex = primaryIndex + 1;
            MemoryCR dataMem = this.o3Columns.getQuick(primaryIndex);
            MemoryCR indexMem = this.o3Columns.getQuick(secondaryIndex);
            MemoryCARW dataMem2 = this.o3MemColumns2.getQuick(primaryIndex);
            MemoryCARW indexMem2 = this.o3MemColumns2.getQuick(secondaryIndex);
            long srcDataAddr = dataMem.addressOf(0L);
            long srcIndxAddr = indexMem.addressOf(0L);
            long tgtDataAddr = dataMem2.resize(dataMem.size());
            long tgtIndxAddr = indexMem2.resize(valueCount * 8L);
            assert (srcDataAddr != 0L);
            assert (srcIndxAddr != 0L);
            assert (tgtDataAddr != 0L);
            assert (tgtIndxAddr != 0L);
            long offset = Vect.sortVarColumn(mergedTimestampsAddr, valueCount, srcDataAddr, srcIndxAddr, tgtDataAddr, tgtIndxAddr);
            dataMem2.jumpTo(offset);
            indexMem2.jumpTo(valueCount * 8L);
            indexMem2.putLong(offset);
        }
        catch (Throwable th) {
            this.handleWorkStealingException("sort variable size column failed", columnIndex, columnType, mergedTimestampsAddr, valueCount, ignore1, ignore2, th);
        }
    }

    private void o3TimestampSetter(long timestamp) {
        this.o3TimestampMem.putLong128(timestamp, this.getO3RowCount0());
        this.o3CommitBatchTimestampMin = Math.min(this.o3CommitBatchTimestampMin, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumnFiles(CharSequence name, long columnNameTxn, int columnIndex, int pathTrimToLen) {
        MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
        MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
        try {
            mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
            if (mem2 != null) {
                mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name, columnNameTxn), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
            }
        }
        finally {
            this.path.trimTo(pathTrimToLen);
        }
    }

    private void openLastPartitionAndSetAppendPosition(long ts) {
        this.openPartition(ts);
        this.setAppendPosition(this.txWriter.getTransientRowCount() + (long)this.txWriter.getLagRowCount(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewColumnFiles(CharSequence name, int columnType, boolean indexFlag, int indexValueBlockCapacity) {
        try {
            MemoryMA mem2;
            long partitionTimestamp = this.txWriter.getLastPartitionTimestamp();
            this.setStateForTimestamp(this.path, partitionTimestamp);
            int plen = this.path.length();
            int columnIndex = this.columnCount - 1;
            long columnNameTxn = this.getTxn();
            if (indexFlag) {
                this.createIndexFiles(name, columnNameTxn, indexValueBlockCapacity, plen, true);
            }
            this.openColumnFiles(name, columnNameTxn, columnIndex, plen);
            if (this.txWriter.getTransientRowCount() > 0L) {
                this.columnVersionWriter.upsert(this.txWriter.getLastPartitionTimestamp(), columnIndex, columnNameTxn, this.txWriter.getTransientRowCount());
            }
            if (indexFlag) {
                ColumnIndexer indexer = this.indexers.getQuick(columnIndex);
                assert (indexer != null);
                this.indexers.getQuick(columnIndex).configureFollowerAndWriter(this.path.trimTo(plen), name, columnNameTxn, this.getPrimaryColumn(columnIndex), this.txWriter.getTransientRowCount());
            }
            if ((mem2 = this.getSecondaryColumn(this.columnCount - 1)) != null) {
                mem2.putLong(0L);
            }
            LOG.info().$("ADDED column '").utf8(name).$('[').$(ColumnType.nameOf(columnType)).$("], columnName txn ").$(columnNameTxn).$(" to ").$(this.path).$(" with columnTop ").$(this.txWriter.getTransientRowCount()).$();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openPartition(long timestamp) {
        try {
            timestamp = this.txWriter.getPartitionTimestampByTimestamp(timestamp);
            this.setStateForTimestamp(this.path, timestamp);
            this.partitionTimestampHi = this.txWriter.getNextPartitionTimestamp(timestamp) - 1L;
            int plen = this.path.length();
            if (this.ff.mkdirs(this.path.slash$(), this.mkDirMode) != 0) {
                throw CairoException.critical(this.ff.errno()).put("Cannot create directory: ").put(this.path);
            }
            assert (this.columnCount > 0);
            this.lastOpenPartitionTs = timestamp;
            this.lastOpenPartitionIsReadOnly = this.partitionBy != 3 && this.txWriter.isPartitionReadOnlyByPartitionTimestamp(this.lastOpenPartitionTs);
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnIndexer indexer;
                if (this.metadata.getColumnType(i) <= 0) continue;
                String name = this.metadata.getColumnName(i);
                long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(this.lastOpenPartitionTs, i);
                ColumnIndexer columnIndexer = indexer = this.metadata.isColumnIndexed(i) ? this.indexers.getQuick(i) : null;
                if (indexer != null) {
                    this.createIndexFiles(name, columnNameTxn, this.metadata.getIndexValueBlockCapacity(i), plen, this.txWriter.getTransientRowCount() < 1L);
                    indexer.closeSlider();
                }
                this.openColumnFiles(name, columnNameTxn, i, plen);
                if (indexer == null) continue;
                long columnTop = this.columnVersionWriter.getColumnTopQuick(this.lastOpenPartitionTs, i);
                indexer.configureFollowerAndWriter(this.path, name, columnNameTxn, this.getPrimaryColumn(i), columnTop);
            }
            this.populateDenseIndexerList();
            LOG.info().$("switched partition [path='").utf8(this.path).$('\'').I$();
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long openTodoMem() {
        this.path.concat("_todo_").$();
        try {
            if (this.ff.exists(this.path)) {
                long fileLen = this.ff.length(this.path);
                if (fileLen < 32L) {
                    throw CairoException.critical(0).put("corrupt ").put(this.path);
                }
                this.todoMem.smallFile(this.ff, this.path, 5);
                this.todoTxn = this.todoMem.getLong(0L);
                if (this.todoMem.getLong(24L) != this.todoTxn) {
                    this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
                    this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
                    Unsafe.getUnsafe().storeFence();
                    this.todoMem.putLong(24L, this.todoTxn);
                    long l = 0L;
                    return l;
                }
                long l = this.todoMem.getLong(32L);
                return l;
            }
            TableUtils.resetTodoLog(this.ff, this.path, this.rootLen, this.todoMem);
            this.todoTxn = 0L;
            long l = 0L;
            return l;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void performRecovery() {
        this.rollbackIndexes();
        this.rollbackSymbolTables();
        this.performRecovery = false;
    }

    private void populateDenseIndexerList() {
        this.denseIndexers.clear();
        int n = this.indexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.indexers.getQuick(i);
            if (indexer == null) continue;
            this.denseIndexers.add(indexer);
        }
        this.indexCount = this.denseIndexers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsyncWriterCommand(AsyncWriterCommand asyncWriterCommand, TableWriterTask cmd, long cursor, Sequence sequence, boolean contextAllowsAnyStructureChanges) {
        int cmdType = cmd.getType();
        long correlationId = cmd.getInstance();
        long tableId = cmd.getTableId();
        int errorCode = 0;
        CharSequence errorMsg = null;
        long affectedRowsCount = 0L;
        try {
            this.publishTableWriterEvent(cmdType, tableId, correlationId, 0, null, 0L, 64);
            LOG.info().$("received async cmd [type=").$(cmdType).$(", tableName=").utf8(this.tableToken.getTableName()).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).$(", cursor=").$(cursor).I$();
            asyncWriterCommand = asyncWriterCommand.deserialize(cmd);
            affectedRowsCount = asyncWriterCommand.apply(this, contextAllowsAnyStructureChanges);
        }
        catch (TableReferenceOutOfDateException ex) {
            LOG.info().$("cannot complete async cmd, reader is out of date [type=").$(cmdType).$(", tableName=").utf8(this.tableToken.getTableName()).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).I$();
            errorCode = -1;
            errorMsg = ex.getMessage();
        }
        catch (AlterTableContextException ex) {
            LOG.info().$("cannot complete async cmd, table structure change is not allowed [type=").$(cmdType).$(", tableName=").utf8(this.tableToken.getTableName()).$(", tableId=").$(tableId).$(", correlationId=").$(correlationId).I$();
            errorCode = -2;
            errorMsg = "async cmd cannot change table structure while writer is busy";
        }
        catch (CairoException ex) {
            errorCode = -3;
            errorMsg = ex.getFlyweightMessage();
        }
        catch (Throwable ex) {
            LOG.error().$("error on processing async cmd [type=").$(cmdType).$(", tableName=").utf8(this.tableToken.getTableName()).$(", ex=").$(ex).I$();
            errorCode = -4;
            errorMsg = ex.getMessage();
        }
        finally {
            sequence.done(cursor);
        }
        this.publishTableWriterEvent(cmdType, tableId, correlationId, errorCode, errorMsg, affectedRowsCount, 65);
    }

    private void processCommandQueue(boolean contextAllowsAnyStructureChanges) {
        long cursor;
        while ((cursor = this.commandSubSeq.next()) > -1L) {
            TableWriterTask cmd = this.commandQueue.get(cursor);
            this.processCommandQueue(cmd, this.commandSubSeq, cursor, contextAllowsAnyStructureChanges);
        }
    }

    private void processO3Block(long o3LagRowCount, int timestampIndex, long sortedTimestampsAddr, long srcOooMax, long o3TimestampMin, long o3TimestampMax, boolean flattenTimestamp, long rowLo) {
        this.o3ErrorCount.set(0);
        this.lastErrno = 0;
        this.partitionRemoveCandidates.clear();
        this.o3ColumnCounters.clear();
        this.o3BasketPool.clear();
        long maxTimestamp = this.txWriter.getMaxTimestamp();
        long transientRowCount = this.txWriter.transientRowCount;
        this.o3DoneLatch.reset();
        this.o3PartitionUpdRemaining.set(0L);
        boolean success = true;
        int latchCount = 0;
        long srcOoo = rowLo;
        int pCount = 0;
        try {
            long commitTransientRowCount = transientRowCount;
            this.resizePartitionUpdateSink();
            while (srcOoo < srcOooMax) {
                try {
                    long srcNameTxn;
                    long srcDataMax;
                    long srcOooLo = srcOoo;
                    long o3Timestamp = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOoo);
                    assert (o3Timestamp >= Math.min(o3TimestampMin, Math.max(this.txWriter.getMinTimestamp(), 0L)));
                    long srcOooTimestampCeil = this.txWriter.getNextPartitionTimestamp(o3Timestamp) - 1L;
                    long srcOooHi = srcOooTimestampCeil < o3TimestampMax ? Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, srcOooTimestampCeil, srcOooLo, srcOooMax - 1L, 1) : srcOooMax - 1L;
                    long partitionTimestamp = this.txWriter.getPartitionTimestampByTimestamp(o3Timestamp);
                    boolean last = partitionTimestamp == this.lastPartitionTimestamp;
                    srcOoo = srcOooHi + 1L;
                    int partitionIndexRaw = this.txWriter.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp);
                    if (partitionIndexRaw > -1) {
                        srcDataMax = last ? transientRowCount : this.getPartitionSizeByRawIndex(partitionIndexRaw);
                        srcNameTxn = this.getPartitionNameTxnByRawIndex(partitionIndexRaw);
                    } else {
                        srcDataMax = 0L;
                        srcNameTxn = this.txWriter.getTxn() - 1L;
                    }
                    boolean append = last && (srcDataMax == 0L || o3Timestamp >= maxTimestamp);
                    long srcOooBatchRowSize = srcOooHi - srcOooLo + 1L;
                    long partitionSize = srcDataMax + srcOooBatchRowSize;
                    boolean partitionIsReadOnly = this.txWriter.isPartitionReadOnlyByPartitionTimestamp(partitionTimestamp);
                    LOG.info().$("o3 partition task [table=").utf8(this.tableToken.getTableName()).$(", partitionIsReadOnly=").$(partitionIsReadOnly).$(", srcOooBatchRowSize=").$(srcOooBatchRowSize).$(", srcOooLo=").$(srcOooLo).$(", srcOooHi=").$(srcOooHi).$(", srcOooMax=").$(srcOooMax).$(", o3RowCount=").$(this.o3RowCount).$(", o3LagRowCount=").$(o3LagRowCount).$(", srcDataMax=").$(srcDataMax).$(", o3TimestampMin=").$ts(o3TimestampMin).$(", o3Timestamp=").$ts(o3Timestamp).$(", o3TimestampMax=").$ts(o3TimestampMax).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", partitionIndex=").$(partitionIndexRaw).$(", partitionSize=").$(partitionSize).$(", maxTimestamp=").$ts(maxTimestamp).$(", last=").$(last).$(", append=").$(append).$(", pCount=").$(++pCount).$(", flattenTimestamp=").$(flattenTimestamp).$(", memUsed=").$(Unsafe.getMemUsed()).I$();
                    if (partitionIsReadOnly) {
                        LOG.critical().$("o3 ignoring write on read-only partition [table=").utf8(this.tableToken.getTableName()).$(", timestamp=").$ts(partitionTimestamp).$(", numRows=").$(srcOooBatchRowSize).$();
                        continue;
                    }
                    if (partitionTimestamp < this.lastPartitionTimestamp) {
                        this.txWriter.fixedRowCount += srcOooBatchRowSize;
                    } else if (partitionTimestamp == this.lastPartitionTimestamp) {
                        commitTransientRowCount = partitionSize;
                    } else {
                        this.txWriter.fixedRowCount += commitTransientRowCount;
                        commitTransientRowCount = partitionSize;
                    }
                    this.o3PartitionUpdRemaining.incrementAndGet();
                    O3Basket o3Basket = this.o3BasketPool.next();
                    o3Basket.ensureCapacity(this.configuration, this.columnCount, this.indexCount);
                    AtomicInteger columnCounter = this.o3ColumnCounters.next();
                    ++latchCount;
                    long partitionUpdateSinkAddr = this.o3PartitionUpdateSink.allocateBlock();
                    Vect.memset(partitionUpdateSinkAddr + 40L, (long)this.metadata.getColumnCount() * 8L, -1);
                    Unsafe.getUnsafe().putLong(partitionUpdateSinkAddr, partitionTimestamp);
                    if (append) {
                        try {
                            this.setAppendPosition(srcDataMax, false);
                        }
                        catch (Throwable e) {
                            this.o3BumpErrorCount();
                            this.o3ClockDownPartitionUpdateCount();
                            this.o3CountDownDoneLatch();
                            throw e;
                        }
                        columnCounter.set(TableUtils.compressColumnCount(this.metadata));
                        Path pathToPartition = Path.getThreadLocal(this.path);
                        TableUtils.setPathForPartition(pathToPartition, this.partitionBy, this.txWriter.getPartitionTimestampByTimestamp(o3TimestampMin), srcNameTxn);
                        int plen = pathToPartition.length();
                        int columnsPublished = 0;
                        for (int i = 0; i < this.columnCount; ++i) {
                            MemoryMA dstVarMem;
                            MemoryMA dstFixMem;
                            long srcOooVarAddr;
                            long srcOooFixAddr;
                            int columnType = this.metadata.getColumnType(i);
                            if (columnType < 0) continue;
                            int colOffset = TableWriter.getPrimaryColumnIndex(i);
                            boolean notTheTimestamp = i != timestampIndex;
                            String columnName = this.metadata.getColumnName(i);
                            int indexBlockCapacity = this.metadata.isColumnIndexed(i) ? this.metadata.getIndexValueBlockCapacity(i) : -1;
                            BitmapIndexWriter indexWriter = indexBlockCapacity > -1 ? this.getBitmapIndexWriter(i) : null;
                            MemoryR oooMem1 = this.o3Columns.getQuick(colOffset);
                            MemoryR oooMem2 = this.o3Columns.getQuick(colOffset + 1);
                            MemoryMA mem1 = this.columns.getQuick(colOffset);
                            MemoryMA mem2 = this.columns.getQuick(colOffset + 1);
                            long srcDataTop = this.getColumnTop(i);
                            if (!ColumnType.isVariableLength(columnType)) {
                                srcOooFixAddr = oooMem1.addressOf(0L);
                                srcOooVarAddr = 0L;
                                dstFixMem = mem1;
                                dstVarMem = null;
                            } else {
                                srcOooFixAddr = oooMem2.addressOf(0L);
                                srcOooVarAddr = oooMem1.addressOf(0L);
                                dstFixMem = mem2;
                                dstVarMem = mem1;
                            }
                            ++columnsPublished;
                            try {
                                O3OpenColumnJob.appendLastPartition(pathToPartition, plen, columnName, columnCounter, notTheTimestamp ? columnType : ColumnType.setDesignatedTimestampBit(columnType, true), srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, o3TimestampMin, partitionTimestamp, srcDataTop, srcDataMax, indexBlockCapacity, dstFixMem, dstVarMem, partitionSize, partitionSize, this, indexWriter, this.getColumnNameTxn(partitionTimestamp, i), partitionUpdateSinkAddr);
                                continue;
                            }
                            catch (Throwable e) {
                                if (columnCounter.addAndGet(columnsPublished - this.columnCount) == 0) {
                                    this.o3ClockDownPartitionUpdateCount();
                                    this.o3CountDownDoneLatch();
                                }
                                throw e;
                            }
                        }
                        this.addPhysicallyWrittenRows(srcOooBatchRowSize);
                        continue;
                    }
                    if (flattenTimestamp && this.o3RowCount > 0L) {
                        Vect.flattenIndex(sortedTimestampsAddr, this.o3RowCount);
                        flattenTimestamp = false;
                    }
                    this.o3CommitPartitionAsync(columnCounter, maxTimestamp, sortedTimestampsAddr, srcOooMax, o3TimestampMin, o3TimestampMax, srcOooLo, srcOooHi, partitionTimestamp, last, srcDataMax, srcNameTxn, o3Basket, partitionUpdateSinkAddr);
                }
                catch (CairoError | CairoException e) {
                    LOG.error().$((Sinkable)((Object)e)).$();
                    success = false;
                    throw e;
                }
            }
            this.txWriter.transientRowCount = commitTransientRowCount;
            this.partitionTimestampHi = Math.max(this.partitionTimestampHi, this.txWriter.getNextPartitionTimestamp(o3TimestampMax) - 1L);
            this.txWriter.updateMaxTimestamp(Math.max(this.txWriter.getMaxTimestamp(), o3TimestampMax));
            LOG.debug().$("o3 expecting updates [table=").utf8(this.tableToken.getTableName()).$(", partitionsPublished=").$(pCount).I$();
            this.o3ConsumePartitionUpdates();
            this.o3DoneLatch.await(latchCount);
            boolean bl = this.o3InError = !success || this.o3ErrorCount.get() > 0;
        }
        catch (Throwable th) {
            try {
                LOG.error().$(th).$();
                throw th;
            }
            catch (Throwable throwable) {
                LOG.debug().$("o3 expecting updates [table=").utf8(this.tableToken.getTableName()).$(", partitionsPublished=").$(pCount).I$();
                this.o3ConsumePartitionUpdates();
                this.o3DoneLatch.await(latchCount);
                boolean bl = this.o3InError = !success || this.o3ErrorCount.get() > 0;
                if (success && this.o3ErrorCount.get() > 0) {
                    throw CairoException.critical(0).put("bulk update failed and will be rolled back");
                }
                throw throwable;
            }
        }
        if (success && this.o3ErrorCount.get() > 0) {
            throw CairoException.critical(0).put("bulk update failed and will be rolled back");
        }
        if (o3LagRowCount > 0L && !this.metadata.isWalEnabled()) {
            LOG.info().$("shifting lag rows up [table=").$(this.tableToken.getTableName()).$(", lagCount=").$(o3LagRowCount).I$();
            this.o3ShiftLagRowsUp(timestampIndex, o3LagRowCount, srcOooMax, 0L, false, this.o3MoveLagRef);
        }
    }

    private void processPartitionRemoveCandidates() {
        try {
            int n = this.partitionRemoveCandidates.size();
            if (n > 0) {
                this.processPartitionRemoveCandidates0(n);
            }
        }
        finally {
            this.partitionRemoveCandidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartitionRemoveCandidates0(int n) {
        boolean anyReadersBeforeCommittedTxn;
        boolean scheduleAsyncPurge = anyReadersBeforeCommittedTxn = this.checkScoreboardHasReadersBeforeLastCommittedTxn();
        if (!anyReadersBeforeCommittedTxn) {
            for (int i = 0; i < n; i += 2) {
                try {
                    long timestamp = this.partitionRemoveCandidates.getQuick(i);
                    long txn = this.partitionRemoveCandidates.getQuick(i + 1);
                    TableUtils.setPathForPartition(this.other, this.partitionBy, timestamp, txn);
                    this.other.$();
                    int errno = this.ff.unlinkOrRemove(this.other, LOG);
                    if (errno == 0 || errno == -1) continue;
                    LOG.info().$("could not purge partition version, async purge will be scheduled [path=").utf8(this.other).$(", errno=").$(errno).I$();
                    scheduleAsyncPurge = true;
                    continue;
                }
                finally {
                    this.other.trimTo(this.rootLen);
                }
            }
        }
        if (scheduleAsyncPurge) {
            if (TableUtils.schedulePurgeO3Partitions(this.messageBus, this.tableToken, this.partitionBy)) {
                LOG.info().$("scheduled to purge partitions [table=").utf8(this.tableToken.getTableName()).I$();
            } else {
                LOG.error().$("could not queue for purge, queue is full [table=").utf8(this.tableToken.getTableName()).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishTableWriterEvent(int cmdType, long tableId, long correlationId, int errorCode, CharSequence errorMsg, long affectedRowsCount, int eventType) {
        long pubCursor;
        do {
            if ((pubCursor = this.messageBus.getTableWriterEventPubSeq().next()) != -2L) continue;
            Os.pause();
        } while (pubCursor < -1L);
        if (pubCursor > -1L) {
            try {
                TableWriterTask event = this.messageBus.getTableWriterEventQueue().get(pubCursor);
                event.of(eventType, tableId, this.tableToken);
                event.putInt(errorCode);
                if (errorCode != 0) {
                    event.putStr(errorMsg);
                } else {
                    event.putLong(affectedRowsCount);
                }
                event.setInstance(correlationId);
            }
            finally {
                this.messageBus.getTableWriterEventPubSeq().done(pubCursor);
            }
            if (eventType == 65) {
                LogRecord lg = LOG.info().$("published async command complete event [type=").$(cmdType).$(",tableName=").utf8(this.tableToken.getTableName()).$(",tableId=").$(tableId).$(",correlationId=").$(correlationId);
                if (errorCode != 0) {
                    lg.$(",errorCode=").$(errorCode).$(",errorMsg=").$(errorMsg);
                }
                lg.I$();
            }
        } else {
            LOG.error().$("could not publish sync command complete event [type=").$(cmdType).$(",tableName=").utf8(this.tableToken.getTableName()).$(",tableId=").$(tableId).$(",correlationId=").$(correlationId).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMinTimestamp(long partitionTimestamp) {
        this.setStateForTimestamp(this.other, partitionTimestamp);
        try {
            TableUtils.dFile(this.other, this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L);
            if (this.ff.exists(this.other)) {
                int fd = TableUtils.openRO(this.ff, this.other, LOG);
                try {
                    long l = TableUtils.readLongOrFail(this.ff, fd, 0L, this.tempMem16b, this.other);
                    return l;
                }
                finally {
                    this.ff.close(fd);
                }
            }
            throw CairoException.critical(0).put("Partition does not exist [path=").put(this.other).put(']');
        }
        finally {
            this.other.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartitionMinMax(FilesFacade ff, long partitionTimestamp, Path path, CharSequence columnName, long partitionSize) {
        TableUtils.dFile(path, columnName, -1L);
        int fd = TableUtils.openRO(ff, path, LOG);
        try {
            this.attachMinTimestamp = ff.readNonNegativeLong(fd, 0L);
            this.attachMaxTimestamp = ff.readNonNegativeLong(fd, (partitionSize - 1L) * (long)ColumnType.sizeOf(8));
            if (this.attachMinTimestamp < 0L || this.attachMaxTimestamp < 0L) {
                throw CairoException.critical(ff.errno()).put("cannot read min, max timestamp from the column [path=").put(path).put(", partitionSizeRows=").put(partitionSize).put(", errno=").put(ff.errno()).put(']');
            }
            if (this.txWriter.getPartitionTimestampByTimestamp(this.attachMinTimestamp) != partitionTimestamp || this.txWriter.getPartitionTimestampByTimestamp(this.attachMaxTimestamp) != partitionTimestamp) {
                throw CairoException.critical(0).put("invalid timestamp column data in detached partition, data does not match partition directory name [path=").put(path).put(", minTimestamp=").ts(this.attachMinTimestamp).put(", maxTimestamp=").ts(this.attachMaxTimestamp).put(']');
            }
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * Exception decompiling
     */
    private long readPartitionSizeMinMax(FilesFacade ff, long partitionTimestamp, Path path, CharSequence columnName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readTimestampRaw(long transientRowCount) {
        long offset = (transientRowCount - 1L) * 8L;
        long addr = this.mapAppendColumnBuffer(this.getPrimaryColumn(this.metadata.getTimestampIndex()), offset, 8L, false);
        try {
            long l = Unsafe.getUnsafe().getLong(Math.abs(addr));
            return l;
        }
        finally {
            this.mapAppendColumnBufferRelease(addr, offset, 8L);
        }
    }

    private int readTodo() {
        long todoCount;
        try {
            todoCount = this.openTodoMem();
        }
        catch (CairoException ex) {
            if (ex.errnoReadPathDoesNotExist()) {
                throw CairoException.tableDoesNotExist(this.tableToken.getTableName());
            }
            throw ex;
        }
        int todo = todoCount > 0L ? (int)this.todoMem.getLong(40L) : -1;
        return todo;
    }

    private void rebuildAttachedPartitionColumnIndex(long partitionTimestamp, long partitionSize, CharSequence columnName) {
        if (this.attachIndexBuilder == null) {
            this.attachIndexBuilder = new IndexBuilder(this.configuration);
            this.attachIndexBuilder.of("");
        }
        this.attachIndexBuilder.reindexColumn(this.ff, this.attachColumnVersionReader, this.metadata, this.metadata.getColumnIndex(columnName), -1L, partitionTimestamp, this.partitionBy, partitionSize);
    }

    private boolean reconcileOptimisticPartitions() {
        int maxTimestampPartitionIndex;
        if (this.txWriter.getPartitionTimestampByIndex(this.txWriter.getPartitionCount() - 1) > this.txWriter.getMaxTimestamp() && (maxTimestampPartitionIndex = this.txWriter.getPartitionIndex(this.txWriter.getMaxTimestamp())) < this.getPartitionCount() - 1) {
            int n = this.getPartitionCount();
            for (int i = maxTimestampPartitionIndex + 1; i < n; ++i) {
                long timestamp = this.txWriter.getPartitionTimestampByIndex(i);
                long partitionTxn = this.txWriter.getPartitionNameTxn(i);
                this.partitionRemoveCandidates.add(timestamp, partitionTxn);
            }
            this.txWriter.reconcileOptimisticPartitions();
            return true;
        }
        return false;
    }

    private void recoverFromMetaRenameFailure(CharSequence columnName) {
        TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
    }

    private void recoverFromSwapRenameFailure(CharSequence columnName) {
        this.recoverFromTodoWriteFailure(columnName);
        this.clearTodoLog();
    }

    private void recoverFromSymbolMapWriterFailure(CharSequence columnName) {
        this.removeSymbolMapFilesQuiet(columnName, this.getTxn());
        this.removeMetaFile();
        this.recoverFromSwapRenameFailure(columnName);
    }

    private void recoverFromTodoWriteFailure(CharSequence columnName) {
        this.restoreMetaFrom("_meta.prev", this.metaPrevIndex);
        TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
    }

    private void recoverOpenColumnFailure(CharSequence columnName) {
        int index = this.columnCount - 1;
        this.removeMetaFile();
        this.removeLastColumn();
        --this.columnCount;
        this.recoverFromSwapRenameFailure(columnName);
        this.removeSymbolMapWriter(index);
    }

    private void releaseLock(boolean distressed) {
        if ((long)this.lockFd != -1L) {
            if (distressed) {
                this.ff.close(this.lockFd);
                return;
            }
            try {
                TableUtils.lockName(this.path);
                TableUtils.removeOrException(this.ff, this.lockFd, this.path);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private ReadOnlyObjList<? extends MemoryCR> remapWalSymbols(SymbolMapDiffCursor symbolMapDiffCursor, long rowLo, long rowHi, Path walPath, long destRowLo) {
        this.o3ColumnOverrides.clear();
        if (symbolMapDiffCursor != null) {
            SymbolMapDiff symbolMapDiff;
            while ((symbolMapDiff = symbolMapDiffCursor.nextSymbolMapDiff()) != null) {
                int columnIndex = symbolMapDiff.getColumnIndex();
                int columnType = this.metadata.getColumnType(columnIndex);
                if (columnType == -12) {
                    symbolMapDiff.drain();
                    continue;
                }
                if (!ColumnType.isSymbol(columnType)) {
                    throw CairoException.critical(0).put("WAL column and table writer column types don't match [columnIndex=").put(columnIndex).put(", walPath=").put(walPath).put(']');
                }
                boolean identical = this.createWalSymbolMapping(symbolMapDiff, columnIndex, this.symbolRewriteMap);
                if (identical) continue;
                int primaryColumnIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
                MemoryCR o3SymbolColumn = this.o3Columns.getQuick(primaryColumnIndex);
                if (this.o3ColumnOverrides.size() == 0) {
                    this.o3ColumnOverrides.addAll(this.o3Columns);
                }
                MemoryCARW symbolColumnDest = this.o3MemColumns.get(primaryColumnIndex);
                long destOffset = destRowLo - rowLo << 2;
                symbolColumnDest.jumpTo(destOffset + (rowHi << 2));
                this.o3ColumnOverrides.setQuick(primaryColumnIndex, symbolColumnDest);
                int cleanSymbolCount = symbolMapDiff.getCleanSymbolCount();
                for (long rowId = rowLo; rowId < rowHi; ++rowId) {
                    long valueOffset = rowId << 2;
                    int symKey = o3SymbolColumn.getInt(valueOffset);
                    assert (symKey >= 0 || symKey == Integer.MIN_VALUE);
                    if (symKey >= cleanSymbolCount) {
                        int newKey = this.symbolRewriteMap.getQuick(symKey - cleanSymbolCount);
                        if (newKey < 0) {
                            throw CairoException.critical(0).put("WAL symbol key not mapped [columnIndex=").put(columnIndex).put(", columnKey=").put(symKey).put(", walPath=").put(walPath).put(", walRowId=").put(rowId).put(']');
                        }
                        symKey = newKey;
                    }
                    symbolColumnDest.putInt(destOffset + valueOffset, symKey);
                }
            }
        }
        if (this.o3ColumnOverrides.size() == 0) {
            return this.o3Columns;
        }
        return this.o3ColumnOverrides;
    }

    private void removeColumn(int columnIndex) {
        int pi = TableWriter.getPrimaryColumnIndex(columnIndex);
        int si = TableWriter.getSecondaryColumnIndex(columnIndex);
        this.freeNullSetter(this.nullSetters, columnIndex);
        this.freeNullSetter(this.o3NullSetters, columnIndex);
        this.freeNullSetter(this.o3NullSetters2, columnIndex);
        this.freeAndRemoveColumnPair(this.columns, pi, si);
        this.freeAndRemoveO3ColumnPair(this.o3MemColumns, pi, si);
        this.freeAndRemoveO3ColumnPair(this.o3MemColumns2, pi, si);
        if (columnIndex < this.indexers.size()) {
            Misc.free(this.indexers.getAndSetQuick(columnIndex, null));
            this.populateDenseIndexerList();
        }
    }

    private void removeColumnFiles(int columnIndex, int columnType) {
        PurgingOperator purgingOperator = this.getPurgingOperator();
        long defaultNameTxn = this.columnVersionWriter.getDefaultColumnNameTxn(columnIndex);
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            int i = this.txWriter.getPartitionCount() - 1;
            while ((long)i > -1L) {
                long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
                if (!this.txWriter.isPartitionReadOnlyByPartitionTimestamp(partitionTimestamp)) {
                    long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                    long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
                    purgingOperator.add(columnIndex, columnNameTxn, partitionTimestamp, partitionNameTxn);
                }
                --i;
            }
        } else {
            purgingOperator.add(columnIndex, defaultNameTxn, this.txWriter.getLastPartitionTimestamp(), -1L);
        }
        if (ColumnType.isSymbol(columnType)) {
            purgingOperator.add(columnIndex, defaultNameTxn, -9223372036854775807L, -1L);
        }
    }

    private void removeColumnFilesInPartition(CharSequence columnName, int columnIndex, long partitionTimestamp) {
        if (!this.txWriter.isPartitionReadOnlyByPartitionTimestamp(partitionTimestamp)) {
            TableUtils.setPathForPartition(this.path, this.partitionBy, partitionTimestamp, -1L);
            int plen = this.path.length();
            long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
            TableWriter.removeFileAndOrLog(this.ff, TableUtils.dFile(this.path, columnName, columnNameTxn));
            TableWriter.removeFileAndOrLog(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName, columnNameTxn));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn));
            this.path.trimTo(this.rootLen);
        } else {
            LOG.critical().$("o3 ignoring removal of column in read-only partition [table=").utf8(this.tableToken.getTableName()).$(", columnName=").utf8(columnName).$(", timestamp=").$ts(partitionTimestamp).$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeColumnFromMeta(int index) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount);
            this.ddlMem.putInt(this.partitionBy);
            if (timestampIndex == index) {
                this.ddlMem.putInt(-1);
            } else {
                this.ddlMem.putInt(timestampIndex);
            }
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < this.columnCount; ++i) {
                this.writeColumnEntry(i, i == index);
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)Vm.getStorageLength(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIndexFiles(CharSequence columnName, int columnIndex) {
        try {
            int i = this.txWriter.getPartitionCount() - 1;
            while ((long)i > -1L) {
                long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(i);
                long partitionNameTxn = this.txWriter.getPartitionNameTxn(i);
                this.removeIndexFilesInPartition(columnName, columnIndex, partitionTimestamp, partitionNameTxn);
                --i;
            }
            if (!PartitionBy.isPartitioned(this.partitionBy)) {
                this.removeColumnFilesInPartition(columnName, columnIndex, this.txWriter.getLastPartitionTimestamp());
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeIndexFilesInPartition(CharSequence columnName, int columnIndex, long partitionTimestamp, long partitionNameTxn) {
        TableUtils.setPathForPartition(this.path, this.partitionBy, partitionTimestamp, partitionNameTxn);
        int plen = this.path.length();
        long columnNameTxn = this.columnVersionWriter.getColumnNameTxn(partitionTimestamp, columnIndex);
        TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        this.path.trimTo(this.rootLen);
    }

    private void removeLastColumn() {
        this.removeColumn(this.columnCount - 1);
    }

    private void removeMetaFile() {
        try {
            this.path.concat("_meta").$();
            if (this.ff.exists(this.path) && !this.ff.remove(this.path)) {
                this.other.concat("_meta").put('.').put(this.configuration.getMicrosecondClock().getTicks()).$();
                if (this.ff.rename(this.path, this.other) != 0) {
                    LOG.error().$("could not remove [path=").$(this.path).$(']').$();
                    throw CairoException.critical(this.ff.errno()).put("Recovery failed. Cannot remove: ").put(this.path);
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void removeNonAttachedPartitions() {
        LOG.debug().$("purging non attached partitions [path=").$(this.path.$()).I$();
        try {
            this.ff.iterateDir(this.path.$(), this.removePartitionDirsNotAttached);
            this.processPartitionRemoveCandidates();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirsNotAttached(long pUtf8NameZ, int type) {
        int checkedType = this.ff.typeDirOrSoftLinkDirNoDots(this.path, this.rootLen, pUtf8NameZ, type, this.fileNameSink);
        if (!(checkedType == 0 || CairoKeywords.isDetachedDirMarker(pUtf8NameZ) || CairoKeywords.isWal(pUtf8NameZ) || CairoKeywords.isTxnSeq(pUtf8NameZ) || CairoKeywords.isSeq(pUtf8NameZ) || Chars.endsWith((CharSequence)this.fileNameSink, this.configuration.getAttachPartitionSuffix()))) {
            try {
                long txn = 0L;
                int txnSep = Chars.indexOf(this.fileNameSink, '.');
                if (txnSep < 0) {
                    txnSep = this.fileNameSink.length();
                } else {
                    txn = Numbers.parseLong(this.fileNameSink, txnSep + 1, this.fileNameSink.length());
                }
                long dirTimestamp = this.partitionDirFmt.parse(this.fileNameSink, 0, txnSep, null);
                if (txn <= this.txWriter.txn && (this.txWriter.attachedPartitionsContains(dirTimestamp) || this.txWriter.isActivePartition(dirTimestamp))) {
                    return;
                }
                this.partitionRemoveCandidates.add(dirTimestamp, txn);
                this.path.trimTo(this.rootLen).$();
            }
            catch (NumericException ignore) {
                this.path.trimTo(this.rootLen);
                this.path.concat(pUtf8NameZ).$();
                LOG.error().$("invalid partition directory inside table folder: ").utf8(this.path).$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSymbolMapFilesQuiet(CharSequence name, long columnNamTxn) {
        try {
            TableWriter.removeFileAndOrLog(this.ff, TableUtils.offsetFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
            TableWriter.removeFileAndOrLog(this.ff, TableUtils.charFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), name, columnNamTxn));
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeSymbolMapWriter(int index) {
        MapWriter writer = this.symbolMapWriters.getAndSetQuick(index, NullMapWriter.INSTANCE);
        if (writer != null && writer != NullMapWriter.INSTANCE) {
            for (int symColIndex = this.denseSymbolMapWriters.remove(writer); symColIndex < this.denseSymbolMapWriters.size(); ++symColIndex) {
                MapWriter w = this.denseSymbolMapWriters.getQuick(symColIndex);
                w.setSymbolIndexInTxWriter(symColIndex);
            }
            Misc.freeIfCloseable(writer);
        }
    }

    private int rename(int retries) {
        try {
            int index = 0;
            this.other.concat("_meta.prev").$();
            this.path.concat("_meta").$();
            int l = this.other.length();
            do {
                if (index > 0) {
                    this.other.trimTo(l);
                    this.other.put('.').put(index);
                    this.other.$();
                }
                if (this.ff.exists(this.other) && !this.ff.remove(this.other)) {
                    LOG.info().$("could not remove target of rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).I$();
                    ++index;
                    continue;
                }
                if (this.ff.rename(this.path, this.other) != 0) {
                    LOG.info().$("could not rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).I$();
                    ++index;
                    continue;
                }
                int n = index;
                return n;
            } while (index < retries);
            throw CairoException.critical(0).put("could not rename ").put(this.path).put(". Max number of attempts reached [").put(index).put("]. Last target was: ").put(this.other);
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int renameColumnFromMeta(int index, CharSequence newName) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount);
            this.ddlMem.putInt(this.partitionBy);
            this.ddlMem.putInt(timestampIndex);
            this.copyVersionAndLagValues();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < this.columnCount; ++i) {
                this.writeColumnEntry(i, false);
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                nameOffset += (long)Vm.getStorageLength(columnName);
                if (i == index && TableUtils.getColumnType(this.metaMem, i) > 0) {
                    columnName = newName;
                }
                this.ddlMem.putStr(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void renameMetaToMetaPrev(CharSequence columnName) {
        try {
            this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void renameSwapMetaToMeta(CharSequence columnName) {
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_SWAP_RENAME_FAILURE, columnName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long repairDataGaps(long timestamp) {
        if (this.txWriter.getMaxTimestamp() != Long.MIN_VALUE && PartitionBy.isPartitioned(this.partitionBy)) {
            long expectedSize;
            long fixedRowCount = 0L;
            long lastTimestamp = -1L;
            long transientRowCount = this.txWriter.getTransientRowCount();
            long maxTimestamp = this.txWriter.getMaxTimestamp();
            try {
                long tsLimit = this.txWriter.getPartitionTimestampByTimestamp(this.txWriter.getMaxTimestamp());
                long ts = this.txWriter.getPartitionTimestampByTimestamp(this.txWriter.getMinTimestamp());
                while (ts < tsLimit) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, ts);
                    int p = this.path.length();
                    long partitionSize = this.txWriter.getPartitionSizeByPartitionTimestamp(ts);
                    if (partitionSize >= 0L && this.ff.exists(this.path.$())) {
                        fixedRowCount += partitionSize;
                        lastTimestamp = ts;
                    } else {
                        Path other = Path.getThreadLocal2(this.path.trimTo(p).$());
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (this.ff.rename(other, this.path) != 0) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).I$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$(this.path).I$();
                        } else {
                            LOG.debug().$("missing partition [name=").$(this.path.trimTo(p).$()).I$();
                        }
                    }
                    ts = this.txWriter.getNextPartitionTimestamp(ts);
                }
                if (lastTimestamp > -1L) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, tsLimit);
                    if (!this.ff.exists(this.path.$())) {
                        Path other = Path.getThreadLocal2(this.path);
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (this.ff.rename(other, this.path) != 0) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).I$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$(this.path).I$();
                        } else {
                            LOG.error().$("last partition does not exist [name=").$(this.path).I$();
                            this.path.trimTo(this.rootLen);
                            this.setStateForTimestamp(this.path, lastTimestamp);
                            int p = this.path.length();
                            transientRowCount = this.txWriter.getPartitionSizeByPartitionTimestamp(lastTimestamp);
                            TableUtils.dFile(this.path.trimTo(p), this.metadata.getColumnName(this.metadata.getTimestampIndex()), -1L);
                            maxTimestamp = TableUtils.readLongAtOffset(this.ff, this.path, this.tempMem16b, (transientRowCount - 1L) * 8L);
                            fixedRowCount -= transientRowCount;
                            this.txWriter.removeAttachedPartitions(this.txWriter.getMaxTimestamp());
                            LOG.info().$("updated active partition [name=").$(this.path.trimTo(p).$()).$(", maxTimestamp=").$ts(maxTimestamp).$(", transientRowCount=").$(transientRowCount).$(", fixedRowCount=").$(this.txWriter.getFixedRowCount()).I$();
                        }
                    }
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
            if ((expectedSize = this.txWriter.unsafeReadFixedRowCount()) != fixedRowCount || maxTimestamp != this.txWriter.getMaxTimestamp()) {
                LOG.info().$("actual table size has been adjusted [name=`").utf8(this.tableToken.getTableName()).$('`').$(", expectedFixedSize=").$(expectedSize).$(", actualFixedSize=").$(fixedRowCount).I$();
                this.txWriter.reset(fixedRowCount, transientRowCount, maxTimestamp, this.denseSymbolMapWriters);
                return maxTimestamp;
            }
        }
        return timestamp;
    }

    private void repairMetaRename(int index) {
        try {
            this.path.concat("_meta.prev");
            if (index > 0) {
                this.path.put('.').put(index);
            }
            this.path.$();
            if (this.ff.exists(this.path)) {
                LOG.info().$("Repairing metadata from: ").$(this.path).$();
                if (this.ff.exists(this.other.concat("_meta").$()) && !this.ff.remove(this.other)) {
                    throw CairoException.critical(this.ff.errno()).put("Repair failed. Cannot replace ").put(this.other);
                }
                if (this.ff.rename(this.path, this.other) != 0) {
                    throw CairoException.critical(this.ff.errno()).put("Repair failed. Cannot rename ").put(this.path).put(" -> ").put(this.other);
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
        this.clearTodoLog();
    }

    private void repairTruncate() {
        LOG.info().$("repairing abnormally terminated truncate on ").$(this.path).$();
        this.scheduleRemoveAllPartitions();
        this.txWriter.truncate(this.columnVersionWriter.getVersion(), this.denseSymbolMapWriters);
        this.clearTodoLog();
        this.processPartitionRemoveCandidates();
    }

    private void resizePartitionUpdateSink() {
        if (this.o3PartitionUpdateSink == null) {
            this.o3PartitionUpdateSink = new PagedDirectLongList(3);
        }
        this.o3PartitionUpdateSink.clear();
        this.o3PartitionUpdateSink.setBlockSize(5 + this.metadata.getColumnCount());
    }

    private void restoreMetaFrom(CharSequence fromBase, int fromIndex) {
        try {
            this.path.concat(fromBase);
            if (fromIndex > 0) {
                this.path.put('.').put(fromIndex);
            }
            this.path.$();
            TableUtils.renameOrFail(this.ff, this.path, this.other.concat("_meta").$());
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void rollbackIndexes() {
        long maxRow = this.txWriter.getTransientRowCount() - 1L;
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            int fd = indexer.getFd();
            if (fd <= -1) continue;
            LOG.info().$("recovering index [fd=").$(fd).I$();
            indexer.rollback(maxRow);
        }
    }

    private void rollbackSymbolTables() {
        int expectedMapWriters = this.txWriter.unsafeReadSymbolColumnCount();
        for (int i = 0; i < expectedMapWriters; ++i) {
            this.denseSymbolMapWriters.getQuick(i).rollback(this.txWriter.unsafeReadSymbolWriterIndexOffset(i));
        }
    }

    private void rowAppend(ObjList<Runnable> activeNullSetters) {
        if ((this.masterRef & 1L) != 0L) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.rowValueIsNotNull.getQuick(i) >= this.masterRef) continue;
                activeNullSetters.getQuick(i).run();
            }
            ++this.masterRef;
        }
    }

    private void runFragile(FragileCode fragile, CharSequence columnName, CairoException e) {
        try {
            fragile.run(columnName);
        }
        catch (CairoException e2) {
            LOG.error().$("DOUBLE ERROR: 1st: {").$(e).$('}').$();
            this.throwDistressException(e2);
        }
        throw e;
    }

    private void safeDeletePartitionDir(long timestamp, long partitionNameTxn) {
        this.partitionRemoveCandidates.clear();
        this.partitionRemoveCandidates.add(timestamp, partitionNameTxn);
        this.processPartitionRemoveCandidates();
    }

    private void scheduleRemoveAllPartitions() {
        int i = this.txWriter.getPartitionCount() - 1;
        while ((long)i > -1L) {
            long timestamp = this.txWriter.getPartitionTimestampByIndex(i);
            long partitionTxn = this.txWriter.getPartitionNameTxn(i);
            this.partitionRemoveCandidates.add(timestamp, partitionTxn);
            --i;
        }
    }

    private void setAppendPosition(long rowCount, boolean doubleAllocate) {
        long recordLength = 0L;
        for (int i = 0; i < this.columnCount; ++i) {
            recordLength += this.setColumnSize(i, rowCount, doubleAllocate);
        }
        this.avgRecordSize = rowCount > 0L ? recordLength / rowCount : Math.max(this.avgRecordSize, recordLength);
    }

    private long setColumnSize(int columnIndex, long size, boolean doubleAllocate) {
        long dataSizeBytes = 0L;
        try {
            MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
            MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
            int type = this.metadata.getColumnType(columnIndex);
            if (type > 0) {
                long pos = size - this.getColumnTop(columnIndex);
                if (pos > 0L) {
                    long m1pos;
                    switch (ColumnType.tagOf(type)) {
                        case 11: 
                        case 18: {
                            assert (mem2 != null);
                            if (doubleAllocate) {
                                mem2.allocate(pos * 8L + 8L);
                            }
                            mem2.jumpTo(pos * 8L);
                            m1pos = Unsafe.getUnsafe().getLong(mem2.getAppendAddress());
                            mem2.jumpTo((pos + 1L) * 8L);
                            dataSizeBytes = m1pos + (pos + 1L) * 8L;
                            break;
                        }
                        default: {
                            dataSizeBytes = m1pos = pos << ColumnType.pow2SizeOf(type);
                        }
                    }
                    if (doubleAllocate) {
                        mem1.allocate(m1pos);
                    }
                    mem1.jumpTo(m1pos);
                } else {
                    mem1.jumpTo(0L);
                    dataSizeBytes = ColumnType.sizeOf(type);
                    if (mem2 != null) {
                        mem2.jumpTo(0L);
                        mem2.putLong(0L);
                        dataSizeBytes = 28L;
                    }
                }
            }
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        return dataSizeBytes;
    }

    private void setO3AppendPosition(long position) {
        for (int i = 0; i < this.columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (columnType <= 0) continue;
            this.o3SetAppendOffset(i, columnType, position);
        }
    }

    private void setRowValueNotNull(int columnIndex) {
        assert (this.rowValueIsNotNull.getQuick(columnIndex) != this.masterRef);
        this.rowValueIsNotNull.setQuick(columnIndex, this.masterRef);
    }

    private void setStateForTimestamp(Path path, long timestamp) {
        long partitionTxnName = PartitionBy.isPartitioned(this.partitionBy) ? this.txWriter.getTxn() - 1L : -1L;
        partitionTxnName = this.txWriter.getPartitionNameTxnByPartitionTimestamp(timestamp, partitionTxnName);
        TableUtils.setPathForPartition(path, this.partitionBy, timestamp, partitionTxnName);
    }

    private void shrinkO3Mem() {
        int i;
        int n = this.o3MemColumns.size();
        for (i = 0; i < n; ++i) {
            MemoryCARW o3mem = this.o3MemColumns.getQuick(i);
            if (o3mem == null) continue;
            o3mem.truncate();
        }
        n = this.o3MemColumns2.size();
        for (i = 0; i < n; ++i) {
            MemoryCARW o3mem2 = this.o3MemColumns2.getQuick(i);
            if (o3mem2 == null) continue;
            o3mem2.truncate();
        }
    }

    private void squashPartitionForce(int partitionIndex) {
        int lastLogicalPartitionIndex = partitionIndex;
        long lastLogicalPartitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex);
        assert (lastLogicalPartitionTimestamp == this.txWriter.getLogicalPartitionTimestamp(lastLogicalPartitionTimestamp));
        while (partitionIndex < this.txWriter.getPartitionCount()) {
            long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex);
            long logicalPartitionTimestamp = this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp);
            if (logicalPartitionTimestamp != lastLogicalPartitionTimestamp) {
                if (partitionIndex > lastLogicalPartitionIndex + 1) {
                    this.squashSplitPartitions(lastLogicalPartitionIndex, partitionIndex, 1, true);
                }
                return;
            }
            ++partitionIndex;
        }
        if (partitionIndex > lastLogicalPartitionIndex + 1) {
            this.squashSplitPartitions(lastLogicalPartitionIndex, partitionIndex, 1, true);
        }
    }

    private void squashPartitionRange(int maxLastSubPartitionCount, int partitionIndexLo, int partitionIndexHi) {
        if (partitionIndexHi > partitionIndexLo) {
            int optimalPartitionCount;
            int subpartitions = partitionIndexHi - partitionIndexLo;
            int n = optimalPartitionCount = partitionIndexHi == this.txWriter.getPartitionCount() ? maxLastSubPartitionCount : 1;
            if (subpartitions > Math.max(1, optimalPartitionCount)) {
                this.squashSplitPartitions(partitionIndexLo, partitionIndexHi, optimalPartitionCount, false);
            } else if (subpartitions == 1 && partitionIndexLo >= 0 && partitionIndexLo < this.txWriter.getPartitionCount() && this.minSplitPartitionTimestamp == this.txWriter.getPartitionTimestampByIndex(partitionIndexLo)) {
                this.minSplitPartitionTimestamp = this.getPartitionTimestampOrMax(partitionIndexLo + 1);
            }
        }
    }

    private long squashPartitionTimestamp(long ts) {
        int partitionIndex = this.txWriter.findAttachedPartitionIndexByLoTimestamp(ts);
        if (partitionIndex < 0) {
            partitionIndex = -partitionIndex - 1;
        }
        if (partitionIndex >= this.txWriter.getPartitionCount()) {
            return Long.MAX_VALUE;
        }
        return this.txWriter.getLogicalPartitionTimestamp(this.txWriter.getPartitionTimestampByIndex(partitionIndex));
    }

    private void squashSplitPartitions(long timestampMin, long timestampMax, int maxLastSubPartitionCount) {
        if (timestampMin > this.txWriter.getMaxTimestamp() || this.txWriter.getPartitionCount() < 2) {
            return;
        }
        long logicalPartition = this.squashPartitionTimestamp(timestampMin);
        int partitionIndex = this.txWriter.getPartitionIndex(logicalPartition);
        if (partitionIndex > -1) {
            int partitionIndexLo = partitionIndex;
            int partitionCount = this.txWriter.getPartitionCount();
            while (logicalPartition < timestampMax && ++partitionIndex < partitionCount) {
                long partitionTimestamp = this.txWriter.getPartitionTimestampByIndex(partitionIndex);
                long newLogicalPartition = this.txWriter.getLogicalPartitionTimestamp(partitionTimestamp);
                if (logicalPartition == newLogicalPartition) continue;
                this.squashPartitionRange(maxLastSubPartitionCount, partitionIndexLo, partitionIndex);
                partitionCount = this.txWriter.getPartitionCount();
                partitionIndex = this.txWriter.getPartitionIndex(newLogicalPartition);
                logicalPartition = newLogicalPartition;
                partitionIndexLo = partitionIndex;
            }
            long lastPartitionTimestamp = this.txWriter.getLastPartitionTimestamp();
            this.squashPartitionRange(maxLastSubPartitionCount, partitionIndexLo, partitionIndex);
            if (lastPartitionTimestamp != this.txWriter.getLastPartitionTimestamp()) {
                this.openLastPartition();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void squashSplitPartitions(int partitionIndexLo, int partitionIndexHi, int optimalPartitionCount, boolean force) {
        assert (partitionIndexHi >= 0 && partitionIndexHi <= this.txWriter.getPartitionCount() && partitionIndexLo >= 0);
        int targetPartitionIndex = partitionIndexLo;
        if (partitionIndexHi > partitionIndexLo + 1) {
            long targetPartition = Long.MIN_VALUE;
            boolean copyTargetFrame = false;
            while (targetPartitionIndex + 1 < partitionIndexHi) {
                boolean canOverwrite = this.canSquashOverwritePartitionTail(targetPartitionIndex);
                if (canOverwrite || force) {
                    targetPartition = this.txWriter.getPartitionTimestampByIndex(partitionIndexLo);
                    copyTargetFrame = !canOverwrite;
                    break;
                }
                ++targetPartitionIndex;
            }
            if (targetPartition == Long.MIN_VALUE) {
                return;
            }
            boolean lastPartitionSquashed = false;
            int squashCount = partitionIndexHi - partitionIndexLo - optimalPartitionCount;
            if (squashCount > 0) {
                long targetPartitionNameTxn = this.txWriter.getPartitionNameTxnByPartitionTimestamp(targetPartition);
                TableUtils.setPathForPartition(this.path, this.partitionBy, targetPartition, targetPartitionNameTxn);
                long originalSize = this.txWriter.getPartitionSizeByPartitionTimestamp(targetPartition);
                boolean rw = !copyTargetFrame;
                Frame targetFrame = null;
                Frame firstPartitionFrame = this.partitionFrameFactory.open(rw, this.path, targetPartition, this.metadata, this.columnVersionWriter, originalSize);
                try {
                    if (copyTargetFrame) {
                        try {
                            TableUtils.setPathForPartition(this.other, this.partitionBy, targetPartition, this.txWriter.txn);
                            TableUtils.createDirsOrFail(this.ff, this.other.slash$(), this.configuration.getMkDirMode());
                            LOG.info().$("copying partition to force squash [from=").$(this.path).$(", to=").$(this.other).I$();
                            targetFrame = this.partitionFrameFactory.openRW(this.other, targetPartition, this.metadata, this.columnVersionWriter, 0L);
                            FrameAlgebra.append(targetFrame, firstPartitionFrame, this.configuration.getCommitMode());
                            this.physicallyWrittenRowsSinceLastCommit.addAndGet(firstPartitionFrame.getSize());
                            this.txWriter.updatePartitionSizeAndTxnByRawIndex(partitionIndexLo * 4, originalSize);
                            this.partitionRemoveCandidates.add(targetPartition, targetPartitionNameTxn);
                        }
                        finally {
                            Misc.free(firstPartitionFrame);
                        }
                    } else {
                        targetFrame = firstPartitionFrame;
                    }
                    for (int i = 0; i < squashCount; ++i) {
                        long sourcePartition = this.txWriter.getPartitionTimestampByIndex(partitionIndexLo + 1);
                        this.other.trimTo(this.rootLen);
                        long sourceNameTxn = this.txWriter.getPartitionNameTxnByPartitionTimestamp(sourcePartition);
                        TableUtils.setPathForPartition(this.other, this.partitionBy, sourcePartition, sourceNameTxn);
                        long partitionSize = this.txWriter.getPartitionSizeByPartitionTimestamp(sourcePartition);
                        boolean bl = lastPartitionSquashed = partitionIndexLo + 2 == this.txWriter.getPartitionCount();
                        if (lastPartitionSquashed) {
                            this.closeActivePartition(false);
                            partitionSize = this.txWriter.getTransientRowCount() + (long)this.txWriter.getLagRowCount();
                        }
                        assert (partitionSize > 0L);
                        LOG.info().$("squashing partitions [table=").$(this.tableToken).$(", target=").$(this.formatPartitionForTimestamp(targetPartition, targetPartitionNameTxn)).$(", targetSize=").$(targetFrame.getSize()).$(", source=").$(this.formatPartitionForTimestamp(sourcePartition, sourceNameTxn)).$(", sourceSize=").$(partitionSize).I$();
                        try (Frame sourceFrame = this.partitionFrameFactory.openRO(this.other, sourcePartition, this.metadata, this.columnVersionWriter, partitionSize);){
                            FrameAlgebra.append(targetFrame, sourceFrame, this.configuration.getCommitMode());
                            this.physicallyWrittenRowsSinceLastCommit.addAndGet(sourceFrame.getSize());
                        }
                        catch (Throwable th) {
                            LOG.critical().$("partition squashing failed [table=").$(this.tableToken).$(", error=").$(th).I$();
                            throw th;
                        }
                        this.txWriter.removeAttachedPartitions(sourcePartition);
                        this.columnVersionWriter.removePartition(sourcePartition);
                        this.txWriter.updatePartitionColumnVersion(targetPartition);
                        this.partitionRemoveCandidates.add(sourcePartition, sourceNameTxn);
                        if (sourcePartition != this.minSplitPartitionTimestamp) continue;
                        this.minSplitPartitionTimestamp = this.getPartitionTimestampOrMax(partitionIndexLo + 1);
                    }
                    this.txWriter.updatePartitionSizeByTimestamp(targetPartition, targetFrame.getSize());
                    if (lastPartitionSquashed) {
                        long newTransientRowCount = targetFrame.getSize() - (long)this.txWriter.getLagRowCount();
                        assert (newTransientRowCount >= 0L);
                        this.txWriter.fixedRowCount += this.txWriter.getTransientRowCount() - newTransientRowCount;
                        assert (this.txWriter.fixedRowCount >= 0L);
                        this.txWriter.transientRowCount = newTransientRowCount;
                    }
                }
                finally {
                    Misc.free(targetFrame);
                    this.path.trimTo(this.rootLen);
                    this.other.trimTo(this.rootLen);
                }
                this.columnVersionWriter.commit();
                this.txWriter.setColumnVersion(this.columnVersionWriter.getVersion());
                this.txWriter.commit(this.denseSymbolMapWriters);
                this.processPartitionRemoveCandidates();
            }
        }
    }

    private void swapMetaFile(CharSequence columnName) {
        this.metaMem.close();
        this.validateSwapMeta(columnName);
        this.renameMetaToMetaPrev(columnName);
        this.writeRestoreMetaTodo(columnName);
        this.renameSwapMetaToMeta(columnName);
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.bumpMetadataVersion();
    }

    private void swapO3ColumnsExcept(int timestampIndex) {
        ObjList<MemoryCARW> temp = this.o3MemColumns;
        this.o3MemColumns = this.o3MemColumns2;
        this.o3MemColumns2 = temp;
        int timestampMemoryIndex = TableWriter.getPrimaryColumnIndex(timestampIndex);
        this.o3MemColumns2.setQuick(timestampMemoryIndex, this.o3MemColumns.getAndSetQuick(timestampMemoryIndex, this.o3MemColumns2.getQuick(timestampMemoryIndex)));
        this.o3Columns = this.o3MemColumns;
        this.activeColumns = this.o3MemColumns;
        ObjList<Runnable> tempNullSetters = this.o3NullSetters;
        this.o3NullSetters = this.o3NullSetters2;
        this.o3NullSetters2 = tempNullSetters;
        this.activeNullSetters = this.o3NullSetters;
    }

    private void switchPartition(long timestamp) {
        this.updateIndexes();
        this.txWriter.switchPartitions(timestamp);
        this.openPartition(timestamp);
        this.setAppendPosition(0L, false);
    }

    private void syncColumns() {
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            int i;
            boolean async = commitMode == 0;
            this.syncColumns0(async);
            int n = this.denseIndexers.size();
            for (i = 0; i < n; ++i) {
                this.denseIndexers.getQuick(i).sync(async);
            }
            n = this.denseSymbolMapWriters.size();
            for (i = 0; i < n; ++i) {
                this.denseSymbolMapWriters.getQuick(i).sync(async);
            }
        }
    }

    private void syncColumns0(boolean async) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns.getQuick(i * 2).sync(async);
            MemoryMA m2 = this.columns.getQuick(i * 2 + 1);
            if (m2 == null) continue;
            m2.sync(async);
        }
    }

    private void throwDistressException(CairoException cause) {
        LOG.critical().$("writer error [table=").utf8(this.tableToken.getTableName()).$(", e=").$(cause).I$();
        this.distressed = true;
        throw new CairoError(cause);
    }

    private void truncate(boolean keepSymbolTables) {
        int i;
        int n;
        this.rollback();
        if (!keepSymbolTables) {
            n = this.denseSymbolMapWriters.size();
            for (i = 0; i < n; ++i) {
                this.denseSymbolMapWriters.getQuick(i).truncate();
            }
        }
        if (this.size() == 0L) {
            return;
        }
        this.todoMem.putLong(0L, ++this.todoTxn);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
        this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(24L, this.todoTxn);
        this.todoMem.putLong(32L, 1L);
        this.todoMem.putLong(40L, 1L);
        this.todoMem.jumpTo(48L);
        if (this.partitionBy != 3) {
            this.freeColumns(false);
            if (this.indexers != null) {
                n = this.indexers.size();
                for (i = 0; i < n; ++i) {
                    Misc.free(this.indexers.getQuick(i));
                }
            }
            this.scheduleRemoveAllPartitions();
            this.rowAction = 0;
        } else {
            this.truncateColumns();
        }
        this.txWriter.resetTimestamp();
        this.columnVersionWriter.truncate();
        this.txWriter.truncate(this.columnVersionWriter.getVersion(), this.denseSymbolMapWriters);
        try {
            this.clearTodoLog();
        }
        catch (CairoException e) {
            this.throwDistressException(e);
        }
        this.minSplitPartitionTimestamp = Long.MAX_VALUE;
        this.processPartitionRemoveCandidates();
        LOG.info().$("truncated [name=").utf8(this.tableToken.getTableName()).I$();
    }

    private void truncateColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) < 0) continue;
            this.getPrimaryColumn(i).truncate();
            MemoryMA mem = this.getSecondaryColumn(i);
            if (mem == null || !mem.isOpen()) continue;
            mem.truncate();
            mem.putLong(0L);
        }
    }

    private void updateIndexes() {
        if (this.indexCount == 0 || this.avoidIndexOnCommit) {
            this.avoidIndexOnCommit = false;
            return;
        }
        this.updateIndexesSlow();
    }

    private void updateIndexesParallel(long lo, long hi) {
        int i;
        this.indexSequences.clear();
        this.indexLatch.setCount(this.indexCount);
        int nParallelIndexes = this.indexCount - 1;
        Sequence indexPubSequence = this.messageBus.getIndexerPubSequence();
        RingQueue<ColumnIndexerTask> indexerQueue = this.messageBus.getIndexerQueue();
        LOG.info().$("parallel indexing [table=").utf8(this.tableToken.getTableName()).$(", indexCount=").$(this.indexCount).$(", rowCount=").$(hi - lo).I$();
        int serialIndexCount = 0;
        block0: for (i = 0; i < nParallelIndexes; ++i) {
            long cursor = indexPubSequence.next();
            if (cursor == -1L) {
                TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                ++serialIndexCount;
                continue;
            }
            if (cursor == -2L) {
                do {
                    Os.pause();
                    cursor = indexPubSequence.next();
                    if (cursor != -1L) continue;
                    TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                    ++serialIndexCount;
                    continue block0;
                } while (cursor < 0L);
            }
            ColumnIndexerTask queueItem = indexerQueue.get(cursor);
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long sequence = indexer.getSequence();
            queueItem.indexer = indexer;
            queueItem.lo = lo;
            queueItem.hi = hi;
            queueItem.countDownLatch = this.indexLatch;
            queueItem.sequence = sequence;
            this.indexSequences.add(sequence);
            indexPubSequence.done(cursor);
        }
        TableWriter.indexAndCountDown(this.denseIndexers.getQuick(this.indexCount - 1), lo, hi, this.indexLatch);
        ++serialIndexCount;
        if (!this.indexLatch.await(this.configuration.getWorkStealTimeoutNanos())) {
            for (i = 0; i < nParallelIndexes; ++i) {
                ColumnIndexer indexer = this.denseIndexers.getQuick(i);
                if (!indexer.tryLock(this.indexSequences.getQuick(i))) continue;
                TableWriter.indexAndCountDown(indexer, lo, hi, this.indexLatch);
                ++serialIndexCount;
            }
            this.indexLatch.await();
        }
        boolean distressed = false;
        for (int i2 = 0; i2 < this.indexCount; ++i2) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i2);
            distressed |= indexer.isDistressed();
        }
        if (distressed) {
            this.throwDistressException(null);
        }
        LOG.info().$("parallel indexing done [serialCount=").$(serialIndexCount).I$();
    }

    private void updateIndexesSerially(long lo, long hi) {
        LOG.info().$("serial indexing [table=").utf8(this.tableToken.getTableName()).$(", indexCount=").$(this.indexCount).$(", rowCount=").$(hi - lo).I$();
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.denseIndexers.getQuick(i).refreshSourceAndIndex(lo, hi);
                continue;
            }
            catch (CairoException e) {
                this.throwDistressException(e);
            }
        }
        LOG.info().$("serial indexing done [table=").utf8(this.tableToken.getTableName()).I$();
    }

    private void updateIndexesSlow() {
        long lo;
        long hi = this.txWriter.getTransientRowCount();
        long l = lo = this.txWriter.getAppendedPartitionCount() == 1 ? hi - this.txWriter.getLastTxSize() : 0L;
        if (this.indexCount > 1 && this.parallelIndexerEnabled && hi - lo > (long)this.configuration.getParallelIndexThreshold()) {
            this.updateIndexesParallel(lo, hi);
        } else {
            this.updateIndexesSerially(lo, hi);
        }
    }

    private void updateMaxTimestamp(long timestamp) {
        this.txWriter.updateMaxTimestamp(timestamp);
        this.timestampSetter.accept(timestamp);
    }

    private void updateMetaStructureVersion() {
        try {
            this.copyMetadataAndUpdateVersion();
            this.finishMetaSwapUpdate();
            this.clearTodoLog();
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void updateO3ColumnTops() {
        int columnCount = this.metadata.getColumnCount();
        long blockIndex = -1L;
        while ((blockIndex = this.o3PartitionUpdateSink.nextBlockIndex(blockIndex)) > -1L) {
            long blockAddress = this.o3PartitionUpdateSink.getBlockAddress(blockIndex);
            long partitionTimestamp = Unsafe.getUnsafe().getLong(blockAddress);
            if (partitionTimestamp <= -1L) continue;
            blockAddress += 40L;
            for (int column = 0; column < columnCount; ++column) {
                long colTop = Unsafe.getUnsafe().getLong(blockAddress);
                blockAddress += 8L;
                if (colTop <= -1L) continue;
                this.columnVersionWriter.upsertColumnTop(partitionTimestamp, column, colTop);
            }
        }
    }

    private void validateSwapMeta(CharSequence columnName) {
        try {
            try {
                this.path.concat("_meta.swp");
                if (this.metaSwapIndex > 0) {
                    this.path.put('.').put(this.metaSwapIndex);
                }
                this.metaMem.smallFile(this.ff, this.path.$(), 5);
                this.validationMap.clear();
                TableUtils.validateMeta(this.metaMem, this.validationMap, 426);
            }
            finally {
                this.metaMem.close();
                this.path.trimTo(this.rootLen);
            }
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void writeColumnEntry(int i, boolean markDeleted) {
        int columnType = TableUtils.getColumnType(this.metaMem, i);
        if (markDeleted) {
            columnType = -Math.abs(columnType);
        }
        this.ddlMem.putInt(columnType);
        long flags = 0L;
        if (TableUtils.isColumnIndexed(this.metaMem, i)) {
            flags |= 1L;
        }
        if (TableUtils.isSequential(this.metaMem, i)) {
            flags |= 2L;
        }
        this.ddlMem.putLong(flags);
        this.ddlMem.putInt(TableUtils.getIndexBlockCapacity(this.metaMem, i));
        this.ddlMem.skip(16L);
    }

    private void writeRestoreMetaTodo(CharSequence columnName) {
        try {
            this.writeRestoreMetaTodo();
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_TODO_WRITE_FAILURE, columnName, e);
        }
    }

    private void writeRestoreMetaTodo() {
        this.todoMem.putLong(0L, ++this.todoTxn);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
        this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(32L, 1L);
        this.todoMem.putLong(40L, 2L);
        this.todoMem.putLong(48L, this.metaPrevIndex);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(24L, this.todoTxn);
        this.todoMem.jumpTo(56L);
        this.todoMem.sync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indexAndCountDown(ColumnIndexer indexer, long lo, long hi, SOCountDownLatch latch) {
        try {
            indexer.refreshSourceAndIndex(lo, hi);
        }
        catch (CairoException e) {
            indexer.distress();
            LOG.critical().$("index error [fd=").$(indexer.getFd()).$("]{").$(e).$('}').$();
        }
        finally {
            latch.countDown();
        }
    }

    boolean allowMixedIO() {
        return this.mixedIOFlag;
    }

    void closeActivePartition(long size) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnSize(i, size, false);
            Misc.free(this.getPrimaryColumn(i));
            Misc.free(this.getSecondaryColumn(i));
        }
        Misc.freeObjList(this.denseIndexers);
        this.denseIndexers.clear();
    }

    BitmapIndexWriter getBitmapIndexWriter(int columnIndex) {
        return this.indexers.getQuick(columnIndex).getWriter();
    }

    long getColumnTop(int columnIndex) {
        assert (this.lastOpenPartitionTs != Long.MIN_VALUE);
        return this.columnVersionWriter.getColumnTopQuick(this.lastOpenPartitionTs, columnIndex);
    }

    ColumnVersionReader getColumnVersionReader() {
        return this.columnVersionWriter;
    }

    CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    Sequence getO3CopyPubSeq() {
        return this.messageBus.getO3CopyPubSeq();
    }

    RingQueue<O3CopyTask> getO3CopyQueue() {
        return this.messageBus.getO3CopyQueue();
    }

    Sequence getO3OpenColumnPubSeq() {
        return this.messageBus.getO3OpenColumnPubSeq();
    }

    RingQueue<O3OpenColumnTask> getO3OpenColumnQueue() {
        return this.messageBus.getO3OpenColumnQueue();
    }

    long getPartitionNameTxnByRawIndex(int index) {
        return this.txWriter.getPartitionNameTxnByRawIndex(index);
    }

    long getPartitionSizeByRawIndex(int index) {
        return this.txWriter.getPartitionSizeByRawIndex(index);
    }

    TxReader getTxReader() {
        return this.txWriter;
    }

    void o3ClockDownPartitionUpdateCount() {
        this.o3PartitionUpdRemaining.decrementAndGet();
    }

    void o3CountDownDoneLatch() {
        this.o3DoneLatch.countDown();
    }

    void purgeUnusedPartitions() {
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            this.removeNonAttachedPartitions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rowCancel() {
        if ((this.masterRef & 1L) == 0L) {
            return;
        }
        if (this.hasO3()) {
            long o3RowCount = this.getO3RowCount0();
            if (o3RowCount > 0L) {
                --this.masterRef;
                this.setO3AppendPosition(o3RowCount);
            } else {
                this.setO3AppendPosition(0L);
                --this.masterRef;
                this.clearO3();
            }
            this.rowValueIsNotNull.fill(0, this.columnCount, this.masterRef);
            return;
        }
        long dirtyMaxTimestamp = this.txWriter.getMaxTimestamp();
        long dirtyTransientRowCount = this.txWriter.getTransientRowCount();
        long rollbackToMaxTimestamp = this.txWriter.cancelToMaxTimestamp();
        long rollbackToTransientRowCount = this.txWriter.cancelToTransientRowCount();
        if (dirtyTransientRowCount == 1L) {
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                this.closeActivePartition(false);
                if (this.removeDirOnCancelRow) {
                    try {
                        this.setStateForTimestamp(this.path, this.txWriter.getPartitionTimestampByTimestamp(dirtyMaxTimestamp));
                        int errno = this.ff.rmdir(this.path.$());
                        if (errno != 0) {
                            throw CairoException.critical(errno).put("Cannot remove directory: ").put(this.path);
                        }
                        this.removeDirOnCancelRow = false;
                    }
                    finally {
                        this.path.trimTo(this.rootLen);
                    }
                }
                if (rollbackToMaxTimestamp > Long.MIN_VALUE) {
                    try {
                        this.txWriter.setMaxTimestamp(rollbackToMaxTimestamp);
                        this.openPartition(rollbackToMaxTimestamp);
                        this.setAppendPosition(rollbackToTransientRowCount, false);
                    }
                    catch (Throwable e) {
                        this.freeColumns(false);
                        throw e;
                    }
                } else {
                    this.txWriter.removeAllPartitions();
                    this.rowAction = 0;
                }
                this.removeDirOnCancelRow = true;
                this.txWriter.cancelRow();
            } else {
                this.txWriter.cancelRow();
                this.truncateColumns();
            }
        } else {
            boolean rowChanged;
            this.txWriter.cancelRow();
            boolean bl = rowChanged = this.metadata.getTimestampIndex() >= 0;
            if (!rowChanged) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.rowValueIsNotNull.getQuick(i) != this.masterRef) continue;
                    rowChanged = true;
                    break;
                }
            }
            if (rowChanged) {
                this.setAppendPosition(dirtyTransientRowCount - 1L, false);
            }
        }
        this.rowValueIsNotNull.fill(0, this.columnCount, --this.masterRef);
        if (this.txWriter.transientRowCount > 0L) {
            --this.txWriter.transientRowCount;
        }
    }

    private class RowImpl
    implements Row {
        private RowImpl() {
        }

        @Override
        public void append() {
            TableWriter.this.rowAppend(TableWriter.this.activeNullSetters);
        }

        @Override
        public void cancel() {
            TableWriter.this.rowCancel();
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(address, len));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(sequence));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
            this.getPrimaryColumn(columnIndex).putBool(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putByte(int columnIndex, byte value) {
            this.getPrimaryColumn(columnIndex).putByte(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putChar(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putChar(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putDouble(int columnIndex, double value) {
            this.getPrimaryColumn(columnIndex).putDouble(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putFloat(int columnIndex, float value) {
            this.getPrimaryColumn(columnIndex).putFloat(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putGeoHash(int index, long value) {
            int type = TableWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, value, type, this);
        }

        @Override
        public void putGeoHashDeg(int index, double lat, double lon) {
            int type = TableWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, GeoHashes.fromCoordinatesDegUnsafe(lat, lon, ColumnType.getGeoHashBits(type)), type, this);
        }

        @Override
        public void putGeoStr(int index, CharSequence hash) {
            int type = TableWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoStr(index, hash, type, this);
        }

        @Override
        public void putInt(int columnIndex, int value) {
            this.getPrimaryColumn(columnIndex).putInt(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong(int columnIndex, long value) {
            this.getPrimaryColumn(columnIndex).putLong(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong128(int columnIndex, long lo, long hi) {
            MemoryA primaryColumn = this.getPrimaryColumn(columnIndex);
            primaryColumn.putLong(lo);
            primaryColumn.putLong(hi);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
            this.getPrimaryColumn(columnIndex).putLong256(l0, l1, l2, l3);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
            this.getPrimaryColumn(columnIndex).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString, start, end);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putShort(int columnIndex, short value) {
            this.getPrimaryColumn(columnIndex).putShort(value);
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, char value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value, pos, len));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStrUtf8AsUtf16(int columnIndex, DirectByteCharSequence value, boolean hasNonAsciiChars) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStrUtf8AsUtf16(value, hasNonAsciiChars));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
            this.getPrimaryColumn(columnIndex).putInt(TableWriter.this.symbolMapWriters.getQuick(columnIndex).put(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putInt(TableWriter.this.symbolMapWriters.getQuick(columnIndex).put(value));
            TableWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putUuid(int columnIndex, CharSequence uuidStr) {
            SqlUtil.implicitCastStrAsUuid(uuidStr, TableWriter.this.uuid);
            this.putLong128(columnIndex, TableWriter.this.uuid.getLo(), TableWriter.this.uuid.getHi());
        }

        private MemoryA getPrimaryColumn(int columnIndex) {
            return TableWriter.this.activeColumns.getQuick(TableWriter.getPrimaryColumnIndex(columnIndex));
        }

        private MemoryA getSecondaryColumn(int columnIndex) {
            return TableWriter.this.activeColumns.getQuick(TableWriter.getSecondaryColumnIndex(columnIndex));
        }
    }

    private static class NoOpRow
    implements Row {
        private NoOpRow() {
        }

        @Override
        public void append() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
        }

        @Override
        public void putByte(int columnIndex, byte value) {
        }

        @Override
        public void putChar(int columnIndex, char value) {
        }

        @Override
        public void putDate(int columnIndex, long value) {
        }

        @Override
        public void putDouble(int columnIndex, double value) {
        }

        @Override
        public void putFloat(int columnIndex, float value) {
        }

        @Override
        public void putGeoHash(int columnIndex, long value) {
        }

        @Override
        public void putGeoHashDeg(int index, double lat, double lon) {
        }

        @Override
        public void putGeoStr(int columnIndex, CharSequence value) {
        }

        @Override
        public void putInt(int columnIndex, int value) {
        }

        @Override
        public void putLong(int columnIndex, long value) {
        }

        @Override
        public void putLong128(int columnIndex, long lo, long hi) {
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
        }

        @Override
        public void putShort(int columnIndex, short value) {
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
        }

        @Override
        public void putStr(int columnIndex, char value) {
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
        }

        @Override
        public void putStrUtf8AsUtf16(int columnIndex, DirectByteCharSequence value, boolean hasNonAsciiChars) {
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
        }

        @Override
        public void putSym(int columnIndex, char value) {
        }

        @Override
        public void putSymIndex(int columnIndex, int key) {
        }

        @Override
        public void putSymUtf8(int columnIndex, DirectByteCharSequence value, boolean hasNonAsciiChars) {
        }

        @Override
        public void putTimestamp(int columnIndex, long value) {
        }

        @Override
        public void putUuid(int columnIndex, CharSequence uuid) {
        }
    }

    public static interface Row {
        public void append();

        public void cancel();

        public void putBin(int var1, long var2, long var4);

        public void putBin(int var1, BinarySequence var2);

        public void putBool(int var1, boolean var2);

        public void putByte(int var1, byte var2);

        public void putChar(int var1, char var2);

        default public void putDate(int columnIndex, long value) {
            this.putLong(columnIndex, value);
        }

        public void putDouble(int var1, double var2);

        public void putFloat(int var1, float var2);

        public void putGeoHash(int var1, long var2);

        public void putGeoHashDeg(int var1, double var2, double var4);

        public void putGeoStr(int var1, CharSequence var2);

        public void putInt(int var1, int var2);

        public void putLong(int var1, long var2);

        public void putLong128(int var1, long var2, long var4);

        public void putLong256(int var1, long var2, long var4, long var6, long var8);

        public void putLong256(int var1, Long256 var2);

        public void putLong256(int var1, CharSequence var2);

        public void putLong256(int var1, @NotNull CharSequence var2, int var3, int var4);

        public void putShort(int var1, short var2);

        public void putStr(int var1, CharSequence var2);

        public void putStr(int var1, char var2);

        public void putStr(int var1, CharSequence var2, int var3, int var4);

        public void putStrUtf8AsUtf16(int var1, DirectByteCharSequence var2, boolean var3);

        public void putSym(int var1, CharSequence var2);

        public void putSym(int var1, char var2);

        default public void putSymIndex(int columnIndex, int key) {
            this.putInt(columnIndex, key);
        }

        default public void putSymUtf8(int columnIndex, DirectByteCharSequence value, boolean hasNonAsciiChars) {
            throw new UnsupportedOperationException();
        }

        default public void putTimestamp(int columnIndex, long value) {
            this.putLong(columnIndex, value);
        }

        public void putUuid(int var1, CharSequence var2);
    }

    @FunctionalInterface
    public static interface O3ColumnUpdateMethod {
        public void run(int var1, int var2, long var3, long var5, long var7, long var9);
    }

    @FunctionalInterface
    private static interface FragileCode {
        public void run(CharSequence var1);
    }

    @FunctionalInterface
    public static interface ExtensionListener {
        public void onTableExtended(long var1);
    }
}

