/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.TableDescriptor;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;

public class TableConverter {
    private static final Log LOG = LogFactory.getLog(TableConverter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjList<TableToken> convertTables(CairoConfiguration configuration, TableSequencerAPI tableSequencerAPI) {
        ObjList<TableToken> convertedTables = new ObjList<TableToken>();
        if (!configuration.isTableTypeConversionEnabled()) {
            LOG.info().$("Table type conversion is disabled").$();
            return null;
        }
        if (configuration.isReadOnlyInstance()) {
            LOG.info().$("Read only instance is not allowed to perform table type conversion").$();
            return null;
        }
        Path path = Path.getThreadLocal(configuration.getRoot());
        int rootLen = path.length();
        StringSink sink = Misc.getThreadLocalBuilder();
        FilesFacade ff = configuration.getFilesFacade();
        long findPtr = ff.findFirst(path.$());
        try {
            do {
                if (!ff.isDirOrSoftLinkDirNoDots(path, rootLen, ff.findName(findPtr), ff.findType(findPtr), sink) || !ff.exists(path.concat("_convert").$())) continue;
                try {
                    String dirName = sink.toString();
                    boolean walEnabled = TableConverter.readWalEnabled(path, ff);
                    LOG.info().$("Converting table [dirName=").utf8(dirName).$(", walEnabled=").$(walEnabled).I$();
                    path.trimTo(rootLen).concat(dirName);
                    try (MemoryMARW metaMem = Vm.getMARWInstance();){
                        TableUtils.openSmallFile(ff, path, rootLen, metaMem, "_meta", 38);
                        if (metaMem.getBool(40L) == walEnabled) {
                            LOG.info().$("Skipping conversion, table already has the expected type [dirName=").utf8(dirName).$(", walEnabled=").$(walEnabled).I$();
                        } else {
                            String tableName;
                            try (MemoryCMR mem = Vm.getCMRInstance();){
                                String name = TableUtils.readTableName(path.of(configuration.getRoot()).concat(dirName), rootLen, mem, ff);
                                tableName = name != null ? name : dirName;
                            }
                            int tableId = metaMem.getInt(16L);
                            TableToken token = new TableToken(tableName, dirName, tableId, walEnabled);
                            if (walEnabled) {
                                try (TableReaderMetadata metadata = new TableReaderMetadata(configuration, token);){
                                    metadata.load();
                                    tableSequencerAPI.registerTable(tableId, new TableDescriptorImpl(metadata), token);
                                }
                            } else {
                                tableSequencerAPI.deregisterTable(token);
                                TableConverter.removeWalPersistence(path, rootLen, ff, dirName);
                            }
                            metaMem.putBool(40L, walEnabled);
                            convertedTables.add(token);
                        }
                        path.trimTo(rootLen).concat(dirName).concat("_convert").$();
                        if (!ff.remove(path)) {
                            LOG.error().$("Could not remove _convert file [path=").utf8(path).I$();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error().$("Table conversion failed [path=").utf8(path).$(", e=").$(e).I$();
                }
            } while (ff.findNext(findPtr) > 0);
        }
        finally {
            ff.findClose(findPtr);
        }
        return convertedTables;
    }

    private static boolean readWalEnabled(Path path, FilesFacade ff) {
        int fd = -1;
        try {
            fd = ff.openRO(path);
            if (fd < 1) {
                throw CairoException.critical(ff.errno()).put("Could not open file [path=").put(path).put(']');
            }
            byte walType = ff.readNonNegativeByte(fd, 0L);
            switch (walType) {
                case 1: {
                    boolean bl = true;
                    return bl;
                }
                case 0: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw CairoException.critical(ff.errno()).put("Could not read walType from file [path=").put(path).put(']');
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeWalPersistence(Path path, int rootLen, FilesFacade ff, String dirName) {
        path.trimTo(rootLen).concat(dirName).concat("txn_seq").$();
        if (ff.rmdir(path) != 0) {
            LOG.error().$("Could not remove sequencer dir [errno=").$(ff.errno()).$(", path=").$(path).I$();
        }
        path.trimTo(rootLen).concat(dirName).$();
        int plen = path.length();
        long pFind = ff.findFirst(path);
        if (pFind > 0L) {
            try {
                do {
                    long name = ff.findName(pFind);
                    int type = ff.findType(pFind);
                    if (!CairoKeywords.isWal(name)) continue;
                    path.trimTo(plen).concat(name).$();
                    if (type == 8 && CairoKeywords.isLock(name)) {
                        if (ff.remove(path)) continue;
                        LOG.error().$("Could not remove wal lock file [errno=").$(ff.errno()).$(", path=").$(path).I$();
                        continue;
                    }
                    if (ff.rmdir(path) == 0) continue;
                    LOG.error().$("Could not remove wal dir [errno=").$(ff.errno()).$(", path=").$(path).I$();
                } while (ff.findNext(pFind) > 0);
            }
            finally {
                ff.findClose(pFind);
            }
        }
    }

    private static class TableDescriptorImpl
    implements TableDescriptor {
        private final ObjList<CharSequence> columnNames = new ObjList();
        private final IntList columnTypes = new IntList();
        private final int timestampIndex;

        private TableDescriptorImpl(TableRecordMetadata metadata) {
            this.timestampIndex = metadata.getTimestampIndex();
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.columnNames.add(metadata.getColumnName(i));
                this.columnTypes.add(metadata.getColumnType(i));
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.columnNames.get(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            return this.columnTypes.get(columnIndex);
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampIndex;
        }
    }
}

