/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.str.Path;
import io.questdb.std.str.SingleCharCharSequence;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class SymbolMapWriter
implements Closeable,
MapWriter {
    public static final int HEADER_CACHE_ENABLED = 4;
    public static final int HEADER_CAPACITY = 0;
    public static final int HEADER_NULL_FLAG = 8;
    public static final int HEADER_SIZE = 64;
    private static final Log LOG = LogFactory.getLog(SymbolMapWriter.class);
    private final CharSequenceIntHashMap cache;
    private final MemoryMARW charMem;
    private final BitmapIndexWriter indexWriter;
    private final int maxHash;
    private final int symbolCapacity;
    private final SymbolValueCountCollector valueCountCollector;
    private boolean nullValue = false;
    private MemoryMARW offsetMem;
    private int symbolIndexInTxWriter;

    public SymbolMapWriter(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, int symbolCount, int symbolIndexInTxWriter, @NotNull SymbolValueCountCollector valueCountCollector) {
        int plen = path.length();
        try {
            FilesFacade ff = configuration.getFilesFacade();
            long mapPageSize = configuration.getMiscAppendPageSize();
            TableUtils.offsetFileName(path.trimTo(plen), name, columnNameTxn);
            if (!ff.exists(path)) {
                LOG.error().$(path).$(" is not found").$();
                throw CairoException.critical(0).put("SymbolMap does not exist: ").put(path);
            }
            long len = ff.length(path);
            if (len < 64L) {
                LOG.error().$(path).$(" is too short [len=").$(len).$(']').$();
                throw CairoException.critical(0).put("SymbolMap is too short: ").put(path);
            }
            this.offsetMem = Vm.getWholeMARWInstance(ff, path, mapPageSize, 14, configuration.getWriterFileOpenOpts());
            this.symbolCapacity = this.offsetMem.getInt(0L);
            assert (this.symbolCapacity > 0);
            boolean useCache = this.offsetMem.getBool(4L);
            this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(symbolCount) + 8L);
            this.indexWriter = new BitmapIndexWriter(configuration);
            this.indexWriter.of(path.trimTo(plen), name, columnNameTxn);
            this.charMem = Vm.getWholeMARWInstance(ff, TableUtils.charFileName(path.trimTo(plen), name, columnNameTxn), mapPageSize, 14, configuration.getWriterFileOpenOpts());
            this.jumpCharMemToSymbolCount(symbolCount);
            this.maxHash = Math.max(Numbers.ceilPow2(this.symbolCapacity / 2) - 1, 1);
            this.cache = useCache ? new CharSequenceIntHashMap(this.symbolCapacity, 0.3, -1) : null;
            this.symbolIndexInTxWriter = symbolIndexInTxWriter;
            this.valueCountCollector = valueCountCollector;
            LOG.debug().$("open [name=").$(path.trimTo(plen).concat(name).$()).$(", fd=").$(this.offsetMem.getFd()).$(", cache=").$(this.cache != null).$(", capacity=").$(this.symbolCapacity).I$();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    public static boolean mergeSymbols(MapWriter dst, SymbolMapReader src) {
        boolean remapped = false;
        int symbolCount = src.getSymbolCount();
        for (int srcId = 0; srcId < symbolCount; ++srcId) {
            if (dst.put(src.valueOf(srcId)) == srcId) continue;
            remapped = true;
        }
        dst.updateNullFlag(dst.getNullFlag() || src.containsNullValue());
        return remapped;
    }

    public static void mergeSymbols(MapWriter dst, SymbolMapReader src, MemoryMARW map) {
        map.jumpTo(0L);
        int symbolCount = src.getSymbolCount();
        for (int srcId = 0; srcId < symbolCount; ++srcId) {
            map.putInt(dst.put(src.valueOf(srcId)));
        }
        dst.updateNullFlag(dst.getNullFlag() || src.containsNullValue());
    }

    @Override
    public void close() {
        Misc.free(this.indexWriter);
        Misc.free(this.charMem);
        if (this.offsetMem != null) {
            int fd = this.offsetMem.getFd();
            this.offsetMem = Misc.free(this.offsetMem);
            LOG.debug().$("closed [fd=").$(fd).$(']').$();
        }
        this.nullValue = false;
    }

    @Override
    public boolean getNullFlag() {
        return this.offsetMem.getBool(8L);
    }

    @Override
    public int getSymbolCapacity() {
        return this.symbolCapacity;
    }

    @Override
    public int getSymbolCount() {
        return SymbolMapWriter.offsetToKey(this.offsetMem.getAppendOffset() - 8L);
    }

    @Override
    public boolean isCached() {
        return this.cache != null;
    }

    @Override
    public int put(char c) {
        return this.put(SingleCharCharSequence.get(c));
    }

    @Override
    public int put(CharSequence symbol) {
        return this.put(symbol, this.valueCountCollector);
    }

    @Override
    public int put(CharSequence symbol, SymbolValueCountCollector valueCountCollector) {
        if (symbol == null) {
            if (!this.nullValue) {
                this.updateNullFlag(true);
            }
            return Integer.MIN_VALUE;
        }
        if (this.cache != null) {
            int index = this.cache.keyIndex(symbol);
            return index < 0 ? this.cache.valueAt(index) : this.lookupPutAndCache(index, symbol, valueCountCollector);
        }
        return this.lookupAndPut(symbol, valueCountCollector);
    }

    @Override
    public void rollback(int symbolCount) {
        this.indexWriter.rollbackValues(SymbolMapWriter.keyToOffset(symbolCount - 1));
        this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(symbolCount) + 8L);
        this.jumpCharMemToSymbolCount(symbolCount);
        this.valueCountCollector.collectValueCount(this.symbolIndexInTxWriter, symbolCount);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public void setSymbolIndexInTxWriter(int symbolIndexInTxWriter) {
        this.symbolIndexInTxWriter = symbolIndexInTxWriter;
    }

    @Override
    public void sync(boolean async) {
        this.charMem.sync(async);
        this.offsetMem.sync(async);
        this.indexWriter.sync(async);
    }

    @Override
    public void truncate() {
        int symbolCapacity = this.offsetMem.getInt(0L);
        this.offsetMem.truncate();
        this.offsetMem.putInt(0L, symbolCapacity);
        this.offsetMem.putBool(4L, this.isCached());
        this.updateNullFlag(false);
        this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(0) + 8L);
        this.charMem.truncate();
        this.indexWriter.truncate();
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public void updateCacheFlag(boolean flag) {
        this.offsetMem.putBool(4L, flag);
    }

    @Override
    public void updateNullFlag(boolean flag) {
        this.offsetMem.putBool(8L, flag);
        this.nullValue = flag;
    }

    private void jumpCharMemToSymbolCount(int symbolCount) {
        if (symbolCount > 0) {
            this.charMem.jumpTo(this.offsetMem.getLong(SymbolMapWriter.keyToOffset(symbolCount)));
        } else {
            this.charMem.jumpTo(0L);
        }
    }

    private int lookupAndPut(CharSequence symbol, SymbolValueCountCollector countCollector) {
        int hash = Hash.boundedHash(symbol, this.maxHash);
        RowCursor cursor = this.indexWriter.getCursor(hash);
        while (cursor.hasNext()) {
            long offsetOffset = cursor.next();
            if (!Chars.equals(symbol, this.charMem.getStr(this.offsetMem.getLong(offsetOffset)))) continue;
            return SymbolMapWriter.offsetToKey(offsetOffset);
        }
        return this.put0(symbol, hash, countCollector);
    }

    private int lookupPutAndCache(int index, CharSequence symbol, SymbolValueCountCollector countCollector) {
        int result = this.lookupAndPut(symbol, countCollector);
        this.cache.putAt(index, symbol.toString(), result);
        return result;
    }

    private int put0(CharSequence symbol, int hash, SymbolValueCountCollector countCollector) {
        long offsetOffset = this.offsetMem.getAppendOffset() - 8L;
        this.offsetMem.putLong(this.charMem.putStr(symbol));
        this.indexWriter.add(hash, offsetOffset);
        int symIndex = SymbolMapWriter.offsetToKey(offsetOffset);
        countCollector.collectValueCount(this.symbolIndexInTxWriter, symIndex + 1);
        return symIndex;
    }

    static long keyToOffset(int key) {
        return 64L + (long)key * 8L;
    }

    static int offsetToKey(long offset) {
        return (int)((offset - 64L) / 8L);
    }
}

