/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ptt.IsoDatePartitionFormat;
import io.questdb.cairo.ptt.IsoWeekPartitionFormat;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public final class PartitionBy {
    public static final int DAY = 0;
    public static final int HOUR = 4;
    public static final int MONTH = 1;
    public static final int NONE = 3;
    public static final int WEEK = 5;
    public static final int YEAR = 2;
    private static final PartitionAddMethod ADD_DD = Timestamps::addDays;
    private static final PartitionAddMethod ADD_HH = Timestamps::addHours;
    private static final PartitionAddMethod ADD_MM = Timestamps::addMonths;
    private static final PartitionAddMethod ADD_WW = Timestamps::addWeeks;
    private static final PartitionAddMethod ADD_YYYY = Timestamps::addYear;
    private static final PartitionCeilMethod CEIL_DD = Timestamps::ceilDD;
    private static final PartitionCeilMethod CEIL_HH = Timestamps::ceilHH;
    private static final PartitionCeilMethod CEIL_MM = Timestamps::ceilMM;
    private static final PartitionCeilMethod CEIL_WW = Timestamps::ceilWW;
    private static final PartitionCeilMethod CEIL_YYYY = Timestamps::ceilYYYY;
    private static final DateFormat DEFAULT_FORMAT = new DateFormat(){

        @Override
        public void format(long datetime, DateLocale locale, CharSequence timeZoneName, CharSink sink) {
            sink.put("default");
        }

        @Override
        public long parse(CharSequence in, DateLocale locale) {
            return this.parse(in, 0, in.length(), locale);
        }

        @Override
        public long parse(CharSequence in, int lo, int hi, DateLocale locale) {
            return 0L;
        }
    };
    private static final PartitionFloorMethod FLOOR_DD = Timestamps::floorDD;
    private static final PartitionFloorMethod FLOOR_HH = Timestamps::floorHH;
    private static final PartitionFloorMethod FLOOR_MM = Timestamps::floorMM;
    private static final PartitionFloorMethod FLOOR_WW = Timestamps::floorWW;
    private static final PartitionFloorMethod FLOOR_YYYY = Timestamps::floorYYYY;
    private static final LowerCaseCharSequenceIntHashMap nameToIndexMap = new LowerCaseCharSequenceIntHashMap();
    private static final DateFormat PARTITION_DAY_FORMAT = new IsoDatePartitionFormat(FLOOR_DD, TimestampFormatUtils.DAY_FORMAT);
    private static final DateFormat PARTITION_HOUR_FORMAT = new IsoDatePartitionFormat(FLOOR_HH, TimestampFormatUtils.HOUR_FORMAT);
    private static final DateFormat PARTITION_MONTH_FORMAT = new IsoDatePartitionFormat(FLOOR_MM, TimestampFormatUtils.MONTH_FORMAT);
    private static final DateFormat PARTITION_WEEK_FORMAT = new IsoWeekPartitionFormat();
    private static final DateFormat PARTITION_YEAR_FORMAT = new IsoDatePartitionFormat(FLOOR_YYYY, TimestampFormatUtils.YEAR_FORMAT);

    private PartitionBy() {
    }

    public static int fromString(CharSequence name) {
        return nameToIndexMap.get(name);
    }

    public static PartitionAddMethod getPartitionAddMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return ADD_DD;
            }
            case 1: {
                return ADD_MM;
            }
            case 2: {
                return ADD_YYYY;
            }
            case 4: {
                return ADD_HH;
            }
            case 5: {
                return ADD_WW;
            }
        }
        return null;
    }

    public static PartitionCeilMethod getPartitionCeilMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return CEIL_DD;
            }
            case 1: {
                return CEIL_MM;
            }
            case 2: {
                return CEIL_YYYY;
            }
            case 4: {
                return CEIL_HH;
            }
            case 5: {
                return CEIL_WW;
            }
        }
        return null;
    }

    public static DateFormat getPartitionDirFormatMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return PARTITION_DAY_FORMAT;
            }
            case 1: {
                return PARTITION_MONTH_FORMAT;
            }
            case 2: {
                return PARTITION_YEAR_FORMAT;
            }
            case 4: {
                return PARTITION_HOUR_FORMAT;
            }
            case 5: {
                return PARTITION_WEEK_FORMAT;
            }
            case 3: {
                return DEFAULT_FORMAT;
            }
        }
        throw new UnsupportedOperationException("partition by " + partitionBy + " does not have date format");
    }

    public static PartitionFloorMethod getPartitionFloorMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return FLOOR_DD;
            }
            case 5: {
                return FLOOR_WW;
            }
            case 1: {
                return FLOOR_MM;
            }
            case 2: {
                return FLOOR_YYYY;
            }
            case 4: {
                return FLOOR_HH;
            }
        }
        return null;
    }

    public static boolean isPartitioned(int partitionBy) {
        return partitionBy != 3;
    }

    public static long parsePartitionDirName(@NotNull CharSequence partitionName, int partitionBy) {
        return PartitionBy.parsePartitionDirName(partitionName, partitionBy, 0, partitionName.length());
    }

    public static long parsePartitionDirName(@NotNull CharSequence partitionName, int partitionBy, int lo, int hi) {
        try {
            CharSequence fmtStr;
            DateFormat fmtMethod;
            switch (partitionBy) {
                case 0: {
                    fmtMethod = PARTITION_DAY_FORMAT;
                    fmtStr = "yyyy-MM-dd";
                    break;
                }
                case 1: {
                    fmtMethod = PARTITION_MONTH_FORMAT;
                    fmtStr = "yyyy-MM";
                    break;
                }
                case 2: {
                    fmtMethod = PARTITION_YEAR_FORMAT;
                    fmtStr = "yyyy";
                    break;
                }
                case 4: {
                    fmtMethod = PARTITION_HOUR_FORMAT;
                    fmtStr = "yyyy-MM-ddTHH";
                    break;
                }
                case 5: {
                    fmtMethod = PARTITION_WEEK_FORMAT;
                    fmtStr = "YYYY-Www";
                    break;
                }
                case 3: {
                    fmtMethod = DEFAULT_FORMAT;
                    fmtStr = partitionName;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("partition by " + partitionBy + " does not have date format");
                }
            }
            int limit = fmtStr.length();
            if (hi < 0) {
                hi = lo + Math.min(limit, partitionName.length());
            }
            if (hi - lo < limit) {
                throw PartitionBy.expectedPartitionDirNameFormatCairoException(partitionName, lo, hi, partitionBy);
            }
            return fmtMethod.parse(partitionName, lo, hi, null);
        }
        catch (NumericException e) {
            if (partitionBy == 5) {
                int localLimit = "yyyy-MM-dd".length();
                try {
                    return Timestamps.floorDOW(TimestampFormatUtils.DAY_FORMAT.parse(partitionName, 0, localLimit, null));
                }
                catch (NumericException ignore) {
                    throw PartitionBy.expectedPartitionDirNameFormatCairoException(partitionName, 0, Math.min(partitionName.length(), localLimit), partitionBy);
                }
            }
            throw PartitionBy.expectedPartitionDirNameFormatCairoException(partitionName, lo, hi, partitionBy);
        }
    }

    public static void setSinkForPartition(CharSink path, int partitionBy, long timestamp) {
        if (partitionBy != 3) {
            PartitionBy.getPartitionDirFormatMethod(partitionBy).format(timestamp, null, null, path);
            return;
        }
        path.put("default");
    }

    public static String toString(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return "DAY";
            }
            case 1: {
                return "MONTH";
            }
            case 2: {
                return "YEAR";
            }
            case 4: {
                return "HOUR";
            }
            case 5: {
                return "WEEK";
            }
            case 3: {
                return "NONE";
            }
        }
        return "UNKNOWN";
    }

    private static CairoException expectedPartitionDirNameFormatCairoException(CharSequence partitionName, int lo, int hi, int partitionBy) {
        CairoException ee = CairoException.critical(0).put('\'');
        switch (partitionBy) {
            case 0: {
                ee.put("yyyy-MM-dd");
                break;
            }
            case 5: {
                ee.put("YYYY-Www").put("' or '").put("yyyy-MM-dd");
                break;
            }
            case 1: {
                ee.put("yyyy-MM");
                break;
            }
            case 2: {
                ee.put("yyyy");
                break;
            }
            case 4: {
                ee.put("yyyy-MM-ddTHH");
            }
        }
        ee.put("' expected, found [ts=").put(partitionName.subSequence(lo, hi)).put(']');
        return ee;
    }

    static {
        nameToIndexMap.put("day", 0);
        nameToIndexMap.put("month", 1);
        nameToIndexMap.put("year", 2);
        nameToIndexMap.put("hour", 4);
        nameToIndexMap.put("week", 5);
        nameToIndexMap.put("none", 3);
    }

    @FunctionalInterface
    public static interface PartitionFloorMethod {
        public long floor(long var1);
    }

    @FunctionalInterface
    public static interface PartitionCeilMethod {
        public long ceil(long var1);
    }

    @FunctionalInterface
    public static interface PartitionAddMethod {
        public long calculate(long var1, int var3);
    }
}

