/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnPurgeJob;
import io.questdb.cairo.O3CallbackJob;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3PartitionJob;
import io.questdb.cairo.O3PartitionPurgeJob;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cairo.sql.async.PageFrameReduceJob;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.WorkerPool;
import io.questdb.std.FilesFacade;
import io.questdb.std.NanosecondClock;
import io.questdb.std.Rnd;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import org.jetbrains.annotations.Nullable;

public class O3Utils {
    private static final Log LOG = LogFactory.getLog(O3Utils.class);

    public static void setupWorkerPool(WorkerPool workerPool, CairoEngine cairoEngine, @Nullable SqlExecutionCircuitBreakerConfiguration sqlExecutionCircuitBreakerConfiguration, @Nullable FunctionFactoryCache functionFactoryCache) throws SqlException {
        MessageBus messageBus = cairoEngine.getMessageBus();
        int workerCount = workerPool.getWorkerCount();
        O3PartitionPurgeJob purgeDiscoveryJob = new O3PartitionPurgeJob(messageBus, workerPool.getWorkerCount());
        workerPool.assign(purgeDiscoveryJob);
        if (!cairoEngine.getConfiguration().disableColumnPurgeJob()) {
            ColumnPurgeJob columnPurgeJob = new ColumnPurgeJob(cairoEngine, functionFactoryCache);
            workerPool.freeOnExit(columnPurgeJob);
            workerPool.assign(columnPurgeJob);
        }
        workerPool.assign(new O3PartitionJob(messageBus));
        workerPool.assign(new O3OpenColumnJob(messageBus));
        workerPool.assign(new O3CopyJob(messageBus));
        workerPool.assign(new O3CallbackJob(messageBus));
        workerPool.freeOnExit(purgeDiscoveryJob);
        MicrosecondClock microsecondClock = messageBus.getConfiguration().getMicrosecondClock();
        NanosecondClock nanosecondClock = messageBus.getConfiguration().getNanosecondClock();
        for (int i = 0; i < workerCount; ++i) {
            PageFrameReduceJob pageFrameReduceJob = new PageFrameReduceJob(messageBus, new Rnd(microsecondClock.getTicks(), nanosecondClock.getTicks()), sqlExecutionCircuitBreakerConfiguration);
            workerPool.assign(i, pageFrameReduceJob);
            workerPool.freeOnExit(pageFrameReduceJob);
        }
    }

    static void close(FilesFacade ff, int fd) {
        if (fd > 0) {
            LOG.debug().$("closed [fd=").$(fd).$(']').$();
            ff.close(fd);
        }
    }

    static void copyFromTimestampIndex(long src, long srcLo, long srcHi, long dstAddr) {
        Vect.copyFromTimestampIndex(src, srcLo, srcHi, dstAddr);
    }

    static long findVarOffset(long srcFixAddr, long srcLo) {
        long result = Unsafe.getUnsafe().getLong(srcFixAddr + srcLo * 8L);
        assert (srcLo == 0L && result == 0L || result > 0L);
        return result;
    }

    static long getVarColumnLength(long srcLo, long srcHi, long srcFixAddr) {
        return O3Utils.findVarOffset(srcFixAddr, srcHi + 1L) - O3Utils.findVarOffset(srcFixAddr, srcLo);
    }

    static void shiftCopyFixedSizeColumnData(long shift, long src, long srcLo, long srcHi, long dstAddr) {
        Vect.shiftCopyFixedSizeColumnData(shift, src, srcLo, srcHi, dstAddr);
    }

    static void unmap(FilesFacade ff, long addr, long size) {
        if (addr != 0L && size > 0L) {
            ff.munmap(addr, size, 2);
        }
    }

    static void unmapAndClose(FilesFacade ff, int dstFixFd, long dstFixAddr, long dstFixSize) {
        O3Utils.unmap(ff, dstFixAddr, dstFixSize);
        O3Utils.close(ff, dstFixFd);
    }
}

