/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.TableWriter;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.tasks.O3CallbackTask;
import org.jetbrains.annotations.NotNull;

public class O3CallbackJob
extends AbstractQueueConsumerJob<O3CallbackTask> {
    public O3CallbackJob(MessageBus messageBus) {
        super(messageBus.getO3CallbackQueue(), messageBus.getO3CallbackSubSeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCallbackWithCol(O3CallbackTask task, long cursor, @NotNull Sequence subSeq) {
        int columnIndex = task.getColumnIndex();
        int columnType = task.getColumnType();
        long mergedTimestampsAddr = task.getMergedTimestampsAddr();
        long row1Count = task.getRow1Count();
        long row2Lo = task.getRow2Lo();
        long row2Hi = task.getRow2Hi();
        TableWriter.O3ColumnUpdateMethod callbackMethod = task.getWriterCallbackMethod();
        CountDownLatchSPI countDownLatchSPI = task.getCountDownLatchSPI();
        subSeq.done(cursor);
        try {
            callbackMethod.run(columnIndex, columnType, mergedTimestampsAddr, row1Count, row2Lo, row2Hi);
        }
        finally {
            countDownLatchSPI.countDown();
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        O3CallbackTask task = (O3CallbackTask)this.queue.get(cursor);
        O3CallbackJob.runCallbackWithCol(task, cursor, this.subSeq);
        return true;
    }
}

