/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.O3MutableAtomicInteger;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class O3Basket
implements Mutable {
    private final ObjList<BitmapIndexWriter> indexers = new ObjList();
    private final ObjList<AtomicInteger> partCounters = new ObjList();
    private int columnCount;
    private int indexCount;
    private int indexerPointer;
    private int partCounterPointer;

    @Override
    public void clear() {
        this.indexerPointer = 0;
        this.partCounterPointer = 0;
    }

    public void ensureCapacity(CairoConfiguration configuration, int columnCount, int indexCount) {
        if (this.columnCount == columnCount && this.indexCount == indexCount) {
            return;
        }
        this.ensureCapacity0(configuration, columnCount, indexCount);
    }

    public BitmapIndexWriter nextIndexer() {
        return this.indexers.getQuick(this.indexerPointer++);
    }

    public AtomicInteger nextPartCounter() {
        return this.partCounters.getQuick(this.partCounterPointer++);
    }

    private void ensureCapacity0(CairoConfiguration configuration, int columnCount, int indexCount) {
        int i;
        if (this.columnCount < columnCount) {
            for (i = this.columnCount; i < columnCount; ++i) {
                this.partCounters.add(new O3MutableAtomicInteger());
            }
        } else {
            for (i = columnCount; i < this.columnCount; ++i) {
                this.partCounters.setQuick(i, null);
            }
            this.partCounters.setPos(columnCount);
        }
        this.columnCount = columnCount;
        if (this.indexCount < indexCount) {
            for (i = this.indexCount; i < indexCount; ++i) {
                this.indexers.add(new BitmapIndexWriter(configuration));
            }
        } else {
            for (i = indexCount; i < this.indexCount; ++i) {
                this.indexers.setQuick(i, null);
            }
            this.indexers.setPos(indexCount);
        }
        this.indexCount = indexCount;
    }
}

