/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.RebuildColumnBase;
import io.questdb.cairo.SymbolColumnIndexer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;

public class IndexBuilder
extends RebuildColumnBase {
    private static final Log LOG = LogFactory.getLog(IndexBuilder.class);
    private final MemoryMAR ddlMem;
    private final MemoryMR indexMem = Vm.getMRInstance();
    private final SymbolColumnIndexer indexer;

    public IndexBuilder(CairoConfiguration configuration) {
        super(configuration);
        this.ddlMem = Vm.getMARInstance(configuration.getCommitMode());
        this.indexer = new SymbolColumnIndexer(configuration);
        this.unsupportedColumnMessage = "Column is not indexed";
    }

    @Override
    public void clear() {
        super.clear();
        this.ddlMem.close();
        this.indexer.clear();
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFiles(FilesFacade ff, CharSequence columnName, int indexValueBlockCapacity, int plen, long columnNameTxn) {
        try {
            BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn);
            try {
                LOG.info().$("writing ").utf8(this.path).$();
                this.ddlMem.smallFile(ff, this.path, 5);
                BitmapIndexWriter.initKeyMemory(this.ddlMem, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                LOG.error().$("could not create index [name=").utf8(this.path).$(", errno=").$(e.getErrno()).$(']').$();
                if (!ff.remove(this.path)) {
                    LOG.error().$("could not remove '").utf8(this.path).$("'. Please remove MANUALLY.").$("[errno=").$(ff.errno()).$(']').$();
                }
                throw e;
            }
            finally {
                this.ddlMem.close();
            }
            if (!ff.touch(BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$("could not create index [name=").utf8(this.path).$(']').$();
                throw CairoException.critical(ff.errno()).put("could not create index [name=").put(this.path).put(']');
            }
            LOG.info().$("writing ").utf8(this.path).$();
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void removeFile(FilesFacade ff, Path path) {
        LOG.info().$("deleting ").utf8(path).$();
        if (!ff.remove(this.path)) {
            if (!ff.exists(this.path)) {
                LOG.info().$("index file did not exist, file will be re-written [path=").utf8(path).I$();
            } else {
                throw CairoException.critical(ff.errno()).put("cannot remove index file");
            }
        }
    }

    private void removeIndexFiles(FilesFacade ff, CharSequence columnName, long columnNameTxn) {
        int plen = this.path.length();
        BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn);
        this.removeFile(ff, this.path);
        BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn);
        this.removeFile(ff, this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReindex(FilesFacade ff, ColumnVersionReader columnVersionReader, int columnWriterIndex, CharSequence columnName, long partitionNameTxn, long partitionSize, long partitionTimestamp, int partitionBy, int indexValueBlockCapacity) {
        block14: {
            int trimTo = this.path.length();
            TableUtils.setPathForPartition(this.path, partitionBy, partitionTimestamp, partitionNameTxn);
            try {
                int plen = this.path.length();
                if (ff.exists(this.path.$())) {
                    try (MemoryMR roMem = this.indexMem;){
                        long columnNameTxn = columnVersionReader.getColumnNameTxn(partitionTimestamp, columnWriterIndex);
                        this.removeIndexFiles(ff, columnName, columnNameTxn);
                        TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn);
                        long columnTop = columnVersionReader.getColumnTop(partitionTimestamp, columnWriterIndex);
                        if (columnTop > -1L) {
                            if (partitionSize <= columnTop) break block14;
                            LOG.info().$("indexing [path=").utf8(this.path).I$();
                            this.createIndexFiles(ff, columnName, indexValueBlockCapacity, plen, columnNameTxn);
                            TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn);
                            roMem.of(ff, this.path, 0L, (partitionSize - columnTop) * 4L, 5);
                            try {
                                this.indexer.configureWriter(this.path.trimTo(plen), columnName, columnNameTxn, columnTop);
                                this.indexer.index(roMem, columnTop, partitionSize);
                                break block14;
                            }
                            finally {
                                this.indexer.clear();
                            }
                        }
                        LOG.info().$("column is empty in partition [path=").$(this.path).I$();
                        break block14;
                    }
                }
                LOG.info().$("partition does not exist [path=").$(this.path).I$();
            }
            finally {
                this.path.trimTo(trimTo);
            }
        }
    }

    @Override
    protected boolean isSupportedColumn(RecordMetadata metadata, int columnIndex) {
        return metadata.isColumnIndexed(columnIndex);
    }
}

