/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractFullDataFrameCursor;
import io.questdb.cairo.sql.DataFrame;
import org.jetbrains.annotations.Nullable;

public class FullBwdDataFrameCursor
extends AbstractFullDataFrameCursor {
    private int skipToPartitionIndex = -1;
    private long skipToPosition = -1L;

    @Override
    public DataFrame next() {
        while (this.partitionIndex > -1) {
            long hi = this.reader.openPartition(this.partitionIndex);
            if (hi < 1L) {
                --this.partitionIndex;
                continue;
            }
            this.frame.partitionIndex = this.partitionIndex--;
            this.frame.rowHi = hi;
            return this.frame;
        }
        return null;
    }

    @Override
    @Nullable
    public DataFrame skipTo(long rowCount) {
        int partitionCount = this.getTableReader().getPartitionCount();
        if (partitionCount < 1) {
            return null;
        }
        if (this.skipToPartitionIndex == -1) {
            this.skipToPosition = rowCount;
            this.skipToPartitionIndex = partitionCount - 1;
        }
        long partitionRows = 0L;
        while (this.skipToPartitionIndex > -1) {
            partitionRows = this.getTableReader().openPartition(this.skipToPartitionIndex);
            if (partitionRows < 0L) {
                --this.skipToPartitionIndex;
                continue;
            }
            if (partitionRows > this.skipToPosition) break;
            if (this.skipToPartitionIndex == 0) {
                this.skipToPosition = -1L;
                break;
            }
            this.skipToPosition -= partitionRows;
            --this.skipToPartitionIndex;
        }
        this.frame.partitionIndex = this.skipToPartitionIndex;
        this.frame.rowHi = this.skipToPosition > -1L ? partitionRows - this.skipToPosition : this.skipToPosition;
        this.frame.rowLo = 0L;
        this.partitionIndex = this.skipToPartitionIndex - 1;
        this.skipToPosition = -1L;
        this.skipToPartitionIndex = -1;
        return this.frame;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    @Override
    public void toTop() {
        this.partitionIndex = this.partitionHi - 1;
        this.skipToPartitionIndex = -1;
        this.skipToPosition = -1L;
    }
}

