/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableNameRegistryFileStore;
import io.questdb.cairo.TableToken;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;

public abstract class AbstractTableNameRegistry
implements TableNameRegistry {
    protected final TableNameRegistryFileStore nameStore;
    private ConcurrentHashMap<TableToken> nameTokenMap;
    private ConcurrentHashMap<ReverseTableMapItem> reverseNameTokenMap;

    public AbstractTableNameRegistry(CairoConfiguration configuration) {
        this.nameStore = new TableNameRegistryFileStore(configuration);
    }

    @Override
    public void close() {
        this.nameTokenMap.clear();
        this.reverseNameTokenMap.clear();
        Misc.free(this.nameStore);
    }

    @Override
    public TableToken getTableToken(CharSequence tableName) {
        return this.nameTokenMap.get(tableName);
    }

    @Override
    public TableToken getTableToken(String dirName, int tableId) {
        ReverseTableMapItem rmi = this.reverseNameTokenMap.get(dirName);
        if (rmi != null && !rmi.isDropped() && rmi.getToken().getTableId() == tableId) {
            return rmi.getToken();
        }
        return null;
    }

    @Override
    public int getTableTokenCount(boolean includeDropped) {
        int count = 0;
        for (ReverseTableMapItem entry : this.reverseNameTokenMap.values()) {
            if (!includeDropped && entry.isDropped()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void getTableTokens(ObjHashSet<TableToken> target, boolean includeDropped) {
        target.clear();
        for (ReverseTableMapItem entry : this.reverseNameTokenMap.values()) {
            if (!includeDropped && entry.isDropped()) continue;
            target.add(entry.getToken());
        }
    }

    @Override
    public TableToken getTokenByDirName(CharSequence dirName) {
        ReverseTableMapItem entry = this.reverseNameTokenMap.get(dirName);
        return entry == null ? null : entry.getToken();
    }

    @Override
    public boolean isTableDropped(TableToken tableToken) {
        ReverseTableMapItem rmi = this.reverseNameTokenMap.get(tableToken.getDirName());
        return rmi != null && rmi.isDropped();
    }

    @Override
    public void resetMemory() {
        this.nameStore.resetMemory();
    }

    void setNameMaps(ConcurrentHashMap<TableToken> nameTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> reverseTableNameTokenMap) {
        this.nameTokenMap = nameTableTokenMap;
        this.reverseNameTokenMap = reverseTableNameTokenMap;
    }
}

