/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.TelemetryConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Os;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.tasks.AbstractTelemetryTask;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public final class Telemetry<T extends AbstractTelemetryTask>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Telemetry.class);
    private final boolean enabled;
    private MicrosecondClock clock;
    private MPSequence telemetryPubSeq;
    private RingQueue<T> telemetryQueue;
    private SCSequence telemetrySubSeq;
    private TelemetryType<T> telemetryType;
    private TableWriter writer;
    private final QueueConsumer<T> taskConsumer = this::consume;

    public Telemetry(TelemetryTypeBuilder<T> builder, CairoConfiguration configuration) {
        TelemetryType<T> type = builder.build(configuration);
        TelemetryConfiguration telemetryConfiguration = type.getTelemetryConfiguration(configuration);
        this.enabled = telemetryConfiguration.getEnabled();
        if (this.enabled) {
            this.telemetryType = type;
            this.clock = configuration.getMicrosecondClock();
            this.telemetryQueue = new RingQueue<T>(type.getTaskFactory(), telemetryConfiguration.getQueueCapacity());
            this.telemetryPubSeq = new MPSequence(this.telemetryQueue.getCycle());
            this.telemetrySubSeq = new SCSequence();
            this.telemetryPubSeq.then(this.telemetrySubSeq).then(this.telemetryPubSeq);
        }
    }

    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        this.consumeAll();
        Misc.free(this.telemetryQueue);
        this.telemetryType.logStatus(this.writer, (short)101, this.clock.getTicks());
        this.writer = Misc.free(this.writer);
    }

    public void consume(T task) {
        task.writeTo(this.writer, this.clock.getTicks());
    }

    public void consumeAll() {
        if (this.enabled && this.telemetrySubSeq.consumeAll(this.telemetryQueue, this.taskConsumer)) {
            this.writer.commit();
        }
    }

    public void init(CairoEngine engine, SqlCompiler compiler, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (!this.enabled) {
            return;
        }
        String tableName = this.telemetryType.getTableName();
        this.telemetryType.getCreateSql(compiler.query()).compile(sqlExecutionContext);
        TableToken tableToken = engine.verifyTableName(tableName);
        try {
            this.writer = engine.getWriter(tableToken, "telemetry");
        }
        catch (CairoException ex) {
            LOG.error().$("could not open [table=`").utf8(tableToken.getTableName()).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
        }
        this.telemetryType.logStatus(this.writer, (short)100, this.clock.getTicks());
        if (this.telemetryType.shouldLogClasses()) {
            this.telemetryType.logStatus(this.writer, Telemetry.getOSClass(), this.clock.getTicks());
            this.telemetryType.logStatus(this.writer, Telemetry.getCpuClass(), this.clock.getTicks());
            this.telemetryType.logStatus(this.writer, Telemetry.getDBSizeClass(engine.getConfiguration()), this.clock.getTicks());
            this.telemetryType.logStatus(this.writer, Telemetry.getTableCountClass(engine), this.clock.getTicks());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public T nextTask() {
        if (!this.enabled) {
            return null;
        }
        long cursor = this.telemetryPubSeq.next();
        if (cursor < 0L) {
            return null;
        }
        return (T)((AbstractTelemetryTask)this.telemetryQueue.get(cursor));
    }

    public void store() {
        this.telemetryPubSeq.done(this.telemetryPubSeq.current());
    }

    private static short getCpuClass() {
        int cpus = Runtime.getRuntime().availableProcessors();
        if (cpus <= 4) {
            return -20;
        }
        if (cpus <= 8) {
            return -21;
        }
        if (cpus <= 16) {
            return -22;
        }
        if (cpus <= 32) {
            return -23;
        }
        if (cpus <= 64) {
            return -24;
        }
        return -25;
    }

    private static short getDBSizeClass(CairoConfiguration configuration) {
        FilesFacade ff = configuration.getFilesFacade();
        String root = configuration.getRoot();
        Path path = Path.PATH.get();
        path.of(root).$();
        long dbSize = ff.getDirSize(path);
        if (dbSize <= 0x280000000L) {
            return -30;
        }
        if (dbSize <= 0xC80000000L) {
            return -31;
        }
        if (dbSize <= 0x1900000000L) {
            return -32;
        }
        if (dbSize <= 0x7D00000000L) {
            return -33;
        }
        if (dbSize <= 0x10000000000L) {
            return -34;
        }
        if (dbSize <= 0x50000000000L) {
            return -35;
        }
        if (dbSize <= 0xA0000000000L) {
            return -36;
        }
        return -37;
    }

    private static short getOSClass() {
        if (Os.isLinux()) {
            return -10;
        }
        if (Os.isOSX()) {
            return -11;
        }
        if (Os.isWindows()) {
            return -12;
        }
        return -13;
    }

    private static short getTableCountClass(CairoEngine engine) {
        long tableCount = engine.getTableTokenCount(false);
        if (tableCount <= 10L) {
            return -40;
        }
        if (tableCount <= 25L) {
            return -41;
        }
        if (tableCount <= 50L) {
            return -42;
        }
        if (tableCount <= 100L) {
            return -43;
        }
        if (tableCount <= 250L) {
            return -44;
        }
        if (tableCount <= 1000L) {
            return -45;
        }
        return -46;
    }

    public static interface TelemetryTypeBuilder<T extends AbstractTelemetryTask> {
        public TelemetryType<T> build(CairoConfiguration var1);
    }

    public static interface TelemetryType<T extends AbstractTelemetryTask> {
        public SqlCompiler.QueryBuilder getCreateSql(SqlCompiler.QueryBuilder var1);

        public String getTableName();

        public ObjectFactory<T> getTaskFactory();

        default public TelemetryConfiguration getTelemetryConfiguration(@NotNull CairoConfiguration configuration) {
            return configuration.getTelemetryConfiguration();
        }

        default public void logStatus(TableWriter writer, short systemStatus, long micros) {
        }

        default public boolean shouldLogClasses() {
            return false;
        }
    }
}

