/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.cairo.TableWriterMetrics;
import io.questdb.cairo.wal.WalMetrics;
import io.questdb.cutlass.http.processors.JsonQueryMetrics;
import io.questdb.cutlass.pgwire.PGWireMetrics;
import io.questdb.metrics.GCMetrics;
import io.questdb.metrics.HealthMetricsImpl;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.metrics.MetricsRegistryImpl;
import io.questdb.metrics.NullMetricsRegistry;
import io.questdb.metrics.Scrapable;
import io.questdb.metrics.VirtualLongGauge;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;

public class Metrics
implements Scrapable {
    private final boolean enabled;
    private final GCMetrics gcMetrics;
    private final HealthMetricsImpl healthCheck;
    private final JsonQueryMetrics jsonQuery;
    private final MetricsRegistry metricsRegistry;
    private final PGWireMetrics pgWire;
    private final Runtime runtime = Runtime.getRuntime();
    private final VirtualLongGauge.StatProvider jvmFreeMemRef = this.runtime::freeMemory;
    private final VirtualLongGauge.StatProvider jvmMaxMemRef = this.runtime::maxMemory;
    private final VirtualLongGauge.StatProvider jvmTotalMemRef = this.runtime::totalMemory;
    private final TableWriterMetrics tableWriter;
    private final WalMetrics walMetrics;

    public Metrics(boolean enabled, MetricsRegistry metricsRegistry) {
        this.enabled = enabled;
        this.gcMetrics = new GCMetrics();
        this.jsonQuery = new JsonQueryMetrics(metricsRegistry);
        this.pgWire = new PGWireMetrics(metricsRegistry);
        this.healthCheck = new HealthMetricsImpl(metricsRegistry);
        this.tableWriter = new TableWriterMetrics(metricsRegistry);
        this.walMetrics = new WalMetrics(metricsRegistry);
        this.createMemoryGauges(metricsRegistry);
        this.metricsRegistry = metricsRegistry;
    }

    public static Metrics disabled() {
        return new Metrics(false, new NullMetricsRegistry());
    }

    public static Metrics enabled() {
        return new Metrics(true, new MetricsRegistryImpl());
    }

    public WalMetrics getWalMetrics() {
        return this.walMetrics;
    }

    public HealthMetricsImpl health() {
        return this.healthCheck;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JsonQueryMetrics jsonQuery() {
        return this.jsonQuery;
    }

    public PGWireMetrics pgWire() {
        return this.pgWire;
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        this.metricsRegistry.scrapeIntoPrometheus(sink);
        if (this.enabled) {
            this.gcMetrics.scrapeIntoPrometheus(sink);
        }
    }

    public TableWriterMetrics tableWriter() {
        return this.tableWriter;
    }

    private void createMemoryGauges(MetricsRegistry metricsRegistry) {
        for (int i = 0; i < 54; ++i) {
            metricsRegistry.newLongGauge(i);
        }
        metricsRegistry.newVirtualGauge("memory_free_count", Unsafe::getFreeCount);
        metricsRegistry.newVirtualGauge("memory_mem_used", Unsafe::getMemUsed);
        metricsRegistry.newVirtualGauge("memory_malloc_count", Unsafe::getMallocCount);
        metricsRegistry.newVirtualGauge("memory_realloc_count", Unsafe::getReallocCount);
        metricsRegistry.newVirtualGauge("memory_rss", Os::getRss);
        metricsRegistry.newVirtualGauge("memory_jvm_free", this.jvmFreeMemRef);
        metricsRegistry.newVirtualGauge("memory_jvm_total", this.jvmTotalMemRef);
        metricsRegistry.newVirtualGauge("memory_jvm_max", this.jvmMaxMemRef);
    }
}

