/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jetty.configuration.connector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.jetty.configuration.connector.ApplicationLayerProtocol;
import org.apache.nifi.jetty.configuration.connector.ServerConnectorFactory;
import org.apache.nifi.jetty.configuration.connector.alpn.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class StandardServerConnectorFactory
implements ServerConnectorFactory {
    private static final boolean SEND_SERVER_VERSION = false;
    private static final String[] INCLUDE_ALL_SECURITY_PROTOCOLS = new String[0];
    private static final Set<ApplicationLayerProtocol> DEFAULT_APPLICATION_LAYER_PROTOCOLS = Collections.singleton(ApplicationLayerProtocol.HTTP_1_1);
    private final Server server;
    private final int port;
    private Set<ApplicationLayerProtocol> applicationLayerProtocols = DEFAULT_APPLICATION_LAYER_PROTOCOLS;
    private SSLContext sslContext;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] includeSecurityProtocols = INCLUDE_ALL_SECURITY_PROTOCOLS;

    public StandardServerConnectorFactory(Server server, int port) {
        this.server = Objects.requireNonNull(server, "Server required");
        this.port = port;
    }

    @Override
    public ServerConnector getServerConnector() {
        ServerConnector serverConnector;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        if (this.sslContext == null) {
            serverConnector = new ServerConnector(this.server, new ConnectionFactory[]{httpConnectionFactory});
        } else {
            ArrayList<ALPNServerConnectionFactory> connectionFactories = new ArrayList<ALPNServerConnectionFactory>();
            if (this.applicationLayerProtocols.contains((Object)ApplicationLayerProtocol.H2)) {
                ALPNServerConnectionFactory alpnServerConnectionFactory = new ALPNServerConnectionFactory();
                HTTP2ServerConnectionFactory http2ServerConnectionFactory = new HTTP2ServerConnectionFactory(httpConfiguration);
                connectionFactories.add(alpnServerConnectionFactory);
                connectionFactories.add((ALPNServerConnectionFactory)http2ServerConnectionFactory);
            }
            if (this.applicationLayerProtocols.contains((Object)ApplicationLayerProtocol.HTTP_1_1)) {
                connectionFactories.add((ALPNServerConnectionFactory)httpConnectionFactory);
            }
            String nextProtocol = ((ConnectionFactory)connectionFactories.get(0)).getProtocol();
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(this.getSslContextFactory(), nextProtocol);
            connectionFactories.add(0, (ALPNServerConnectionFactory)sslConnectionFactory);
            ConnectionFactory[] factories = connectionFactories.toArray(new ConnectionFactory[0]);
            serverConnector = new ServerConnector(this.server, factories);
        }
        serverConnector.setPort(this.port);
        return serverConnector;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public void setIncludeSecurityProtocols(String[] includeSecurityProtocols) {
        this.includeSecurityProtocols = includeSecurityProtocols == null ? INCLUDE_ALL_SECURITY_PROTOCOLS : includeSecurityProtocols;
    }

    public void setApplicationLayerProtocols(Set<ApplicationLayerProtocol> applicationLayerProtocols) {
        if (Objects.requireNonNull(applicationLayerProtocols, "Application Layer Protocols required").isEmpty()) {
            throw new IllegalArgumentException("Application Layer Protocols not specified");
        }
        this.applicationLayerProtocols = applicationLayerProtocols;
    }

    protected Server getServer() {
        return this.server;
    }

    protected HttpConfiguration getHttpConfiguration() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        if (this.sslContext != null) {
            httpConfiguration.setSecurePort(this.port);
            httpConfiguration.setSecureScheme(HttpScheme.HTTPS.asString());
            httpConfiguration.setSendServerVersion(false);
            SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
        }
        return httpConfiguration;
    }

    protected SslContextFactory.Server getSslContextFactory() {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setSslContext(this.sslContext);
        sslContextFactory.setNeedClientAuth(this.needClientAuth);
        sslContextFactory.setWantClientAuth(this.wantClientAuth);
        sslContextFactory.setIncludeProtocols(this.includeSecurityProtocols);
        if (this.applicationLayerProtocols.contains((Object)ApplicationLayerProtocol.H2)) {
            sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        }
        return sslContextFactory;
    }
}

