/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.util.Objects;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.util.NiFiProperties;

public class PythonBundle {
    private static final BundleCoordinate PYTHON_BUNDLE_COORDINATE = new BundleCoordinate("org.apache.nifi", "python-extensions", "unversioned");

    public static Bundle create(NiFiProperties properties, ClassLoader classLoader) {
        File pythonWorkingDirectory = new File(properties.getProperty("nifi.python.working.directory", "./work/python"));
        BundleDetails systemBundleDetails = new BundleDetails.Builder().workingDir(pythonWorkingDirectory).coordinate(PYTHON_BUNDLE_COORDINATE).build();
        return new Bundle(systemBundleDetails, classLoader);
    }

    public static boolean isPythonCoordinate(BundleCoordinate coordinate) {
        return PythonBundle.isPythonCoordinate(coordinate.getGroup(), coordinate.getId());
    }

    public static boolean isPythonCoordinate(String groupId, String artifactId) {
        return Objects.equals(PYTHON_BUNDLE_COORDINATE.getGroup(), groupId) && Objects.equals(PYTHON_BUNDLE_COORDINATE.getId(), artifactId);
    }
}

