/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.PeerDescriptionModifiable;
import org.apache.nifi.remote.PeerDescriptionModifier;
import org.apache.nifi.remote.RemoteResourceFactory;
import org.apache.nifi.remote.RemoteSiteListener;
import org.apache.nifi.remote.cluster.NodeInformant;
import org.apache.nifi.remote.cluster.NodeInformation;
import org.apache.nifi.remote.exception.BadRequestException;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.exception.NotAuthorizedException;
import org.apache.nifi.remote.exception.RequestExpiredException;
import org.apache.nifi.remote.io.socket.SocketCommunicationsSession;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.RequestType;
import org.apache.nifi.remote.protocol.ServerProtocol;
import org.apache.nifi.security.cert.StandardPrincipalFormatter;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketRemoteSiteListener
implements RemoteSiteListener {
    private final int socketPort;
    private final SSLContext sslContext;
    private final NodeInformant nodeInformant;
    private final AtomicReference<ProcessGroup> rootGroup = new AtomicReference();
    private final NiFiProperties nifiProperties;
    private final PeerDescriptionModifier peerDescriptionModifier;
    private static final int EXCEPTION_THRESHOLD_MILLIS = 10000;
    private volatile long tlsErrorLastSeen = -1L;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private static final Logger LOG = LoggerFactory.getLogger(SocketRemoteSiteListener.class);

    public SocketRemoteSiteListener(int socketPort, SSLContext sslContext, NiFiProperties nifiProperties) {
        this(socketPort, sslContext, nifiProperties, null);
    }

    public SocketRemoteSiteListener(int socketPort, SSLContext sslContext, NiFiProperties nifiProperties, NodeInformant nodeInformant) {
        this.socketPort = socketPort;
        this.sslContext = sslContext;
        this.nifiProperties = nifiProperties;
        this.nodeInformant = nodeInformant;
        this.peerDescriptionModifier = new PeerDescriptionModifier(nifiProperties);
    }

    @Override
    public void setRootGroup(ProcessGroup rootGroup) {
        this.rootGroup.set(rootGroup);
    }

    @Override
    public void start() throws IOException {
        final boolean secure = this.sslContext != null;
        final ArrayList threads = new ArrayList();
        this.stopped.set(false);
        Thread listenerThread = new Thread(new Runnable(){
            private int threadCount = 0;

            @Override
            public void run() {
                block11: {
                    try (ServerSocket serverSocket = SocketRemoteSiteListener.this.createServerSocket();){
                        serverSocket.setSoTimeout(2000);
                        while (!SocketRemoteSiteListener.this.stopped.get()) {
                            Socket acceptedSocket = SocketRemoteSiteListener.this.acceptConnection(serverSocket);
                            if (acceptedSocket == null) continue;
                            if (SocketRemoteSiteListener.this.stopped.get()) {
                                break;
                            }
                            Thread thread = this.createWorkerThread(acceptedSocket);
                            thread.setName("Site-to-Site Worker Thread-" + this.threadCount++);
                            LOG.debug("Handing connection to {}", (Object)thread);
                            thread.start();
                            threads.add(thread);
                            threads.removeIf(t -> !t.isAlive());
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Unable to open server socket due to {}", (Object)e.toString());
                        if (!LOG.isDebugEnabled()) break block11;
                        LOG.error("", (Throwable)e);
                    }
                }
                for (Thread thread : threads) {
                    if (thread == null) continue;
                    thread.interrupt();
                }
            }

            private Thread createWorkerThread(final Socket socket) {
                return new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        Peer peer;
                        ServerProtocol protocol;
                        String peerUri;
                        block60: {
                            OutputStream socketOut;
                            InputStream socketIn;
                            SocketCommunicationsSession commsSession;
                            String dn;
                            LOG.debug("{} Determining URL of connection", (Object)this);
                            InetAddress inetAddress = socket.getInetAddress();
                            String clientHostName = inetAddress.getHostName();
                            int slashIndex = clientHostName.indexOf("/");
                            if (slashIndex == 0) {
                                clientHostName = clientHostName.substring(1);
                            } else if (slashIndex > 0) {
                                clientHostName = clientHostName.substring(0, slashIndex);
                            }
                            int clientPort = socket.getPort();
                            peerUri = "nifi://" + clientHostName + ":" + clientPort;
                            LOG.debug("{} Connection URL is {}", (Object)this, (Object)peerUri);
                            try {
                                if (secure) {
                                    LOG.trace("{} Connection is secure", (Object)this);
                                    SSLSocket sslSocket = (SSLSocket)socket;
                                    dn = SocketRemoteSiteListener.this.getPeerIdentity(sslSocket);
                                    commsSession = new SocketCommunicationsSession(socket);
                                    commsSession.setUserDn(dn);
                                } else {
                                    LOG.trace("{} Connection is not secure", (Object)this);
                                    commsSession = new SocketCommunicationsSession(socket);
                                    dn = null;
                                }
                            }
                            catch (Exception e) {
                                String msg = String.format("RemoteSiteListener Unable to accept connection from %s due to %s", socket, e.getLocalizedMessage());
                                if (SocketRemoteSiteListener.this.isTlsError(e)) {
                                    boolean printedAsWarning = SocketRemoteSiteListener.this.handleTlsError(msg);
                                    if (!printedAsWarning) return;
                                    SocketRemoteSiteListener.this.tlsErrorLastSeen = System.currentTimeMillis();
                                    return;
                                }
                                LOG.error(msg);
                                if (!LOG.isDebugEnabled()) return;
                                LOG.error("", (Throwable)e);
                                return;
                            }
                            LOG.info("Received connection from {}, User DN: {}", (Object)socket.getInetAddress(), (Object)dn);
                            try {
                                socketIn = commsSession.getInput().getInputStream();
                                socketOut = commsSession.getOutput().getOutputStream();
                            }
                            catch (IOException e) {
                                LOG.error("Connection dropped from {} before any data was transmitted", (Object)peerUri);
                                try {
                                    commsSession.close();
                                    return;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return;
                            }
                            DataInputStream dis = new DataInputStream(socketIn);
                            DataOutputStream dos = new DataOutputStream(socketOut);
                            protocol = null;
                            peer = null;
                            LOG.debug("Verifying magic bytes...");
                            SocketRemoteSiteListener.this.verifyMagicBytes(dis, peerUri);
                            LOG.debug("Receiving Server Protocol Negotiation");
                            protocol = (ServerProtocol)RemoteResourceFactory.receiveServerProtocolNegotiation(dis, dos);
                            protocol.setRootProcessGroup(SocketRemoteSiteListener.this.rootGroup.get());
                            protocol.setNodeInformant(SocketRemoteSiteListener.this.nodeInformant);
                            if (protocol instanceof PeerDescriptionModifiable) {
                                ((PeerDescriptionModifiable)protocol).setPeerDescriptionModifier(SocketRemoteSiteListener.this.peerDescriptionModifier);
                            }
                            PeerDescription description = new PeerDescription(clientHostName, clientPort, SocketRemoteSiteListener.this.sslContext != null);
                            peer = new Peer(description, (CommunicationsSession)commsSession, peerUri, "nifi://localhost:" + SocketRemoteSiteListener.this.getPort());
                            LOG.debug("Handshaking....");
                            protocol.handshake(peer);
                            if (!protocol.isHandshakeSuccessful()) {
                                LOG.error("Handshake failed with {}; closing connection", (Object)peer);
                                try {
                                    peer.close();
                                }
                                catch (IOException e) {
                                    LOG.warn("Failed to close {} due to {}", (Object)peer, (Object)e);
                                }
                                LOG.trace("Cleaning up");
                                try {
                                    if (protocol != null && peer != null) {
                                        protocol.shutdown(peer);
                                    }
                                }
                                catch (Exception protocolException) {
                                    LOG.warn("Failed to shutdown protocol due to {}", (Object)protocolException.toString());
                                }
                                try {
                                    if (peer != null) {
                                        peer.close();
                                    }
                                }
                                catch (Exception peerException) {
                                    LOG.warn("Failed to close peer due to {}; some resources may not be appropriately cleaned up", (Object)peerException.toString());
                                }
                                LOG.trace("Finished cleaning up");
                                return;
                            }
                            commsSession.setTimeout((int)protocol.getRequestExpiration());
                            LOG.info("Successfully negotiated ServerProtocol {} Version {} with {}", new Object[]{protocol.getResourceName(), protocol.getVersionNegotiator().getVersion(), peer});
                            try {
                                while (true) {
                                    if (protocol.isShutdown()) {
                                        LOG.debug("Finished communicating with {} ({})", (Object)peer, protocol);
                                        break;
                                    }
                                    LOG.trace("Getting Protocol Request Type...");
                                    int timeoutCount = 0;
                                    RequestType requestType = null;
                                    while (requestType == null) {
                                        try {
                                            requestType = protocol.getRequestType(peer);
                                        }
                                        catch (SocketTimeoutException e) {
                                            LOG.debug("{} Timed out waiting to receive RequestType using {} with {}", new Object[]{this, protocol, peer});
                                            requestType = null;
                                            if (++timeoutCount < 2) continue;
                                            throw e;
                                        }
                                    }
                                    SocketRemoteSiteListener.this.handleRequest(protocol, peer, requestType);
                                }
                            }
                            catch (Exception e) {
                                LOG.error("Unable to communicate with remote instance {} ({}) due to {}; closing connection", new Object[]{peer, protocol, e.toString()});
                                if (!LOG.isDebugEnabled()) break block60;
                                LOG.error("", (Throwable)e);
                            }
                        }
                        LOG.trace("Cleaning up");
                        try {
                            if (protocol != null && peer != null) {
                                protocol.shutdown(peer);
                            }
                        }
                        catch (Exception protocolException) {
                            LOG.warn("Failed to shutdown protocol due to {}", (Object)protocolException.toString());
                        }
                        try {
                            if (peer != null) {
                                peer.close();
                            }
                        }
                        catch (Exception peerException) {
                            LOG.warn("Failed to close peer due to {}; some resources may not be appropriately cleaned up", (Object)peerException.toString());
                        }
                        LOG.trace("Finished cleaning up");
                        return;
                        catch (IOException e) {
                            LOG.error("Unable to communicate with remote instance {} due to {}; closing connection", peer, (Object)e.toString());
                            if (!LOG.isDebugEnabled()) return;
                            LOG.error("", (Throwable)e);
                            return;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            catch (Throwable t) {
                                block61: {
                                    LOG.error("Handshake failed when communicating with {}; closing connection. Reason for failure: {}", (Object)peerUri, (Object)t.toString());
                                    if (!LOG.isDebugEnabled()) break block61;
                                    LOG.error("", t);
                                }
                                LOG.trace("Cleaning up");
                                try {
                                    if (protocol != null && peer != null) {
                                        protocol.shutdown(peer);
                                    }
                                }
                                catch (Exception protocolException) {
                                    LOG.warn("Failed to shutdown protocol due to {}", (Object)protocolException.toString());
                                }
                                try {
                                    if (peer != null) {
                                        peer.close();
                                    }
                                }
                                catch (Exception peerException) {
                                    LOG.warn("Failed to close peer due to {}; some resources may not be appropriately cleaned up", (Object)peerException.toString());
                                }
                                LOG.trace("Finished cleaning up");
                                return;
                            }
                        }
                        finally {
                            LOG.trace("Cleaning up");
                            try {
                                if (protocol != null && peer != null) {
                                    protocol.shutdown(peer);
                                }
                            }
                            catch (Exception protocolException) {
                                LOG.warn("Failed to shutdown protocol due to {}", (Object)protocolException.toString());
                            }
                            try {
                                if (peer != null) {
                                    peer.close();
                                }
                            }
                            catch (Exception peerException) {
                                LOG.warn("Failed to close peer due to {}; some resources may not be appropriately cleaned up", (Object)peerException.toString());
                            }
                            LOG.trace("Finished cleaning up");
                        }
                    }
                });
            }
        });
        listenerThread.setName("Site-to-Site Listener");
        listenerThread.start();
    }

    private boolean isTlsError(Throwable e) {
        boolean tlsError = e instanceof SSLException || e instanceof GeneralSecurityException ? true : (e.getCause() == null ? false : this.isTlsError(e.getCause()));
        return tlsError;
    }

    private String getPeerIdentity(SSLSocket sslSocket) throws SSLPeerUnverifiedException {
        SSLSession sslSession = sslSocket.getSession();
        Certificate[] peerCertificates = sslSession.getPeerCertificates();
        if (peerCertificates == null || peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException(String.format("Peer [%s] certificates not found", sslSocket.getRemoteSocketAddress()));
        }
        X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
        return StandardPrincipalFormatter.getInstance().getSubject(peerCertificate);
    }

    private boolean handleTlsError(String msg) {
        if (this.tlsErrorRecentlySeen()) {
            LOG.debug(msg);
            return false;
        }
        LOG.error(msg);
        return true;
    }

    private boolean tlsErrorRecentlySeen() {
        long now = System.currentTimeMillis();
        return now - this.tlsErrorLastSeen < 10000L;
    }

    private ServerSocket createServerSocket() throws IOException {
        if (this.sslContext != null) {
            SSLServerSocket serverSocket = (SSLServerSocket)this.sslContext.getServerSocketFactory().createServerSocket(this.socketPort);
            serverSocket.setNeedClientAuth(true);
            serverSocket.setEnabledProtocols(TlsPlatform.getPreferredProtocols().toArray(new String[0]));
            return serverSocket;
        }
        return new ServerSocket(this.socketPort);
    }

    private Socket acceptConnection(ServerSocket serverSocket) {
        LOG.trace("Accepting Connection...");
        Socket acceptedSocket = null;
        try {
            while (!this.stopped.get() && acceptedSocket == null) {
                try {
                    acceptedSocket = serverSocket.accept();
                }
                catch (SocketTimeoutException ste) {
                    LOG.trace("SocketTimeoutException occurred. {}", (Object)ste.getMessage());
                }
            }
        }
        catch (IOException e) {
            LOG.error("RemoteSiteListener Unable to accept connection due to {}", (Object)e.toString());
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            return acceptedSocket;
        }
        LOG.trace("Got connection");
        return acceptedSocket;
    }

    private void handleRequest(ServerProtocol protocol, Peer peer, RequestType requestType) throws IOException, NotAuthorizedException, BadRequestException, RequestExpiredException {
        LOG.debug("Request type from {} is {}", (Object)protocol, (Object)requestType);
        switch (requestType) {
            case NEGOTIATE_FLOWFILE_CODEC: {
                protocol.negotiateCodec(peer);
                break;
            }
            case RECEIVE_FLOWFILES: {
                protocol.getPort().transferFlowFiles(peer, protocol);
                break;
            }
            case SEND_FLOWFILES: {
                protocol.getPort().receiveFlowFiles(peer, protocol);
                break;
            }
            case REQUEST_PEER_LIST: {
                Boolean isSiteToSiteSecure;
                Optional nodeInfo = this.nodeInformant == null ? Optional.empty() : Optional.of(this.nodeInformant.getNodeInformation());
                String remoteInputHostVal = this.nifiProperties.getRemoteInputHost();
                if (remoteInputHostVal == null) {
                    remoteInputHostVal = InetAddress.getLocalHost().getHostName();
                }
                Integer apiPort = (isSiteToSiteSecure = this.nifiProperties.isSiteToSiteSecure()) != false ? this.nifiProperties.getSslPort() : this.nifiProperties.getPort();
                NodeInformation self = new NodeInformation(remoteInputHostVal, this.nifiProperties.getRemoteInputPort(), this.nifiProperties.getRemoteInputHttpPort(), apiPort != null ? apiPort : 0, isSiteToSiteSecure.booleanValue(), 0);
                protocol.sendPeerList(peer, nodeInfo, self);
                break;
            }
            case SHUTDOWN: {
                protocol.shutdown(peer);
            }
        }
    }

    private int getPort() {
        return this.socketPort;
    }

    @Override
    public void stop() {
        this.stopped.set(true);
    }

    @Override
    public void destroy() {
    }

    private void verifyMagicBytes(InputStream in, String peerDescription) throws IOException {
        byte[] receivedMagicBytes = new byte[CommunicationsSession.MAGIC_BYTES.length];
        try {
            for (int i = 0; i < receivedMagicBytes.length; ++i) {
                receivedMagicBytes[i] = (byte)in.read();
            }
        }
        catch (EOFException e) {
            throw new HandshakeException("Handshake failed (not enough bytes) when communicating with " + peerDescription);
        }
        if (!Arrays.equals(CommunicationsSession.MAGIC_BYTES, receivedMagicBytes)) {
            throw new HandshakeException("Handshake with " + peerDescription + " failed because the Magic Header was not present");
        }
    }
}

