/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.authorization;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.nifi.registry.authorization.Permissions;

@ApiModel
public class ResourcePermissions {
    private Permissions buckets = new Permissions();
    private Permissions tenants = new Permissions();
    private Permissions policies = new Permissions();
    private Permissions proxy = new Permissions();

    @ApiModelProperty(value="The access that the current user has to any top level resources (a logical 'OR' of all other values)", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Permissions getAnyTopLevelResource() {
        return new Permissions().withCanRead(this.buckets.getCanRead() || this.tenants.getCanRead() || this.policies.getCanRead() || this.proxy.getCanRead()).withCanWrite(this.buckets.getCanWrite() || this.tenants.getCanWrite() || this.policies.getCanWrite() || this.proxy.getCanWrite()).withCanDelete(this.buckets.getCanDelete() || this.tenants.getCanDelete() || this.policies.getCanDelete() || this.proxy.getCanDelete());
    }

    @ApiModelProperty(value="The access that the current user has to the top level /buckets resource of this NiFi Registry (i.e., access to all buckets)", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Permissions getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Permissions buckets) {
        this.buckets = buckets;
    }

    @ApiModelProperty(value="The access that the current user has to the top level /tenants resource of this NiFi Registry", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Permissions getTenants() {
        return this.tenants;
    }

    public void setTenants(Permissions tenants) {
        this.tenants = tenants;
    }

    @ApiModelProperty(value="The access that the current user has to the top level /policies resource of this NiFi Registry", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Permissions getPolicies() {
        return this.policies;
    }

    public void setPolicies(Permissions policies) {
        this.policies = policies;
    }

    @ApiModelProperty(value="The access that the current user has to the top level /proxy resource of this NiFi Registry", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Permissions getProxy() {
        return this.proxy;
    }

    public void setProxy(Permissions proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePermissions that = (ResourcePermissions)o;
        if (this.buckets != null ? !this.buckets.equals(that.buckets) : that.buckets != null) {
            return false;
        }
        if (this.tenants != null ? !this.tenants.equals(that.tenants) : that.tenants != null) {
            return false;
        }
        if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) {
            return false;
        }
        return this.proxy != null ? this.proxy.equals(that.proxy) : that.proxy == null;
    }

    public int hashCode() {
        int result = this.buckets != null ? this.buckets.hashCode() : 0;
        result = 31 * result + (this.tenants != null ? this.tenants.hashCode() : 0);
        result = 31 * result + (this.policies != null ? this.policies.hashCode() : 0);
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResourcePermissions{buckets=" + String.valueOf(this.buckets) + ", tenants=" + String.valueOf(this.tenants) + ", policies=" + String.valueOf(this.policies) + ", proxy=" + String.valueOf(this.proxy) + "}";
    }
}

