/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.authorization;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class Permissions {
    private boolean canRead = false;
    private boolean canWrite = false;
    private boolean canDelete = false;

    public Permissions() {
    }

    public Permissions(Permissions permissions) {
        if (permissions == null) {
            throw new IllegalArgumentException("Cannot call copy constructor with null argument");
        }
        this.canRead = permissions.getCanRead();
        this.canWrite = permissions.getCanWrite();
        this.canDelete = permissions.getCanDelete();
    }

    @ApiModelProperty(value="Indicates whether the user can read a given resource.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public boolean getCanRead() {
        return this.canRead;
    }

    public void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    public Permissions withCanRead(boolean canRead) {
        this.setCanRead(canRead);
        return this;
    }

    @ApiModelProperty(value="Indicates whether the user can write a given resource.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public boolean getCanWrite() {
        return this.canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public Permissions withCanWrite(boolean canWrite) {
        this.setCanWrite(canWrite);
        return this;
    }

    @ApiModelProperty(value="Indicates whether the user can delete a given resource.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public boolean getCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public Permissions withCanDelete(boolean canDelete) {
        this.setCanDelete(canDelete);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permissions that = (Permissions)o;
        if (this.canRead != that.canRead) {
            return false;
        }
        if (this.canWrite != that.canWrite) {
            return false;
        }
        return this.canDelete == that.canDelete;
    }

    public int hashCode() {
        int result = this.canRead ? 1 : 0;
        result = 31 * result + (this.canWrite ? 1 : 0);
        result = 31 * result + (this.canDelete ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Permissions{canRead=" + this.canRead + ", canWrite=" + this.canWrite + ", canDelete=" + this.canDelete + "}";
    }
}

