/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.detection;

import java.nio.ByteBuffer;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.bcrypt.BcryptDerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.io.ByteBufferSearch;
import org.apache.nifi.security.crypto.key.pbkdf2.Pbkdf2DerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.scrypt.ScryptDerivedKeyParameterSpecReader;

public class DetectedDerivedKeyParameterSpecReader
implements DerivedKeyParameterSpecReader<DerivedKeyParameterSpec> {
    private static final byte[] ARGON2_ID_DELIMITER = new byte[]{36, 97, 114, 103, 111, 110, 50, 105, 100, 36};
    private static final byte[] BCRYPT_2A_DELIMITER = new byte[]{36, 50, 97, 36};
    private static final byte[] SCRYPT_DELIMITER = new byte[]{36, 115, 48, 36};
    private static final Argon2DerivedKeyParameterSpecReader argon2Reader = new Argon2DerivedKeyParameterSpecReader();
    private static final BcryptDerivedKeyParameterSpecReader bcryptReader = new BcryptDerivedKeyParameterSpecReader();
    private static final ScryptDerivedKeyParameterSpecReader scryptReader = new ScryptDerivedKeyParameterSpecReader();
    private static final Pbkdf2DerivedKeyParameterSpecReader pbkdf2Reader = new Pbkdf2DerivedKeyParameterSpecReader();

    @Override
    public DerivedKeyParameterSpec read(byte[] serializedParameters) {
        ByteBuffer buffer = ByteBuffer.wrap(serializedParameters);
        DerivedKeyParameterSpecReader<? extends DerivedKeyParameterSpec> reader = this.getReader(buffer);
        return reader.read(serializedParameters);
    }

    private DerivedKeyParameterSpecReader<? extends DerivedKeyParameterSpec> getReader(ByteBuffer buffer) {
        DerivedKeyParameterSpecReader<Argon2DerivedKeyParameterSpec> reader = ByteBufferSearch.indexOf(buffer, ARGON2_ID_DELIMITER) == 0 ? argon2Reader : (ByteBufferSearch.indexOf(buffer, BCRYPT_2A_DELIMITER) == 0 ? bcryptReader : (ByteBufferSearch.indexOf(buffer, SCRYPT_DELIMITER) == 0 ? scryptReader : pbkdf2Reader));
        return reader;
    }
}

