/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.nifi.migration.ControllerServiceCreationDetails;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.migration.PropertyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardPropertyConfiguration
implements PropertyConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StandardPropertyConfiguration.class);
    private final Map<String, String> effectiveProperties;
    private final Map<String, String> rawProperties;
    private final Function<String, String> effectiveValueResolver;
    private final String componentDescription;
    private final ControllerServiceFactory controllerServiceFactory;
    private final List<ControllerServiceCreationDetails> createdServices = new ArrayList<ControllerServiceCreationDetails>();
    private boolean modified = false;

    public StandardPropertyConfiguration(Map<String, String> effectivePropertyValues, Map<String, String> rawPropertyValues, Function<String, String> effectiveValueResolver, String componentDescription, ControllerServiceFactory controllerServiceFactory) {
        this.effectiveProperties = new LinkedHashMap<String, String>(effectivePropertyValues);
        this.rawProperties = new LinkedHashMap<String, String>(rawPropertyValues);
        this.effectiveValueResolver = effectiveValueResolver;
        this.componentDescription = componentDescription;
        this.controllerServiceFactory = controllerServiceFactory;
    }

    public boolean renameProperty(String propertyName, String newName) {
        if (!this.effectiveProperties.containsKey(propertyName)) {
            logger.debug("Will not rename property [{}] for [{}] because the property is not known", (Object)propertyName, (Object)this.componentDescription);
            return false;
        }
        String effectivePropertyValue = this.effectiveProperties.remove(propertyName);
        this.effectiveProperties.put(newName, effectivePropertyValue);
        String rawPropertyValue = this.rawProperties.remove(propertyName);
        this.rawProperties.put(newName, rawPropertyValue);
        this.modified = true;
        logger.info("Renamed property [{}] to [{}] for [{}]", new Object[]{propertyName, newName, this.componentDescription});
        return true;
    }

    public boolean removeProperty(String propertyName) {
        if (!this.effectiveProperties.containsKey(propertyName)) {
            logger.debug("Will not remove property [{}] from [{}] because the property is not known", (Object)propertyName, (Object)this.componentDescription);
            return false;
        }
        this.effectiveProperties.remove(propertyName);
        this.rawProperties.remove(propertyName);
        this.modified = true;
        logger.info("Removed property [{}] from [{}]", (Object)propertyName, (Object)this.componentDescription);
        return true;
    }

    public boolean hasProperty(String propertyName) {
        return this.effectiveProperties.containsKey(propertyName);
    }

    public boolean isPropertySet(String propertyName) {
        return this.effectiveProperties.get(propertyName) != null;
    }

    public void setProperty(String propertyName, String propertyValue) {
        String previousValue = this.rawProperties.put(propertyName, propertyValue);
        if (Objects.equals(previousValue, propertyValue)) {
            logger.debug("Will not update property [{}] for [{}] because the proposed value and the current value are the same", (Object)propertyName, (Object)this.componentDescription);
            return;
        }
        String effectiveValue = this.effectiveValueResolver.apply(propertyValue);
        this.effectiveProperties.put(propertyName, effectiveValue);
        this.modified = true;
        if (previousValue == null) {
            logger.info("Updated property [{}] for [{}], which was previously unset", (Object)propertyName, (Object)this.componentDescription);
        } else {
            logger.info("Updated property [{}] for [{}], overwriting previous value", (Object)propertyName, (Object)this.componentDescription);
        }
    }

    public Optional<String> getPropertyValue(String propertyName) {
        return Optional.ofNullable(this.effectiveProperties.get(propertyName));
    }

    public Optional<String> getRawPropertyValue(String propertyName) {
        return Optional.ofNullable(this.rawProperties.get(propertyName));
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.effectiveProperties);
    }

    public Map<String, String> getRawProperties() {
        return Collections.unmodifiableMap(this.rawProperties);
    }

    public String createControllerService(String implementationClassName, Map<String, String> serviceProperties) {
        ControllerServiceCreationDetails creationDetails = this.controllerServiceFactory.getCreationDetails(implementationClassName, serviceProperties);
        if (creationDetails.creationState() == ControllerServiceCreationDetails.CreationState.SERVICE_TO_BE_CREATED) {
            this.modified = true;
            this.createdServices.add(creationDetails);
        }
        return creationDetails.serviceIdentifier();
    }

    public boolean isModified() {
        return this.modified;
    }

    public List<ControllerServiceCreationDetails> getCreatedServices() {
        return this.createdServices;
    }
}

