/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceNotValidException;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.groups.DefaultComponentScheduler;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.Severity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceProvider
implements ControllerServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardControllerServiceProvider.class);
    private final ProcessScheduler processScheduler;
    private final BulletinRepository bulletinRepo;
    private final FlowManager flowManager;
    private final ExtensionManager extensionManager;
    private final ConcurrentMap<String, ControllerServiceNode> serviceCache = new ConcurrentHashMap<String, ControllerServiceNode>();

    public StandardControllerServiceProvider(ProcessScheduler scheduler, BulletinRepository bulletinRepo, FlowManager flowManager, ExtensionManager extensionManager) {
        this.processScheduler = scheduler;
        this.bulletinRepo = bulletinRepo;
        this.flowManager = flowManager;
        this.extensionManager = extensionManager;
    }

    public void onControllerServiceAdded(ControllerServiceNode serviceNode) {
        this.serviceCache.putIfAbsent(serviceNode.getIdentifier(), serviceNode);
    }

    public Set<ComponentNode> disableReferencingServices(ControllerServiceNode serviceNode) {
        List toDisable = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        HashSet serviceSet = new HashSet(toDisable);
        HashSet<ComponentNode> updated = new HashSet<ComponentNode>();
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
            updated.add((ComponentNode)nodeToDisable);
        }
        Collections.reverse(toDisable);
        this.processScheduler.disableControllerServices(toDisable);
        return updated;
    }

    public Set<ComponentNode> scheduleReferencingComponents(ControllerServiceNode serviceNode) {
        return this.scheduleReferencingComponents(serviceNode, null, (ComponentScheduler)new DefaultComponentScheduler(this, VersionedComponentStateLookup.IDENTITY_LOOKUP));
    }

    public Set<ComponentNode> scheduleReferencingComponents(ControllerServiceNode serviceNode, Set<ComponentNode> candidates, ComponentScheduler componentScheduler) {
        List processors = serviceNode.getReferences().findRecursiveReferences(ProcessorNode.class);
        List reportingTasks = serviceNode.getReferences().findRecursiveReferences(ReportingTaskNode.class);
        List flowAnalysisRuleNodes = serviceNode.getReferences().findRecursiveReferences(FlowAnalysisRuleNode.class);
        for (ProcessorNode node : processors) {
            if (candidates != null && !candidates.contains(node) || node.getScheduledState() == ScheduledState.DISABLED) continue;
            node.verifyCanStart();
        }
        for (ProcessorNode node : reportingTasks) {
            if (candidates != null && !candidates.contains(node) || node.getScheduledState() == ScheduledState.DISABLED) continue;
            node.verifyCanStart();
        }
        for (ProcessorNode node : flowAnalysisRuleNodes) {
            if (candidates != null && !candidates.contains(node) || node.isEnabled()) continue;
            node.verifyCanEnable();
        }
        HashSet<ComponentNode> updated = new HashSet<ComponentNode>();
        for (ProcessorNode node : processors) {
            if (candidates != null && !candidates.contains(node) || node.getScheduledState() == ScheduledState.DISABLED) continue;
            componentScheduler.startComponent((Connectable)node);
            updated.add((ComponentNode)node);
        }
        for (ProcessorNode node : reportingTasks) {
            if (candidates != null && !candidates.contains(node) || node.getScheduledState() == ScheduledState.DISABLED) continue;
            componentScheduler.startReportingTask((ReportingTaskNode)node);
            updated.add((ComponentNode)node);
        }
        for (ProcessorNode node : flowAnalysisRuleNodes) {
            if (candidates != null && !candidates.contains(node) || node.isEnabled()) continue;
            node.enable();
            updated.add((ComponentNode)node);
        }
        return updated;
    }

    public Map<ComponentNode, Future<Void>> unscheduleReferencingComponents(ControllerServiceNode serviceNode) {
        CompletableFuture future;
        List processors = serviceNode.getReferences().findRecursiveReferences(ProcessorNode.class);
        List reportingTasks = serviceNode.getReferences().findRecursiveReferences(ReportingTaskNode.class);
        List flowAnalysisRuleNodes = serviceNode.getReferences().findRecursiveReferences(FlowAnalysisRuleNode.class);
        HashMap<ComponentNode, Future<Void>> updated = new HashMap<ComponentNode, Future<Void>>();
        for (ProcessorNode node : processors) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            node.verifyCanStop();
        }
        for (ProcessorNode node : reportingTasks) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            node.verifyCanStop();
        }
        for (ProcessorNode node : flowAnalysisRuleNodes) {
            if (!node.isEnabled()) continue;
            node.verifyCanDisable();
        }
        for (ProcessorNode node : processors) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            future = node.getProcessGroup().stopProcessor(node);
            updated.put((ComponentNode)node, future);
        }
        for (ProcessorNode node : reportingTasks) {
            if (node.getScheduledState() != ScheduledState.RUNNING) continue;
            future = this.processScheduler.unschedule((ReportingTaskNode)node);
            updated.put((ComponentNode)node, future);
        }
        for (ProcessorNode node : flowAnalysisRuleNodes) {
            if (!node.isEnabled()) continue;
            future = new CompletableFuture();
            this.processScheduler.submitFrameworkTask(() -> StandardControllerServiceProvider.lambda$unscheduleReferencingComponents$0((FlowAnalysisRuleNode)node, future));
            updated.put((ComponentNode)node, future);
        }
        return updated;
    }

    public CompletableFuture<Void> enableControllerService(ControllerServiceNode serviceNode) {
        if (serviceNode.isActive()) {
            CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
            return future;
        }
        serviceNode.verifyCanEnable();
        serviceNode.reloadAdditionalResourcesIfNecessary();
        return this.processScheduler.enableControllerService(serviceNode);
    }

    public void enableControllerServices(Collection<ControllerServiceNode> serviceNodes) {
        boolean shouldStart = true;
        Iterator<ControllerServiceNode> serviceIter = serviceNodes.iterator();
        while (serviceIter.hasNext() && shouldStart) {
            ControllerServiceNode controllerServiceNode = serviceIter.next();
            List requiredServices = controllerServiceNode.getRequiredControllerServices();
            for (ControllerServiceNode requiredService : requiredServices) {
                if (requiredService.isActive() || serviceNodes.contains(requiredService)) continue;
                shouldStart = false;
                logger.debug("Will not start {} because required service {} is not active and is not part of the collection of things to start", serviceNodes, (Object)requiredService);
            }
        }
        if (shouldStart) {
            for (ControllerServiceNode controllerServiceNode : serviceNodes) {
                try {
                    Future<Void> future = this.enableControllerServiceAndDependencies(controllerServiceNode);
                    future.get(30L, TimeUnit.SECONDS);
                    logger.debug("Successfully enabled {}; service state = {}", (Object)controllerServiceNode, (Object)controllerServiceNode.getState());
                }
                catch (ControllerServiceNotValidException csnve) {
                    logger.warn("Failed to enable service {} because it is not currently valid", (Object)controllerServiceNode);
                }
                catch (Exception e) {
                    logger.error("Failed to enable " + String.valueOf(controllerServiceNode), (Throwable)e);
                    if (this.bulletinRepo == null) continue;
                    this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not start " + String.valueOf(controllerServiceNode) + " due to " + String.valueOf(e))));
                }
            }
        }
    }

    public Future<Void> enableControllerServicesAsync(Collection<ControllerServiceNode> serviceNodes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.processScheduler.submitFrameworkTask(() -> {
            try {
                this.enableControllerServices(serviceNodes, future);
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private void enableControllerServices(Collection<ControllerServiceNode> serviceNodes, CompletableFuture<Void> completableFuture) throws Exception {
        Exception firstFailure = null;
        block5: for (ControllerServiceNode controllerServiceNode : serviceNodes) {
            if (completableFuture.isCancelled()) {
                return;
            }
            try {
                if (controllerServiceNode.isActive()) continue;
                Future<Void> future = this.enableControllerServiceAndDependencies(controllerServiceNode);
                while (true) {
                    try {
                        future.get(1L, TimeUnit.SECONDS);
                        logger.debug("Successfully enabled {}; service state = {}", (Object)controllerServiceNode, (Object)controllerServiceNode.getState());
                        continue block5;
                    }
                    catch (TimeoutException e) {
                        if (!completableFuture.isCancelled()) continue;
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to enable service {}", (Object)controllerServiceNode, (Object)e);
                        if (firstFailure == null) {
                            firstFailure = e;
                        } else {
                            firstFailure.addSuppressed(e);
                        }
                        if (this.bulletinRepo == null) continue block5;
                        this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not enable " + String.valueOf(controllerServiceNode) + " due to " + String.valueOf(e))));
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Failed to enable " + String.valueOf(controllerServiceNode), (Throwable)e);
                if (this.bulletinRepo == null) continue;
                this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not start " + String.valueOf(controllerServiceNode) + " due to " + String.valueOf(e))));
            }
        }
        if (firstFailure != null) {
            throw firstFailure;
        }
    }

    public Future<Void> enableControllerServiceAndDependencies(ControllerServiceNode serviceNode) {
        if (serviceNode.isActive()) {
            logger.debug("Enabling of Controller Service {} triggered but service already enabled", (Object)serviceNode);
            return CompletableFuture.completedFuture(null);
        }
        List dependentServices = serviceNode.getRequiredControllerServices();
        for (ControllerServiceNode depNode : dependentServices) {
            if (depNode.isActive()) continue;
            logger.debug("Before enabling {}, will enable dependent Controller Service {}", (Object)serviceNode, (Object)depNode);
            this.enableControllerServiceAndDependencies(depNode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("All dependent services for {} have now begun enabling. Will wait for them to complete", (Object)serviceNode);
        }
        for (ControllerServiceNode dependentService : dependentServices) {
            try {
                boolean enabled = dependentService.awaitEnabled(30L, TimeUnit.SECONDS);
                if (enabled) {
                    logger.debug("Successfully enabled dependent service {}; service state = {}", (Object)dependentService, (Object)dependentService.getState());
                    continue;
                }
                logger.debug("After 30 seconds, {} is still not enabled. Will continue attempting to enable additional Controller Services", (Object)dependentService);
            }
            catch (Exception e) {
                logger.error("Failed to enable service {}, so may be unable to enable {}", new Object[]{dependentService, serviceNode, e});
            }
        }
        logger.debug("All dependent services have been enabled for {}; will now start service itself", (Object)serviceNode);
        return this.enableControllerService(serviceNode);
    }

    static List<List<ControllerServiceNode>> determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap) {
        ArrayList<List<ControllerServiceNode>> orderedNodeLists = new ArrayList<List<ControllerServiceNode>>();
        for (ControllerServiceNode node : serviceNodeMap.values()) {
            ArrayList<ControllerServiceNode> branch = new ArrayList<ControllerServiceNode>();
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, node, branch, new HashSet<ControllerServiceNode>());
            orderedNodeLists.add(branch);
        }
        return orderedNodeLists;
    }

    private static void determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap, ControllerServiceNode contextNode, List<ControllerServiceNode> orderedNodes, Set<ControllerServiceNode> visited) {
        if (visited.contains(contextNode)) {
            return;
        }
        for (Map.Entry entry : contextNode.getEffectivePropertyValues().entrySet()) {
            ControllerServiceNode referencedNode;
            String referencedServiceId;
            if (((PropertyDescriptor)entry.getKey()).getControllerServiceDefinition() == null || (referencedServiceId = (String)entry.getValue()) == null || orderedNodes.contains(referencedNode = serviceNodeMap.get(referencedServiceId))) continue;
            visited.add(contextNode);
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, referencedNode, orderedNodes, visited);
        }
        if (!orderedNodes.contains(contextNode)) {
            orderedNodes.add(contextNode);
        }
    }

    public CompletableFuture<Void> disableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanDisable();
        return this.processScheduler.disableControllerService(serviceNode);
    }

    public CompletableFuture<Void> disableControllerServicesAsync(Collection<ControllerServiceNode> serviceNodes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.processScheduler.submitFrameworkTask(() -> {
            try {
                this.disableControllerServices(serviceNodes, future);
                future.complete(null);
            }
            catch (Exception e) {
                logger.error("Failed to disable Controller Services {}", (Object)serviceNodes, (Object)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private void disableControllerServices(Collection<ControllerServiceNode> serviceNodes, CompletableFuture<Void> future) throws Exception {
        HashSet<ControllerServiceNode> serviceNodeSet = new HashSet<ControllerServiceNode>(serviceNodes);
        for (ControllerServiceNode serviceNode : serviceNodes) {
            List references = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
            for (ControllerServiceNode reference : references) {
                if (!reference.isActive()) continue;
                try {
                    reference.verifyCanDisable(serviceNodeSet);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }
        }
        Exception firstFailure = null;
        for (ControllerServiceNode serviceNode : serviceNodes) {
            if (serviceNode.isActive()) {
                try {
                    this.disableControllerServiceAndReferencingServices(serviceNode, future::isCancelled);
                }
                catch (Exception e) {
                    if (firstFailure == null) {
                        firstFailure = e;
                        continue;
                    }
                    firstFailure.addSuppressed(e);
                }
                continue;
            }
            boolean disabled = false;
            while (!disabled) {
                try {
                    disabled = serviceNode.awaitDisabled(1L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    logger.error("Failed to disable {}", (Object)serviceNode, (Object)e);
                    future.completeExceptionally(e);
                }
            }
        }
        if (firstFailure != null) {
            throw firstFailure;
        }
    }

    private void disableControllerServiceAndReferencingServices(ControllerServiceNode serviceNode, BooleanSupplier cancelSupplier) throws ExecutionException, InterruptedException {
        logger.debug("Disabling referencing services for {} before disabling service", (Object)serviceNode);
        this.disableReferencingServices(serviceNode);
        logger.debug("Disabling service {}", (Object)serviceNode);
        CompletableFuture<Void> serviceFuture = this.disableControllerService(serviceNode);
        while (true) {
            try {
                serviceFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                if (!cancelSupplier.getAsBoolean()) continue;
                return;
            }
            break;
        }
        logger.debug("{} is now disabled", (Object)serviceNode);
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? null : node.getProxiedControllerService();
    }

    private ProcessGroup getRootGroup() {
        return this.flowManager.getRootGroup();
    }

    public ControllerService getControllerServiceForComponent(String serviceIdentifier, String componentId) {
        ProcessGroup groupOfInterest;
        ControllerServiceNode serviceNode;
        ProcessorNode procNode = this.flowManager.getProcessorNode(componentId);
        if (procNode == null) {
            serviceNode = this.getControllerServiceNode(componentId);
            if (serviceNode == null) {
                FlowRegistryClientNode flowRegistryClientNode;
                ParameterProviderNode parameterProviderNode;
                FlowAnalysisRuleNode flowAnalysisRuleNode;
                ReportingTaskNode taskNode = this.flowManager.getReportingTaskNode(componentId);
                if (taskNode == null && (flowAnalysisRuleNode = this.flowManager.getFlowAnalysisRuleNode(componentId)) == null && (parameterProviderNode = this.flowManager.getParameterProvider(componentId)) == null && (flowRegistryClientNode = this.flowManager.getFlowRegistryClient(componentId)) == null) {
                    throw new IllegalStateException("Could not find any Processor, Reporting Task, Parameter Provider, or Controller Service with identifier " + componentId);
                }
                ControllerServiceNode rootServiceNode = this.flowManager.getRootControllerService(serviceIdentifier);
                return rootServiceNode == null ? null : rootServiceNode.getProxiedControllerService();
            }
            groupOfInterest = serviceNode.getProcessGroup();
        } else {
            groupOfInterest = procNode.getProcessGroup();
        }
        if (groupOfInterest == null) {
            ControllerServiceNode rootServiceNode = this.flowManager.getRootControllerService(serviceIdentifier);
            return rootServiceNode == null ? null : rootServiceNode.getProxiedControllerService();
        }
        serviceNode = groupOfInterest.findControllerService(serviceIdentifier, false, true);
        if (serviceNode != null) {
            return serviceNode.getProxiedControllerService();
        }
        return null;
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.isControllerServiceEnabled(service.getIdentifier());
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node != null && ControllerServiceState.ENABLED == node.getState();
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node != null && ControllerServiceState.ENABLING == node.getState();
    }

    public ControllerServiceNode getControllerServiceNode(String serviceIdentifier) {
        ControllerServiceNode rootServiceNode = this.flowManager.getRootControllerService(serviceIdentifier);
        if (rootServiceNode != null) {
            return rootServiceNode;
        }
        return (ControllerServiceNode)this.serviceCache.get(serviceIdentifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType, String groupId) {
        Set serviceNodes;
        if (groupId == null) {
            serviceNodes = this.flowManager.getRootControllerServices();
        } else {
            ProcessGroup group = this.getRootGroup();
            if (!"root".equals(groupId) && !group.getIdentifier().equals(groupId)) {
                group = group.findProcessGroup(groupId);
            }
            if (group == null) {
                return Collections.emptySet();
            }
            serviceNodes = group.getControllerServices(true);
        }
        return serviceNodes.stream().filter(service -> serviceType.isAssignableFrom(service.getProxiedControllerService().getClass())).map(ComponentNode::getIdentifier).collect(Collectors.toSet());
    }

    public Class<? extends ControllerService> getControllerServiceType(String serviceTypeName) {
        Set serviceDefinitions = this.extensionManager.getExtensions(ControllerService.class);
        for (ExtensionDefinition definition : serviceDefinitions) {
            Class serviceClass = this.extensionManager.getClass(definition);
            Class<? extends ControllerService> serviceType = this.getServiceInterfaceByName(serviceClass, serviceTypeName);
            if (serviceType == null) continue;
            return serviceType;
        }
        return null;
    }

    private Class<? extends ControllerService> getServiceInterfaceByName(Class<?> serviceClass, String type) {
        for (Class<?> serviceInterface : serviceClass.getInterfaces()) {
            if (!ControllerService.class.isAssignableFrom(serviceInterface) || !type.equals(serviceInterface.getSimpleName()) && !type.equals(serviceInterface.getCanonicalName()) || !ControllerService.class.isAssignableFrom(serviceInterface)) continue;
            return serviceInterface;
        }
        return null;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? null : node.getName();
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        Objects.requireNonNull(serviceNode);
        ProcessGroup group = serviceNode.getProcessGroup();
        if (group == null) {
            this.flowManager.removeRootControllerService(serviceNode);
        } else {
            group.removeControllerService(serviceNode);
        }
        LogRepositoryFactory.removeRepository((String)serviceNode.getIdentifier());
        this.extensionManager.removeInstanceClassLoader(serviceNode.getIdentifier());
        this.serviceCache.remove(serviceNode.getIdentifier());
        this.flowManager.getRuleViolationsManager().ifPresent(ruleViolationsManager -> ruleViolationsManager.removeRuleViolationsForSubject(serviceNode.getIdentifier()));
    }

    public Collection<ControllerServiceNode> getNonRootControllerServices() {
        return this.serviceCache.values().stream().filter(serviceNode -> serviceNode.getProcessGroup() != null).collect(Collectors.toSet());
    }

    public Set<ComponentNode> enableReferencingServices(ControllerServiceNode serviceNode) {
        List recursiveReferences = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        logger.debug("Enabling the following Referencing Services for {}: {}", (Object)serviceNode, (Object)recursiveReferences);
        return this.enableReferencingServices(serviceNode, recursiveReferences);
    }

    private Set<ComponentNode> enableReferencingServices(ControllerServiceNode serviceNode, List<ControllerServiceNode> recursiveReferences) {
        if (!serviceNode.isActive()) {
            serviceNode.verifyCanEnable(new HashSet<ControllerServiceNode>(recursiveReferences));
        }
        HashSet<ComponentNode> updated = new HashSet<ComponentNode>();
        HashSet<ControllerServiceNode> ifEnabled = new HashSet<ControllerServiceNode>();
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            nodeToEnable.verifyCanEnable(ifEnabled);
            ifEnabled.add(nodeToEnable);
        }
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            logger.debug("Enabling {} because it references {}", (Object)nodeToEnable, (Object)serviceNode);
            this.enableControllerService(nodeToEnable);
            updated.add((ComponentNode)nodeToEnable);
        }
        return updated;
    }

    public void verifyCanEnableReferencingServices(ControllerServiceNode serviceNode) {
        List referencingServices = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        HashSet referencingServiceSet = new HashSet(referencingServices);
        for (ControllerServiceNode referencingService : referencingServices) {
            referencingService.verifyCanEnable(referencingServiceSet);
        }
    }

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List referencingServices = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        List referencingReportingTasks = serviceNode.getReferences().findRecursiveReferences(ReportingTaskNode.class);
        List referencingFlowAnalysisRuleNodes = serviceNode.getReferences().findRecursiveReferences(FlowAnalysisRuleNode.class);
        List referencingProcessors = serviceNode.getReferences().findRecursiveReferences(ProcessorNode.class);
        HashSet referencingServiceSet = new HashSet(referencingServices);
        for (ReportingTaskNode taskNode : referencingReportingTasks) {
            if (taskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            taskNode.verifyCanStart(referencingServiceSet);
        }
        for (FlowAnalysisRuleNode ruleNode : referencingFlowAnalysisRuleNodes) {
            ruleNode.verifyCanEnable(referencingServiceSet);
        }
        for (ProcessorNode procNode : referencingProcessors) {
            if (procNode.getScheduledState() == ScheduledState.DISABLED) continue;
            procNode.verifyCanStart();
        }
    }

    public void verifyCanDisableReferencingServices(ControllerServiceNode serviceNode) {
        List toDisable = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
        HashSet serviceSet = new HashSet(toDisable);
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
        }
    }

    public void verifyCanStopReferencingComponents(ControllerServiceNode serviceNode) {
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Cannot obtain Controller Service Identifiers for service type " + String.valueOf(serviceType) + " without providing a Process Group Identifier");
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    private static /* synthetic */ void lambda$unscheduleReferencingComponents$0(FlowAnalysisRuleNode node, CompletableFuture future) {
        try {
            node.disable();
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
    }
}

