/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.scheduling;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.util.Connectables;

public class ConnectableProcessContext
implements ProcessContext {
    private final Connectable connectable;
    private final StateManager stateManager;

    public ConnectableProcessContext(Connectable connectable, StateManager stateManager) {
        this.connectable = connectable;
        this.stateManager = stateManager;
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.getProperty(descriptor.getName());
    }

    public PropertyValue getProperty(String propertyName) {
        return new PropertyValue(this){

            public String getValue() {
                return null;
            }

            public Integer asInteger() {
                return null;
            }

            public Long asLong() {
                return null;
            }

            public Boolean asBoolean() {
                return null;
            }

            public Float asFloat() {
                return null;
            }

            public Double asDouble() {
                return null;
            }

            public Long asTimePeriod(TimeUnit timeUnit) {
                return null;
            }

            public Duration asDuration() {
                return null;
            }

            public Double asDataSize(DataUnit dataUnit) {
                return null;
            }

            public PropertyValue evaluateAttributeExpressions() throws ProcessException {
                return this;
            }

            public PropertyValue evaluateAttributeExpressions(FlowFile flowFile) throws ProcessException {
                return this;
            }

            public PropertyValue evaluateAttributeExpressions(AttributeValueDecorator decorator) throws ProcessException {
                return this;
            }

            public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, AttributeValueDecorator decorator) throws ProcessException {
                return this;
            }

            public ControllerService asControllerService() {
                return null;
            }

            public <T extends ControllerService> T asControllerService(Class<T> serviceType) throws IllegalArgumentException {
                return null;
            }

            public ResourceReference asResource() {
                return null;
            }

            public ResourceReferences asResources() {
                return null;
            }

            public boolean isSet() {
                return false;
            }

            public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes) throws ProcessException {
                return null;
            }

            public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes) throws ProcessException {
                return null;
            }

            public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes, AttributeValueDecorator decorator) throws ProcessException {
                return null;
            }

            public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator) throws ProcessException {
                return null;
            }

            public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator, Map<String, String> stateValues) throws ProcessException {
                return null;
            }

            public boolean isExpressionLanguagePresent() {
                return false;
            }
        };
    }

    public PropertyValue newPropertyValue(String rawValue) {
        throw new UnsupportedOperationException();
    }

    public void yield() {
        this.connectable.yield();
    }

    public int getMaxConcurrentTasks() {
        return this.connectable.getMaxConcurrentTasks();
    }

    public ExecutionNode getExecutionNode() {
        return ExecutionNode.ALL;
    }

    public String getAnnotationData() {
        return null;
    }

    public Map<String, String> getAllProperties() {
        return new HashMap<String, String>();
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return new HashMap<PropertyDescriptor, String>();
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return null;
    }

    public Set<Relationship> getAvailableRelationships() {
        for (Connection connection : this.connectable.getConnections()) {
            if (!connection.getFlowFileQueue().isFull()) continue;
            return Collections.emptySet();
        }
        Collection relationships = this.connectable.getRelationships();
        if (relationships instanceof Set) {
            return (Set)relationships;
        }
        return new HashSet<Relationship>(this.connectable.getRelationships());
    }

    public boolean hasIncomingConnection() {
        return this.connectable.hasIncomingConnection();
    }

    public boolean hasNonLoopConnection() {
        return Connectables.hasNonLoopConnection(this.connectable);
    }

    public boolean hasConnection(Relationship relationship) {
        Set connections = this.connectable.getConnections(relationship);
        return connections != null && !connections.isEmpty();
    }

    public boolean isExpressionLanguagePresent(PropertyDescriptor property) {
        return false;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getName() {
        return this.connectable.getName();
    }

    public boolean isConnectedToCluster() {
        throw new UnsupportedOperationException();
    }

    public boolean isRelationshipRetried(Relationship relationship) {
        return false;
    }

    public int getRetryCount() {
        return 0;
    }
}

