/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.cache.filesystem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.c2.api.InvalidParameterException;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCache;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCacheFileInfo;
import org.apache.nifi.minifi.c2.api.util.Pair;
import org.apache.nifi.minifi.c2.cache.filesystem.FileSystemCacheFileInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemConfigurationCache
implements ConfigurationCache {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemConfigurationCache.class);
    private final Path pathRoot;
    private final String pathPattern;

    public FileSystemConfigurationCache(String pathRoot, String pathPattern) throws IOException {
        String serverHome = System.getenv("C2_SERVER_HOME");
        String homePath = serverHome == null ? "." : serverHome;
        this.pathRoot = Paths.get(homePath, new String[0]).resolve(pathRoot).toAbsolutePath();
        Files.createDirectories(this.pathRoot, new FileAttribute[0]);
        this.pathPattern = pathPattern;
    }

    protected Path resolveChildAndVerifyParent(Path parent, String s) throws InvalidParameterException {
        Path child = parent.resolve(s).toAbsolutePath();
        if (child.toAbsolutePath().getParent().equals(parent)) {
            return child;
        }
        throw new InvalidParameterException("Path entry " + s + " not child of " + String.valueOf(parent));
    }

    public ConfigurationCacheFileInfo getCacheFileInfo(String contentType, Map<String, List<String>> parameters) throws InvalidParameterException {
        String[] split;
        Object pathString = this.pathPattern;
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            if (entry.getValue().size() != 1) {
                throw new InvalidParameterException("Multiple values for same parameter not supported in this provider.");
            }
            pathString = ((String)pathString).replaceAll(Pattern.quote("${" + entry.getKey() + "}"), entry.getValue().get(0));
        }
        pathString = (String)pathString + "." + contentType.replace('/', '.');
        for (String s1 : split = ((String)pathString).split("/")) {
            int closeBrace;
            int openBrace = s1.indexOf("${");
            if (openBrace < 0 || openBrace >= s1.length() + 2 || (closeBrace = s1.indexOf("}", openBrace + 2)) < 0) continue;
            throw new InvalidParameterException("Found unsubstituted variable " + s1.substring(openBrace + 2, closeBrace));
        }
        String[] stringArray = split;
        Path path = this.pathRoot.toAbsolutePath();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String s = stringArray[i];
            path = this.resolveChildAndVerifyParent(path, s);
        }
        Pair dirPathAndFilename = new Pair((Object)path, (Object)stringArray[stringArray.length - 1]);
        if (logger.isDebugEnabled()) {
            StringBuilder message = new StringBuilder("Parameters {");
            message.append(parameters.entrySet().stream().map(e -> (String)e.getKey() + ": [" + String.join((CharSequence)", ", (Iterable)e.getValue()) + "]").collect(Collectors.joining(", ")));
            message.append("} -> ");
            message.append(((Path)dirPathAndFilename.getFirst()).resolve((String)dirPathAndFilename.getSecond()).toAbsolutePath());
            logger.debug(message.toString());
        }
        return new FileSystemCacheFileInfoImpl(this, (Path)dirPathAndFilename.getFirst(), (String)dirPathAndFilename.getSecond() + ".v");
    }
}

