/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.documentation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.documentation.DocumentationWriter;
import org.apache.nifi.documentation.html.HtmlDocumentationWriter;
import org.apache.nifi.documentation.html.HtmlProcessorDocumentationWriter;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DocGenerator.class);

    public static void generate(NiFiProperties properties, ExtensionManager extensionManager, ExtensionMapping extensionMapping) {
        File explodedNiFiDocsDir = properties.getComponentDocumentationWorkingDirectory();
        logger.debug("Generating Documentation: Components [{}] Directory [{}]", (Object)extensionMapping.size(), (Object)explodedNiFiDocsDir);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(Processor.class), explodedNiFiDocsDir, extensionManager);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(ControllerService.class), explodedNiFiDocsDir, extensionManager);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(ReportingTask.class), explodedNiFiDocsDir, extensionManager);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(FlowAnalysisRule.class), explodedNiFiDocsDir, extensionManager);
        DocGenerator.documentConfigurableComponent(extensionManager.getExtensions(ParameterProvider.class), explodedNiFiDocsDir, extensionManager);
    }

    public static void documentConfigurableComponent(Set<ExtensionDefinition> extensionDefinitions, File explodedNiFiDocsDir, ExtensionManager extensionManager) {
        for (ExtensionDefinition extensionDefinition : extensionDefinitions) {
            Bundle bundle = extensionDefinition.getBundle();
            if (bundle == null) {
                logger.warn("Documentation generation failed: Extension bundle not found [{}]", (Object)extensionDefinition);
                continue;
            }
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            String extensionClassName = extensionDefinition.getImplementationClassName();
            String path = coordinate.getGroup() + "/" + coordinate.getId() + "/" + coordinate.getVersion() + "/" + extensionClassName;
            File componentDirectory = new File(explodedNiFiDocsDir, path);
            File indexHtml = new File(componentDirectory, "index.html");
            if (indexHtml.exists()) {
                logger.debug("Existing documentation found [{}] skipped component class [{}]", (Object)indexHtml.getAbsolutePath(), (Object)extensionClassName);
                continue;
            }
            Class extensionType = extensionDefinition.getExtensionType();
            if (!ConfigurableComponent.class.isAssignableFrom(extensionType)) continue;
            if (componentDirectory.mkdirs()) {
                logger.debug("Documentation directory created [{}]", (Object)componentDirectory);
            }
            Class extensionClass = extensionManager.getClass(extensionDefinition);
            Class<ConfigurableComponent> componentClass = extensionClass.asSubclass(ConfigurableComponent.class);
            try {
                logger.debug("Documentation generation started: Component Class [{}]", componentClass);
                DocGenerator.document(extensionManager, componentDirectory, componentClass, coordinate);
            }
            catch (Exception e) {
                logger.warn("Documentation generation failed: Component Class [{}]", componentClass, (Object)e);
            }
        }
    }

    private static void document(ExtensionManager extensionManager, File componentDocsDir, Class<? extends ConfigurableComponent> componentClass, BundleCoordinate bundleCoordinate) throws IOException {
        String classType = componentClass.getCanonicalName();
        ConfigurableComponent component = extensionManager.getTempComponent(classType, bundleCoordinate);
        DocumentationWriter writer = DocGenerator.getDocumentWriter(extensionManager, componentClass);
        File baseDocumentationFile = new File(componentDocsDir, "index.html");
        if (baseDocumentationFile.exists()) {
            logger.warn("Overwriting Component Documentation [{}]", (Object)baseDocumentationFile);
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(baseDocumentationFile.toPath(), new OpenOption[0]));){
            writer.write(component, output, DocGenerator.hasAdditionalInfo(componentDocsDir));
        }
    }

    private static DocumentationWriter getDocumentWriter(ExtensionManager extensionManager, Class<? extends ConfigurableComponent> componentClass) {
        if (Processor.class.isAssignableFrom(componentClass)) {
            return new HtmlProcessorDocumentationWriter(extensionManager);
        }
        return new HtmlDocumentationWriter(extensionManager);
    }

    private static boolean hasAdditionalInfo(File directory) {
        Path additionalDetailsPath = directory.toPath().resolve("additionalDetails.html");
        return Files.exists(additionalDetailsPath, new LinkOption[0]);
    }
}

